// ui/gfx/mojom/mask_filter_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/mask_filter_info.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/mask_filter_info.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/mask_filter_info.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/mojom/rrect_f.mojom-blink.h"
#include "ui/gfx/mojom/linear_gradient.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {








class  MaskFilterInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MaskFilterInfo, T>::value>;
  using DataView = MaskFilterInfoDataView;
  using Data_ = internal::MaskFilterInfo_Data;

  template <typename... Args>
  static MaskFilterInfoPtr New(Args&&... args) {
    return MaskFilterInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MaskFilterInfoPtr From(const U& u) {
    return mojo::TypeConverter<MaskFilterInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MaskFilterInfo>::Convert(*this);
  }


  MaskFilterInfo();

  MaskFilterInfo(
      ::gfx::mojom::blink::RRectFPtr rounded_corner_bounds,
      ::gfx::mojom::blink::LinearGradientPtr gradient_mask,
      std::optional<int32_t> clip_id);

MaskFilterInfo(const MaskFilterInfo&) = delete;
MaskFilterInfo& operator=(const MaskFilterInfo&) = delete;

  ~MaskFilterInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MaskFilterInfoPtr>
  MaskFilterInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MaskFilterInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MaskFilterInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MaskFilterInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MaskFilterInfo_UnserializedMessageContext<
            UserType, MaskFilterInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MaskFilterInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MaskFilterInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MaskFilterInfo_UnserializedMessageContext<
            UserType, MaskFilterInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MaskFilterInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::mojom::blink::RRectFPtr rounded_corner_bounds;
  
  ::gfx::mojom::blink::LinearGradientPtr gradient_mask;
  
  std::optional<int32_t> clip_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MaskFilterInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MaskFilterInfoPtr MaskFilterInfo::Clone() const {
  return New(
      mojo::Clone(rounded_corner_bounds),
      mojo::Clone(gradient_mask),
      mojo::Clone(clip_id)
  );
}

template <typename T, MaskFilterInfo::EnableIfSame<T>*>
bool MaskFilterInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rounded_corner_bounds, other_struct.rounded_corner_bounds))
    return false;
  if (!mojo::Equals(this->gradient_mask, other_struct.gradient_mask))
    return false;
  if (!mojo::Equals(this->clip_id, other_struct.clip_id))
    return false;
  return true;
}

template <typename T, MaskFilterInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rounded_corner_bounds < rhs.rounded_corner_bounds)
    return true;
  if (rhs.rounded_corner_bounds < lhs.rounded_corner_bounds)
    return false;
  if (lhs.gradient_mask < rhs.gradient_mask)
    return true;
  if (rhs.gradient_mask < lhs.gradient_mask)
    return false;
  if (lhs.clip_id < rhs.clip_id)
    return true;
  if (rhs.clip_id < lhs.clip_id)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::MaskFilterInfo::DataView,
                                         ::gfx::mojom::blink::MaskFilterInfoPtr> {
  static bool IsNull(const ::gfx::mojom::blink::MaskFilterInfoPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::MaskFilterInfoPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::MaskFilterInfo::rounded_corner_bounds)& rounded_corner_bounds(
      const ::gfx::mojom::blink::MaskFilterInfoPtr& input) {
    return input->rounded_corner_bounds;
  }

  static const decltype(::gfx::mojom::blink::MaskFilterInfo::gradient_mask)& gradient_mask(
      const ::gfx::mojom::blink::MaskFilterInfoPtr& input) {
    return input->gradient_mask;
  }

  static decltype(::gfx::mojom::blink::MaskFilterInfo::clip_id) clip_id(
      const ::gfx::mojom::blink::MaskFilterInfoPtr& input) {
    return input->clip_id;
  }

  static bool Read(::gfx::mojom::blink::MaskFilterInfo::DataView input, ::gfx::mojom::blink::MaskFilterInfoPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_BLINK_H_