// ui/gfx/mojom/hdr_static_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_HDR_STATIC_METADATA_MOJOM_H_
#define UI_GFX_MOJOM_HDR_STATIC_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/hdr_static_metadata.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/hdr_static_metadata.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/hdr_static_metadata.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/gfx/mojom/hdr_static_metadata_mojom_traits.h"




namespace gfx::mojom {





class  HDRStaticMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HDRStaticMetadata, T>::value>;
  using DataView = HDRStaticMetadataDataView;
  using Data_ = internal::HDRStaticMetadata_Data;

  template <typename... Args>
  static HDRStaticMetadataPtr New(Args&&... args) {
    return HDRStaticMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HDRStaticMetadataPtr From(const U& u) {
    return mojo::TypeConverter<HDRStaticMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HDRStaticMetadata>::Convert(*this);
  }


  HDRStaticMetadata();

  HDRStaticMetadata(
      float max,
      float max_avg,
      float min,
      uint8_t supported_eotf_mask);


  ~HDRStaticMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HDRStaticMetadataPtr>
  HDRStaticMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HDRStaticMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HDRStaticMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HDRStaticMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HDRStaticMetadata_UnserializedMessageContext<
            UserType, HDRStaticMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HDRStaticMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HDRStaticMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HDRStaticMetadata_UnserializedMessageContext<
            UserType, HDRStaticMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HDRStaticMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float max;
  
  float max_avg;
  
  float min;
  
  uint8_t supported_eotf_mask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HDRStaticMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
HDRStaticMetadataPtr HDRStaticMetadata::Clone() const {
  return New(
      mojo::Clone(max),
      mojo::Clone(max_avg),
      mojo::Clone(min),
      mojo::Clone(supported_eotf_mask)
  );
}

template <typename T, HDRStaticMetadata::EnableIfSame<T>*>
bool HDRStaticMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max, other_struct.max))
    return false;
  if (!mojo::Equals(this->max_avg, other_struct.max_avg))
    return false;
  if (!mojo::Equals(this->min, other_struct.min))
    return false;
  if (!mojo::Equals(this->supported_eotf_mask, other_struct.supported_eotf_mask))
    return false;
  return true;
}

template <typename T, HDRStaticMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max < rhs.max)
    return true;
  if (rhs.max < lhs.max)
    return false;
  if (lhs.max_avg < rhs.max_avg)
    return true;
  if (rhs.max_avg < lhs.max_avg)
    return false;
  if (lhs.min < rhs.min)
    return true;
  if (rhs.min < lhs.min)
    return false;
  if (lhs.supported_eotf_mask < rhs.supported_eotf_mask)
    return true;
  if (rhs.supported_eotf_mask < lhs.supported_eotf_mask)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::HDRStaticMetadata::DataView,
                                         ::gfx::mojom::HDRStaticMetadataPtr> {
  static bool IsNull(const ::gfx::mojom::HDRStaticMetadataPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::HDRStaticMetadataPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::HDRStaticMetadata::max) max(
      const ::gfx::mojom::HDRStaticMetadataPtr& input) {
    return input->max;
  }

  static decltype(::gfx::mojom::HDRStaticMetadata::max_avg) max_avg(
      const ::gfx::mojom::HDRStaticMetadataPtr& input) {
    return input->max_avg;
  }

  static decltype(::gfx::mojom::HDRStaticMetadata::min) min(
      const ::gfx::mojom::HDRStaticMetadataPtr& input) {
    return input->min;
  }

  static decltype(::gfx::mojom::HDRStaticMetadata::supported_eotf_mask) supported_eotf_mask(
      const ::gfx::mojom::HDRStaticMetadataPtr& input) {
    return input->supported_eotf_mask;
  }

  static bool Read(::gfx::mojom::HDRStaticMetadata::DataView input, ::gfx::mojom::HDRStaticMetadataPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_HDR_STATIC_METADATA_MOJOM_H_