// ui/gfx/mojom/delegated_ink_point.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DELEGATED_INK_POINT_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_DELEGATED_INK_POINT_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/delegated_ink_point.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "ui/gfx/mojom/delegated_ink_point.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::DelegatedInkPointDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::DelegatedInkPointDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::DelegatedInkPoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::point(input)) in_point = Traits::point(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->point)::BaseType> point_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_point,
        point_fragment);

      fragment->point.Set(
          point_fragment.is_null() ? nullptr : point_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->point.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null point in DelegatedInkPoint struct");

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in DelegatedInkPoint struct");

      fragment->pointer_id = Traits::pointer_id(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_DELEGATED_INK_POINT_MOJOM_SEND_VALIDATION_H_