// ui/gfx/mojom/buffer_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"

#include "ui/gfx/mojom/buffer_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gfx::mojom::BufferFormat, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gfx::mojom::BufferUsage, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gfx::mojom::BufferPlane, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::BufferUsageAndFormatDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::BufferUsageAndFormatDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::BufferUsageAndFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
        Traits::usage(input),
        &fragment->usage);

      
      mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
        Traits::format(input),
        &fragment->format);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::GpuMemoryBufferIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuMemoryBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::GpuMemoryBufferHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferHandleDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuMemoryBufferHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->offset = Traits::offset(input);

      fragment->stride = Traits::stride(input);

      decltype(Traits::platform_handle(input)) in_platform_handle = Traits::platform_handle(input);
      mojo::internal::MessageFragment<decltype(fragment->platform_handle)>
          platform_handle_fragment(fragment.message());
      platform_handle_fragment.Claim(&fragment->platform_handle);
      
      mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, send_validation>(
        in_platform_handle,
        platform_handle_fragment,
        true);
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SEND_VALIDATION_H_