// ui/events/mojom/event_constants.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/mojom/event_constants.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/event_constants.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* AcceleratorPhaseToStringHelper(AcceleratorPhase value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AcceleratorPhase::PRE_TARGET:
      return "PRE_TARGET";
    case AcceleratorPhase::POST_TARGET:
      return "POST_TARGET";
    default:
      return nullptr;
  }
}

std::string AcceleratorPhaseToString(AcceleratorPhase value) {
  const char *str = AcceleratorPhaseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AcceleratorPhase value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AcceleratorPhase value) {
  return os << AcceleratorPhaseToString(value);
}

NOINLINE static const char* EventTypeToStringHelper(EventType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EventType::UNKNOWN:
      return "UNKNOWN";
    case EventType::KEY_PRESSED:
      return "KEY_PRESSED";
    case EventType::KEY_RELEASED:
      return "KEY_RELEASED";
    case EventType::GESTURE_TAP:
      return "GESTURE_TAP";
    case EventType::GESTURE_SWIPE:
      return "GESTURE_SWIPE";
    case EventType::GESTURE_PINCH_BEGIN:
      return "GESTURE_PINCH_BEGIN";
    case EventType::GESTURE_PINCH_END:
      return "GESTURE_PINCH_END";
    case EventType::GESTURE_PINCH_UPDATE:
      return "GESTURE_PINCH_UPDATE";
    case EventType::SCROLL:
      return "SCROLL";
    case EventType::SCROLL_FLING_START:
      return "SCROLL_FLING_START";
    case EventType::SCROLL_FLING_CANCEL:
      return "SCROLL_FLING_CANCEL";
    case EventType::CANCEL_MODE:
      return "CANCEL_MODE";
    case EventType::MOUSE_PRESSED_EVENT:
      return "MOUSE_PRESSED_EVENT";
    case EventType::MOUSE_DRAGGED_EVENT:
      return "MOUSE_DRAGGED_EVENT";
    case EventType::MOUSE_RELEASED_EVENT:
      return "MOUSE_RELEASED_EVENT";
    case EventType::MOUSE_MOVED_EVENT:
      return "MOUSE_MOVED_EVENT";
    case EventType::MOUSE_ENTERED_EVENT:
      return "MOUSE_ENTERED_EVENT";
    case EventType::MOUSE_EXITED_EVENT:
      return "MOUSE_EXITED_EVENT";
    case EventType::MOUSE_WHEEL_EVENT:
      return "MOUSE_WHEEL_EVENT";
    case EventType::MOUSE_CAPTURE_CHANGED_EVENT:
      return "MOUSE_CAPTURE_CHANGED_EVENT";
    case EventType::TOUCH_RELEASED:
      return "TOUCH_RELEASED";
    case EventType::TOUCH_PRESSED:
      return "TOUCH_PRESSED";
    case EventType::TOUCH_MOVED:
      return "TOUCH_MOVED";
    case EventType::TOUCH_CANCELLED:
      return "TOUCH_CANCELLED";
    default:
      return nullptr;
  }
}

std::string EventTypeToString(EventType value) {
  const char *str = EventTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EventType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EventType value) {
  return os << EventTypeToString(value);
}

NOINLINE static const char* ScrollEventPhaseToStringHelper(ScrollEventPhase value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollEventPhase::kNone:
      return "kNone";
    case ScrollEventPhase::kBegan:
      return "kBegan";
    case ScrollEventPhase::kUpdate:
      return "kUpdate";
    case ScrollEventPhase::kEnd:
      return "kEnd";
    default:
      return nullptr;
  }
}

std::string ScrollEventPhaseToString(ScrollEventPhase value) {
  const char *str = ScrollEventPhaseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollEventPhase value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollEventPhase value) {
  return os << ScrollEventPhaseToString(value);
}

NOINLINE static const char* EventMomentumPhaseToStringHelper(EventMomentumPhase value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EventMomentumPhase::NONE:
      return "NONE";
    case EventMomentumPhase::BEGAN:
      return "BEGAN";
    case EventMomentumPhase::MAY_BEGIN:
      return "MAY_BEGIN";
    case EventMomentumPhase::INERTIAL_UPDATE:
      return "INERTIAL_UPDATE";
    case EventMomentumPhase::END:
      return "END";
    case EventMomentumPhase::BLOCKED:
      return "BLOCKED";
    default:
      return nullptr;
  }
}

std::string EventMomentumPhaseToString(EventMomentumPhase value) {
  const char *str = EventMomentumPhaseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EventMomentumPhase value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EventMomentumPhase value) {
  return os << EventMomentumPhaseToString(value);
}

NOINLINE static const char* GestureDeviceTypeToStringHelper(GestureDeviceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GestureDeviceType::DEVICE_UNKNOWN:
      return "DEVICE_UNKNOWN";
    case GestureDeviceType::DEVICE_TOUCHPAD:
      return "DEVICE_TOUCHPAD";
    case GestureDeviceType::DEVICE_TOUCHSCREEN:
      return "DEVICE_TOUCHSCREEN";
    default:
      return nullptr;
  }
}

std::string GestureDeviceTypeToString(GestureDeviceType value) {
  const char *str = GestureDeviceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GestureDeviceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GestureDeviceType value) {
  return os << GestureDeviceTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::AcceleratorPhase>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::AcceleratorPhase value) {
  return std::move(context).WriteString(::ui::mojom::AcceleratorPhaseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::EventType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::EventType value) {
  return std::move(context).WriteString(::ui::mojom::EventTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::ScrollEventPhase>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::ScrollEventPhase value) {
  return std::move(context).WriteString(::ui::mojom::ScrollEventPhaseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::EventMomentumPhase>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::EventMomentumPhase value) {
  return std::move(context).WriteString(::ui::mojom::EventMomentumPhaseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::GestureDeviceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::GestureDeviceType value) {
  return std::move(context).WriteString(::ui::mojom::GestureDeviceTypeToString(value));
}

} // namespace perfetto