// ui/display/mojom/display_snapshot.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_SEND_VALIDATION_H_
#define UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_SEND_VALIDATION_H_

#include "ui/display/mojom/display_snapshot.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"
#include "ui/display/mojom/display_constants.mojom-shared.h"
#include "ui/display/mojom/display_mode.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_static_metadata.mojom-shared.h"

#include "ui/display/mojom/display_snapshot.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::DisplaySnapshotColorInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplaySnapshotColorInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplaySnapshotColorInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_space)::BaseType> color_space_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView, send_validation>(
        in_color_space,
        color_space_fragment);

      fragment->color_space.Set(
          color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_space.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in DisplaySnapshotColorInfo struct");

      decltype(Traits::edid_primaries(input)) in_edid_primaries = Traits::edid_primaries(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->edid_primaries)::BaseType> edid_primaries_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorSpacePrimariesDataView, send_validation>(
        in_edid_primaries,
        edid_primaries_fragment);

      fragment->edid_primaries.Set(
          edid_primaries_fragment.is_null() ? nullptr : edid_primaries_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->edid_primaries.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null edid_primaries in DisplaySnapshotColorInfo struct");

      fragment->edid_gamma = Traits::edid_gamma(input);

      decltype(Traits::hdr_static_metadata(input)) in_hdr_static_metadata = Traits::hdr_static_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hdr_static_metadata)::BaseType> hdr_static_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::HDRStaticMetadataDataView, send_validation>(
        in_hdr_static_metadata,
        hdr_static_metadata_fragment);

      fragment->hdr_static_metadata.Set(
          hdr_static_metadata_fragment.is_null() ? nullptr : hdr_static_metadata_fragment.data());

      fragment->supports_color_temperature_adjustment = Traits::supports_color_temperature_adjustment(input);

      fragment->bits_per_channel = Traits::bits_per_channel(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::DisplaySnapshotDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplaySnapshotDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplaySnapshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->display_id = Traits::display_id(input);

      fragment->port_display_id = Traits::port_display_id(input);

      fragment->edid_display_id = Traits::edid_display_id(input);

      fragment->connector_index = Traits::connector_index(input);

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in DisplaySnapshot struct");

      decltype(Traits::physical_size(input)) in_physical_size = Traits::physical_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->physical_size)::BaseType> physical_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_physical_size,
        physical_size_fragment);

      fragment->physical_size.Set(
          physical_size_fragment.is_null() ? nullptr : physical_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->physical_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null physical_size in DisplaySnapshot struct");

      
      mojo::internal::Serialize<::display::mojom::DisplayConnectionType>(
        Traits::type(input),
        &fragment->type);

      fragment->base_connector_id = Traits::base_connector_id(input);

      decltype(Traits::path_topology(input)) in_path_topology = Traits::path_topology(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path_topology)::BaseType>
          path_topology_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& path_topology_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>, send_validation>(
        in_path_topology,
        path_topology_fragment,
        &path_topology_validate_params);

      fragment->path_topology.Set(
          path_topology_fragment.is_null() ? nullptr : path_topology_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path_topology.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path_topology in DisplaySnapshot struct");

      fragment->is_aspect_preserving_scaling = Traits::is_aspect_preserving_scaling(input);

      fragment->has_overscan = Traits::has_overscan(input);

      
      mojo::internal::Serialize<::display::mojom::PrivacyScreenState>(
        Traits::privacy_screen_state(input),
        &fragment->privacy_screen_state);

      fragment->has_content_protection_key = Traits::has_content_protection_key(input);

      decltype(Traits::color_info(input)) in_color_info = Traits::color_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_info)::BaseType> color_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::display::mojom::DisplaySnapshotColorInfoDataView, send_validation>(
        in_color_info,
        color_info_fragment);

      fragment->color_info.Set(
          color_info_fragment.is_null() ? nullptr : color_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_info in DisplaySnapshot struct");

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in DisplaySnapshot struct");

      decltype(Traits::sys_path(input)) in_sys_path = Traits::sys_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sys_path)::BaseType> sys_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_sys_path,
        sys_path_fragment);

      fragment->sys_path.Set(
          sys_path_fragment.is_null() ? nullptr : sys_path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sys_path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sys_path in DisplaySnapshot struct");

      decltype(Traits::modes(input)) in_modes = Traits::modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->modes)::BaseType>
          modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& modes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplayModeDataView>, send_validation>(
        in_modes,
        modes_fragment,
        &modes_validate_params);

      fragment->modes.Set(
          modes_fragment.is_null() ? nullptr : modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modes in DisplaySnapshot struct");

      
      mojo::internal::Serialize<::display::mojom::PanelOrientation>(
        Traits::panel_orientation(input),
        &fragment->panel_orientation);

      decltype(Traits::edid(input)) in_edid = Traits::edid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->edid)::BaseType>
          edid_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& edid_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_edid,
        edid_fragment,
        &edid_validate_params);

      fragment->edid.Set(
          edid_fragment.is_null() ? nullptr : edid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->edid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null edid in DisplaySnapshot struct");

      fragment->current_mode_index = Traits::current_mode_index(input);

      fragment->has_current_mode = Traits::has_current_mode(input);

      fragment->native_mode_index = Traits::native_mode_index(input);

      fragment->has_native_mode = Traits::has_native_mode(input);

      fragment->product_code = Traits::product_code(input);

      fragment->year_of_manufacture = Traits::year_of_manufacture(input);

      decltype(Traits::maximum_cursor_size(input)) in_maximum_cursor_size = Traits::maximum_cursor_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->maximum_cursor_size)::BaseType> maximum_cursor_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_maximum_cursor_size,
        maximum_cursor_size_fragment);

      fragment->maximum_cursor_size.Set(
          maximum_cursor_size_fragment.is_null() ? nullptr : maximum_cursor_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->maximum_cursor_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maximum_cursor_size in DisplaySnapshot struct");

      
      mojo::internal::Serialize<::display::mojom::VariableRefreshRateState>(
        Traits::variable_refresh_rate_state(input),
        &fragment->variable_refresh_rate_state);
  }
};

}  // namespace mojo::internal

#endif  // UI_DISPLAY_MOJOM_DISPLAY_SNAPSHOT_MOJOM_SEND_VALIDATION_H_