// ui/display/mojom/display_color_management.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_BLINK_H_
#define UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display_color_management.mojom-features.h"  // IWYU pragma: export
#include "ui/display/mojom/display_color_management.mojom-shared.h"  // IWYU pragma: export
#include "ui/display/mojom/display_color_management.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace.mojom-blink.h"
#include "ui/display/mojom/gamma_ramp_rgb_entry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace display::mojom::blink {











class  GammaCurve {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GammaCurve, T>::value>;
  using DataView = GammaCurveDataView;
  using Data_ = internal::GammaCurve_Data;

  template <typename... Args>
  static GammaCurvePtr New(Args&&... args) {
    return GammaCurvePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GammaCurvePtr From(const U& u) {
    return mojo::TypeConverter<GammaCurvePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GammaCurve>::Convert(*this);
  }


  GammaCurve();

  explicit GammaCurve(
      ::blink::Vector<::display::mojom::blink::GammaRampRGBEntryPtr> lut);

GammaCurve(const GammaCurve&) = delete;
GammaCurve& operator=(const GammaCurve&) = delete;

  ~GammaCurve();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GammaCurvePtr>
  GammaCurvePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GammaCurve::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GammaCurve::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GammaCurve::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GammaCurve_UnserializedMessageContext<
            UserType, GammaCurve::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GammaCurve::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GammaCurve::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GammaCurve_UnserializedMessageContext<
            UserType, GammaCurve::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GammaCurve::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::display::mojom::blink::GammaRampRGBEntryPtr> lut;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GammaCurve::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ColorCalibration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorCalibration, T>::value>;
  using DataView = ColorCalibrationDataView;
  using Data_ = internal::ColorCalibration_Data;

  template <typename... Args>
  static ColorCalibrationPtr New(Args&&... args) {
    return ColorCalibrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorCalibrationPtr From(const U& u) {
    return mojo::TypeConverter<ColorCalibrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorCalibration>::Convert(*this);
  }


  ColorCalibration();

  ColorCalibration(
      GammaCurvePtr srgb_to_linear,
      const ::skcms_Matrix3x3& srgb_to_device_matrix,
      GammaCurvePtr linear_to_device);

ColorCalibration(const ColorCalibration&) = delete;
ColorCalibration& operator=(const ColorCalibration&) = delete;

  ~ColorCalibration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorCalibrationPtr>
  ColorCalibrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorCalibration::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorCalibration::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorCalibration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorCalibration_UnserializedMessageContext<
            UserType, ColorCalibration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorCalibration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorCalibration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorCalibration_UnserializedMessageContext<
            UserType, ColorCalibration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorCalibration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GammaCurvePtr srgb_to_linear;
  
  ::skcms_Matrix3x3 srgb_to_device_matrix;
  
  GammaCurvePtr linear_to_device;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorCalibration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ColorTemperatureAdjustment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorTemperatureAdjustment, T>::value>;
  using DataView = ColorTemperatureAdjustmentDataView;
  using Data_ = internal::ColorTemperatureAdjustment_Data;

  template <typename... Args>
  static ColorTemperatureAdjustmentPtr New(Args&&... args) {
    return ColorTemperatureAdjustmentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorTemperatureAdjustmentPtr From(const U& u) {
    return mojo::TypeConverter<ColorTemperatureAdjustmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorTemperatureAdjustment>::Convert(*this);
  }


  ColorTemperatureAdjustment();

  explicit ColorTemperatureAdjustment(
      const ::skcms_Matrix3x3& srgb_matrix);


  ~ColorTemperatureAdjustment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorTemperatureAdjustmentPtr>
  ColorTemperatureAdjustmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorTemperatureAdjustment::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorTemperatureAdjustment::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorTemperatureAdjustment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorTemperatureAdjustment_UnserializedMessageContext<
            UserType, ColorTemperatureAdjustment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorTemperatureAdjustment::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorTemperatureAdjustment::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorTemperatureAdjustment_UnserializedMessageContext<
            UserType, ColorTemperatureAdjustment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorTemperatureAdjustment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::skcms_Matrix3x3 srgb_matrix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GammaAdjustment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GammaAdjustment, T>::value>;
  using DataView = GammaAdjustmentDataView;
  using Data_ = internal::GammaAdjustment_Data;

  template <typename... Args>
  static GammaAdjustmentPtr New(Args&&... args) {
    return GammaAdjustmentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GammaAdjustmentPtr From(const U& u) {
    return mojo::TypeConverter<GammaAdjustmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GammaAdjustment>::Convert(*this);
  }


  GammaAdjustment();

  explicit GammaAdjustment(
      GammaCurvePtr curve);

GammaAdjustment(const GammaAdjustment&) = delete;
GammaAdjustment& operator=(const GammaAdjustment&) = delete;

  ~GammaAdjustment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GammaAdjustmentPtr>
  GammaAdjustmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GammaAdjustment::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GammaAdjustment::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GammaAdjustment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GammaAdjustment_UnserializedMessageContext<
            UserType, GammaAdjustment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GammaAdjustment::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GammaAdjustment::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GammaAdjustment_UnserializedMessageContext<
            UserType, GammaAdjustment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GammaAdjustment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GammaCurvePtr curve;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GammaAdjustment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GammaCurvePtr GammaCurve::Clone() const {
  return New(
      mojo::Clone(lut)
  );
}

template <typename T, GammaCurve::EnableIfSame<T>*>
bool GammaCurve::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lut, other_struct.lut))
    return false;
  return true;
}

template <typename T, GammaCurve::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lut < rhs.lut)
    return true;
  if (rhs.lut < lhs.lut)
    return false;
  return false;
}
template <typename StructPtrType>
ColorCalibrationPtr ColorCalibration::Clone() const {
  return New(
      mojo::Clone(srgb_to_linear),
      mojo::Clone(srgb_to_device_matrix),
      mojo::Clone(linear_to_device)
  );
}

template <typename T, ColorCalibration::EnableIfSame<T>*>
bool ColorCalibration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->srgb_to_linear, other_struct.srgb_to_linear))
    return false;
  if (!mojo::Equals(this->srgb_to_device_matrix, other_struct.srgb_to_device_matrix))
    return false;
  if (!mojo::Equals(this->linear_to_device, other_struct.linear_to_device))
    return false;
  return true;
}

template <typename T, ColorCalibration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.srgb_to_linear < rhs.srgb_to_linear)
    return true;
  if (rhs.srgb_to_linear < lhs.srgb_to_linear)
    return false;
  if (lhs.srgb_to_device_matrix < rhs.srgb_to_device_matrix)
    return true;
  if (rhs.srgb_to_device_matrix < lhs.srgb_to_device_matrix)
    return false;
  if (lhs.linear_to_device < rhs.linear_to_device)
    return true;
  if (rhs.linear_to_device < lhs.linear_to_device)
    return false;
  return false;
}
template <typename StructPtrType>
ColorTemperatureAdjustmentPtr ColorTemperatureAdjustment::Clone() const {
  return New(
      mojo::Clone(srgb_matrix)
  );
}

template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>*>
bool ColorTemperatureAdjustment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->srgb_matrix, other_struct.srgb_matrix))
    return false;
  return true;
}

template <typename T, ColorTemperatureAdjustment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.srgb_matrix < rhs.srgb_matrix)
    return true;
  if (rhs.srgb_matrix < lhs.srgb_matrix)
    return false;
  return false;
}
template <typename StructPtrType>
GammaAdjustmentPtr GammaAdjustment::Clone() const {
  return New(
      mojo::Clone(curve)
  );
}

template <typename T, GammaAdjustment::EnableIfSame<T>*>
bool GammaAdjustment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->curve, other_struct.curve))
    return false;
  return true;
}

template <typename T, GammaAdjustment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.curve < rhs.curve)
    return true;
  if (rhs.curve < lhs.curve)
    return false;
  return false;
}


}  // display::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::display::mojom::blink::GammaCurve::DataView,
                                         ::display::mojom::blink::GammaCurvePtr> {
  static bool IsNull(const ::display::mojom::blink::GammaCurvePtr& input) { return !input; }
  static void SetToNull(::display::mojom::blink::GammaCurvePtr* output) { output->reset(); }

  static const decltype(::display::mojom::blink::GammaCurve::lut)& lut(
      const ::display::mojom::blink::GammaCurvePtr& input) {
    return input->lut;
  }

  static bool Read(::display::mojom::blink::GammaCurve::DataView input, ::display::mojom::blink::GammaCurvePtr* output);
};


template <>
struct  StructTraits<::display::mojom::blink::ColorCalibration::DataView,
                                         ::display::mojom::blink::ColorCalibrationPtr> {
  static bool IsNull(const ::display::mojom::blink::ColorCalibrationPtr& input) { return !input; }
  static void SetToNull(::display::mojom::blink::ColorCalibrationPtr* output) { output->reset(); }

  static const decltype(::display::mojom::blink::ColorCalibration::srgb_to_linear)& srgb_to_linear(
      const ::display::mojom::blink::ColorCalibrationPtr& input) {
    return input->srgb_to_linear;
  }

  static const decltype(::display::mojom::blink::ColorCalibration::srgb_to_device_matrix)& srgb_to_device_matrix(
      const ::display::mojom::blink::ColorCalibrationPtr& input) {
    return input->srgb_to_device_matrix;
  }

  static const decltype(::display::mojom::blink::ColorCalibration::linear_to_device)& linear_to_device(
      const ::display::mojom::blink::ColorCalibrationPtr& input) {
    return input->linear_to_device;
  }

  static bool Read(::display::mojom::blink::ColorCalibration::DataView input, ::display::mojom::blink::ColorCalibrationPtr* output);
};


template <>
struct  StructTraits<::display::mojom::blink::ColorTemperatureAdjustment::DataView,
                                         ::display::mojom::blink::ColorTemperatureAdjustmentPtr> {
  static bool IsNull(const ::display::mojom::blink::ColorTemperatureAdjustmentPtr& input) { return !input; }
  static void SetToNull(::display::mojom::blink::ColorTemperatureAdjustmentPtr* output) { output->reset(); }

  static const decltype(::display::mojom::blink::ColorTemperatureAdjustment::srgb_matrix)& srgb_matrix(
      const ::display::mojom::blink::ColorTemperatureAdjustmentPtr& input) {
    return input->srgb_matrix;
  }

  static bool Read(::display::mojom::blink::ColorTemperatureAdjustment::DataView input, ::display::mojom::blink::ColorTemperatureAdjustmentPtr* output);
};


template <>
struct  StructTraits<::display::mojom::blink::GammaAdjustment::DataView,
                                         ::display::mojom::blink::GammaAdjustmentPtr> {
  static bool IsNull(const ::display::mojom::blink::GammaAdjustmentPtr& input) { return !input; }
  static void SetToNull(::display::mojom::blink::GammaAdjustmentPtr* output) { output->reset(); }

  static const decltype(::display::mojom::blink::GammaAdjustment::curve)& curve(
      const ::display::mojom::blink::GammaAdjustmentPtr& input) {
    return input->curve;
  }

  static bool Read(::display::mojom::blink::GammaAdjustment::DataView input, ::display::mojom::blink::GammaAdjustmentPtr* output);
};

}  // namespace mojo

#endif  // UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_BLINK_H_