// ui/base/mojom/themes.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/mojom/themes.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/themes.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* BrowserColorVariantToStringHelper(BrowserColorVariant value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BrowserColorVariant::kSystem:
      return "kSystem";
    case BrowserColorVariant::kTonalSpot:
      return "kTonalSpot";
    case BrowserColorVariant::kNeutral:
      return "kNeutral";
    case BrowserColorVariant::kVibrant:
      return "kVibrant";
    case BrowserColorVariant::kExpressive:
      return "kExpressive";
    default:
      return nullptr;
  }
}

std::string BrowserColorVariantToString(BrowserColorVariant value) {
  const char *str = BrowserColorVariantToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BrowserColorVariant value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BrowserColorVariant value) {
  return os << BrowserColorVariantToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::BrowserColorVariant>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::BrowserColorVariant value) {
  return std::move(context).WriteString(::ui::mojom::BrowserColorVariantToString(value));
}

} // namespace perfetto