// ui/base/mojom/attributed_string.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/base/mojom/attributed_string.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/attributed_string.mojom-params-data.h"
#include "ui/base/mojom/attributed_string.mojom-shared-message-ids.h"

#include "ui/base/mojom/attributed_string.mojom-import-headers.h"
#include "ui/base/mojom/attributed_string.mojom-test-utils.h"


namespace ui::mojom {
FontAttribute::FontAttribute()
    : font_name(),
      font_point_size(),
      effective_range() {}

FontAttribute::FontAttribute(
    const ::std::u16string& font_name_in,
    float font_point_size_in,
    const ::gfx::Range& effective_range_in)
    : font_name(std::move(font_name_in)),
      font_point_size(std::move(font_point_size_in)),
      effective_range(std::move(effective_range_in)) {}

FontAttribute::~FontAttribute() = default;

void FontAttribute::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_name"), this->font_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_point_size"), this->font_point_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effective_range"), this->effective_range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Range&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FontAttribute::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AttributedString::AttributedString()
    : string(),
      attributes() {}

AttributedString::AttributedString(
    const ::std::u16string& string_in,
    std::vector<FontAttributePtr> attributes_in)
    : string(std::move(string_in)),
      attributes(std::move(attributes_in)) {}

AttributedString::~AttributedString() = default;

void AttributedString::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string"), this->string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attributes"), this->attributes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FontAttributePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AttributedString::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ui::mojom


namespace mojo {


// static
bool StructTraits<::ui::mojom::FontAttribute::DataView, ::ui::mojom::FontAttributePtr>::Read(
    ::ui::mojom::FontAttribute::DataView input,
    ::ui::mojom::FontAttributePtr* output) {
  bool success = true;
  ::ui::mojom::FontAttributePtr result(::ui::mojom::FontAttribute::New());
  
      if (success && !input.ReadFontName(&result->font_name))
        success = false;
      if (success)
        result->font_point_size = input.font_point_size();
      if (success && !input.ReadEffectiveRange(&result->effective_range))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::AttributedString::DataView, ::ui::mojom::AttributedStringPtr>::Read(
    ::ui::mojom::AttributedString::DataView input,
    ::ui::mojom::AttributedStringPtr* output) {
  bool success = true;
  ::ui::mojom::AttributedStringPtr result(::ui::mojom::AttributedString::New());
  
      if (success && !input.ReadString(&result->string))
        success = false;
      if (success && !input.ReadAttributes(&result->attributes))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ui::mojom {




}  // ui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif