// ui/base/mojom/attributed_string.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_SEND_VALIDATION_H_
#define UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_SEND_VALIDATION_H_

#include "ui/base/mojom/attributed_string.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"

#include "ui/base/mojom/attributed_string.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::FontAttributeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::FontAttributeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::FontAttribute_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::font_name(input)) in_font_name = Traits::font_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->font_name)::BaseType> font_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_font_name,
        font_name_fragment);

      fragment->font_name.Set(
          font_name_fragment.is_null() ? nullptr : font_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->font_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null font_name in FontAttribute struct");

      fragment->font_point_size = Traits::font_point_size(input);

      decltype(Traits::effective_range(input)) in_effective_range = Traits::effective_range(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->effective_range)::BaseType> effective_range_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RangeDataView, send_validation>(
        in_effective_range,
        effective_range_fragment);

      fragment->effective_range.Set(
          effective_range_fragment.is_null() ? nullptr : effective_range_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->effective_range.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null effective_range in FontAttribute struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::AttributedStringDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::AttributedStringDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::AttributedString_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::string(input)) in_string = Traits::string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->string)::BaseType> string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_string,
        string_fragment);

      fragment->string.Set(
          string_fragment.is_null() ? nullptr : string_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->string.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string in AttributedString struct");

      decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attributes)::BaseType>
          attributes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& attributes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::FontAttributeDataView>, send_validation>(
        in_attributes,
        attributes_fragment,
        &attributes_validate_params);

      fragment->attributes.Set(
          attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attributes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attributes in AttributedString struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_BASE_MOJOM_ATTRIBUTED_STRING_MOJOM_SEND_VALIDATION_H_