// ui/base/accelerators/mojom/accelerator.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/accelerators/mojom/accelerator.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* AcceleratorKeyStateToStringHelper(AcceleratorKeyState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AcceleratorKeyState::PRESSED:
      return "PRESSED";
    case AcceleratorKeyState::RELEASED:
      return "RELEASED";
    default:
      return nullptr;
  }
}

std::string AcceleratorKeyStateToString(AcceleratorKeyState value) {
  const char *str = AcceleratorKeyStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AcceleratorKeyState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AcceleratorKeyState value) {
  return os << AcceleratorKeyStateToString(value);
}

namespace internal {


// static
bool Accelerator_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Accelerator_Data* object =
      static_cast<const Accelerator_Data*>(data);


  if (!::ui::mojom::internal::AcceleratorKeyState_Data
        ::Validate(object->key_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_stamp, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_stamp, validation_context))
    return false;

  return true;
}

Accelerator_Data::Accelerator_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::AcceleratorKeyState>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::AcceleratorKeyState value) {
  return std::move(context).WriteString(::ui::mojom::AcceleratorKeyStateToString(value));
}

} // namespace perfetto