// ui/accessibility/mojom/ax_updates_and_events.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_updates_and_events.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-import-headers.h"
#include "ui/accessibility/mojom/ax_updates_and_events.mojom-test-utils.h"


namespace ax::mojom {
AXUpdatesAndEvents::AXUpdatesAndEvents()
    : tree_id(),
      updates(),
      events() {}

AXUpdatesAndEvents::AXUpdatesAndEvents(
    const ::ui::AXTreeID& tree_id_in,
    std::vector<::ui::AXTreeUpdate> updates_in,
    std::vector<::ui::AXEvent> events_in)
    : tree_id(std::move(tree_id_in)),
      updates(std::move(updates_in)),
      events(std::move(events_in)) {}

AXUpdatesAndEvents::~AXUpdatesAndEvents() = default;

void AXUpdatesAndEvents::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tree_id"), this->tree_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::AXTreeID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updates"), this->updates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXTreeUpdate>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "events"), this->events,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXEvent>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXUpdatesAndEvents::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom


namespace mojo {


// static
bool StructTraits<::ax::mojom::AXUpdatesAndEvents::DataView, ::ax::mojom::AXUpdatesAndEventsPtr>::Read(
    ::ax::mojom::AXUpdatesAndEvents::DataView input,
    ::ax::mojom::AXUpdatesAndEventsPtr* output) {
  bool success = true;
  ::ax::mojom::AXUpdatesAndEventsPtr result(::ax::mojom::AXUpdatesAndEvents::New());
  
      if (success && !input.ReadTreeId(&result->tree_id))
        success = false;
      if (success && !input.ReadUpdates(&result->updates))
        success = false;
      if (success && !input.ReadEvents(&result->events))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom {




}  // ax::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif