// ui/accessibility/mojom/ax_updates_and_events.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXUpdatesAndEventsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXUpdatesAndEventsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXUpdatesAndEvents_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::tree_id(input)) in_tree_id = Traits::tree_id(input);
      mojo::internal::MessageFragment<decltype(fragment->tree_id)>
          tree_id_fragment(fragment.message());
      tree_id_fragment.Claim(&fragment->tree_id);
      
      mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView, send_validation>(
        in_tree_id,
        tree_id_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tree_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tree_id in AXUpdatesAndEvents struct");

      decltype(Traits::updates(input)) in_updates = Traits::updates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->updates)::BaseType>
          updates_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& updates_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>, send_validation>(
        in_updates,
        updates_fragment,
        &updates_validate_params);

      fragment->updates.Set(
          updates_fragment.is_null() ? nullptr : updates_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->updates.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updates in AXUpdatesAndEvents struct");

      decltype(Traits::events(input)) in_events = Traits::events(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->events)::BaseType>
          events_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXEventDataView>, send_validation>(
        in_events,
        events_fragment,
        &events_validate_params);

      fragment->events.Set(
          events_fragment.is_null() ? nullptr : events_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->events.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null events in AXUpdatesAndEvents struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_SEND_VALIDATION_H_