// ui/accessibility/mojom/ax_action_data.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_action_data.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var ax_enums$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/ax_enums.mojom', '../ax_enums.mojom.js');
  }
  var ax_tree_id$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/mojom/ax_tree_id.mojom', 'ax_tree_id.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../gfx/geometry/mojom/geometry.mojom.js');
  }



  function AXActionData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXActionData.prototype.initDefaults_ = function() {
    this.action = 0;
    this.targetNodeId = 0;
    this.targetTreeId = null;
    this.sourceExtensionId = null;
    this.requestId = 0;
    this.flags = 0;
    this.anchorNodeId = 0;
    this.anchorOffset = 0;
    this.focusNodeId = 0;
    this.focusOffset = 0;
    this.customActionId = 0;
    this.hitTestEventToFire = 0;
    this.targetRect = null;
    this.targetPoint = null;
    this.value = null;
    this.horizontalScrollAlignment = 0;
    this.verticalScrollAlignment = 0;
    this.scrollBehavior = 0;
    this.targetRole = ax_enums$.Role.kUnknown;
    this.childTreeId = null;
  };
  AXActionData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXActionData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 128}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.action
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ax_enums$.Action);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.targetTreeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.sourceExtensionId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;










    // validate AXActionData.targetRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.targetPoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 80, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.hitTestEventToFire
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 60, ax_enums$.Event);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.horizontalScrollAlignment
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 88, ax_enums$.ScrollAlignment);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.verticalScrollAlignment
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 92, ax_enums$.ScrollAlignment);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.scrollBehavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 96, ax_enums$.ScrollBehavior);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.childTreeId
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 104, ax_tree_id$.AXTreeID, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXActionData.targetRole
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, ax_enums$.Role);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXActionData.encodedSize = codec.kStructHeaderSize + 120;

  AXActionData.decode = function(decoder) {
    var packed;
    var val = new AXActionData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Action));
    val.targetNodeId =
        decoder.decodeStruct(codec.Int32);
    val.targetTreeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    val.sourceExtensionId =
        decoder.decodeStruct(codec.String);
    val.requestId =
        decoder.decodeStruct(codec.Int32);
    val.flags =
        decoder.decodeStruct(codec.Int32);
    val.anchorNodeId =
        decoder.decodeStruct(codec.Int32);
    val.anchorOffset =
        decoder.decodeStruct(codec.Int32);
    val.focusNodeId =
        decoder.decodeStruct(codec.Int32);
    val.focusOffset =
        decoder.decodeStruct(codec.Int32);
    val.customActionId =
        decoder.decodeStruct(codec.Int32);
    val.hitTestEventToFire =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Event));
    val.targetRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.targetPoint =
        decoder.decodeStructPointer(geometry$.Point);
    val.value =
        decoder.decodeStruct(codec.String);
    val.horizontalScrollAlignment =
        decoder.decodeStruct(new codec.Enum(ax_enums$.ScrollAlignment));
    val.verticalScrollAlignment =
        decoder.decodeStruct(new codec.Enum(ax_enums$.ScrollAlignment));
    val.scrollBehavior =
        decoder.decodeStruct(new codec.Enum(ax_enums$.ScrollBehavior));
    val.targetRole =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Role));
    val.childTreeId =
        decoder.decodeStruct(ax_tree_id$.AXTreeID);
    return val;
  };

  AXActionData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXActionData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.encodeStruct(codec.Int32, val.targetNodeId);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.targetTreeId);
    encoder.encodeStruct(codec.String, val.sourceExtensionId);
    encoder.encodeStruct(codec.Int32, val.requestId);
    encoder.encodeStruct(codec.Int32, val.flags);
    encoder.encodeStruct(codec.Int32, val.anchorNodeId);
    encoder.encodeStruct(codec.Int32, val.anchorOffset);
    encoder.encodeStruct(codec.Int32, val.focusNodeId);
    encoder.encodeStruct(codec.Int32, val.focusOffset);
    encoder.encodeStruct(codec.Int32, val.customActionId);
    encoder.encodeStruct(codec.Int32, val.hitTestEventToFire);
    encoder.encodeStructPointer(geometry$.Rect, val.targetRect);
    encoder.encodeStructPointer(geometry$.Point, val.targetPoint);
    encoder.encodeStruct(codec.String, val.value);
    encoder.encodeStruct(codec.Int32, val.horizontalScrollAlignment);
    encoder.encodeStruct(codec.Int32, val.verticalScrollAlignment);
    encoder.encodeStruct(codec.Int32, val.scrollBehavior);
    encoder.encodeStruct(codec.Int32, val.targetRole);
    encoder.encodeStruct(ax_tree_id$.AXTreeID, val.childTreeId);
  };
  exports.AXActionData = AXActionData;
})();