// ui/accessibility/mojom/ax_action_data.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_action_data.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_action_data.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_action_data.mojom-blink-import-headers.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace ax::mojom::blink {
AXActionData::AXActionData()
    : action(),
      target_tree_id(),
      source_extension_id(),
      target_node_id(),
      request_id(),
      flags(),
      anchor_node_id(),
      anchor_offset(),
      focus_node_id(),
      focus_offset(),
      custom_action_id(),
      target_rect(),
      target_point(),
      value(),
      hit_test_event_to_fire(),
      horizontal_scroll_alignment(),
      vertical_scroll_alignment(),
      scroll_behavior(),
      child_tree_id(),
      target_role(::ax::mojom::blink::Role::kUnknown) {}

AXActionData::AXActionData(
    ::ax::mojom::blink::Action action_in,
    ::ax::mojom::blink::AXTreeIDPtr target_tree_id_in,
    const ::blink::String& source_extension_id_in,
    int32_t target_node_id_in,
    int32_t request_id_in,
    int32_t flags_in,
    int32_t anchor_node_id_in,
    int32_t anchor_offset_in,
    int32_t focus_node_id_in,
    int32_t focus_offset_in,
    int32_t custom_action_id_in,
    const ::gfx::Rect& target_rect_in,
    const ::gfx::Point& target_point_in,
    const ::blink::String& value_in,
    ::ax::mojom::blink::Event hit_test_event_to_fire_in,
    ::ax::mojom::blink::ScrollAlignment horizontal_scroll_alignment_in,
    ::ax::mojom::blink::ScrollAlignment vertical_scroll_alignment_in,
    ::ax::mojom::blink::ScrollBehavior scroll_behavior_in,
    ::ax::mojom::blink::AXTreeIDPtr child_tree_id_in,
    ::ax::mojom::blink::Role target_role_in)
    : action(std::move(action_in)),
      target_tree_id(std::move(target_tree_id_in)),
      source_extension_id(std::move(source_extension_id_in)),
      target_node_id(std::move(target_node_id_in)),
      request_id(std::move(request_id_in)),
      flags(std::move(flags_in)),
      anchor_node_id(std::move(anchor_node_id_in)),
      anchor_offset(std::move(anchor_offset_in)),
      focus_node_id(std::move(focus_node_id_in)),
      focus_offset(std::move(focus_offset_in)),
      custom_action_id(std::move(custom_action_id_in)),
      target_rect(std::move(target_rect_in)),
      target_point(std::move(target_point_in)),
      value(std::move(value_in)),
      hit_test_event_to_fire(std::move(hit_test_event_to_fire_in)),
      horizontal_scroll_alignment(std::move(horizontal_scroll_alignment_in)),
      vertical_scroll_alignment(std::move(vertical_scroll_alignment_in)),
      scroll_behavior(std::move(scroll_behavior_in)),
      child_tree_id(std::move(child_tree_id_in)),
      target_role(std::move(target_role_in)) {}

AXActionData::~AXActionData() = default;

void AXActionData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::Action>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_tree_id"), this->target_tree_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::AXTreeIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_extension_id"), this->source_extension_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_node_id"), this->target_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_node_id"), this->anchor_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_offset"), this->anchor_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focus_node_id"), this->focus_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "focus_offset"), this->focus_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_action_id"), this->custom_action_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_rect"), this->target_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_point"), this->target_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_event_to_fire"), this->hit_test_event_to_fire,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::Event>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "horizontal_scroll_alignment"), this->horizontal_scroll_alignment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::ScrollAlignment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertical_scroll_alignment"), this->vertical_scroll_alignment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::ScrollAlignment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_behavior"), this->scroll_behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::ScrollBehavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_tree_id"), this->child_tree_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::AXTreeIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_role"), this->target_role,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::blink::Role>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXActionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom::blink


namespace mojo {


// static
bool StructTraits<::ax::mojom::blink::AXActionData::DataView, ::ax::mojom::blink::AXActionDataPtr>::Read(
    ::ax::mojom::blink::AXActionData::DataView input,
    ::ax::mojom::blink::AXActionDataPtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXActionDataPtr result(::ax::mojom::blink::AXActionData::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success && !input.ReadTargetTreeId(&result->target_tree_id))
        success = false;
      if (success && !input.ReadSourceExtensionId(&result->source_extension_id))
        success = false;
      if (success)
        result->target_node_id = input.target_node_id();
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->flags = input.flags();
      if (success)
        result->anchor_node_id = input.anchor_node_id();
      if (success)
        result->anchor_offset = input.anchor_offset();
      if (success)
        result->focus_node_id = input.focus_node_id();
      if (success)
        result->focus_offset = input.focus_offset();
      if (success)
        result->custom_action_id = input.custom_action_id();
      if (success && !input.ReadTargetRect(&result->target_rect))
        success = false;
      if (success && !input.ReadTargetPoint(&result->target_point))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadHitTestEventToFire(&result->hit_test_event_to_fire))
        success = false;
      if (success && !input.ReadHorizontalScrollAlignment(&result->horizontal_scroll_alignment))
        success = false;
      if (success && !input.ReadVerticalScrollAlignment(&result->vertical_scroll_alignment))
        success = false;
      if (success && !input.ReadScrollBehavior(&result->scroll_behavior))
        success = false;
      if (success && !input.ReadChildTreeId(&result->child_tree_id))
        success = false;
      if (success && !input.ReadTargetRole(&result->target_role))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom::blink {




}  // ax::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif