// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE SCHEMA DEFINITION AND DESCRIPTION IN
//   ../../third_party/search_engines_data/prepopulated_engines_schema.json
//   ../../third_party/search_engines_data/resources/definitions/prepopulated_engines.json
// using json_to_struct.py. DO NOT EDIT.

#include "prepopulated_engines.h"

namespace TemplateURLPrepopulateData {

const int kMaxPrepopulatedEngineID = 115;
const int kCurrentDataVersion = 191;

const char* const array_baidu_alternate_urls[] = {
  "https://www.baidu.com/s?ie={inputEncoding}&wd={searchTerms}",
  "https://www.baidu.com/s?ie={inputEncoding}&word={searchTerms}",
  "https://www.baidu.com/{google:pathWildcard}/s?ie={inputEncoding}&word={searchTerms}",
};
const PrepopulatedEngine baidu = {
  u"\x767e" u"\x5ea6" u"",
  u"baidu.com",
  "https://www.baidu.com/favicon.ico",
  nullptr,
  "https://www.baidu.com/#ie={inputEncoding}&wd={searchTerms}",
  "UTF-8",
  "https://suggestion.baidu.com/su?wd={searchTerms}&action=opensearch&ie={inputEncoding}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_baidu_alternate_urls,
  SEARCH_ENGINE_BAIDU,
  nullptr,
  nullptr,
  21,
  {},
};

const RegulatoryExtension array_bing_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "PC=U316&FORM=CHROMN",
    "PC=U316",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "PC=U534&FORM=U534DF",
    "PC=U534&FORM=U534SS",
  },
};
const PrepopulatedEngine bing = {
  u"Microsoft Bing",
  u"bing.com",
  "https://www.bing.com/sa/simg/bing_p_rr_teal_min.ico",
  "SEARCH_ENGINE_BING",
  "https://www.bing.com/search?q={searchTerms}",
  "UTF-8",
  "https://www.bing.com/osjson.aspx?query={searchTerms}&language={language}",
  "https://www.bing.com/images/detail/search?iss=sbiupload&FORM=CHROMI#enterInsights",
  nullptr,
  "https://www.bing.com/chrome/newtab",
  nullptr,
  "https://cdn.sapphire.microsoftapp.net/icons/bing_144.png",
  nullptr,
  nullptr,
  nullptr,
  "imageBin={google:imageThumbnailBase64}",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_BING,
  nullptr,
  nullptr,
  3,
  array_bing_regulatory_extensions,
};

const RegulatoryExtension array_brave_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "source=csChrome",
    nullptr,
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "source=csAndroid",
    nullptr,
  },
};
const PrepopulatedEngine brave = {
  u"Brave",
  u"search.brave.com",
  "https://cdn.search.brave.com/serp/favicon.ico",
  "SEARCH_ENGINE_BRAVE",
  "https://search.brave.com/search?q={searchTerms}",
  "UTF-8",
  "https://search.brave.com/api/suggest?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_BRAVE,
  nullptr,
  nullptr,
  109,
  array_brave_regulatory_extensions,
};

const PrepopulatedEngine coccoc = {
  u"C\x1ed1" u"c C\x1ed1" u"c",
  u"coccoc.com",
  "https://coccoc.com/favicon.ico",
  "SEARCH_ENGINE_COCCOC",
  "https://coccoc.com/search#query={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_COCCOC,
  nullptr,
  nullptr,
  91,
  {},
};

const PrepopulatedEngine daum = {
  u"Daum",
  u"daum.net",
  "https://search.daum.net/favicon.ico",
  nullptr,
  "https://search.daum.net/search?w=tot&DA=JU5&q={searchTerms}",
  "UTF-8",
  "https://suggest.search.daum.net/sushi/opensearch/pc?q={searchTerms}&DA=JU6",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_DAUM,
  nullptr,
  nullptr,
  68,
  {},
};

const RegulatoryExtension array_duckduckgo_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kAndroidEEA,
    "t=euandroid",
    nullptr,
  },
};
const PrepopulatedEngine duckduckgo = {
  u"DuckDuckGo",
  u"duckduckgo.com",
  "https://duckduckgo.com/favicon.ico",
  "SEARCH_ENGINE_DUCKDUCKGO",
  "https://duckduckgo.com/?q={searchTerms}",
  "UTF-8",
  "https://duckduckgo.com/ac/?q={searchTerms}&type=list",
  nullptr,
  nullptr,
  "https://duckduckgo.com/chrome_newtab",
  nullptr,
  "https://staticcdn.duckduckgo.com/serp-fe/www/logos/dynamic/DuckDuckGoLogo.png",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_DUCKDUCKGO,
  nullptr,
  nullptr,
  92,
  array_duckduckgo_regulatory_extensions,
};

const RegulatoryExtension array_ecosia_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "addon=opensearch",
    nullptr,
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "chrome_dse_attribution=1&tt=0387qhzr",
    nullptr,
  },
};
const PrepopulatedEngine ecosia = {
  u"Ecosia",
  u"ecosia.org",
  "https://cdn.ecosia.org/assets/images/ico/favicon.ico",
  "SEARCH_ENGINE_ECOSIA",
  "https://www.ecosia.org/search?q={searchTerms}",
  "UTF-8",
  "https://ac.ecosia.org?q={searchTerms}&mkt={language}&type=list&language={language}",
  nullptr,
  nullptr,
  "https://www.ecosia.org/newtab/",
  nullptr,
  "https://cdn.ecosia.org/static/icons/japan-choice-screen-logo.png",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_ECOSIA,
  nullptr,
  nullptr,
  101,
  array_ecosia_regulatory_extensions,
};

const PrepopulatedEngine freespoke = {
  u"Freespoke",
  u"freespoke",
  "https://freespoke.com/favicon-16x16.png",
  "SEARCH_ENGINE_FREESPOKE",
  "https://freespoke.com/search/web?q={searchTerms}",
  "UTF-8",
  "https://api-lb.freespoke.com/typeahead/v1/browser?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_FREESPOKE,
  nullptr,
  nullptr,
  114,
  {},
};

const char* const array_google_alternate_urls[] = {
  "{google:baseURL}#q={searchTerms}",
  "{google:baseURL}search#q={searchTerms}",
  "{google:baseURL}webhp#q={searchTerms}",
  "{google:baseURL}s#q={searchTerms}",
  "{google:baseURL}s?q={searchTerms}",
};
const char* const array_google_search_intent_params[] = {
  "si",
  "gs_ssp",
  "udm",
};
const PrepopulatedEngine google = {
  u"Google",
  u"google.com",
  "https://www.google.com/images/branding/product/ico/googleg_alldp.ico",
  "SEARCH_ENGINE_GOOGLE",
  "{google:baseURL}search?q={searchTerms}&{google:RLZ}{google:originalQueryForSuggestion}{google:assistedQueryStats}{google:searchFieldtrialParameter}{google:language}{google:prefetchSource}{google:searchClient}{google:sourceId}{google:contextualSearchVersion}ie={inputEncoding}",
  "UTF-8",
  "{google:baseSuggestURL}search?{google:searchFieldtrialParameter}client={google:suggestClient}&gs_ri={google:suggestRid}&xssi=t&q={searchTerms}&{google:inputType}{google:omniboxFocusType}{google:cursorPosition}{google:currentPageUrl}{google:pageClassification}{google:clientCacheTimeToLive}{google:searchVersion}{google:sessionToken}{google:prefetchQuery}sugkey={google:suggestAPIKeyParameter}",
  "{google:baseSearchByImageURL}upload",
  "{google:baseSearchByImageURL}upload?filtertype=tr&{imageTranslateSourceLocale}{imageTranslateTargetLocale}",
  nullptr,
  "{google:baseURL}_/contextualsearch?{google:contextualSearchVersion}{google:contextualSearchContextData}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  "encoded_image={google:imageThumbnail},image_url={google:imageURL},sbisrc={google:imageSearchSource},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},processed_image_dimensions={google:processedImageDimensions}",
  "sourcelang",
  "targetlang",
  nullptr,
  array_google_search_intent_params,
  array_google_alternate_urls,
  SEARCH_ENGINE_GOOGLE,
  "ALLOWED",
  "ALLOWED",
  1,
  {},
};

const PrepopulatedEngine info_com = {
  u"Info.com",
  u"info.com",
  "https://www.info.com/static/www.info.com/favicon.ico",
  "SEARCH_ENGINE_INFO",
  "https://www.info.com/serp?q={searchTerms}&segment=info.0472",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_INFO_COM,
  nullptr,
  nullptr,
  97,
  {},
};

const PrepopulatedEngine kagi = {
  u"Kagi",
  u"kagi.com",
  "https://kagi.com/favicon.ico",
  "SEARCH_ENGINE_KAGI",
  "https://kagi.com/search?q={searchTerms}",
  "UTF-8",
  "https://kagisuggest.com/api/autosuggest?q={searchTerms}",
  nullptr,
  nullptr,
  "https://kagi.com/",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_KAGI,
  nullptr,
  nullptr,
  115,
  {},
};

const RegulatoryExtension array_karma_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "euchrome",
    nullptr,
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "euandroid",
    nullptr,
  },
};
const PrepopulatedEngine karma = {
  u"Karma Search",
  u"karmasearch.org",
  "https://karmasearch.org/favicon.ico",
  "SEARCH_ENGINE_KARMA",
  "https://karmasearch.org/search?q={searchTerms}",
  "UTF-8",
  "https://api.karmasearch.org/search/autosuggest?q={searchTerms}",
  nullptr,
  nullptr,
  "https://karmasearch.org/newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_KARMA,
  nullptr,
  nullptr,
  110,
  array_karma_regulatory_extensions,
};

const PrepopulatedEngine lilo = {
  u"Lilo",
  u"lilo.org",
  "https://www.lilo.org/wp-content/themes/jarvis_wp/ajans/assets/favicon.ico",
  "SEARCH_ENGINE_LILO",
  "https://search.lilo.org/?q={searchTerms}",
  "UTF-8",
  "https://search.lilo.org/api/?service=suggestions&action=suggest&q={searchTerms}&f=chr&l={language}",
  nullptr,
  nullptr,
  "https://search.lilo.org",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_LILO,
  nullptr,
  nullptr,
  111,
  {},
};

const char* const array_mail_ru_alternate_urls[] = {
  "https://go.mail.ru/msearch?q={searchTerms}&{mailru:referralID}",
};
const PrepopulatedEngine mail_ru = {
  u"@MAIL.RU",
  u"mail.ru",
  "https://go.imgsmail.ru/favicon.ico",
  "SEARCH_ENGINE_MAILRU",
  "https://go.mail.ru/search?q={searchTerms}&{mailru:referralID}&fr=ch_omnibox",
  "UTF-8",
  "https://suggests.go.mail.ru/chrome?q={searchTerms}",
  nullptr,
  nullptr,
  "https://go.mail.ru/chrome/newtab/",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_mail_ru_alternate_urls,
  SEARCH_ENGINE_MAILRU,
  nullptr,
  nullptr,
  83,
  {},
};

const PrepopulatedEngine mojeek = {
  u"Mojeek",
  u"mojeek.com",
  "https://www.mojeek.com/favicon.ico",
  "SEARCH_ENGINE_MOJEEK",
  "https://www.mojeek.com/search?q={searchTerms}",
  "UTF-8",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_MOJEEK,
  nullptr,
  nullptr,
  103,
  {},
};

const PrepopulatedEngine naver = {
  u"\xb124" u"\xc774" u"\xbc84" u"",
  u"naver.com",
  "https://ssl.pstatic.net/sstatic/search/favicon/favicon_140327.ico",
  nullptr,
  "https://search.naver.com/search.naver?ie={inputEncoding}&query={searchTerms}&sm=chr_hty",
  "UTF-8",
  "https://ac.search.naver.com/nx/ac?of=os&ie={inputEncoding}&q={searchTerms}&oe={outputEncoding}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_NAVER,
  nullptr,
  nullptr,
  67,
  {},
};

const PrepopulatedEngine nona = {
  u"Nona",
  u"nona.de",
  "https://www.nona.de/favicon.ico",
  "SEARCH_ENGINE_NONA",
  "https://www.nona.de/?q={searchTerms}",
  "UTF-8",
  "https://www.nona.de/autocomplete/?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_NONA,
  nullptr,
  nullptr,
  107,
  {},
};

const RegulatoryExtension array_oceanhero_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=ch_om",
    "fr=ch_om",
  },
};
const PrepopulatedEngine oceanhero = {
  u"OceanHero",
  u"oceanhero.today",
  "https://oceanhero.today/favicon.ico",
  "SEARCH_ENGINE_OCEANHERO",
  "https://oceanhero.today/web?q={searchTerms}",
  "UTF-8",
  "https://api.oceanhero.today/suggestions?q={searchTerms}",
  nullptr,
  nullptr,
  "https://oceanhero.today/home",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_OCEANHERO,
  nullptr,
  nullptr,
  99,
  array_oceanhero_regulatory_extensions,
};

const PrepopulatedEngine panda = {
  u"WWF Panda Search",
  u"panda-search.org",
  "https://panda-search.org/favicon.ico",
  "SEARCH_ENGINE_PANDA",
  "https://panda-search.org/search/?q={searchTerms}",
  "UTF-8",
  "https://suggest.panda-search.org/suggest?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_PANDASEARCH,
  nullptr,
  nullptr,
  104,
  {},
};

const PrepopulatedEngine privacywall = {
  u"PrivacyWall",
  u"privacywall.org",
  "https://www.privacywall.org/images/favicon_32x32.ico",
  "SEARCH_ENGINE_PRIVACYWALL",
  "https://www.privacywall.org/search/secure/?q={searchTerms}",
  "UTF-8",
  "https://search.privacywall.org/suggest.php?q={searchTerms}",
  nullptr,
  nullptr,
  "https://www.privacywall.org/newtab/",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_PRIVACYWALL,
  nullptr,
  nullptr,
  100,
  {},
};

const PrepopulatedEngine quendu = {
  u"Quendu.com",
  u"quendu.com",
  "https://quendu.com/assets/favicon-48x48.png",
  "SEARCH_ENGINE_QUENDU",
  "https://www.quendu.com/search?q={searchTerms}",
  "UTF-8",
  "https://www.quendu.com/suggest?query={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_QUENDU,
  nullptr,
  nullptr,
  108,
  {},
};

const RegulatoryExtension array_qwant_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "client=cs-chrome",
    "client=opensearch",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "client=acs",
    "client=opensearch",
  },
};
const PrepopulatedEngine qwant = {
  u"Qwant",
  u"qwant.com",
  "https://www.qwant.com/favicon.ico",
  "SEARCH_ENGINE_QWANT",
  "https://www.qwant.com/?q={searchTerms}",
  "UTF-8",
  "https://api.qwant.com/api/suggest/?q={searchTerms}",
  nullptr,
  nullptr,
  "https://www.qwant.com/newtab?client=cs-chrome-newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_QWANT,
  nullptr,
  nullptr,
  94,
  array_qwant_regulatory_extensions,
};

const RegulatoryExtension array_seznam_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kAndroidEEA,
    "sourceid=srch_ga_cs",
    nullptr,
  },
};
const PrepopulatedEngine seznam = {
  u"Seznam.cz",
  u"seznam",
  "https://search.seznam.cz/favicon.ico",
  "SEARCH_ENGINE_SEZNAM",
  "https://search.seznam.cz/?q={searchTerms}",
  "UTF-8",
  "https://suggest.seznam.cz/fulltext_ff?phrase={searchTerms}",
  nullptr,
  nullptr,
  "https://search.seznam.cz/newtab",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_SEZNAM,
  nullptr,
  nullptr,
  25,
  array_seznam_regulatory_extensions,
};

const char* const array_so_360_alternate_urls[] = {
  "https://m.so.com/s?ie={inputEncoding}&q={searchTerms}",
  "https://m.so.com/index.php?ie={inputEncoding}&q={searchTerms}",
};
const PrepopulatedEngine so_360 = {
  u"360",
  u"so.com",
  "https://www.so.com/favicon.ico",
  nullptr,
  "https://www.so.com/s?ie={inputEncoding}&q={searchTerms}",
  "UTF-8",
  "https://sug.so.360.cn/suggest?encodein={inputEncoding}&encodeout={outputEncoding}&format=opensearch&word={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_so_360_alternate_urls,
  SEARCH_ENGINE_360,
  nullptr,
  nullptr,
  88,
  {},
};

const char* const array_sogou_alternate_urls[] = {
  "https://m.sogou.com/web/{google:pathWildcard}?ie={inputEncoding}&keyword={searchTerms}",
};
const PrepopulatedEngine sogou = {
  u"\x641c" u"\x72d7" u"",
  u"sogou.com",
  "https://www.sogou.com/images/logo/old/favicon.ico",
  nullptr,
  "https://www.sogou.com/web?ie={inputEncoding}&query={searchTerms}",
  "UTF-8",
  "https://sugg.sogou.com/sugg/ajaj_json.jsp?type=addrbar&key={searchTerms}&ie={inputEncoding}&from=google",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  array_sogou_alternate_urls,
  SEARCH_ENGINE_SOGOU,
  nullptr,
  nullptr,
  56,
  {},
};

const PrepopulatedEngine startpage = {
  u"startpage",
  u"startpage.com",
  "https://www.startpage.com/favicon.ico",
  "SEARCH_ENGINE_STARTPAGE",
  "https://www.startpage.com/sp/search?q={searchTerms}",
  "UTF-8",
  "https://www.startpage.com/osuggestions?q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_STARTPAGE,
  nullptr,
  nullptr,
  113,
  {},
};

const PrepopulatedEngine yahoo = {
  u"Yahoo!",
  u"yahoo.com",
  "https://search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas_sfp&p={searchTerms}",
  "UTF-8",
  "https://search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas_sfp&command={searchTerms}",
  nullptr,
  nullptr,
  "https://search.yahoo.com?fr=crmas_sfp",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ar = {
  u"Yahoo! Argentina",
  u"ar.yahoo.com",
  "https://ar.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://ar.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ar.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_at_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_at = {
  u"Yahoo Search",
  u"at.yahoo.com",
  "https://at.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://at.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://at.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_at_regulatory_extensions,
};

const PrepopulatedEngine yahoo_au = {
  u"Yahoo!",
  u"au.yahoo.com",
  "https://au.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://au.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://au.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_br = {
  u"Yahoo! Brasil",
  u"br.yahoo.com",
  "https://br.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://br.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://br.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ca = {
  u"Yahoo! Canada",
  u"ca.yahoo.com",
  "https://ca.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://ca.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ca.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ch = {
  u"Yahoo! Schweiz",
  u"ch.yahoo.com",
  "https://ch.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://ch.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ch.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_cl = {
  u"Yahoo! Chile",
  u"cl.yahoo.com",
  "https://cl.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://cl.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://cl.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_co = {
  u"Yahoo! Colombia",
  u"co.yahoo.com",
  "https://co.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://co.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://co.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_de_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_de = {
  u"Yahoo Search",
  u"de.yahoo.com",
  "https://de.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://de.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://de.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_de_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_dk_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_dk = {
  u"Yahoo Search",
  u"dk.yahoo.com",
  "https://dk.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://dk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://dk.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_dk_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_emea_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_emea = {
  u"Yahoo Search",
  u"emea.yahoo.com",
  "https://emea.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://emea.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://emea.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_emea_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_es_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_es = {
  u"Yahoo B\x00fa" u"squedas",
  u"es.yahoo.com",
  "https://es.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://es.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://es.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_es_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_fi_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_fi = {
  u"Yahoo Search",
  u"fi.yahoo.com",
  "https://fi.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://fi.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://fi.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_fi_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_fr_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_fr = {
  u"Yahoo Recherche",
  u"fr.yahoo.com",
  "https://fr.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://fr.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://fr.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_fr_regulatory_extensions,
};

const PrepopulatedEngine yahoo_hk = {
  u"Yahoo! Hong Kong",
  u"hk.yahoo.com",
  "https://hk.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://hk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://hk.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_id = {
  u"Yahoo! Indonesia",
  u"id.yahoo.com",
  "https://id.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://id.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://id.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_in = {
  u"Yahoo! India",
  u"in.yahoo.com",
  "https://in.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://in.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://in.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_it_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_it = {
  u"Ricerca di Yahoo",
  u"it.yahoo.com",
  "https://it.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://it.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://it.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_it_regulatory_extensions,
};

const RegulatoryExtension array_yahoo_jp_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    nullptr,
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=crmset",
    nullptr,
  },
};
const PrepopulatedEngine yahoo_jp = {
  u"Yahoo! JAPAN",
  u"yahoo.co.jp",
  "https://search.yahoo.co.jp/favicon.ico",
  "SEARCH_ENGINE_YAHOO_JP",
  "https://search.yahoo.co.jp/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://search.yahooapis.jp/AssistSearchService/V2/webassistSearch?p={searchTerms}&appid=oQsoxcyxg66enp0TYoirkKoryq6rF8bK76mW0KYxZ0v0WPLtn.Lix6wy8F_LwGWHUII-&output=fxjson&fr=crmas",
  nullptr,
  nullptr,
  "https://search.yahoo.co.jp/?fr=crmas_dt",
  nullptr,
  "https://s.yimg.jp/images/search/top/yjlogo.png",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_jp_regulatory_extensions,
};

const PrepopulatedEngine yahoo_mx = {
  u"Yahoo! M\x00e9" u"xico",
  u"mx.yahoo.com",
  "https://mx.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://mx.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://mx.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_my = {
  u"Yahoo! Malaysia",
  u"malaysia.yahoo.com",
  "https://malaysia.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://malaysia.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://malaysia.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_nl_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_nl = {
  u"Yahoo Search",
  u"nl.yahoo.com",
  "https://nl.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://nl.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://nl.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_nl_regulatory_extensions,
};

const PrepopulatedEngine yahoo_nz = {
  u"Yahoo! New Zealand",
  u"nz.yahoo.com",
  "https://nz.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://nz.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://nz.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_pe = {
  u"Yahoo! Per\x00fa" u"",
  u"pe.yahoo.com",
  "https://pe.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://pe.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://pe.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_ph = {
  u"Yahoo! Philippines",
  u"ph.yahoo.com",
  "https://ph.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://ph.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://ph.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_se_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_se = {
  u"Yahoo Search",
  u"se.yahoo.com",
  "https://se.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://se.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://se.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_se_regulatory_extensions,
};

const PrepopulatedEngine yahoo_sg = {
  u"Yahoo! Singapore",
  u"sg.yahoo.com",
  "https://sg.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://sg.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://sg.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_th = {
  u"Yahoo! \x0e1b" u"\x0e23" u"\x0e30" u"\x0e40" u"\x0e17" u"\x0e28" u"\x0e44" u"\x0e17" u"\x0e22" u"",
  u"th.yahoo.com",
  "https://th.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://th.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://th.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_tr = {
  u"Yahoo! T\x00fc" u"rkiye",
  u"tr.yahoo.com",
  "https://tr.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://tr.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://tr.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const PrepopulatedEngine yahoo_tw = {
  u"Yahoo!\x5947" u"\x6469" u"",
  u"tw.yahoo.com",
  "https://tw.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://tw.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&fr=crmas&p={searchTerms}",
  "UTF-8",
  "https://tw.search.yahoo.com/sugg/chrome?output=fxjson&appid=crmas&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  {},
};

const RegulatoryExtension array_yahoo_uk_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "fr=crmas",
    "appid=crmas",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "fr=yset_eu_chr_googchoic",
    "appid=gglandreucrmas",
  },
};
const PrepopulatedEngine yahoo_uk = {
  u"Yahoo Search",
  u"uk.yahoo.com",
  "https://uk.search.yahoo.com/favicon.ico",
  "SEARCH_ENGINE_YAHOO",
  "https://uk.search.yahoo.com/search{google:pathWildcard}?ei={inputEncoding}&p={searchTerms}",
  "UTF-8",
  "https://uk.search.yahoo.com/sugg/chrome?output=fxjson&command={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YAHOO,
  nullptr,
  nullptr,
  2,
  array_yahoo_uk_regulatory_extensions,
};

const PrepopulatedEngine yandex_by = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.by",
  "https://yastatic.net/s3/web4static/_/v2/v9YNE_BX0evwMHbDyd0NZv8ReK0.png",
  "SEARCH_ENGINE_YANDEX",
  "https://yandex.by/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.by/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.by/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.by/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/chrome_ru/logo.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const RegulatoryExtension array_yandex_com_regulatory_extensions[] = {
  {
    RegulatoryExtensionType::kDefault,
    "from=os&clid=1836588",
    "uil=en&v=3&sn=5",
  },
  {
    RegulatoryExtensionType::kAndroidEEA,
    "clid=5143284",
    "uil=en",
  },
};
const PrepopulatedEngine yandex_com = {
  u"Yandex",
  u"yandex.com",
  "https://yastatic.net/s3/web4static/_/v2/v9YNE_BX0evwMHbDyd0NZv8ReK0.png",
  "SEARCH_ENGINE_YANDEX",
  "https://yandex.com/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.com/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.com/images/search?rpt=imageview",
  nullptr,
  nullptr,
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/chrome_com/logo.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  array_yandex_com_regulatory_extensions,
};

const PrepopulatedEngine yandex_kz = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.kz",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "SEARCH_ENGINE_YANDEX",
  "https://yandex.kz/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.kz/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.kz/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.kz/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/chrome_kz/logo.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yandex_ru = {
  u"\x042f" u"\x043d" u"\x0434" u"\x0435" u"\x043a" u"\x0441" u"",
  u"yandex.ru",
  "https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico",
  "SEARCH_ENGINE_YANDEX",
  "https://yandex.ru/{yandex:searchPath}?text={searchTerms}&{yandex:referralID}",
  "UTF-8",
  "https://suggest.yandex.ru/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.ru/images/search/?rpt=imageview",
  nullptr,
  "https://www.yandex.ru/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/chrome_ru/logo.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yandex_tr = {
  u"Yandex",
  u"yandex.com.tr",
  "https://yastatic.net/lego/_/rBTjd6UOPk5913OSn5ZQVYMTQWQ.ico",
  "SEARCH_ENGINE_YANDEX",
  "https://www.yandex.com.tr/{yandex:searchPath}?text={searchTerms}",
  "UTF-8",
  "https://suggest.yandex.com.tr/suggest-ff.cgi?part={searchTerms}&{google:cursorPosition}",
  "https://yandex.com.tr/gorsel/search?rpt=imageview",
  nullptr,
  "https://www.yandex.com.tr/chrome/newtab",
  nullptr,
  "https://storage.ape.yandex.net/get/browser/Doodles/chrome_tr/logo.png",
  nullptr,
  nullptr,
  nullptr,
  "upfile={google:imageThumbnail},original_width={google:imageOriginalWidth},original_height={google:imageOriginalHeight},prg=1",
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YANDEX,
  nullptr,
  nullptr,
  15,
  {},
};

const PrepopulatedEngine yep = {
  u"Yep",
  u"yep.com",
  "https://cdn.yep.com/static/meta/favicon.ico",
  "SEARCH_ENGINE_YEP",
  "https://yep.com/web?q={searchTerms}",
  "UTF-8",
  "https://api.yep.com/ac/?query={searchTerms}&os=true",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YEP,
  nullptr,
  nullptr,
  106,
  {},
};

const PrepopulatedEngine you = {
  u"You.com",
  u"you.com",
  "https://api.you.com/favicon.ico",
  "SEARCH_ENGINE_YOU",
  "https://you.com/search?tbm=youchat&q={searchTerms}",
  "UTF-8",
  "https://you.com/api/ac?domain=default&q={searchTerms}",
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  {},
  {},
  SEARCH_ENGINE_YOU,
  nullptr,
  nullptr,
  112,
  {},
};

const std::array<const PrepopulatedEngine*, 65> kAllEngines ({{
  &baidu,
  &bing,
  &brave,
  &coccoc,
  &daum,
  &duckduckgo,
  &ecosia,
  &freespoke,
  &google,
  &info_com,
  &kagi,
  &karma,
  &lilo,
  &mail_ru,
  &mojeek,
  &naver,
  &nona,
  &oceanhero,
  &panda,
  &privacywall,
  &quendu,
  &qwant,
  &seznam,
  &so_360,
  &sogou,
  &startpage,
  &yahoo,
  &yahoo_ar,
  &yahoo_at,
  &yahoo_au,
  &yahoo_br,
  &yahoo_ca,
  &yahoo_ch,
  &yahoo_cl,
  &yahoo_co,
  &yahoo_de,
  &yahoo_dk,
  &yahoo_emea,
  &yahoo_es,
  &yahoo_fi,
  &yahoo_fr,
  &yahoo_hk,
  &yahoo_id,
  &yahoo_in,
  &yahoo_it,
  &yahoo_jp,
  &yahoo_mx,
  &yahoo_my,
  &yahoo_nl,
  &yahoo_nz,
  &yahoo_pe,
  &yahoo_ph,
  &yahoo_se,
  &yahoo_sg,
  &yahoo_th,
  &yahoo_tr,
  &yahoo_tw,
  &yahoo_uk,
  &yandex_by,
  &yandex_com,
  &yandex_kz,
  &yandex_ru,
  &yandex_tr,
  &yep,
  &you,
}});

}  // namespace TemplateURLPrepopulateData
