/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef THIRD_PARTY_PERFETTO_SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_ANDROID_TRACK_EVENT_DESCRIPTOR_H_
#define THIRD_PARTY_PERFETTO_SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_ANDROID_TRACK_EVENT_DESCRIPTOR_H_

#include <stddef.h>
#include <stdint.h>
#include <array>

namespace perfetto {

inline constexpr std::array<uint8_t, 2017> kAndroidTrackEventDescriptor{
    {0x0a, 0xde, 0x0f, 0x0a, 0x37, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f,
     0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2f, 0x74, 0x72, 0x61,
     0x63, 0x65, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x2f, 0x61,
     0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b,
     0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
     0x12, 0x0f, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70,
     0x72, 0x6f, 0x74, 0x6f, 0x73, 0x1a, 0x33, 0x70, 0x72, 0x6f, 0x74, 0x6f,
     0x73, 0x2f, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2f, 0x74,
     0x72, 0x61, 0x63, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x65,
     0x76, 0x65, 0x6e, 0x74, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x65,
     0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6,
     0x01, 0x0a, 0x13, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d, 0x65,
     0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x2e,
     0x0a, 0x13, 0x73, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x68,
     0x72, 0x65, 0x61, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
     0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
     0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32,
     0x0a, 0x15, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x5f,
     0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
     0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x72, 0x65, 0x63, 0x65, 0x69,
     0x76, 0x69, 0x6e, 0x67, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x4e, 0x61,
     0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
     0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
     0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
     0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
     0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20,
     0x01, 0x28, 0x04, 0x52, 0x0e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
     0x44, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x73, 0x22, 0x83, 0x07, 0x0a, 0x16,
     0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4a, 0x6f, 0x62, 0x53, 0x63,
     0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x15,
     0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
     0x28, 0x05, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1d, 0x0a,
     0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x69, 0x64, 0x18,
     0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63,
     0x65, 0x55, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78,
     0x79, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
     0x08, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x55, 0x69, 0x64, 0x12, 0x14, 0x0a,
     0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
     0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73,
     0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65,
     0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x73, 0x74, 0x61,
     0x6e, 0x64, 0x62, 0x79, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2d,
     0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f,
     0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01,
     0x28, 0x05, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
     0x64, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x2d, 0x0a,
     0x12, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70,
     0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
     0x05, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
     0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x32, 0x0a, 0x15,
     0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
     0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x08, 0x20,
     0x01, 0x28, 0x05, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x50, 0x72, 0x65, 0x76,
     0x69, 0x6f, 0x75, 0x73, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73,
     0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65,
     0x5f, 0x6d, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x64,
     0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x4d, 0x73, 0x12, 0x19, 0x0a,
     0x08, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x73, 0x18, 0x0a, 0x20,
     0x01, 0x28, 0x03, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x73,
     0x12, 0x2f, 0x0a, 0x14, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x72,
     0x74, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6d, 0x73,
     0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x6a, 0x6f, 0x62, 0x53,
     0x74, 0x61, 0x72, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x4d,
     0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x6e, 0x75, 0x6d, 0x5f, 0x75, 0x6e, 0x63,
     0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72,
     0x6b, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
     0x05, 0x52, 0x17, 0x6e, 0x75, 0x6d, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x70,
     0x6c, 0x65, 0x74, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x49, 0x74, 0x65,
     0x6d, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x5f, 0x73,
     0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
     0x70, 0x72, 0x6f, 0x63, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a,
     0x18, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x5f, 0x6a, 0x6f,
     0x62, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f, 0x6d,
     0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x70, 0x65, 0x72,
     0x69, 0x6f, 0x64, 0x69, 0x63, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x74, 0x65,
     0x72, 0x76, 0x61, 0x6c, 0x4d, 0x73, 0x12, 0x40, 0x0a, 0x1d, 0x70, 0x65,
     0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x66,
     0x6c, 0x65, 0x78, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
     0x5f, 0x6d, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x70,
     0x65, 0x72, 0x69, 0x6f, 0x64, 0x69, 0x63, 0x4a, 0x6f, 0x62, 0x46, 0x6c,
     0x65, 0x78, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x4d, 0x73,
     0x12, 0x4a, 0x0a, 0x22, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x63,
     0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x5f, 0x64, 0x75, 0x65, 0x5f,
     0x74, 0x6f, 0x5f, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x6d, 0x65,
     0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1e, 0x6e, 0x75,
     0x6d, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73,
     0x44, 0x75, 0x65, 0x54, 0x6f, 0x41, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e,
     0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x14, 0x62, 0x61, 0x63, 0x6b,
     0x5f, 0x6f, 0x66, 0x66, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
     0x74, 0x79, 0x70, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11,
     0x62, 0x61, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x50, 0x6f, 0x6c, 0x69, 0x63,
     0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x69, 0x6e, 0x74,
     0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x72,
     0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x05, 0x52,
     0x12, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x6f,
     0x70, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x70,
     0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x72,
     0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x05, 0x52,
     0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x53, 0x74, 0x6f, 0x70, 0x52,
     0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x6a, 0x6f, 0x62,
     0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73,
     0x18, 0x14, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6a, 0x6f, 0x62, 0x53,
     0x74, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0xe8, 0x01,
     0x0a, 0x0d, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x42, 0x69, 0x74,
     0x6d, 0x61, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18,
     0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12,
     0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
     0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a,
     0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
     0x05, 0x52, 0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x18, 0x0a,
     0x07, 0x64, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01,
     0x28, 0x05, 0x52, 0x07, 0x64, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x79, 0x12,
     0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
     0x01, 0x28, 0x05, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
     0x25, 0x0a, 0x0e, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70,
     0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
     0x0d, 0x6d, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x69, 0x78, 0x65,
     0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x5f,
     0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
     0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x70, 0x69, 0x78, 0x65,
     0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
     0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03,
     0x52, 0x02, 0x69, 0x64, 0x22, 0xa0, 0x04, 0x0a, 0x11, 0x41, 0x6e, 0x64,
     0x72, 0x6f, 0x69, 0x64, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x76, 0x65,
     0x6e, 0x74, 0x32, 0x4c, 0x0a, 0x13, 0x62, 0x69, 0x6e, 0x64, 0x65, 0x72,
     0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
     0x65, 0x12, 0x1b, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f,
     0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x63,
     0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0xd1, 0x0f, 0x20, 0x01, 0x28,
     0x09, 0x52, 0x11, 0x62, 0x69, 0x6e, 0x64, 0x65, 0x72, 0x53, 0x65, 0x72,
     0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x32, 0x50, 0x0a, 0x15,
     0x62, 0x69, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
     0x66, 0x61, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x2e,
     0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f,
     0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x76, 0x65,
     0x6e, 0x74, 0x18, 0xd2, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62,
     0x69, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
     0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x32, 0x39, 0x0a, 0x09, 0x61, 0x70,
     0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x2e, 0x70, 0x65,
     0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
     0x73, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74,
     0x18, 0xd3, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x70, 0x65,
     0x78, 0x4e, 0x61, 0x6d, 0x65, 0x32, 0x67, 0x0a, 0x0d, 0x6d, 0x65, 0x73,
     0x73, 0x61, 0x67, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x12, 0x1b,
     0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70, 0x72,
     0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x76,
     0x65, 0x6e, 0x74, 0x18, 0xd4, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
     0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e, 0x70, 0x72,
     0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
     0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65,
     0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65,
     0x75, 0x65, 0x32, 0x54, 0x0a, 0x06, 0x62, 0x69, 0x74, 0x6d, 0x61, 0x70,
     0x12, 0x1b, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e,
     0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b,
     0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0xd5, 0x0f, 0x20, 0x01, 0x28, 0x0b,
     0x32, 0x1e, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f, 0x2e,
     0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f,
     0x69, 0x64, 0x42, 0x69, 0x74, 0x6d, 0x61, 0x70, 0x52, 0x06, 0x62, 0x69,
     0x74, 0x6d, 0x61, 0x70, 0x32, 0x71, 0x0a, 0x11, 0x6a, 0x6f, 0x62, 0x5f,
     0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x6a, 0x6f,
     0x62, 0x12, 0x1b, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f,
     0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x63,
     0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0xd6, 0x0f, 0x20, 0x01, 0x28,
     0x0b, 0x32, 0x27, 0x2e, 0x70, 0x65, 0x72, 0x66, 0x65, 0x74, 0x74, 0x6f,
     0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x41, 0x6e, 0x64, 0x72,
     0x6f, 0x69, 0x64, 0x4a, 0x6f, 0x62, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
     0x6c, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x0f, 0x6a, 0x6f, 0x62, 0x53,
     0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x50,
     0x00}};

}  // namespace perfetto

#endif  // THIRD_PARTY_PERFETTO_SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_ANDROID_TRACK_EVENT_DESCRIPTOR_H_
