// core/lib/legacy-javascript/polyfill-module-data.json
var polyfill_module_data_default = [
  {
    name: "focus-visible",
    modules: [
      "focus-visible"
    ]
  },
  {
    name: "Error.prototype.cause",
    modules: [
      "es.error.cause"
    ]
  },
  {
    name: "Array.prototype.at",
    modules: [
      "es.array.at",
      "esnext.array.at"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.concat",
    modules: [
      "es.array.concat"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.copyWithin",
    modules: [
      "es.array.copy-within"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.every",
    modules: [
      "es.array.every"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.fill",
    modules: [
      "es.array.fill"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.filter",
    modules: [
      "es.array.filter"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.find",
    modules: [
      "es.array.find"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.findIndex",
    modules: [
      "es.array.find-index"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.findLast",
    modules: [
      "es.array.find-last",
      "esnext.array.find-last"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.findLastIndex",
    modules: [
      "es.array.find-last-index",
      "esnext.array.find-last-index"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.flat",
    modules: [
      "es.array.flat"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.flatMap",
    modules: [
      "es.array.flat-map"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.forEach",
    modules: [
      "es.array.for-each"
    ],
    corejs: true
  },
  {
    name: "Array.from",
    modules: [
      "es.array.from"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.includes",
    modules: [
      "es.array.includes"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.indexOf",
    modules: [
      "es.array.index-of"
    ],
    corejs: true
  },
  {
    name: "Array.isArray",
    modules: [
      "es.array.is-array"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.join",
    modules: [
      "es.array.join"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.map",
    modules: [
      "es.array.map"
    ],
    corejs: true
  },
  {
    name: "Array.of",
    modules: [
      "es.array.of"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.slice",
    modules: [
      "es.array.slice"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.some",
    modules: [
      "es.array.some"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.sort",
    modules: [
      "es.array.sort"
    ],
    corejs: true
  },
  {
    name: "Array.prototype.unshift",
    modules: [
      "es.array.unshift"
    ],
    corejs: true
  },
  {
    name: "Math.acosh",
    modules: [
      "es.math.acosh"
    ],
    corejs: true
  },
  {
    name: "Math.asinh",
    modules: [
      "es.math.asinh"
    ],
    corejs: true
  },
  {
    name: "Math.atanh",
    modules: [
      "es.math.atanh"
    ],
    corejs: true
  },
  {
    name: "Math.cbrt",
    modules: [
      "es.math.cbrt"
    ],
    corejs: true
  },
  {
    name: "Math.clz32",
    modules: [
      "es.math.clz32"
    ],
    corejs: true
  },
  {
    name: "Math.cosh",
    modules: [
      "es.math.cosh"
    ],
    corejs: true
  },
  {
    name: "Math.expm1",
    modules: [
      "es.math.expm1"
    ],
    corejs: true
  },
  {
    name: "Math.fround",
    modules: [
      "es.math.fround"
    ],
    corejs: true
  },
  {
    name: "Math.hypot",
    modules: [
      "es.math.hypot"
    ],
    corejs: true
  },
  {
    name: "Math.imul",
    modules: [
      "es.math.imul"
    ],
    corejs: true
  },
  {
    name: "Math.log10",
    modules: [
      "es.math.log10"
    ],
    corejs: true
  },
  {
    name: "Math.log1p",
    modules: [
      "es.math.log1p"
    ],
    corejs: true
  },
  {
    name: "Math.log2",
    modules: [
      "es.math.log2"
    ],
    corejs: true
  },
  {
    name: "Math.sign",
    modules: [
      "es.math.sign"
    ],
    corejs: true
  },
  {
    name: "Math.sinh",
    modules: [
      "es.math.sinh"
    ],
    corejs: true
  },
  {
    name: "Math.tanh",
    modules: [
      "es.math.tanh"
    ],
    corejs: true
  },
  {
    name: "Math.trunc",
    modules: [
      "es.math.trunc"
    ],
    corejs: true
  },
  {
    name: "Object.assign",
    modules: [
      "es.object.assign"
    ],
    corejs: true
  },
  {
    name: "Object.create",
    modules: [
      "es.object.create"
    ],
    corejs: true
  },
  {
    name: "Object.entries",
    modules: [
      "es.object.entries"
    ],
    corejs: true
  },
  {
    name: "Object.freeze",
    modules: [
      "es.object.freeze"
    ],
    corejs: true
  },
  {
    name: "Object.fromEntries",
    modules: [
      "es.object.from-entries"
    ],
    corejs: true
  },
  {
    name: "Object.getOwnPropertyDescriptor",
    modules: [
      "es.object.get-own-property-descriptor"
    ],
    corejs: true
  },
  {
    name: "Object.getOwnPropertyDescriptors",
    modules: [
      "es.object.get-own-property-descriptors"
    ],
    corejs: true
  },
  {
    name: "Object.getPrototypeOf",
    modules: [
      "es.object.get-prototype-of"
    ],
    corejs: true
  },
  {
    name: "Object.hasOwn",
    modules: [
      "es.object.has-own",
      "esnext.object.has-own"
    ],
    corejs: true
  },
  {
    name: "Object.is",
    modules: [
      "es.object.is"
    ],
    corejs: true
  },
  {
    name: "Object.isExtensible",
    modules: [
      "es.object.is-extensible"
    ],
    corejs: true
  },
  {
    name: "Object.isFrozen",
    modules: [
      "es.object.is-frozen"
    ],
    corejs: true
  },
  {
    name: "Object.isSealed",
    modules: [
      "es.object.is-sealed"
    ],
    corejs: true
  },
  {
    name: "Object.keys",
    modules: [
      "es.object.keys"
    ],
    corejs: true
  },
  {
    name: "Object.preventExtensions",
    modules: [
      "es.object.prevent-extensions"
    ],
    corejs: true
  },
  {
    name: "Object.seal",
    modules: [
      "es.object.seal"
    ],
    corejs: true
  },
  {
    name: "Object.setPrototypeOf",
    modules: [
      "es.object.set-prototype-of"
    ],
    corejs: true
  },
  {
    name: "Object.values",
    modules: [
      "es.object.values"
    ],
    corejs: true
  },
  {
    name: "Promise.any",
    modules: [
      "es.promise.any",
      "esnext.promise.any"
    ],
    corejs: true
  },
  {
    name: "Reflect.apply",
    modules: [
      "es.reflect.apply"
    ],
    corejs: true
  },
  {
    name: "Reflect.construct",
    modules: [
      "es.reflect.construct"
    ],
    corejs: true
  },
  {
    name: "Reflect.deleteProperty",
    modules: [
      "es.reflect.delete-property"
    ],
    corejs: true
  },
  {
    name: "Reflect.get",
    modules: [
      "es.reflect.get"
    ],
    corejs: true
  },
  {
    name: "Reflect.getOwnPropertyDescriptor",
    modules: [
      "es.reflect.get-own-property-descriptor"
    ],
    corejs: true
  },
  {
    name: "Reflect.getPrototypeOf",
    modules: [
      "es.reflect.get-prototype-of"
    ],
    corejs: true
  },
  {
    name: "Reflect.has",
    modules: [
      "es.reflect.has"
    ],
    corejs: true
  },
  {
    name: "Reflect.isExtensible",
    modules: [
      "es.reflect.is-extensible"
    ],
    corejs: true
  },
  {
    name: "Reflect.ownKeys",
    modules: [
      "es.reflect.own-keys"
    ],
    corejs: true
  },
  {
    name: "Reflect.preventExtensions",
    modules: [
      "es.reflect.prevent-extensions"
    ],
    corejs: true
  },
  {
    name: "Reflect.setPrototypeOf",
    modules: [
      "es.reflect.set-prototype-of"
    ],
    corejs: true
  },
  {
    name: "String.prototype.codePointAt",
    modules: [
      "es.string.code-point-at"
    ],
    corejs: true
  },
  {
    name: "String.prototype.endsWith",
    modules: [
      "es.string.ends-with"
    ],
    corejs: true
  },
  {
    name: "String.fromCodePoint",
    modules: [
      "es.string.from-code-point"
    ],
    corejs: true
  },
  {
    name: "String.prototype.includes",
    modules: [
      "es.string.includes"
    ],
    corejs: true
  },
  {
    name: "String.prototype.matchAll",
    modules: [
      "es.string.match-all",
      "esnext.string.match-all"
    ],
    corejs: true
  },
  {
    name: "String.raw",
    modules: [
      "es.string.raw"
    ],
    corejs: true
  },
  {
    name: "String.prototype.repeat",
    modules: [
      "es.string.repeat"
    ],
    corejs: true
  },
  {
    name: "String.prototype.replaceAll",
    modules: [
      "es.string.replace-all",
      "esnext.string.replace-all"
    ],
    corejs: true
  },
  {
    name: "String.prototype.startsWith",
    modules: [
      "es.string.starts-with"
    ],
    corejs: true
  },
  {
    name: "String.prototype.substr",
    modules: [
      "es.string.substr"
    ],
    corejs: true
  },
  {
    name: "String.prototype.trim",
    modules: [
      "es.string.trim"
    ],
    corejs: true
  },
  {
    name: "String.prototype.trimEnd",
    modules: [
      "es.string.trim-end"
    ],
    corejs: true
  },
  {
    name: "String.prototype.trimStart",
    modules: [
      "es.string.trim-start"
    ],
    corejs: true
  },
  {
    name: "String.prototype.link",
    modules: [
      "es.string.link"
    ],
    corejs: true
  },
  {
    name: "Promise.allSettled",
    modules: [
      "esnext.promise.all-settled"
    ],
    corejs: true
  }
];

// core/lib/legacy-javascript/polyfill-graph-data.json
var polyfill_graph_data_default = {
  moduleSizes: [26070, 498, 282, 294, 281, 467, 161, 236, 229, 765, 546, 339, 1608, 723, 729, 1545, 438, 214, 657, 111, 759, 537, 209, 281, 685, 217, 757, 631, 293, 182, 475, 79, 407, 140, 366, 792, 269, 222, 158, 280, 188, 137, 158, 105, 189, 543, 160, 742, 1436, 88, 904, 146, 314, 375, 183, 1083, 195, 503, 269, 208, 334, 350, 460, 568, 229, 1155, 334, 266, 30, 120, 309, 370, 358, 1952, 1638, 304, 153, 274, 1288, 192, 543, 74, 144, 137, 33, 336, 457, 2122, 535, 711, 1323, 117, 1961, 244, 557, 318, 119, 124, 108, 144, 96, 133, 441, 210, 1627, 1956, 693, 1426, 863, 637, 301, 51, 708, 583, 119, 600, 221, 370, 728, 1085, 552, 629, 125, 1746, 97, 441, 543, 2756, 371, 447, 548, 243, 266, 217, 99, 440, 183, 546, 137, 464, 207, 983, 503, 237, 382, 249, 675, 402, 254, 223, 164, 214, 191, 831, 218, 202, 232, 124, 249, 160, 251, 217, 717, 78, 561, 1627, 256, 386, 225, 432, 499, 394, 364, 445, 634, 667, 177, 346, 470, 663, 142, 588, 414, 617, 1559, 380, 2520, 1040, 417, 289, 238, 220, 214, 303, 163, 141, 510, 397, 137, 137, 133, 133, 390, 266, 137, 183, 215, 191, 485, 328, 575, 799, 533, 148, 215, 589, 589, 130, 362, 562, 471, 179, 186, 1266, 1456, 521, 1536, 427, 444, 406, 912, 150, 283, 144, 485, 470, 205, 1268, 796, 658, 306, 3751, 814, 146, 2328, 1226, 922, 237, 206, 198, 250, 283, 60, 3e3],
  dependencies: {
    "Array.prototype.at": [0, 5, 69, 105, 106, 116, 164],
    "Array.prototype.concat": [0, 16, 21, 22, 26, 34, 40, 76, 78, 155, 165],
    "Array.prototype.copyWithin": [0, 5, 9, 37, 69, 105, 106, 116, 166],
    "Array.prototype.every": [0, 15, 17, 21, 22, 26, 53, 59, 76, 78, 155, 167],
    "Array.prototype.fill": [0, 5, 10, 69, 105, 106, 116, 168],
    "Array.prototype.filter": [0, 15, 16, 21, 22, 26, 53, 59, 76, 78, 155, 169],
    "Array.prototype.find": [0, 5, 15, 21, 22, 26, 53, 59, 69, 76, 78, 105, 106, 116, 155, 173],
    "Array.prototype.findIndex": [0, 5, 15, 21, 22, 26, 53, 59, 69, 76, 78, 105, 106, 116, 155, 170],
    "Array.prototype.findLast": [0, 5, 14, 53, 59, 69, 105, 106, 116, 172],
    "Array.prototype.findLastIndex": [0, 5, 14, 53, 59, 69, 105, 106, 116, 171],
    "Array.prototype.flat": [0, 21, 22, 26, 40, 50, 53, 59, 76, 78, 155, 175],
    "Array.prototype.flatMap": [0, 21, 22, 26, 40, 50, 53, 59, 76, 78, 155, 174],
    "Array.prototype.forEach": [0, 11, 15, 17, 21, 22, 26, 53, 59, 76, 78, 155, 176],
    "Array.from": [0, 12, 23, 24, 26, 34, 53, 59, 62, 63, 75, 78, 88, 155, 177],
    "Array.prototype.includes": [0, 5, 69, 105, 106, 116, 178],
    "Array.prototype.indexOf": [0, 17, 59, 179],
    "Array.isArray": [0, 76, 180],
    "Array.prototype.join": [0, 17, 181],
    "Array.prototype.map": [0, 15, 16, 21, 22, 26, 53, 59, 76, 78, 155, 182],
    "Array.of": [0, 26, 34, 78, 155, 183],
    "Array.prototype.slice": [0, 16, 19, 26, 34, 76, 78, 155, 184],
    "Array.prototype.some": [0, 15, 17, 21, 22, 26, 53, 59, 76, 78, 155, 185],
    "Array.prototype.sort": [0, 17, 19, 20, 26, 37, 42, 43, 46, 155, 156, 186],
    "Array.prototype.unshift": [0, 18, 37, 40, 76, 187],
    "Math.acosh": [0, 97, 188],
    "Math.asinh": [0, 189],
    "Math.atanh": [0, 190],
    "Math.cbrt": [0, 100, 191],
    "Math.clz32": [0, 192],
    "Math.cosh": [0, 93, 193],
    "Math.expm1": [0, 93, 194],
    "Math.fround": [0, 94, 95, 99, 100, 195],
    "Math.hypot": [0, 196],
    "Math.imul": [0, 197],
    "Math.log10": [0, 96, 198],
    "Math.log1p": [0, 97, 199],
    "Math.log2": [0, 98, 200],
    "Math.sign": [0, 100, 201],
    "Math.sinh": [0, 93, 202],
    "Math.tanh": [0, 93, 203],
    "Math.trunc": [0, 204],
    "Object.assign": [0, 104, 116, 205],
    "Object.create": [0, 69, 105, 106, 116, 206],
    "Object.entries": [0, 29, 112, 116, 119, 207],
    "Object.freeze": [0, 8, 19, 51, 73, 109, 113, 208],
    "Object.fromEntries": [0, 26, 34, 53, 59, 62, 63, 75, 87, 88, 155, 209],
    "Object.getOwnPropertyDescriptor": [0, 210],
    "Object.getOwnPropertyDescriptors": [0, 34, 211],
    "Object.getPrototypeOf": [0, 29, 112, 212],
    "Object.hasOwn": [0, 213],
    "Object.is": [0, 134, 217],
    "Object.isExtensible": [0, 8, 113, 214],
    "Object.isFrozen": [0, 8, 215],
    "Object.isSealed": [0, 8, 216],
    "Object.keys": [0, 116, 218],
    "Object.preventExtensions": [0, 8, 19, 51, 73, 109, 113, 219],
    "Object.seal": [0, 8, 19, 51, 73, 109, 113, 220],
    "Object.setPrototypeOf": [0, 4, 58, 83, 118, 221],
    "Object.values": [0, 29, 112, 116, 119, 222],
    "Promise.any": [0, 24, 26, 47, 53, 59, 62, 63, 75, 87, 88, 102, 122, 123, 124, 125, 155, 224],
    "Reflect.apply": [0, 52, 225],
    "Reflect.construct": [0, 3, 19, 26, 52, 55, 69, 78, 105, 106, 116, 155, 226],
    "Reflect.deleteProperty": [0, 227],
    "Reflect.get": [0, 29, 79, 112, 230],
    "Reflect.getOwnPropertyDescriptor": [0, 228],
    "Reflect.getPrototypeOf": [0, 29, 112, 229],
    "Reflect.has": [0, 231],
    "Reflect.isExtensible": [0, 8, 113, 232],
    "Reflect.ownKeys": [0, 233],
    "Reflect.preventExtensions": [0, 51, 234],
    "Reflect.setPrototypeOf": [0, 4, 58, 83, 118, 235],
    "String.prototype.codePointAt": [0, 26, 141, 155, 156, 236],
    "String.prototype.endsWith": [0, 26, 28, 59, 85, 103, 155, 156, 237],
    "String.fromCodePoint": [0, 238],
    "String.prototype.includes": [0, 26, 28, 85, 103, 155, 156, 239],
    "String.prototype.matchAll": [0, 3, 6, 26, 29, 31, 59, 69, 78, 85, 89, 90, 105, 106, 112, 116, 126, 127, 128, 129, 130, 131, 132, 135, 139, 141, 155, 156, 241],
    "String.raw": [0, 26, 155, 156, 242],
    "String.prototype.repeat": [0, 26, 142, 155, 156, 243],
    "String.prototype.replaceAll": [0, 26, 65, 85, 128, 129, 155, 156, 244],
    "String.prototype.startsWith": [0, 26, 28, 59, 85, 103, 155, 156, 245],
    "String.prototype.substr": [0, 26, 155, 156, 246],
    "String.prototype.trim": [0, 26, 144, 146, 155, 156, 163, 251],
    "String.prototype.trimEnd": [0, 26, 143, 144, 146, 155, 156, 163, 247, 249],
    "String.prototype.trimStart": [0, 26, 144, 145, 146, 155, 156, 163, 248, 250],
    "String.prototype.link": [0, 26, 30, 140, 155, 156, 240],
    "Promise.allSettled": [0, 24, 26, 47, 53, 59, 62, 63, 75, 87, 88, 102, 122, 123, 124, 125, 155, 223, 252],
    "focus-visible": [253]
  },
  maxSize: 155835
};

// core/lib/legacy-javascript/legacy-javascript.js
var polyfillModuleData = polyfill_module_data_default;
var graph = polyfill_graph_data_default;
var CodePatternMatcher = class {
  /**
   * @param {Pattern[]} patterns
   */
  constructor(patterns) {
    this.patterns = patterns;
  }
  /**
   * @param {string} code
   * @return {PatternMatchResult[]}
   */
  match(code) {
    if (!this.re) {
      const patternsExpression = this.patterns.map((pattern) => `(${pattern.expression})`).join("|");
      this.re = new RegExp(`(^\r
|\r|
)|${patternsExpression}`, "g");
    }
    this.re.lastIndex = 0;
    const seen = /* @__PURE__ */ new Set();
    const matches = [];
    let result;
    let line = 0;
    let lineBeginsAtIndex = 0;
    while ((result = this.re.exec(code)) !== null) {
      const captureGroups = result.slice(1);
      const [isNewline, ...patternExpressionMatches] = captureGroups;
      if (isNewline) {
        line++;
        lineBeginsAtIndex = result.index + 1;
        continue;
      }
      const pattern = this.patterns[patternExpressionMatches.findIndex(Boolean)];
      if (seen.has(pattern)) {
        continue;
      }
      seen.add(pattern);
      matches.push({
        name: pattern.name,
        line,
        column: result.index - lineBeginsAtIndex
      });
    }
    return matches;
  }
};
function buildPolyfillExpression(object, property, coreJs3Module) {
  const qt = (token) => `['"]${token}['"]`;
  let expression = "";
  if (object) {
    expression += `${object}\\.${property}\\s?=[^=]`;
  } else {
    expression += `(?:window\\.|[\\s;]+)${property}\\s?=[^=]`;
  }
  if (object) {
    expression += `|${object}\\[${qt(property)}\\]\\s?=[^=]`;
  }
  expression += `|defineProperty\\(${object || "window"},\\s?${qt(property)}`;
  if (object) {
    expression += `|\\(${object},\\s*{${property}:.*},\\s*{${property}`;
  }
  if (object) {
    const objectWithoutPrototype = object.replace(".prototype", "");
    expression += `|{target:${qt(objectWithoutPrototype)}[^;]*},{${property}:`;
  } else {
  }
  expression += `|${coreJs3Module.replaceAll(".", "\\.")}(?:\\.js)?"`;
  return expression;
}
function getCoreJsPolyfillData() {
  return polyfillModuleData.filter((d) => d.corejs).map((d) => {
    return {
      name: d.name,
      coreJs3Module: d.modules[0]
    };
  });
}
function getPolyfillPatterns() {
  const patterns = [];
  for (const { name, coreJs3Module } of getCoreJsPolyfillData()) {
    const parts = name.split(".");
    const object = parts.length > 1 ? parts.slice(0, parts.length - 1).join(".") : null;
    const property = parts[parts.length - 1];
    patterns.push({
      name,
      expression: buildPolyfillExpression(object, property, coreJs3Module)
    });
  }
  return patterns;
}
function getTransformPatterns() {
  const count = (content, pattern) => {
    if (typeof pattern === "string") {
      return content.split(pattern).length - 1;
    }
    return (content.match(pattern) ?? []).length;
  };
  return [
    // @babel/plugin-transform-classes
    //
    // input:
    //
    // class MyTestClass {
    //   log() {
    //     console.log(1);
    //   }
    // };
    //
    // output:
    //
    // function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
    // function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
    // function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
    // function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
    // function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
    // let MyTestClass = function () {
    //   function MyTestClass() {
    //     _classCallCheck(this, MyTestClass);
    //   }
    //   return _createClass(MyTestClass, [{
    //     key: "log",
    //     value: function log() {
    //       console.log(1);
    //     }
    //   }]);
    // }();
    {
      name: "@babel/plugin-transform-classes",
      expression: "Cannot call a class as a function",
      estimateBytes: (content) => {
        return 1e3 + (count(content, "_classCallCheck") - 1) * "_classCallCheck()".length;
      }
    },
    {
      name: "@babel/plugin-transform-regenerator",
      expression: "Generator is already running|regeneratorRuntime",
      // Example of this transform: https://gist.github.com/connorjclark/af8bccfff377ac44efc104a79bc75da2
      // `regeneratorRuntime.awrap` is generated for every usage of `await`, and adds ~80 bytes each.
      estimateBytes: (content) => {
        return count(content, /regeneratorRuntime\(?\)?\.a?wrap/g) * 80;
      }
    },
    {
      name: "@babel/plugin-transform-spread",
      expression: "Invalid attempt to spread non-iterable instance",
      estimateBytes: (content) => {
        const per = "_toConsumableArray()".length;
        return 1169 + count(content, /\.apply\(void 0,\s?_toConsumableArray/g) * per;
      }
    }
  ];
}
function estimateWastedBytes(content, matches) {
  const polyfillResults = matches.filter((m) => !m.name.startsWith("@"));
  const transformResults = matches.filter((m) => m.name.startsWith("@"));
  let estimatedWastedBytesFromPolyfills = 0;
  const modulesSeen = /* @__PURE__ */ new Set();
  for (const result of polyfillResults) {
    const modules = graph.dependencies[result.name];
    if (!modules)
      continue;
    for (const module of modules) {
      modulesSeen.add(module);
    }
  }
  estimatedWastedBytesFromPolyfills += [...modulesSeen].reduce((acc, moduleIndex) => {
    return acc + graph.moduleSizes[moduleIndex];
  }, 0);
  estimatedWastedBytesFromPolyfills = Math.min(estimatedWastedBytesFromPolyfills, graph.maxSize);
  let estimatedWastedBytesFromTransforms = 0;
  for (const result of transformResults) {
    const pattern = getTransformPatterns().find((p) => p.name === result.name);
    if (!pattern || !pattern.estimateBytes || !content)
      continue;
    estimatedWastedBytesFromTransforms += pattern.estimateBytes(content);
  }
  const estimatedWastedBytes = estimatedWastedBytesFromPolyfills + estimatedWastedBytesFromTransforms;
  return estimatedWastedBytes;
}
var matcher = new CodePatternMatcher([
  ...getPolyfillPatterns(),
  ...getTransformPatterns()
]);
function detectLegacyJavaScript(content, map) {
  if (!content)
    return { matches: [], estimatedByteSavings: 0 };
  let matches = matcher.match(content);
  if (map) {
    for (const { name, modules } of polyfillModuleData) {
      if (matches.some((m) => m.name === name))
        continue;
      const source = map.sourceURLs().find((source2) => modules.some((module) => {
        return source2.endsWith(`/${module}.js`) || source2.includes(`node_modules/${module}/`);
      }));
      if (!source)
        continue;
      const mapping = map.mappings().find((m) => m.sourceURL === source);
      if (mapping) {
        matches.push({ name, line: mapping.lineNumber, column: mapping.columnNumber });
      } else {
        matches.push({ name, line: 0, column: 0 });
      }
    }
  }
  matches = matches.sort((a, b) => a.name > b.name ? 1 : a.name === b.name ? 0 : -1);
  return {
    matches,
    estimatedByteSavings: estimateWastedBytes(content, matches)
  };
}
export {
  detectLegacyJavaScript,
  getCoreJsPolyfillData,
  getTransformPatterns
};
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
