import"../../ui/components/switch/switch.js";import"../../ui/components/cards/cards.js";import"../../ui/components/chrome_link/chrome_link.js";import*as e from"../../core/common/common.js";import*as t from"../../core/host/host.js";import*as i from"../../core/i18n/i18n.js";import*as s from"../../core/root/root.js";import*as r from"../../core/sdk/sdk.js";import"../../ui/components/buttons/buttons.js";import*as o from"../../ui/components/input/input.js";import*as n from"../../ui/legacy/legacy.js";import*as a from"../../ui/lit/lit.js";import{Directives as c,html as l,nothing as d,render as u}from"../../ui/lit/lit.js";import*as h from"../../ui/visual_logging/visual_logging.js";import"../../ui/legacy/components/data_grid/data_grid.js";import*as p from"../../core/platform/platform.js";import*as g from"../../models/issues_manager/issues_manager.js";import*as m from"../network/forward/forward.js";import*as y from"../../ui/components/icon_button/icon_button.js";var v=`.overflow-auto{height:100%}.controls{display:flex;flex-direction:column;padding:var(--sys-size-5) var(--sys-size-3) var(--sys-size-5) var(--sys-size-5);min-width:var(--sys-size-33)}.header{display:flex;flex-direction:column;gap:var(--sys-size-2);padding-left:var(--sys-size-5)}h1{margin:0;font:var(--sys-typescale-headline4)}.card-container{max-width:100%}.card{display:flex;flex-direction:column;padding:var(--sys-size-6) var(--sys-size-8);gap:var(--sys-size-6);&.enterprise-disabled{color:var(--sys-color-token-subtle)}}.card-header{display:flex;align-items:center}.card-header > .lhs{width:100%;display:flex;justify-content:space-between;align-items:center;padding-right:var(--sys-size-9);& > devtools-icon{height:var(--sys-size-11);width:var(--sys-size-11)}}.text{display:flex;flex-direction:column;gap:var(--sys-size-2)}h2{font:var(--sys-typescale-headline5);margin:0}.body{font:var(--sys-typescale-body4-regular)}.checkbox-label{gap:var(--sys-size-8);display:flex;align-items:center}.card-row{padding-top:var(--sys-size-4);padding-bottom:var(--sys-size-4);padding-left:var(--sys-size-8)}h3{font:var(--sys-typescale-body4-medium);margin:0}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.enterprise{display:flex;flex-direction:row;justify-content:space-between;gap:var(--sys-size-9);padding:var(--sys-size-6) var(--sys-size-8) var(--sys-size-6) var(--sys-size-11);align-items:center;> .anchor{display:flex;flex-direction:row;gap:var(--sys-size-9)}}input[type="checkbox"]{flex-shrink:0}.main-text{color:var(--sys-color-on-surface)}.subtext{color:var(--sys-color-on-surface-subtle)}\n/*# sourceURL=${import.meta.resolve("./cookieControlsView.css")} */`;const{ref:w}=c,b={viewTitle:"Controls",viewExplanation:"Test how this site will perform if third-party cookies are limited in ChatGPT Atlas",cardTitle:"Temporarily limit third-party cookies",cardDisclaimer:"Only when DevTools is open",siteReloadMessage:"To apply your updated controls, reload the page",exceptions:"Exceptions",exceptionsExplanation:"Scenarios that grant access to third-party cookies",gracePeriodTitle:"Third-party cookie grace period",gracePeriodExplanation:"If this site or a site embedded on it is enrolled in the {PH1}, then the site can access third-party cookies",enrollGracePeriod:"To use this, enroll this site or sites embedded on it in the {PH1}",gracePeriod:"grace period",heuristicTitle:"Heuristics based exception",heuristicExplanation:"In {PH1} like pop-ups or redirects, a site embedded on this site can access third-party cookies",scenarios:"predefined scenarios",enterpriseDisclaimer:"Your organization manages third-party cookie access for this site",enterpriseTooltip:"This setting is managed by your organization",viewDetails:"View details",enableFlag:"To use this, set {PH1} to Default",tpcdMetadataGrants:"#tpcd-metadata-grants",tpcdHeuristicsGrants:"#tpcd-heuristics-grants"},S=i.i18n.registerUIStrings("panels/security/CookieControlsView.ts",b),f=i.i18n.getLocalizedString.bind(void 0,S),k=i.i18n.getFormatLocalizedString.bind(void 0,S);function x(e){return l`
    <devtools-chrome-link href="chrome://flags/#${e}" tabindex="0">
     ${e}
    </devtools-chrome-link>`}const C=(t,i,s)=>{const r=e.Settings.Settings.instance().createSetting("enterprise-enabled",!(!t.thirdPartyControlsDict||!t.thirdPartyControlsDict.managedBlockThirdPartyCookies||"boolean"!=typeof t.thirdPartyControlsDict.managedBlockThirdPartyCookies)&&t.thirdPartyControlsDict.managedBlockThirdPartyCookies,"Global"),o=e.Settings.Settings.instance().createSetting("cookie-control-override-enabled",!!t.thirdPartyControlsDict?.thirdPartyCookieRestrictionEnabled&&t.thirdPartyControlsDict.thirdPartyCookieRestrictionEnabled,"Global"),a=e.Settings.Settings.instance().createSetting("grace-period-mitigation-disabled",!t.thirdPartyControlsDict?.thirdPartyCookieMetadataEnabled||t.thirdPartyControlsDict.thirdPartyCookieMetadataEnabled,"Global"),c=e.Settings.Settings.instance().createSetting("heuristic-mitigation-disabled",!t.thirdPartyControlsDict?.thirdPartyCookieHeuristicsEnabled||t.thirdPartyControlsDict.thirdPartyCookieHeuristicsEnabled,"Global"),p=l`
      <div class="card-header">
        <div class="lhs">
          <div class="text">
            <h2 class="main-text">${f(b.cardTitle)}</h2>
            <div class="body subtext">${f(b.cardDisclaimer)}</div>
          </div>
          ${Boolean(r.get())?l`
            <devtools-icon
              tabindex="0"
              name="domain"
              ${w(e=>{n.Tooltip.Tooltip.install(e,f(b.enterpriseTooltip)),e.role="img"})}>
            </devtools-icon>`:d}
        </div>
        <div>
          <devtools-switch
            .checked=${Boolean(o.get())}
            .disabled=${Boolean(r.get())}
            .label=${"Temporarily limit third-party cookies, only when DevTools is open"}
            data-testid="cookie-control-override"
            @switchchange=${()=>{t.inputChanged(!o.get(),o)}}
            jslog=${h.toggle(o.name).track({click:!0})}
          >
          </devtools-switch>
        </div>
      </div>
    `,g=!!t.thirdPartyControlsDict&&!t.thirdPartyControlsDict.thirdPartyCookieMetadataEnabled||r.get()||!o.get()||!t.isGracePeriodActive,m=l`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${g}
            .checked=${!g&&!Boolean(a.get())}
            @change=${()=>{t.inputChanged(!a.get(),a)}}
            jslog=${h.toggle(a.name).track({click:!0})}
          >
          <div class="text">
            <div class="body main-text">${f(b.gracePeriodTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?k(b.gracePeriodExplanation,{PH1:f(b.gracePeriod)}):t.thirdPartyControlsDict&&!t.thirdPartyControlsDict?.thirdPartyCookieMetadataEnabled?k(b.enableFlag,{PH1:x(b.tpcdMetadataGrants)}):k(t.isGracePeriodActive?b.gracePeriodExplanation:b.enrollGracePeriod,{PH1:n.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period" jslog=${h.link("grace-period-link").track({click:!0})}>${f(b.gracePeriod)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,y=!!t.thirdPartyControlsDict&&!t.thirdPartyControlsDict.thirdPartyCookieHeuristicsEnabled||r.get()||!o.get(),v=l`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${y}
            .checked=${!y&&!Boolean(c.get())}
            @change=${()=>{t.inputChanged(!c.get(),c)}}
            jslog=${h.toggle(c.name).track({click:!0})}
          >
          <div class='text'>
            <div class="body main-text">${f(b.heuristicTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?k(b.heuristicExplanation,{PH1:f(b.scenarios)}):t.thirdPartyControlsDict&&!t.thirdPartyControlsDict.thirdPartyCookieHeuristicsEnabled?k(b.enableFlag,{PH1:x(b.tpcdHeuristicsGrants)}):k(b.heuristicExplanation,{PH1:n.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/heuristics-based-exceptions" jslog=${h.link("heuristic-link").track({click:!0})}>${f(b.scenarios)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,S=l`
      <div class="enterprise">
        <div class="text body">${f(b.enterpriseDisclaimer)}</div>
          <div class="anchor">
            <devtools-icon
            name="domain"
            ></devtools-icon>
            <devtools-button
            @click=${t.openChromeCookieSettings}
            aria-label="View details of third-party cookie access in Settings"
            .variant=${"outlined"}
            jslog=${h.action("view-details").track({click:!0})}>
            ${f(b.viewDetails)}
          </devtools-button>
        </div>
      </div>
    `;u(l`
      <div class="overflow-auto">
        <div class="controls">
          <div class="header">
            <h1>${f(b.viewTitle)}</h1>
            <div class="body">${f(b.viewExplanation)}</div>
          </div>
          <devtools-card class="card-container">
            <div class=${Boolean(r.get())?"card enterprise-disabled":"card"}>
              ${p}
              <div>
                <div class="card-row text">
                  <h3 class="main-text">${f(b.exceptions)}</h3>
                  <div class="body subtext">${f(b.exceptionsExplanation)}</div>
                </div>
                ${m}
                ${v}
              </div>
            </div>
          </devtools-card>
          ${Boolean(r.get())?S:d}
        </div>
      </div>
    `,s)};function T(){n.InspectorView.InspectorView.instance().displayDebuggedTabReloadRequiredWarning(f(b.siteReloadMessage))}class E extends n.Widget.VBox{#e;#t;#i;constructor(e,t=C){super(e,{useShadowDom:!0}),this.#e=t,this.#t=!1,this.#i=s.Runtime.hostConfig.thirdPartyCookieControls,this.registerRequiredCSS(o.checkboxStyles,v),r.TargetManager.TargetManager.instance().addModelListener(r.ResourceTreeModel.ResourceTreeModel,r.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),r.TargetManager.TargetManager.instance().addModelListener(r.ResourceTreeModel.ResourceTreeModel,r.ResourceTreeModel.Events.ResourceAdded,this.checkGracePeriodActive,this),this.checkGracePeriodActive().catch(e=>{console.error(e)}),this.requestUpdate()}performUpdate(){this.#e({thirdPartyControlsDict:this.#i,isGracePeriodActive:this.#t,inputChanged:this.inputChanged.bind(this),openChromeCookieSettings:this.openChromeCookieSettings.bind(this)},this,this.contentElement)}inputChanged(e,t){t.set(e),T(),this.requestUpdate()}openChromeCookieSettings(){const e=r.TargetManager.TargetManager.instance().rootTarget();if(null===e)return;const i="chrome://settings/cookies";e.targetAgent().invoke_createTarget({url:i}).then(e=>{e.getError()&&t.InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(i)})}#s(){this.#t=!1,this.checkGracePeriodActive().catch(e=>{console.error(e)})}async checkGracePeriodActive(e){if(!this.#i||!this.#i.thirdPartyCookieMetadataEnabled)return;if(this.#t)return;const t=r.TargetManager.TargetManager.instance().primaryPageTarget();if(!t)return;const i=[];if(e)i.push(e.data.url);else for(const e of r.TargetManager.TargetManager.instance().models(r.ResourceTreeModel.ResourceTreeModel))e.forAllResources(e=>(i.push(e.url),!0));const s=await t.storageAgent().invoke_getAffectedUrlsForThirdPartyCookieMetadata({firstPartyUrl:t.inspectedURL(),thirdPartyUrls:i});s.matchedUrls&&s.matchedUrls.length>0&&(this.#t=!0,this.requestUpdate())}}var I=Object.freeze({__proto__:null,CookieControlsView:E,i18nFormatString:k,i18nString:f,showInfobar:T}),P=`.report{display:flex;flex-direction:column;width:100%;height:100%;max-height:100%;gap:var(--sys-size-6);padding-top:var(--sys-size-5)}.header{display:flex;flex-direction:column;flex-shrink:0;gap:var(--sys-size-2);padding-left:var(--sys-size-6);padding-right:var(--sys-size-6);min-width:var(--sys-size-31);h1{font:var(--sys-typescale-headline4);margin:0}}.body{font:var(--sys-typescale-body4-regular)}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.filter{padding-right:var(--sys-size-6);flex-shrink:0}.filters-container{display:flex;padding-left:var(--sys-size-5)}devtools-data-grid{flex:auto;margin-left:-1px}.empty-report{display:flex;flex-direction:column;align-items:center;gap:var(--sys-size-2);padding:var(--sys-size-11) var(--sys-size-6) 0 var(--sys-size-6);flex-shrink:0;min-width:var(--sys-size-31)}.empty-report-title{font:var(--sys-typescale-headline5)}.cookie-off{width:var(--sys-size-11);height:var(--sys-size-11)}\n/*# sourceURL=${import.meta.resolve("./cookieReportView.css")} */`;const{render:R,html:A,Directives:{ref:M}}=a,L={title:"Third-party cookies",body:"This site might not work if third-party cookies and other cookies are limited in Chrome.",learnMoreLink:"Learn more about how third-party cookies are used",name:"Name",domain:"Domain",type:"Type",platform:"Platform",recommendation:"Recommendation",status:"Status",allowed:"Allowed",allowedByException:"Allowed by exception",blocked:"Blocked",unknown:"Unknown",report:"Third-Party Cookie Report",emptyReport:"Not a crumb left",emptyReportExplanation:"No issues with third-party cookies found",gitHubResource:"Review {PH1} from third-party site",guidance:"guidance",gracePeriod:"Review {PH1}. Grace period exception is active.",reportedIssues:"reported issues",heuristics:"Action needed later. Heuristics based exception is active.",other:"Contact third-party site for more info",adCookieTypeString:"Advertising",analyticsCookieTypeString:"Analytics",socialCookieTypeString:"Social",videoCookieTypeString:"Video",utilityCookieTypeString:"Utility",hostingCookieTypeString:"Hosting",marketingCookieTypeString:"Marketing",customerSuccessCookieTypeString:"Customer Success",contentCookieTypeString:"Content",cdnCookieTypeString:"CDN",tagManagerCookieTypeString:"Tag Manager",consentProviderCookieTypeString:"Consent Provider",otherCookieTypeString:"Other",showRequestsWithThisCookie:"Show requests with this cookie"},D=i.i18n.registerUIStrings("panels/security/CookieReportView.ts",L),U=i.i18n.getLocalizedString.bind(void 0,D),H=(e,t,i)=>{R(A`
        <div class="report overflow-auto">
            <div class="header">
              <h1>${U(L.title)}</h1>
              <div class="body">${U(L.body)} <x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/prepare/audit-cookies" jslog=${h.link("learn-more").track({click:!0})}>${U(L.learnMoreLink)}</x-link></div>
            </div>
            ${e.cookieRows.length>0?A`
                <div class="filters-container">
                  <devtools-toolbar>
                    <devtools-toolbar-input
                      type="filter"
                      style="flex-grow: 0.4;"
                      @change=${e.onSearchFilterChanged}
                      value=${e.searchText}
                    ></devtools-toolbar-input>
                  </devtools-toolbar>
                  <devtools-named-bit-set-filter
                    class="filter"
                    aria-label="Third-party cookie status filters"
                    @filterChanged=${e.onFilterChanged}
                    .options=${{items:e.filterItems}}
                    ${M(e=>{e instanceof n.FilterBar.NamedBitSetFilterUIElement&&(t.namedBitSetFilterUI=e.getOrCreateNamedBitSetFilterUI())})}
                  ></devtools-named-bit-set-filter>
                </div>
                <!-- @ts-ignore -->
                <devtools-data-grid
                  name=${U(L.report)}
                  striped
                  .filters=${e.filters}
                  @sort=${e.onSortingChanged}
                  @contextmenu=${e.populateContextMenu.bind(e)}
                >
                  <table>
                    <tr>
                      <th id="name" sortable>${U(L.name)}</th>
                      <th id="domain" sortable>${U(L.domain)}</th>
                      <th id="type" sortable>${U(L.type)}</th>
                      <th id="platform" sortable>${U(L.platform)}</th>
                      <th id="status" sortable>${U(L.status)}</th>
                      <th id="recommendation" sortable>${U(L.recommendation)}</th>
                    </tr>
                    ${[...e.cookieRows.values()].map(e=>A`
                      <tr data-name=${e.name} data-domain=${e.domain}>
                        <td>${e.name}</td>
                        <td>${e.domain}</td>
                        <td>${$.getCookieTypeString(e.type)}</td>
                        <td>${e.platform??U(L.unknown)}</td>
                        <td>${$.getStatusString(e.status)}</td>
                        <td>${$.getRecommendation(e.domain,e.insight)}</td>
                      </tr>
                    `)}
                  </table>
                </devtools-data-grid>
              `:A`
                <div class="empty-report">
                  <devtools-icon
                    class="cookie-off"
                    name="cookie_off"
                  ></devtools-icon>
                  <div class="empty-report-title">
                    ${U(L.emptyReport)}
                  </div>
                  <div class="body">
                    ${U(L.emptyReportExplanation)}
                  </div>
                </div>
              `}

        </div>
    `,i)};class $ extends n.Widget.VBox{#r;namedBitSetFilterUI;#o=new Map;#e;filterItems=[];searchText;constructor(t,i=H){super(t,{useShadowDom:!0}),this.#e=i,this.registerRequiredCSS(P),this.searchText=e.Settings.Settings.instance().createSetting("cookie-report-search-query","").get(),r.TargetManager.TargetManager.instance().addModelListener(r.ResourceTreeModel.ResourceTreeModel,r.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),this.#r=g.IssuesManager.IssuesManager.instance(),this.#r.addEventListener("IssueAdded",this.#n,this);for(const e of this.#r.issues())e instanceof g.CookieIssue.CookieIssue&&this.#a(e);this.requestUpdate()}performUpdate(){this.filterItems=this.#c();const e={cookieRows:[...this.#o.values()].filter(e=>!this.namedBitSetFilterUI||this.namedBitSetFilterUI.accept($.getStatusString(e.status))),filters:[{key:"name,domain",regex:RegExp(p.StringUtilities.escapeForRegExp(this.searchText),"i"),negative:!1}],searchText:this.searchText,filterItems:this.filterItems,onSearchFilterChanged:e=>this.onSearchFilterChanged(e),onFilterChanged:()=>this.requestUpdate(),onSortingChanged:()=>this.requestUpdate(),populateContextMenu:this.populateContextMenu.bind(this)};this.#e(e,this,this.contentElement)}#s(){this.#o.clear(),this.namedBitSetFilterUI=void 0,this.requestUpdate()}#n(e){if(e.data.issue instanceof g.CookieIssue.CookieIssue){if(this.#o.has(e.data.issue.cookieId()))return;this.#a(e.data.issue),this.requestUpdate()}}#a(e){const t=e.makeCookieReportEntry();t&&this.#o.set(e.cookieId(),t)}onSearchFilterChanged(t){this.searchText=t.detail?t.detail:"",e.Settings.Settings.instance().createSetting("cookie-report-search-query","").set(this.searchText),this.requestUpdate()}#c(){const e=[];return this.#o.values().some(e=>0===e.status)&&e.push({name:L.blocked,label:()=>U(L.blocked),title:L.blocked,jslogContext:"blocked"}),this.#o.values().some(e=>1===e.status)&&e.push({name:L.allowed,label:()=>U(L.allowed),title:L.allowed,jslogContext:"allowed"}),this.#o.values().some(e=>2===e.status||3===e.status)&&e.push({name:L.allowedByException,label:()=>U(L.allowedByException),title:L.allowedByException,jslogContext:"allowed-by-exception"}),e}populateContextMenu(t){const{menu:i,element:s}=t.detail,{domain:r,name:o}=s?.dataset;r&&o&&i.revealSection().appendItem(U(L.showRequestsWithThisCookie),()=>{const t=m.UIFilter.UIRequestFilter.filters([{filterType:m.UIFilter.FilterType.CookieDomain,filterValue:r},{filterType:m.UIFilter.FilterType.CookieName,filterValue:o}]);e.Revealer.reveal(t)},{jslogContext:"show-requests-with-this-cookie"})}static getStatusString(e){switch(e){case 0:return U(L.blocked);case 2:case 3:return U(L.allowedByException);case 1:return U(L.allowed)}}static getRecommendation(e,t){const i=document.createElement("div");return R($.getRecommendationText(e,t),i,{host:this}),i}static getRecommendationText(t,s){if(!s)return A`${U(L.other)}`;switch(s.type){case"GitHubResource":{const e=n.XLink.XLink.create(s.tableEntryUrl?s.tableEntryUrl:"https://github.com/privacysandbox/privacy-sandbox-dev-support/blob/main/3pc-migration-readiness.md",U(L.guidance),void 0,void 0,"readiness-list-link");return A`${i.i18n.getFormatLocalizedString(D,L.gitHubResource,{PH1:e})}`}case"GracePeriod":{const s=r.TargetManager.TargetManager.instance().primaryPageTarget()?.inspectedURL(),o=n.XLink.XLink.create("https://developers.google.com/privacy-sandbox/cookies/dashboard?url="+(s?e.ParsedURL.ParsedURL.fromString(s)?.host+"+":"")+("."===t.charAt(0)?t.substring(1):t),U(L.reportedIssues),void 0,void 0,"compatibility-lookup-link");return A`${i.i18n.getFormatLocalizedString(D,L.gracePeriod,{PH1:o})}`}case"Heuristics":return A`${U(L.heuristics)}`;default:return A`${U(L.other)}`}}static getCookieTypeString(e){if(!e)return U(L.otherCookieTypeString);switch(e){case"ad":return U(L.adCookieTypeString);case"analytics":return U(L.analyticsCookieTypeString);case"social":return U(L.socialCookieTypeString);case"video":return U(L.videoCookieTypeString);case"utility":return U(L.utilityCookieTypeString);case"hosting":return U(L.hostingCookieTypeString);case"marketing":return U(L.marketingCookieTypeString);case"customer-success":return U(L.customerSuccessCookieTypeString);case"content":return U(L.contentCookieTypeString);case"cdn":return U(L.cdnCookieTypeString);case"tag-manager":return U(L.tagManagerCookieTypeString);case"consent-provider":return U(L.consentProviderCookieTypeString);default:return U(L.otherCookieTypeString)}}}var F=Object.freeze({__proto__:null,CookieReportView:$,i18nString:U}),V=`@scope to (devtools-widget > *){:scope{width:100%;box-shadow:none}.overflow-auto{height:100%}.ip-protection{display:flex;flex-direction:column;padding:var(--sys-size-5) var(--sys-size-3) var(--sys-size-5) var(--sys-size-5);min-width:fit-content;min-height:fit-content;height:100%}.header{display:flex;flex-direction:column;gap:var(--sys-size-2);padding-left:var(--sys-size-5)}h1{margin:0;font:var(--sys-typescale-headline4)}.card-container{max-width:100%}.card{display:flex;flex-direction:column;padding:var(--sys-size-6) var(--sys-size-8);gap:var(--sys-size-6);&.enterprise-disabled{color:var(--sys-color-token-subtle)}}.card-header{display:flex;align-items:center}.card-header > .lhs{width:100%;display:flex;justify-content:space-between;align-items:center;padding-right:var(--sys-size-9);& > devtools-icon{height:var(--sys-size-11);width:var(--sys-size-11)}}.text{display:flex;flex-direction:column;gap:var(--sys-size-2)}h2{font:var(--sys-typescale-headline5);margin:0}.body{font:var(--sys-typescale-body4-regular)}.card-row{display:flex;justify-content:space-between;align-items:center;padding-top:var(--sys-size-4);padding-bottom:var(--sys-size-4);padding-left:var(--sys-size-8)}h3{font:var(--sys-typescale-body4-medium);margin:0}.main-text{color:var(--sys-color-on-surface)}.subtext{color:var(--sys-color-on-surface-subtle)}.empty-report{margin:var(--sys-size-5);display:flex;flex-grow:1;justify-content:center;align-items:center;flex-direction:column;text-align:center;min-height:fit-content;min-width:fit-content}devtools-data-grid{flex:auto}.status-badge{display:flex;align-items:center}.status-icon{width:1.5rem;height:1.5rem}.green-status-icon{color:var(--sys-color-green)}.red-status-icon{color:var(--sys-color-error)}}\n/*# sourceURL=${import.meta.resolve("./ipProtectionView.css")} */`;const{render:O,html:z}=a,{widgetConfig:N}=n.Widget,q={viewTitle:"IP Protection Proxy Controls",viewExplanation:"Test how this site will perform if IP Proxy is enabled in Chrome",cardTitle:"IP Protection Proxy Status",bypassTitle:"Bypass IP Protection",bypassDescription:"Temporarily bypass IP protection for testing",notInIncognito:"IP proxy unavailable",openIncognito:"IP proxy is only available within incognito mode. Open site in incognito.",idColumn:"ID",urlColumn:"URL",methodColumn:"Method",statusColumn:"Status",proxyRequests:"Proxy Requests",Available:"IP Protection is enabled and active.",FeatureNotEnabled:"IP Protection feature is not enabled.",MaskedDomainListNotEnabled:"Masked Domain List feature is not enabled.",MaskedDomainListNotPopulated:"Masked Domain List is not populated.",AuthTokensUnavailable:"Limit for authentication tokens was reached. IP Protection will be paused.",Unavailable:"IP Protection is unavailable.",BypassedByDevTools:"IP Protection is being bypassed by DevTools.",statusUnknown:"Status unknown"},B=i.i18n.registerUIStrings("panels/security/IPProtectionView.ts",q),G=i.i18n.getLocalizedString.bind(void 0,B),j=(e,t,i)=>{const{status:r}=e,o=G(r?q[r]:q.statusUnknown),a=z`
    <div class="card-header">
      <div class="lhs">
        <div class="text">
          <h2 class="main-text">${G(q.cardTitle)}</h2>
          <div class="body subtext">${o}</div>
        </div>
      </div>
      <div class="status-badge">
       ${"Available"===r?z`<devtools-icon class="status-icon green-status-icon" role="presentation" name="check-circle"></devtools-icon>`:z`<devtools-icon class="status-icon red-status-icon" role="presentation" name="cross-circle-filled"></devtools-icon>`}
      </div>
    </div>
  `;O(z`
    <style>
      ${V}
    </style>
    ${s.Runtime.hostConfig.isOffTheRecord?z`
      <div class="overflow-auto">
        <div class="ip-protection">
          <div class="header">
            <h1>${G(q.viewTitle)}</h1>
            <div class="body">${G(q.viewExplanation)}</div>
          </div>
          <devtools-card class="card-container">
            <div class="card">
              ${a}
              <div>
                <div class="card-row">
                  <div class="lhs">
                    <h3 class="main-text">${G(q.bypassTitle)}</h3>
                    <div class="body subtext">${G(q.bypassDescription)}</div>
                  </div>
                  <div>
                    <devtools-switch></devtools-switch>
                  </div>
                </div>
              </div>
            </div>
          </devtools-card>
          <devtools-data-grid striped name=${G(q.proxyRequests)}>
          <table>
            <thead>
              <tr>
                <th id="id" sortable>${G(q.idColumn)}</th>
                <th id="url" sortable>${G(q.urlColumn)}</th>
                <th id="method" sortable>${G(q.methodColumn)}</th>
                <th id="status" sortable>${G(q.statusColumn)}</th>
              </tr>
            </thead>
            <tbody id="proxy-requests-body">
              ${e.proxyRequests.map((e,t)=>z`
                <tr data-request-id=${e.requestId}>
                  <td>${t+1}</td>
                  <td>${e.url}</td>
                  <td>${e.requestMethod}</td>
                  <td>${String(e.statusCode)}</td>
                </tr>
              `)}
            </tbody>
          </table>
        </devtools-data-grid>
        </div>
      </div>
    `:z`
      <div class="empty-report">
        <devtools-widget
          class="learn-more"
          .widgetConfig=${N(n.EmptyWidget.EmptyWidget,{header:G(q.notInIncognito),text:G(q.openIncognito),link:"https://support.google.com/chrome/answer/95464?hl=en&co=GENIE.Platform%3DDesktop"})}>
        </devtools-widget>
      </div>
    `}
  `,i)};class W extends n.Widget.VBox{#e;#l=[];#d=null;constructor(e,t=j){super(e,{useShadowDom:!0}),this.#e=t,this.#l=[{requestId:"1",url:"https://example.com/api/data",requestMethod:"GET",statusCode:200},{requestId:"2",url:"https://example.com/api/submit",requestMethod:"POST",statusCode:404},{requestId:"3",url:"https://example.com/assets/style.css",requestMethod:"GET",statusCode:200}]}async wasShown(){super.wasShown(),r.TargetManager.TargetManager.instance().addModelListener(r.ResourceTreeModel.ResourceTreeModel,r.ResourceTreeModel.Events.PrimaryPageChanged,this.#u,this),await this.#u()}willHide(){r.TargetManager.TargetManager.instance().removeModelListener(r.ResourceTreeModel.ResourceTreeModel,r.ResourceTreeModel.Events.PrimaryPageChanged,this.#u,this),super.willHide()}async#u(){const e=r.TargetManager.TargetManager.instance().primaryPageTarget();if(!e)return this.#d=null,void this.requestUpdate();const t=e.model(r.NetworkManager.NetworkManager);if(!t)return this.#d=null,void this.requestUpdate();const i=await t.getIpProtectionProxyStatus();this.#d=i,this.requestUpdate()}get proxyRequests(){return this.#l}performUpdate(){const e={status:this.#d,proxyRequests:this.#l};this.#e(e,this,this.contentElement)}}var _=Object.freeze({__proto__:null,DEFAULT_VIEW:j,IPProtectionView:W,i18nString:G});const K={theSecurityOfThisPageIsUnknown:"The security of this page is unknown.",thisPageIsNotSecure:"This page is not secure.",thisPageIsSecureValidHttps:"This page is secure (valid HTTPS).",thisPageIsNotSecureBrokenHttps:"This page is not secure (broken HTTPS).",cipherWithMAC:"{PH1} with {PH2}",keyExchangeWithGroup:"{PH1} with {PH2}"},X=i.i18n.registerUIStrings("panels/security/SecurityModel.ts",K),Y=i.i18n.getLocalizedString.bind(void 0,X),J=i.i18n.getLazilyComputedLocalizedString.bind(void 0,X);class Q extends r.SDKModel.SDKModel{dispatcher;securityAgent;constructor(e){super(e),this.dispatcher=new ne(this),this.securityAgent=e.securityAgent(),e.registerSecurityDispatcher(this.dispatcher),this.securityAgent.invoke_enable()}resourceTreeModel(){return this.target().model(r.ResourceTreeModel.ResourceTreeModel)}networkManager(){return this.target().model(r.NetworkManager.NetworkManager)}}function Z(e,t){const i=["info","insecure-broken","insecure","neutral","secure","unknown"];return i.indexOf(e)-i.indexOf(t)}var ee;r.SDKModel.SDKModel.register(Q,{capabilities:512,autostart:!1}),function(e){e.VisibleSecurityStateChanged="VisibleSecurityStateChanged"}(ee||(ee={}));const te={unknown:J(K.theSecurityOfThisPageIsUnknown),insecure:J(K.thisPageIsNotSecure),neutral:J(K.thisPageIsNotSecure),secure:J(K.thisPageIsSecureValidHttps),"insecure-broken":J(K.thisPageIsNotSecureBrokenHttps)};class ie{securityState;certificateSecurityState;safetyTipInfo;securityStateIssueIds;constructor(e,t,i,s){this.securityState=e,this.certificateSecurityState=t?new se(t):null,this.safetyTipInfo=i?new re(i):null,this.securityStateIssueIds=s}}class se{protocol;keyExchange;keyExchangeGroup;cipher;mac;certificate;subjectName;issuer;validFrom;validTo;certificateNetworkError;certificateHasWeakSignature;certificateHasSha1Signature;modernSSL;obsoleteSslProtocol;obsoleteSslKeyExchange;obsoleteSslCipher;obsoleteSslSignature;constructor(e){this.protocol=e.protocol,this.keyExchange=e.keyExchange,this.keyExchangeGroup=e.keyExchangeGroup||null,this.cipher=e.cipher,this.mac=e.mac||null,this.certificate=e.certificate,this.subjectName=e.subjectName,this.issuer=e.issuer,this.validFrom=e.validFrom,this.validTo=e.validTo,this.certificateNetworkError=e.certificateNetworkError||null,this.certificateHasWeakSignature=e.certificateHasWeakSignature,this.certificateHasSha1Signature=e.certificateHasSha1Signature,this.modernSSL=e.modernSSL,this.obsoleteSslProtocol=e.obsoleteSslProtocol,this.obsoleteSslKeyExchange=e.obsoleteSslKeyExchange,this.obsoleteSslCipher=e.obsoleteSslCipher,this.obsoleteSslSignature=e.obsoleteSslSignature}isCertificateExpiringSoon(){const e=new Date(1e3*this.validTo).getTime();return e<new Date(Date.now()).setHours(48)&&e>Date.now()}getKeyExchangeName(){return this.keyExchangeGroup?this.keyExchange?Y(K.keyExchangeWithGroup,{PH1:this.keyExchange,PH2:this.keyExchangeGroup}):this.keyExchangeGroup:this.keyExchange}getCipherFullName(){return this.mac?Y(K.cipherWithMAC,{PH1:this.cipher,PH2:this.mac}):this.cipher}}class re{safetyTipStatus;safeUrl;constructor(e){this.safetyTipStatus=e.safetyTipStatus,this.safeUrl=e.safeUrl||null}}class oe{securityState;title;summary;description;certificate;mixedContentType;recommendations;constructor(e,t,i,s,r=[],o="none",n=[]){this.securityState=e,this.title=t,this.summary=i,this.description=s,this.certificate=r,this.mixedContentType=o,this.recommendations=n}}class ne{model;constructor(e){this.model=e}securityStateChanged(e){}visibleSecurityStateChanged({visibleSecurityState:e}){const t=new ie(e.securityState,e.certificateSecurityState||null,e.safetyTipInfo||null,e.securityStateIssueIds);this.model.dispatchEventToListeners(ee.VisibleSecurityStateChanged,t)}certificateError(e){}}var ae=Object.freeze({__proto__:null,CertificateSecurityState:se,get Events(){return ee},PageVisibleSecurityState:ie,SecurityModel:Q,SecurityStyleExplanation:oe,SummaryMessages:te,securityStateCompare:Z}),ce=`.lock-icon,\n.security-property{height:var(--sys-size-9);width:var(--sys-size-9)}.lock-icon-secure{color:var(--sys-color-green)}.lock-icon-insecure{color:var(--sys-color-error)}.lock-icon-insecure-broken{color:var(--sys-color-error)}.security-property-secure{color:var(--sys-color-green)}.security-property-neutral{color:var(--sys-color-error)}.security-property-insecure{color:var(--sys-color-error)}.security-property-insecure-broken{color:var(--sys-color-error)}.security-property-info{color:var(--sys-color-on-surface-subtle)}.security-property-unknown{color:var(--sys-color-on-surface-subtle)}.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n.url-scheme-insecure,\n.url-scheme-insecure-broken{color:var(--sys-color-error)}\n/*# sourceURL=${import.meta.resolve("./lockIcon.css")} */`,le=`.devtools-link{display:inline-block}.security-main-view{overflow:hidden auto;background-color:var(--sys-color-cdt-base-container)}.security-main-view > div{flex-shrink:0}.security-summary-section-title{font-size:15px;margin:12px 16px;user-select:text}.lock-spectrum{margin:8px 16px;display:flex;align-items:flex-start}.security-summary .lock-icon{flex:none;width:16px;height:16px;margin:0}.security-summary .lock-icon-neutral{margin:0 16px}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n.security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n.security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n.security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:var(--sys-color-state-disabled)}@media (forced-colors: active){.security-summary-neutral .lock-icon-neutral{color:Highlight}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n  .security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n  .security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n  .security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:canvastext}}.triangle-pointer-container{margin:8px 24px 0;padding:0}.triangle-pointer-wrapper{transform:translateX(0);transition:transform 0.3s}.triangle-pointer{width:12px;height:12px;margin-bottom:-6px;margin-left:-6px;transform:rotate(-45deg);border-style:solid;border-width:1px 1px 0 0;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline)}.security-summary-secure .triangle-pointer-wrapper{transform:translateX(0)}.security-summary-neutral .triangle-pointer-wrapper{transform:translateX(32px)}.security-summary-insecure .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-insecure-broken .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-text{padding:16px 24px;border-style:solid;border-width:1px 0;font-size:15px;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline);user-select:text}.security-summary-secure .triangle-pointer,\n.security-summary-secure .security-summary-text,\n.security-explanation-title-secure{color:var(--sys-color-green)}.security-summary-insecure-broken .triangle-pointer,\n.security-summary-insecure-broken .security-summary-text,\n.security-explanation-title-neutral,\n.security-explanation-title-insecure,\n.security-explanation-title-insecure-broken{color:var(--sys-color-error)}.security-explanation-list{padding-bottom:16px}.security-explanation-list:empty{border-bottom:none;padding:0}.security-explanations-main{margin-top:-5px;background-color:var(--sys-color-cdt-base-container);border-bottom:1px solid var(--sys-color-divider)}.security-explanations-extra{background-color:transparent}.security-explanation{padding:11px;display:flex;white-space:nowrap;border:none;color:var(--sys-color-token-subtle)}.security-explanation-text{flex:auto;white-space:normal;max-width:400px}.origin-button{margin-top:var(--sys-size-4)}.security-explanation .security-property{flex:none;width:16px;height:16px;margin-right:16px}.security-explanation-title{color:var(--sys-color-token-subtle);margin-top:1px;margin-bottom:8px}.security-mixed-content{margin-top:8px}.security-explanation-recommendations{padding-inline-start:16px}.security-explanation-recommendations > li{margin-bottom:4px}\n/*# sourceURL=${import.meta.resolve("./mainView.css")} */`;class de extends n.TreeOutline.TreeElement{constructor(e="",t=!1,i){super(e,t,i),n.ARIAUtils.setLabel(this.listItemElement,e)}get elemId(){return"overview"}showElement(){throw new Error("Unimplemented Method")}onselect(e){if(e){const e=this.elemId;this.listItemElement.dispatchEvent(new CustomEvent("update-sidebar-selection",{bubbles:!0,composed:!0,detail:{id:e}})),this.showElement()}return!1}}class ue extends Event{static eventName="showorigin";origin;constructor(e){super(ue.eventName,{bubbles:!0,composed:!0}),this.origin=e}}class he extends de{#h;#p;#g=null;constructor(e,t,i=null){super(),this.#p=t,this.#g=i,this.listItemElement.classList.add(e),this.#h=null,this.setSecurityState("unknown")}setSecurityState(e){this.#h=e,this.#p(this)}securityState(){return this.#h}origin(){return this.#g}showElement(){this.listItemElement.dispatchEvent(new ue(this.#g))}}var pe=`.title-section{padding:16px 0 24px;border-bottom:1px solid var(--sys-color-divider)}.title-section-header{padding-left:16px;padding-bottom:10px;font-size:14px}.security-origin-view{overflow:hidden scroll;display:block;user-select:text}.security-origin-view .origin-view-section{border-bottom:1px solid var(--sys-color-divider);padding:12px 6px 12px 24px;font-size:12px}.origin-view-notes{margin-top:2px;color:var(--sys-color-token-subtle)}.origin-view-section-notes{margin-top:6px;color:var(--sys-color-token-subtle)}.security-origin-view .origin-display{font-size:12px;padding-left:var(--sys-size-8);display:flex;align-items:center}.title-section > .view-network-button{padding:6px 0 0 16px}.security-origin-view .origin-display devtools-icon{width:var(--sys-size-8);height:var(--sys-size-8);margin-right:var(--sys-size-6)}.security-origin-view .origin-view-section-title{margin-top:4px;margin-bottom:4px;font-weight:bold}.security-origin-view .details-table{border-spacing:0}.security-origin-view .details-table-row{white-space:nowrap;overflow:hidden;line-height:22px;vertical-align:top}.security-origin-view .details-table-row > td{padding:0}.security-origin-view .details-table-row > td:first-child{color:var(--sys-color-token-subtle);width:calc(120px + 1em);text-align:right;padding-right:1em}.security-origin-view .details-table-row > td:nth-child(2){white-space:normal}.security-origin-view .sct-details .details-table .details-table-row:last-child td:last-child{border-bottom:1px solid var(--sys-color-divider);padding-bottom:10px}.security-origin-view .sct-details .details-table:last-child .details-table-row:last-child td:last-child{border-bottom:none;padding-bottom:0}.security-origin-view .details-toggle{margin-left:126px}.security-origin-view .sct-toggle{margin-left:145px;padding-top:5px}.security-origin-view .details-table .empty-san{color:var(--sys-color-state-disabled)}.security-origin-view .details-table .san-entry{display:block}.security-origin-view .truncated-san .truncated-entry{display:none}.origin-view-section:last-child{border-bottom:none}.devtools-link{display:inline-flex}\n/*# sourceURL=${import.meta.resolve("./originView.css")} */`;class ge extends de{constructor(e,t){super(e,!1,t),this.setLeadingIcons([y.Icon.create("gear","cookie-icon")])}get elemId(){return"controls"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showFlagControls",{bubbles:!0,composed:!0}))}}class me extends de{constructor(e,t){super(e,!1,t),this.setLeadingIcons([y.Icon.create("cookie","cookie-icon")])}get elemId(){return"report"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showCookieReport",{bubbles:!0,composed:!0}))}}class ye extends de{constructor(e,t){super(e,!1,t),this.setLeadingIcons([y.Icon.create("shield","shield-icon")])}get elemId(){return"protection"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showIPProtection",{bubbles:!0,composed:!0}))}}var ve=`.tree-outline-disclosure{width:100%}.tree-outline li.security-group-list-item{& + ol{padding-left:0}&::before{display:none}&:not(:first-child){margin-top:var(--sys-size-6)}}.security-main-view-reload-message{color:var(--sys-color-token-subtle)}.tree-outline li.security-sidebar-origins + .children > li{&.selected{.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n    .url-scheme-insecure,\n    .url-scheme-insecure-broken{color:var(--sys-color-error)}}}.security-main-view-reload-message,\n.tree-outline li.security-sidebar-origins,\n.tree-outline li.security-group-list-item,\n.tree-outline span{font:var(--sys-typescale-body4-medium);&:hover:not(:has(devtools-checkbox)) .selection{background:transparent}}.tree-outline li{& .leading-icons{flex:none}& .tree-element-title,\n  .highlighted-url,\n  .title{overflow:hidden;text-overflow:ellipsis}}\n/*# sourceURL=${import.meta.resolve("./sidebar.css")} */`;const we={security:"Security",privacy:"Privacy",cookieReport:"Third-party cookies",flagControls:"Controls",ipProtection:"IP Protection",mainOrigin:"Main origin",nonsecureOrigins:"Non-secure origins",secureOrigins:"Secure origins",unknownCanceled:"Unknown / canceled",overview:"Overview",reloadToViewDetails:"Reload to view details"},be=i.i18n.registerUIStrings("panels/security/SecurityPanelSidebar.ts",we),Se=i.i18n.getLocalizedString.bind(void 0,be);class fe extends n.Widget.VBox{#m;sidebarTree;#y;#v;securityOverviewElement;#w;cookieReportTreeElement;ipProtectionTreeElement;#b;#S;#f;constructor(t){if(super(t),this.#m=e.Settings.Settings.instance().createSetting("security-last-selected-element-path",""),this.#f=null,this.sidebarTree=new n.TreeOutline.TreeOutlineInShadow("NavigationTree"),this.sidebarTree.registerRequiredCSS(ce,ve),this.sidebarTree.element.classList.add("security-sidebar"),this.contentElement.appendChild(this.sidebarTree.element),s.Runtime.hostConfig.devToolsPrivacyUI?.enabled){const e=this.#k(Se(we.privacy),"privacy");this.#w=new ge(Se(we.flagControls),"cookie-flag-controls"),e.appendChild(this.#w),this.cookieReportTreeElement=new me(Se(we.cookieReport),"cookie-report"),e.appendChild(this.cookieReportTreeElement),s.Runtime.hostConfig.devToolsIpProtectionPanelInDevTools?.enabled&&(this.ipProtectionTreeElement=new ye(Se(we.ipProtection),"ip-protection"),e.appendChild(this.ipProtectionTreeElement)),""===this.#m.get()&&this.#m.set(this.#w.elemId)}const i=Se(we.security),r=this.#k(i,"security");this.securityOverviewElement=new he("security-main-view-sidebar-tree-item",this.#p),this.securityOverviewElement.tooltip=Se(we.overview),r.appendChild(this.securityOverviewElement),this.#y=new Map([[$e.MainOrigin,{title:Se(we.mainOrigin)}],[$e.NonSecure,{title:Se(we.nonsecureOrigins),icon:Me("insecure","lock-icon lock-icon-insecure")}],[$e.Secure,{title:Se(we.secureOrigins),icon:Me("secure","lock-icon lock-icon-secure")}],[$e.Unknown,{title:Se(we.unknownCanceled),icon:Me("unknown","lock-icon lock-icon-unknown")}]]),this.#v=new Map;for(const e of Object.values($e)){const t=this.#x(this.#y.get(e)?.title,this.#y.get(e)?.icon);this.#v.set(e,t),r.appendChild(t)}this.#S=new n.TreeOutline.TreeElement(Se(we.reloadToViewDetails)),this.#S.selectable=!1,this.#S.listItemElement.classList.add("security-main-view-reload-message");this.#v.get($e.MainOrigin).appendChild(this.#S),this.#C(),this.#b=new Map,this.element.addEventListener("update-sidebar-selection",e=>{const t=e.detail.id;this.#m.set(t)}),this.showLastSelectedElement()}showLastSelectedElement(){this.#w&&this.#m.get()===this.#w.elemId?(this.#w.select(),this.#w.showElement()):this.cookieReportTreeElement&&this.#m.get()===this.cookieReportTreeElement.elemId?(this.cookieReportTreeElement.select(),this.cookieReportTreeElement.showElement()):this.ipProtectionTreeElement&&this.#m.get()===this.ipProtectionTreeElement.elemId?(this.ipProtectionTreeElement.select(),this.ipProtectionTreeElement.showElement()):(this.securityOverviewElement.select(),this.securityOverviewElement.showElement())}#k(e,t){const i=new n.TreeOutline.TreeElement(e,!0,t);return i.listItemElement.classList.add("security-group-list-item"),i.setCollapsible(!1),i.selectable=!1,this.sidebarTree.appendChild(i),n.ARIAUtils.markAsHeading(i.listItemElement,3),n.ARIAUtils.setLabel(i.childrenListElement,e),i}#T(e){return this.#y.get(e)?.title}#E(e){return this.#v.get(e)}#x(e,t){const i=new n.TreeOutline.TreeElement(e,!0);return i.selectable=!1,i.expand(),i.listItemElement.classList.add("security-sidebar-origins"),t&&i.setLeadingIcons([t]),n.ARIAUtils.setLabel(i.childrenListElement,e),i}toggleOriginsList(e){for(const t of this.#v.values())t.hidden=e}addOrigin(e,t){this.#S.hidden=!0;const i=new he("security-sidebar-tree-item",this.#p,e);i.tooltip=e,this.#b.set(e,i),this.updateOrigin(e,t)}setMainOrigin(e){this.#f=e}get mainOrigin(){return this.#f}get originGroups(){return this.#v}updateOrigin(e,t){const i=this.#b.get(e);let s;if(i.setSecurityState(t),e===this.#f)s=this.#v.get($e.MainOrigin),s.title=Se(we.mainOrigin),s.setLeadingIcons([Le(t,`lock-icon lock-icon-${t}`)]),n.ARIAUtils.setLabel(s.childrenListElement,s.title);else switch(t){case"secure":s=this.#E($e.Secure);break;case"unknown":s=this.#E($e.Unknown);break;default:s=this.#E($e.NonSecure)}const r=i.parent;r!==s&&(r&&(r.removeChild(i),0===r.childCount()&&(r.hidden=!0)),s.appendChild(i),s.hidden=!1)}#C(){for(const[e,t]of this.#v)if(e===$e.MainOrigin){for(let e=t.childCount()-1;e>0;e--)t.removeChildAtIndex(e);t.title=this.#T($e.MainOrigin),t.hidden=!1,this.#S.hidden=!1}else t.removeChildren(),t.hidden=!0}clearOrigins(){this.#C(),this.#b.clear()}focus(){this.sidebarTree.focus()}#p(e){if(e instanceof he){const t=e.securityState()??"unknown",i=e.listItemElement.classList.contains("security-main-view-sidebar-tree-item"),s=i?Le(t,`lock-icon lock-icon-${t}`):Me(t,`security-property security-property-${t}`),r=i?(()=>{const e=document.createElement("span");return e.classList.add("title"),e.textContent=Se(we.overview),e})():De(e.origin()??p.DevToolsPath.EmptyUrlString,t);e.setLeadingIcons([s]),e.listItemElement.lastChild&&e.listItemElement.removeChild(e.listItemElement.lastChild),e.listItemElement.appendChild(r)}}}const{widgetConfig:ke}=n.Widget,xe={securityOverview:"Security overview",secure:"Secure",info:"Info",notSecure:"Not secure",viewCertificate:"View certificate",notSecureBroken:"Not secure (broken)",thisPageIsDangerousFlaggedBy:"This page is dangerous (flagged by Google Safe Browsing).",flaggedByGoogleSafeBrowsing:"Flagged by Google Safe Browsing",toCheckThisPagesStatusVisit:"To check this page's status, visit g.co/safebrowsingstatus.",thisIsAnErrorPage:"This is an error page.",thisPageIsInsecureUnencrypted:"This page is insecure (unencrypted HTTP).",thisPageHasANonhttpsSecureOrigin:"This page has a non-HTTPS secure origin.",thisPageIsSuspicious:"This page is suspicious",chromeHasDeterminedThatThisSiteS:"Chrome has determined that this site could be fake or fraudulent.",ifYouBelieveThisIsShownIn:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",possibleSpoofingUrl:"Possible spoofing URL",thisSitesHostnameLooksSimilarToP:"This site's hostname looks similar to {PH1}. Attackers sometimes mimic sites by making small, hard-to-see changes to the domain name.",ifYouBelieveThisIsShownInErrorSafety:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",thisPageIsSuspiciousFlaggedBy:"This page is suspicious (flagged by Chrome).",certificate:"Certificate",insecureSha:"insecure (SHA-1)",theCertificateChainForThisSite:"The certificate chain for this site contains a certificate signed using SHA-1.",subjectAlternativeNameMissing:"`Subject Alternative Name` missing",theCertificateForThisSiteDoesNot:"The certificate for this site does not contain a `Subject Alternative Name` extension containing a domain name or IP address.",missing:"missing",thisSiteIsMissingAValidTrusted:"This site is missing a valid, trusted certificate ({PH1}).",validAndTrusted:"valid and trusted",theConnectionToThisSiteIsUsingA:"The connection to this site is using a valid, trusted server certificate issued by {PH1}.",publickeypinningBypassed:"Public-Key-Pinning bypassed",publickeypinningWasBypassedByA:"Public-Key-Pinning was bypassed by a local root certificate.",certificateExpiresSoon:"Certificate expires soon",theCertificateForThisSiteExpires:"The certificate for this site expires in less than 48 hours and needs to be renewed.",connection:"Connection",secureConnectionSettings:"secure connection settings",theConnectionToThisSiteIs:"The connection to this site is encrypted and authenticated using {PH1}, {PH2}, and {PH3}.",sIsObsoleteEnableTlsOrLater:"{PH1} is obsolete. Enable TLS 1.2 or later.",rsaKeyExchangeIsObsoleteEnableAn:"RSA key exchange is obsolete. Enable an ECDHE-based cipher suite.",sIsObsoleteEnableAnAesgcmbased:"{PH1} is obsolete. Enable an AES-GCM-based cipher suite.",theServerSignatureUsesShaWhichIs:"The server signature uses SHA-1, which is obsolete. Enable a SHA-2 signature algorithm instead. (Note this is different from the signature in the certificate.)",obsoleteConnectionSettings:"obsolete connection settings",resources:"Resources",activeMixedContent:"active mixed content",youHaveRecentlyAllowedNonsecure:"You have recently allowed non-secure content (such as scripts or iframes) to run on this site.",mixedContent:"mixed content",thisPageIncludesHttpResources:"This page includes HTTP resources.",nonsecureForm:"non-secure form",thisPageIncludesAFormWithA:'This page includes a form with a non-secure "action" attribute.',activeContentWithCertificate:"active content with certificate errors",youHaveRecentlyAllowedContent:"You have recently allowed content loaded with certificate errors (such as scripts or iframes) to run on this site.",contentWithCertificateErrors:"content with certificate errors",thisPageIncludesResourcesThat:"This page includes resources that were loaded with certificate errors.",allServedSecurely:"all served securely",allResourcesOnThisPageAreServed:"All resources on this page are served securely.",blockedMixedContent:"Blocked mixed content",yourPageRequestedNonsecure:"Your page requested non-secure resources that were blocked.",reloadThePageToRecordRequestsFor:"Reload the page to record requests for HTTP resources.",viewDRequestsInNetworkPanel:"{n, plural, =1 {View # request in Network Panel} other {View # requests in Network Panel}}",origin:"Origin",viewRequestsInNetworkPanel:"View requests in Network Panel",protocol:"Protocol",keyExchange:"Key exchange",cipher:"Cipher",serverSignature:"Server signature",encryptedClientHello:"Encrypted ClientHello",certificateTransparency:"Certificate Transparency",subject:"Subject",validFrom:"Valid from",validUntil:"Valid until",issuer:"Issuer",openFullCertificateDetails:"Open full certificate details",sct:"SCT",logName:"Log name",logId:"Log ID",validationStatus:"Validation status",source:"Source",issuedAt:"Issued at",hashAlgorithm:"Hash algorithm",signatureAlgorithm:"Signature algorithm",signatureData:"Signature data",showFullDetails:"Show full details",hideFullDetails:"Hide full details",thisRequestCompliesWithChromes:"This request complies with `Chrome`'s Certificate Transparency policy.",thisRequestDoesNotComplyWith:"This request does not comply with `Chrome`'s Certificate Transparency policy.",thisResponseWasLoadedFromCache:"This response was loaded from cache. Some security details might be missing.",theSecurityDetailsAboveAreFrom:"The security details above are from the first inspected response.",thisOriginIsANonhttpsSecure:"This origin is a non-HTTPS secure origin.",yourConnectionToThisOriginIsNot:"Your connection to this origin is not secure.",noSecurityInformation:"No security information",noSecurityDetailsAreAvailableFor:"No security details are available for this origin.",na:"(n/a)",showLess:"Show less",showMoreSTotal:"Show more ({PH1} total)",unknownField:"unknown",enabled:"enabled"},Ce=i.i18n.registerUIStrings("panels/security/SecurityPanel.ts",xe),Te=i.i18n.getLocalizedString.bind(void 0,Ce);let Ee;const Ie=new Map([[513,"RSA with SHA-1"],[1025,"RSA with SHA-256"],[1281,"RSA with SHA-384"],[1537,"RSA with SHA-512"],[1027,"ECDSA with SHA-256"],[1283,"ECDSA with SHA-384"],[2052,"RSA-PSS with SHA-256"],[2053,"RSA-PSS with SHA-384"],[2054,"RSA-PSS with SHA-512"]]),Pe="lock",Re="warning",Ae="indeterminate-question-box";function Me(e,t){let i;switch(e){case"neutral":case"insecure":case"insecure-broken":i=Re;break;case"secure":i=Pe;break;case"info":case"unknown":i=Ae}return y.Icon.create(i,t)}function Le(e,t){let i;switch(e){case"unknown":case"neutral":i=Ae;break;case"insecure":case"insecure-broken":i=Re;break;case"secure":i=Pe;break;case"info":throw new Error(`Unexpected security state ${e}`)}return y.Icon.create(i,t)}function De(e,t){const i="://",s=e.indexOf(i);if(-1===s){const t=document.createElement("span");return t.textContent=e,t}const r=document.createElement("span");r.classList.add("highlighted-url");const o=e.substr(0,s),n=e.substr(s+3);return r.createChild("span","url-scheme-"+t).textContent=o,r.createChild("span","url-scheme-separator").textContent=i,r.createChild("span").textContent=n,r}const Ue=(e,t,i)=>{u(l`
    <devtools-split-view direction="column" name="security"
      ${n.Widget.widgetRef(n.SplitWidget.SplitWidget,e=>{t.splitWidget=e})}>
      <devtools-widget
        slot="sidebar"
        .widgetConfig=${ke(fe)}
        @showIPProtection=${()=>t.setVisibleView(new W)}
        @showCookieReport=${()=>t.setVisibleView(new $)}
        @showFlagControls=${()=>t.setVisibleView(new E)}
        ${n.Widget.widgetRef(fe,e=>{t.sidebar=e})}>
      </devtools-widget>
  </devtools-split-view>`,i)};class He extends n.Panel.Panel{view;mainView;sidebar;lastResponseReceivedForLoaderId;origins;filterRequestCounts;visibleView;eventListeners;securityModel;splitWidget;constructor(e=Ue){super("security"),this.view=e,this.update(),this.sidebar.setMinimumSize(100,25),this.sidebar.element.classList.add("panel-sidebar"),this.sidebar.element.setAttribute("jslog",`${h.pane("sidebar").track({resize:!0})}`),this.mainView=new Fe,this.mainView.panel=this,this.element.addEventListener(ue.eventName,e=>{e.origin?this.showOrigin(e.origin):this.setVisibleView(this.mainView)}),this.lastResponseReceivedForLoaderId=new Map,this.origins=new Map,this.filterRequestCounts=new Map,this.visibleView=null,this.eventListeners=[],this.securityModel=null,r.TargetManager.TargetManager.instance().observeModels(Q,this,{scoped:!0}),r.TargetManager.TargetManager.instance().addModelListener(r.ResourceTreeModel.ResourceTreeModel,r.ResourceTreeModel.Events.PrimaryPageChanged,this.onPrimaryPageChanged,this),this.sidebar.showLastSelectedElement()}static instance(e={forceNew:null}){const{forceNew:t}=e;return Ee&&!t||(Ee=new He),Ee}static createCertificateViewerButtonForOrigin(e,i){const s=n.UIUtils.createTextButton(e,async e=>{e.consume();const s=await r.NetworkManager.MultitargetNetworkManager.instance().getCertificate(i);s.length>0&&t.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(s)},{className:"origin-button",jslogContext:"security.view-certificate-for-origin",title:e});return n.ARIAUtils.markAsButton(s),s}static createCertificateViewerButtonForCert(e,i){const s=n.UIUtils.createTextButton(e,e=>{e.consume(),t.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(i)},{className:"origin-button",jslogContext:"security.view-certificate"});return n.ARIAUtils.markAsButton(s),s}update(){this.view({panel:this},this,this.contentElement)}updateVisibleSecurityState(e){this.sidebar.securityOverviewElement.setSecurityState(e.securityState),this.mainView.updateVisibleSecurityState(e)}onVisibleSecurityStateChanged({data:e}){this.updateVisibleSecurityState(e)}showOrigin(e){const t=this.origins.get(e);t&&(t.originView||(t.originView=new Ve(e,t)),this.setVisibleView(t.originView))}wasShown(){super.wasShown(),this.visibleView||this.sidebar.showLastSelectedElement()}focus(){this.sidebar.focus()}setVisibleView(e){this.visibleView!==e&&(this.visibleView&&this.visibleView.detach(),this.visibleView=e,e&&this.splitWidget.setMainWidget(e))}onResponseReceived(t){const i=t.data.request;i.resourceType()===e.ResourceType.resourceTypes.Document&&i.loaderId&&this.lastResponseReceivedForLoaderId.set(i.loaderId,i)}processRequest(t){const i=e.ParsedURL.ParsedURL.extractOrigin(t.url());if(!i)return;let s=t.securityState();"blockable"!==t.mixedContentType&&"optionally-blockable"!==t.mixedContentType||(s="insecure");const r=this.origins.get(i);if(r){if(Z(s,r.securityState)<0){r.securityState=s;const e=t.securityDetails();e&&(r.securityDetails=e),this.sidebar.updateOrigin(i,s),r.originView&&r.originView.setSecurityState(s)}}else{const e={securityState:s,securityDetails:t.securityDetails(),loadedFromCache:t.cached(),originView:void 0};this.origins.set(i,e),this.sidebar.addOrigin(i,s)}}onRequestFinished(e){const t=e.data;this.updateFilterRequestCounts(t),this.processRequest(t)}updateFilterRequestCounts(e){if("none"===e.mixedContentType)return;let t="all";e.wasBlocked()?t="blocked":"blockable"===e.mixedContentType?t="block-overridden":"optionally-blockable"===e.mixedContentType&&(t="displayed");const i=this.filterRequestCounts.get(t);i?this.filterRequestCounts.set(t,i+1):this.filterRequestCounts.set(t,1),this.mainView.refreshExplanations()}filterRequestCount(e){return this.filterRequestCounts.get(e)||0}modelAdded(t){if(t.target()!==t.target().outermostTarget())return;this.securityModel=t;const i=t.resourceTreeModel(),s=t.networkManager();this.eventListeners.length&&e.EventTarget.removeEventListeners(this.eventListeners),this.eventListeners=[t.addEventListener(ee.VisibleSecurityStateChanged,this.onVisibleSecurityStateChanged,this),i.addEventListener(r.ResourceTreeModel.Events.InterstitialShown,this.onInterstitialShown,this),i.addEventListener(r.ResourceTreeModel.Events.InterstitialHidden,this.onInterstitialHidden,this),s.addEventListener(r.NetworkManager.Events.ResponseReceived,this.onResponseReceived,this),s.addEventListener(r.NetworkManager.Events.RequestFinished,this.onRequestFinished,this)],i.isInterstitialShowing&&this.onInterstitialShown()}modelRemoved(t){this.securityModel===t&&(this.securityModel=null,e.EventTarget.removeEventListeners(this.eventListeners))}onPrimaryPageChanged(t){const{frame:i}=t.data,s=this.lastResponseReceivedForLoaderId.get(i.loaderId);this.sidebar.showLastSelectedElement(),this.sidebar.clearOrigins(),this.origins.clear(),this.lastResponseReceivedForLoaderId.clear(),this.filterRequestCounts.clear(),this.mainView.refreshExplanations();const r=e.ParsedURL.ParsedURL.extractOrigin(s?s.url():i.url);this.sidebar.setMainOrigin(r),s&&this.processRequest(s)}onInterstitialShown(){this.sidebar.showLastSelectedElement(),this.sidebar.toggleOriginsList(!0)}onInterstitialHidden(){this.sidebar.toggleOriginsList(!1)}}var $e;!function(e){e.MainOrigin="MainOrigin",e.NonSecure="NonSecure",e.Secure="Secure",e.Unknown="Unknown"}($e||($e={}));class Fe extends n.Widget.VBox{panel;summarySection;securityExplanationsMain;securityExplanationsExtra;lockSpectrum;summaryText;explanations;securityState;constructor(e){super(e,{jslog:`${h.pane("security.main-view")}`}),this.registerRequiredCSS(ce,le),this.setMinimumSize(200,100),this.contentElement.classList.add("security-main-view"),this.summarySection=this.contentElement.createChild("div","security-summary"),this.securityExplanationsMain=this.contentElement.createChild("div","security-explanation-list security-explanations-main"),this.securityExplanationsExtra=this.contentElement.createChild("div","security-explanation-list security-explanations-extra");const t=this.summarySection.createChild("div","security-summary-section-title");t.textContent=Te(xe.securityOverview),n.ARIAUtils.markAsHeading(t,1);const i=this.summarySection.createChild("div","lock-spectrum");this.lockSpectrum=new Map([["secure",i.appendChild(Le("secure","lock-icon lock-icon-secure"))],["neutral",i.appendChild(Le("neutral","lock-icon lock-icon-neutral"))],["insecure",i.appendChild(Le("insecure","lock-icon lock-icon-insecure"))]]),n.Tooltip.Tooltip.install(this.getLockSpectrumDiv("secure"),Te(xe.secure)),n.Tooltip.Tooltip.install(this.getLockSpectrumDiv("neutral"),Te(xe.info)),n.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),Te(xe.notSecure)),this.summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer"),this.summaryText=this.summarySection.createChild("div","security-summary-text"),n.ARIAUtils.markAsHeading(this.summaryText,2),this.explanations=null,this.securityState=null}getLockSpectrumDiv(e){const t=this.lockSpectrum.get(e);if(!t)throw new Error(`Invalid argument: ${e}`);return t}addExplanation(e,t){const i=e.createChild("div","security-explanation");i.classList.add("security-explanation-"+t.securityState);const s=Me(t.securityState,"security-property security-property-"+t.securityState);i.appendChild(s);const r=i.createChild("div","security-explanation-text"),o=r.createChild("div","security-explanation-title");if(t.title?(o.createChild("span").textContent=t.title+" - ",o.createChild("span","security-explanation-title-"+t.securityState).textContent=t.summary):o.textContent=t.summary,r.createChild("div").textContent=t.description,t.certificate.length&&r.appendChild(He.createCertificateViewerButtonForCert(Te(xe.viewCertificate),t.certificate)),t.recommendations?.length){const e=r.createChild("ul","security-explanation-recommendations");for(const i of t.recommendations)e.createChild("li").textContent=i}return r}updateVisibleSecurityState(e){this.summarySection.classList.remove("security-summary-"+this.securityState),this.securityState=e.securityState,this.summarySection.classList.add("security-summary-"+this.securityState),"insecure"===this.securityState?(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure-broken"),n.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),Te(xe.notSecure))):"insecure-broken"===this.securityState&&(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure"),n.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),Te(xe.notSecureBroken)));const{summary:t,explanations:i}=this.getSecuritySummaryAndExplanations(e);this.summaryText.textContent=t||te[this.securityState](),this.explanations=this.orderExplanations(i),this.refreshExplanations()}getSecuritySummaryAndExplanations(e){const{securityState:t,securityStateIssueIds:i}=e;let s;const r=[];if(s=this.explainSafetyTipSecurity(e,s,r),i.includes("malicious-content"))s=Te(xe.thisPageIsDangerousFlaggedBy),r.unshift(new oe("insecure",void 0,Te(xe.flaggedByGoogleSafeBrowsing),Te(xe.toCheckThisPagesStatusVisit)));else{if(i.includes("is-error-page")&&null===e.certificateSecurityState?.certificateNetworkError)return s=Te(xe.thisIsAnErrorPage),{summary:s,explanations:r};"insecure-broken"===t&&i.includes("scheme-is-not-cryptographic")&&(s=s||Te(xe.thisPageIsInsecureUnencrypted))}return i.includes("scheme-is-not-cryptographic")?("neutral"!==t||i.includes("insecure-origin")||(s=Te(xe.thisPageHasANonhttpsSecureOrigin)),{summary:s,explanations:r}):(this.explainCertificateSecurity(e,r),this.explainConnectionSecurity(e,r),this.explainContentSecurity(e,r),{summary:s,explanations:r})}explainSafetyTipSecurity(e,t,i){const{securityStateIssueIds:s,safetyTipInfo:r}=e,o=[];if(s.includes("bad_reputation")){const e=`${Te(xe.chromeHasDeterminedThatThisSiteS)}\n\n${Te(xe.ifYouBelieveThisIsShownIn)}`;o.push({summary:Te(xe.thisPageIsSuspicious),description:e})}else if(s.includes("lookalike")&&r?.safeUrl){const e=new URL(r.safeUrl).hostname,t=`${Te(xe.thisSitesHostnameLooksSimilarToP,{PH1:e})}\n\n${Te(xe.ifYouBelieveThisIsShownInErrorSafety)}`;o.push({summary:Te(xe.possibleSpoofingUrl),description:t})}return o.length>0&&(t=t||Te(xe.thisPageIsSuspiciousFlaggedBy),i.push(new oe("insecure",void 0,o[0].summary,o[0].description))),t}explainCertificateSecurity(e,t){const{certificateSecurityState:i,securityStateIssueIds:s}=e,r=Te(xe.certificate);if(i?.certificateHasSha1Signature){const e=Te(xe.insecureSha),s=Te(xe.theCertificateChainForThisSite);i.certificateHasWeakSignature?t.push(new oe("insecure",r,e,s,i.certificate,"none")):t.push(new oe("neutral",r,e,s,i.certificate,"none"))}i&&s.includes("cert-missing-subject-alt-name")&&t.push(new oe("insecure",r,Te(xe.subjectAlternativeNameMissing),Te(xe.theCertificateForThisSiteDoesNot),i.certificate,"none")),i&&null!==i.certificateNetworkError?t.push(new oe("insecure",r,Te(xe.missing),Te(xe.thisSiteIsMissingAValidTrusted,{PH1:i.certificateNetworkError}),i.certificate,"none")):i&&!i.certificateHasSha1Signature&&t.push(new oe("secure",r,Te(xe.validAndTrusted),Te(xe.theConnectionToThisSiteIsUsingA,{PH1:i.issuer}),i.certificate,"none")),s.includes("pkp-bypassed")&&t.push(new oe("info",r,Te(xe.publickeypinningBypassed),Te(xe.publickeypinningWasBypassedByA))),i?.isCertificateExpiringSoon()&&t.push(new oe("info",void 0,Te(xe.certificateExpiresSoon),Te(xe.theCertificateForThisSiteExpires)))}explainConnectionSecurity(e,t){const i=e.certificateSecurityState;if(!i)return;const s=Te(xe.connection);if(i.modernSSL)return void t.push(new oe("secure",s,Te(xe.secureConnectionSettings),Te(xe.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()})));const r=[];i.obsoleteSslProtocol&&r.push(Te(xe.sIsObsoleteEnableTlsOrLater,{PH1:i.protocol})),i.obsoleteSslKeyExchange&&r.push(Te(xe.rsaKeyExchangeIsObsoleteEnableAn)),i.obsoleteSslCipher&&r.push(Te(xe.sIsObsoleteEnableAnAesgcmbased,{PH1:i.cipher})),i.obsoleteSslSignature&&r.push(Te(xe.theServerSignatureUsesShaWhichIs)),t.push(new oe("info",s,Te(xe.obsoleteConnectionSettings),Te(xe.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()}),void 0,void 0,r))}explainContentSecurity(e,t){let i=!0;const s=Te(xe.resources),r=e.securityStateIssueIds;r.includes("ran-mixed-content")&&(i=!1,t.push(new oe("insecure",s,Te(xe.activeMixedContent),Te(xe.youHaveRecentlyAllowedNonsecure),[],"blockable"))),r.includes("displayed-mixed-content")&&(i=!1,t.push(new oe("neutral",s,Te(xe.mixedContent),Te(xe.thisPageIncludesHttpResources),[],"optionally-blockable"))),r.includes("contained-mixed-form")&&(i=!1,t.push(new oe("neutral",s,Te(xe.nonsecureForm),Te(xe.thisPageIncludesAFormWithA)))),null===e.certificateSecurityState?.certificateNetworkError&&(r.includes("ran-content-with-cert-error")&&(i=!1,t.push(new oe("insecure",s,Te(xe.activeContentWithCertificate),Te(xe.youHaveRecentlyAllowedContent)))),r.includes("displayed-content-with-cert-errors")&&(i=!1,t.push(new oe("neutral",s,Te(xe.contentWithCertificateErrors),Te(xe.thisPageIncludesResourcesThat))))),i&&(r.includes("scheme-is-not-cryptographic")||t.push(new oe("secure",s,Te(xe.allServedSecurely),Te(xe.allResourcesOnThisPageAreServed))))}orderExplanations(e){if(0===e.length)return e;const t=["insecure","neutral","secure","info"],i=[];for(const s of t)i.push(...e.filter(e=>e.securityState===s));return i}refreshExplanations(){if(this.securityExplanationsMain.removeChildren(),this.securityExplanationsExtra.removeChildren(),this.explanations){for(const e of this.explanations)if("info"===e.securityState)this.addExplanation(this.securityExplanationsExtra,e);else switch(e.mixedContentType){case"blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"block-overridden");break;case"optionally-blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"displayed");break;default:this.addExplanation(this.securityExplanationsMain,e)}if(this.panel.filterRequestCount("blocked")>0){const e={securityState:"info",summary:Te(xe.blockedMixedContent),description:Te(xe.yourPageRequestedNonsecure),mixedContentType:"blockable",certificate:[],title:""};this.addMixedContentExplanation(this.securityExplanationsMain,e,"blocked")}}}addMixedContentExplanation(e,t,i){const s=this.addExplanation(e,t),r=this.panel.filterRequestCount(i);if(!r){return void(s.createChild("div","security-mixed-content").textContent=Te(xe.reloadThePageToRecordRequestsFor))}const o=s.createChild("button","security-mixed-content devtools-link text-button link-style");n.ARIAUtils.markAsLink(o),o.tabIndex=0,o.textContent=Te(xe.viewDRequestsInNetworkPanel,{n:r}),o.addEventListener("click",this.showNetworkFilter.bind(this,i))}showNetworkFilter(t,i){i.consume(),e.Revealer.reveal(m.UIFilter.UIRequestFilter.filters([{filterType:m.UIFilter.FilterType.MixedContent,filterValue:t}]))}}class Ve extends n.Widget.VBox{originLockIcon;constructor(t,s){super({jslog:`${h.pane("security.origin-view")}`}),this.registerRequiredCSS(pe,ce),this.setMinimumSize(200,100),this.element.classList.add("security-origin-view");const r=this.element.createChild("div","title-section"),o=r.createChild("div","title-section-header");o.textContent=Te(xe.origin),n.ARIAUtils.markAsHeading(o,1);const a=r.createChild("div","origin-display");this.originLockIcon=a.createChild("span");const c=Me(s.securityState,`security-property security-property-${s.securityState}`);this.originLockIcon.appendChild(c),a.appendChild(De(t,s.securityState));const l=r.createChild("div","view-network-button"),d=n.UIUtils.createTextButton(Te(xe.viewRequestsInNetworkPanel),i=>{i.consume();const s=new e.ParsedURL.ParsedURL(t);e.Revealer.reveal(m.UIFilter.UIRequestFilter.filters([{filterType:m.UIFilter.FilterType.Domain,filterValue:s.host},{filterType:m.UIFilter.FilterType.Scheme,filterValue:s.scheme}]))},{jslogContext:"reveal-in-network"});if(l.appendChild(d),n.ARIAUtils.markAsLink(d),s.securityDetails){const u=this.element.createChild("div","origin-view-section"),p=u.createChild("div","origin-view-section-title");p.textContent=Te(xe.connection),n.ARIAUtils.markAsHeading(p,2);let g=new Oe;if(u.appendChild(g.element()),g.addRow(Te(xe.protocol),s.securityDetails.protocol),s.securityDetails.keyExchange&&s.securityDetails.keyExchangeGroup?g.addRow(Te(xe.keyExchange),s.securityDetails.keyExchange+" with "+s.securityDetails.keyExchangeGroup):s.securityDetails.keyExchange?g.addRow(Te(xe.keyExchange),s.securityDetails.keyExchange):s.securityDetails.keyExchangeGroup&&g.addRow(Te(xe.keyExchange),s.securityDetails.keyExchangeGroup),s.securityDetails.serverSignatureAlgorithm){let I=Ie.get(s.securityDetails.serverSignatureAlgorithm);I??=Te(xe.unknownField)+" ("+s.securityDetails.serverSignatureAlgorithm+")",g.addRow(Te(xe.serverSignature),I)}g.addRow(Te(xe.cipher),s.securityDetails.cipher+(s.securityDetails.mac?" with "+s.securityDetails.mac:"")),s.securityDetails.encryptedClientHello&&g.addRow(Te(xe.encryptedClientHello),Te(xe.enabled));const y=this.element.createChild("div","origin-view-section"),v=y.createChild("div","origin-view-section-title");v.textContent=Te(xe.certificate),n.ARIAUtils.markAsHeading(v,2);const w=s.securityDetails.signedCertificateTimestampList.length,b=s.securityDetails.certificateTransparencyCompliance;let S;if(w||"unknown"!==b){S=this.element.createChild("div","origin-view-section");const P=S.createChild("div","origin-view-section-title");P.textContent=Te(xe.certificateTransparency),n.ARIAUtils.markAsHeading(P,2)}const f=this.createSanDiv(s.securityDetails.sanList),k=new Date(1e3*s.securityDetails.validFrom).toUTCString(),x=new Date(1e3*s.securityDetails.validTo).toUTCString();if(g=new Oe,y.appendChild(g.element()),g.addRow(Te(xe.subject),s.securityDetails.subjectName),g.addRow(i.i18n.lockedString("SAN"),f),g.addRow(Te(xe.validFrom),k),g.addRow(Te(xe.validUntil),x),g.addRow(Te(xe.issuer),s.securityDetails.issuer),g.addRow("",He.createCertificateViewerButtonForOrigin(Te(xe.openFullCertificateDetails),t)),!S)return;const C=new Oe;C.element().classList.add("sct-summary"),S.appendChild(C.element());for(let R=0;R<w;R++){const A=s.securityDetails.signedCertificateTimestampList[R];C.addRow(Te(xe.sct),A.logDescription+" ("+A.origin+", "+A.status+")")}const T=S.createChild("div","sct-details");T.classList.add("hidden");for(let M=0;M<w;M++){const L=new Oe;T.appendChild(L.element());const D=s.securityDetails.signedCertificateTimestampList[M];L.addRow(Te(xe.logName),D.logDescription),L.addRow(Te(xe.logId),D.logId.replace(/(.{2})/g,"$1 ")),L.addRow(Te(xe.validationStatus),D.status),L.addRow(Te(xe.source),D.origin),L.addRow(Te(xe.issuedAt),new Date(D.timestamp).toUTCString()),L.addRow(Te(xe.hashAlgorithm),D.hashAlgorithm),L.addRow(Te(xe.signatureAlgorithm),D.signatureAlgorithm),L.addRow(Te(xe.signatureData),D.signatureData.replace(/(.{2})/g,"$1 "))}if(w){function U(){let e;const t=!T.classList.contains("hidden");e=Te(t?xe.showFullDetails:xe.hideFullDetails),H.textContent=e,n.ARIAUtils.setLabel(H,e),n.ARIAUtils.setExpanded(H,!t),C.element().classList.toggle("hidden"),T.classList.toggle("hidden")}const H=n.UIUtils.createTextButton(Te(xe.showFullDetails),U,{className:"details-toggle",jslogContext:"security.toggle-scts-details"});S.appendChild(H)}switch(b){case"compliant":S.createChild("div","origin-view-section-notes").textContent=Te(xe.thisRequestCompliesWithChromes);break;case"not-compliant":S.createChild("div","origin-view-section-notes").textContent=Te(xe.thisRequestDoesNotComplyWith)}const E=this.element.createChild("div","origin-view-section origin-view-notes");s.loadedFromCache&&(E.createChild("div").textContent=Te(xe.thisResponseWasLoadedFromCache)),E.createChild("div").textContent=Te(xe.theSecurityDetailsAboveAreFrom)}else if("secure"===s.securityState){const $=this.element.createChild("div","origin-view-section"),F=$.createChild("div","origin-view-section-title");F.textContent=Te(xe.secure),n.ARIAUtils.markAsHeading(F,2),$.createChild("div").textContent=Te(xe.thisOriginIsANonhttpsSecure)}else if("unknown"!==s.securityState){const V=this.element.createChild("div","origin-view-section"),O=V.createChild("div","origin-view-section-title");O.textContent=Te(xe.notSecure),n.ARIAUtils.markAsHeading(O,2),V.createChild("div").textContent=Te(xe.yourConnectionToThisOriginIsNot)}else{const z=this.element.createChild("div","origin-view-section"),N=z.createChild("div","origin-view-section-title");N.textContent=Te(xe.noSecurityInformation),n.ARIAUtils.markAsHeading(N,2),z.createChild("div").textContent=Te(xe.noSecurityDetailsAreAvailableFor)}}createSanDiv(e){const t=document.createElement("div");if(0===e.length)t.textContent=Te(xe.na),t.classList.add("empty-san");else{const i=2,s=e.length>i+1;for(let r=0;r<e.length;r++){const o=t.createChild("span","san-entry");o.textContent=e[r],s&&r>=i&&o.classList.add("truncated-entry")}if(s){function a(){const i=t.classList.contains("truncated-san");let s;i?(t.classList.remove("truncated-san"),s=Te(xe.showLess)):(t.classList.add("truncated-san"),s=Te(xe.showMoreSTotal,{PH1:e.length})),c.textContent=s,n.ARIAUtils.setLabel(c,s),n.ARIAUtils.setExpanded(c,i)}const c=n.UIUtils.createTextButton(Te(xe.showMoreSTotal,{PH1:e.length}),a,{jslogContext:"security.toggle-san-truncation"});t.appendChild(c),a()}}return t}setSecurityState(e){this.originLockIcon.removeChildren();const t=Me(e,`security-property security-property-${e}`);this.originLockIcon.appendChild(t)}}class Oe{#I;constructor(){this.#I=document.createElement("table"),this.#I.classList.add("details-table")}element(){return this.#I}addRow(e,t){const i=this.#I.createChild("tr","details-table-row");i.createChild("td").textContent=e;const s=i.createChild("td");"string"==typeof t?s.textContent=t:s.appendChild(t)}}var ze=Object.freeze({__proto__:null,get OriginGroup(){return $e},SecurityDetailsTable:Oe,SecurityMainView:Fe,SecurityOriginView:Ve,SecurityPanel:He,SecurityRevealer:class{async reveal(){await n.ViewManager.ViewManager.instance().showView("security");const e=n.ViewManager.ViewManager.instance().view("security");if(e){const t=await e.widget();if(!(t instanceof He&&t.sidebar.cookieReportTreeElement))throw new Error("Expected securityPanel to be an instance of SecurityPanel with a cookieReportTreeElement in the sidebar");t.sidebar.cookieReportTreeElement.select(!1,!0)}}},createHighlightedUrl:De,getSecurityStateIconForDetailedView:Me,getSecurityStateIconForOverview:Le});export{I as CookieControlsView,F as CookieReportView,_ as IPProtectionView,ae as SecurityModel,ze as SecurityPanel};
//# sourceMappingURL=security.js.map
