import * as Common from '../../core/common/common.js';
import type * as NetworkTimeCalculator from '../../models/network_time_calculator/network_time_calculator.js';
import * as DataGrid from '../../ui/legacy/components/data_grid/data_grid.js';
import { type NetworkNode } from './NetworkDataGridNode.js';
import type { NetworkLogView } from './NetworkLogView.js';
export declare class NetworkLogViewColumns {
    #private;
    private networkLogView;
    private readonly persistentSettings;
    private readonly networkLogLargeRowsSetting;
    private readonly eventDividers;
    private eventDividersShown;
    private gridMode;
    private columns;
    private waterfallRequestsAreStale;
    private waterfallScrollerWidthIsStale;
    private readonly popupLinkifier;
    private calculatorsMap;
    private lastWheelTime;
    private splitWidget;
    private waterfallColumn;
    private activeScroller;
    private dataGridScroller;
    private waterfallScroller;
    private waterfallScrollerContent;
    private waterfallHeaderElement;
    private waterfallColumnSortIcon;
    private activeWaterfallSortId;
    private popoverHelper?;
    private hasScrollerTouchStarted?;
    private scrollerTouchStartPos?;
    constructor(networkLogView: NetworkLogView, timeCalculator: NetworkTimeCalculator.NetworkTransferTimeCalculator, durationCalculator: NetworkTimeCalculator.NetworkTransferDurationCalculator, networkLogLargeRowsSetting: Common.Settings.Setting<boolean>);
    private static convertToDataGridDescriptor;
    wasShown(): void;
    willHide(): void;
    reset(): void;
    private setupDataGrid;
    private setupWaterfall;
    private onMouseWheel;
    private onTouchStart;
    private onTouchMove;
    private onTouchEnd;
    private syncScrollers;
    private updateScrollerWidthIfNeeded;
    private redrawWaterfallColumn;
    private createWaterfallHeader;
    setCalculator(x: NetworkTimeCalculator.NetworkTimeCalculator): void;
    scheduleRefresh(): void;
    private updateRowsSize;
    show(element: Element): void;
    setHidden(value: boolean): void;
    dataGrid(): DataGrid.SortableDataGrid.SortableDataGrid<NetworkNode>;
    sortByCurrentColumn(): void;
    filterChanged(): void;
    private sortHandler;
    private dataGridSortedForTest;
    private updateColumns;
    switchViewMode(gridMode: boolean): void;
    private toggleColumnVisibility;
    private setWaterfallVisibility;
    private saveColumnsSettings;
    private loadCustomColumnsAndSettings;
    private makeHeaderFragment;
    private manageRequestCustomHeaderDialog;
    private manageResponseCustomHeaderDialog;
    private removeCustomHeader;
    private addCustomHeader;
    private changeCustomHeader;
    private getPopoverRequest;
    addEventDividers(times: number[], className: string): void;
    hideEventDividers(): void;
    showEventDividers(): void;
    selectFilmStripFrame(time: number): void;
    clearFilmStripFrame(): void;
}
export interface Descriptor {
    id: string;
    title: string | (() => string);
    titleDOMFragment?: DocumentFragment;
    subtitle: string | (() => string) | null;
    visible: boolean;
    weight: number;
    hideable: boolean;
    hideableGroup: string | null;
    nonSelectable: boolean;
    sortable: boolean;
    align?: string | null;
    isResponseHeader: boolean;
    isRequestHeader: boolean;
    sortingFunction: (arg0: NetworkNode, arg1: NetworkNode) => number | undefined;
    isCustomHeader: boolean;
    allowInSortByEvenWhenHidden: boolean;
}
