import*as t from"../../core/i18n/i18n.js";import*as e from"../../core/sdk/sdk.js";import*as n from"../../core/common/common.js";import*as i from"../../core/host/host.js";import*as o from"../../ui/components/icon_button/icon_button.js";import*as r from"../../ui/legacy/legacy.js";import*as s from"../../ui/visual_logging/visual_logging.js";import*as a from"../../core/platform/platform.js";import*as l from"../../ui/lit/lit.js";import"../../ui/components/cards/cards.js";import*as c from"../../ui/components/buttons/buttons.js";const d={noThrottling:"No CPU and no network throttling",noInternetConnectivity:"No internet connectivity",lowTierMobile:"Low-tier mobile",slowGXCpuSlowdown:"Slow 3G & 6x CPU slowdown",slowGXCpuSlowdownCalibrated:"Slow 3G & {PH1}x CPU slowdown",midtierMobile:"Mid-tier mobile",fastGXCpuSlowdown:"Fast 3G & 4x CPU slowdown",fastGXCpuSlowdownCalibrated:"Fast 3G & {PH1}x CPU slowdown",custom:"Custom",checkNetworkAndPerformancePanels:"Check Network and Performance panels"},g=t.i18n.registerUIStrings("panels/mobile_throttling/ThrottlingPresets.ts",d),u=t.i18n.getLocalizedString.bind(void 0,g);class h{static getNoThrottlingConditions(){return{title:"function"==typeof e.NetworkManager.NoThrottlingConditions.title?e.NetworkManager.NoThrottlingConditions.title():e.NetworkManager.NoThrottlingConditions.title,description:u(d.noThrottling),network:e.NetworkManager.NoThrottlingConditions,cpuThrottlingOption:e.CPUThrottlingManager.NoThrottlingOption,jslogContext:"no-throttling"}}static getOfflineConditions(){return{title:"function"==typeof e.NetworkManager.OfflineConditions.title?e.NetworkManager.OfflineConditions.title():e.NetworkManager.OfflineConditions.title,description:u(d.noInternetConnectivity),network:e.NetworkManager.OfflineConditions,cpuThrottlingOption:e.CPUThrottlingManager.NoThrottlingOption,jslogContext:"offline"}}static getLowEndMobileConditions(){const t=0!==e.CPUThrottlingManager.CalibratedLowTierMobileThrottlingOption.rate(),n=t?e.CPUThrottlingManager.CalibratedLowTierMobileThrottlingOption:e.CPUThrottlingManager.LowTierThrottlingOption,i=t?u(d.slowGXCpuSlowdownCalibrated,{PH1:n.rate()}):u(d.slowGXCpuSlowdown);return{title:u(d.lowTierMobile),description:i,network:e.NetworkManager.Slow3GConditions,cpuThrottlingOption:n,jslogContext:"low-end-mobile"}}static getMidTierMobileConditions(){const t=0!==e.CPUThrottlingManager.CalibratedMidTierMobileThrottlingOption.rate(),n=t?e.CPUThrottlingManager.CalibratedMidTierMobileThrottlingOption:e.CPUThrottlingManager.MidTierThrottlingOption,i=t?u(d.fastGXCpuSlowdownCalibrated,{PH1:n.rate()}):u(d.fastGXCpuSlowdown);return{title:u(d.midtierMobile),description:i,network:e.NetworkManager.Slow4GConditions,cpuThrottlingOption:n,jslogContext:"mid-tier-mobile"}}static getCustomConditions(){return{title:u(d.custom),description:u(d.checkNetworkAndPerformancePanels),jslogContext:"custom"}}static getMobilePresets(){return[h.getMidTierMobileConditions(),h.getLowEndMobileConditions(),h.getCustomConditions()]}static getAdvancedMobilePresets(){return[h.getOfflineConditions()]}static networkPresets=[e.NetworkManager.Fast4GConditions,e.NetworkManager.Slow4GConditions,e.NetworkManager.Slow3GConditions,e.NetworkManager.OfflineConditions];static cpuThrottlingPresets=[e.CPUThrottlingManager.NoThrottlingOption,e.CPUThrottlingManager.MidTierThrottlingOption,e.CPUThrottlingManager.LowTierThrottlingOption,e.CPUThrottlingManager.ExtraSlowThrottlingOption,e.CPUThrottlingManager.CalibratedLowTierMobileThrottlingOption,e.CPUThrottlingManager.CalibratedMidTierMobileThrottlingOption]}globalThis.MobileThrottling=globalThis.MobileThrottling||{},globalThis.MobileThrottling.networkPresets=h.networkPresets;var p=Object.freeze({__proto__:null,ThrottlingPresets:h});const w={offline:"Offline",forceDisconnectedFromNetwork:"Force disconnected from network",throttling:"Throttling",cpuThrottlingIsEnabled:"CPU throttling is enabled",cpuThrottling:"CPU throttling",excessConcurrency:"Exceeding the default value may degrade system performance.",resetConcurrency:"Reset to the default value",hardwareConcurrency:"Hardware concurrency",hardwareConcurrencySettingLabel:"Override the value reported by navigator.hardwareConcurrency",recommendedThrottling:"{PH1} – recommended",calibrate:"Calibrate…",recalibrate:"Recalibrate…",noSaveDataOverride:"'Save-Data': default",saveDataOn:"'Save-Data': on",saveDataOff:"'Save-Data': off",saveDataSettingTooltip:"Override the value reported by navigator.connection.saveData on the page"},C=t.i18n.registerUIStrings("panels/mobile_throttling/ThrottlingManager.ts",w),m=t.i18n.getLocalizedString.bind(void 0,C);let b;class k{#t=Promise.resolve();push(t){return new Promise(e=>{this.#t=this.#t.then(async()=>e(await t))})}}class v extends n.ObjectWrapper.ObjectWrapper{cpuThrottlingControls;cpuThrottlingOptions;customNetworkConditionsSetting;currentNetworkThrottlingConditionKeySetting;calibratedCpuThrottlingSetting;lastNetworkThrottlingConditions;cpuThrottlingManager;#e=!1;#n=new k;get hardwareConcurrencyOverrideEnabled(){return this.#e}constructor(){super(),this.cpuThrottlingManager=e.CPUThrottlingManager.CPUThrottlingManager.instance(),this.cpuThrottlingManager.addEventListener("RateChanged",t=>this.onCPUThrottlingRateChangedOnSDK(t.data)),this.cpuThrottlingControls=new Set,this.cpuThrottlingOptions=h.cpuThrottlingPresets,this.customNetworkConditionsSetting=e.NetworkManager.customUserNetworkConditionsSetting(),this.currentNetworkThrottlingConditionKeySetting=e.NetworkManager.activeNetworkThrottlingKeySetting(),this.calibratedCpuThrottlingSetting=n.Settings.Settings.instance().createSetting("calibrated-cpu-throttling",{},"Global"),e.NetworkManager.MultitargetNetworkManager.instance().addEventListener("ConditionsChanged",()=>{this.lastNetworkThrottlingConditions=this.#i();const t=e.NetworkManager.MultitargetNetworkManager.instance().networkConditions();this.currentNetworkThrottlingConditionKeySetting.set(t.key)}),this.isDirty()&&e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(this.#i())}#i(){const t=this.currentNetworkThrottlingConditionKeySetting.get(),n=e.NetworkManager.getPredefinedCondition(t);if(n)return n;return this.customNetworkConditionsSetting.get().find(e=>e.key===t)??e.NetworkManager.NoThrottlingConditions}static instance(t={forceNew:null}){const{forceNew:e}=t;return b&&!e||(b=new v),b}createOfflineToolbarCheckbox(){const t=new r.Toolbar.ToolbarCheckbox(m(w.offline),m(w.forceDisconnectedFromNetwork),function(){if(t.checked())e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(e.NetworkManager.OfflineConditions);else{const t=this.lastNetworkThrottlingConditions.download||this.lastNetworkThrottlingConditions.upload?this.lastNetworkThrottlingConditions:e.NetworkManager.NoThrottlingConditions;e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(t)}}.bind(this));return t.element.setAttribute("jslog",`${s.toggle("disconnect-from-network").track({click:!0})}`),e.NetworkManager.MultitargetNetworkManager.instance().addEventListener("ConditionsChanged",function(){t.setChecked(e.NetworkManager.MultitargetNetworkManager.instance().isOffline())}),t.setChecked(e.NetworkManager.MultitargetNetworkManager.instance().isOffline()),t}createMobileThrottlingButton(){const t=new r.Toolbar.ToolbarMenuButton(function(t){for(let o=0;o<e.length;++o){const r=e[o];r&&(r.title===h.getCustomConditions().title&&r.description===h.getCustomConditions().description||t.defaultSection().appendCheckboxItem(r.title,i.optionSelected.bind(i,r),{checked:n===o,jslogContext:r.jslogContext}))}},void 0,void 0,"mobile-throttling");t.setTitle(m(w.throttling)),t.setDarkText();let e=[],n=-1;const i=new N(function(t){e=[];for(const n of t){for(const t of n.items)e.push(t);e.push(null)}return e},function(i){n=i;const o=e[i];o&&(t.setText(o.title),t.setTitle(`${o.title}: ${o.description}`))});return t}updatePanelIcon(){const t=[];this.cpuThrottlingManager.cpuThrottlingRate()!==e.CPUThrottlingManager.CPUThrottlingRates.NO_THROTTLING&&t.push(m(w.cpuThrottlingIsEnabled)),r.InspectorView.InspectorView.instance().setPanelWarnings("timeline",t)}setCPUThrottlingOption(t){this.cpuThrottlingManager.setCPUThrottlingOption(t)}onCPUThrottlingRateChangedOnSDK(t){t!==e.CPUThrottlingManager.CPUThrottlingRates.NO_THROTTLING&&i.userMetrics.actionTaken(i.UserMetrics.Action.CpuThrottlingEnabled);const n=this.cpuThrottlingOptions.indexOf(this.cpuThrottlingManager.cpuThrottlingOption());for(const t of this.cpuThrottlingControls)t.setSelectedIndex(n);this.updatePanelIcon()}createCPUThrottlingSelector(){const t=()=>{const t=this.calibratedCpuThrottlingSetting.get(),e=t.low||t.mid;return m(e?w.recalibrate:w.calibrate)},e=new r.Toolbar.ToolbarComboBox(()=>{if(e.selectedIndex()===e.options().length-1){const t=this.cpuThrottlingOptions.indexOf(this.cpuThrottlingManager.cpuThrottlingOption());e.setSelectedIndex(t),n.Revealer.reveal(this.calibratedCpuThrottlingSetting)}else this.setCPUThrottlingOption(this.cpuThrottlingOptions[e.selectedIndex()])},m(w.cpuThrottling),"","cpu-throttling");this.cpuThrottlingControls.add(e);const i=this.cpuThrottlingManager.cpuThrottlingOption(),o=[],s=this.cpuThrottlingOptions;for(let t=0;t<this.cpuThrottlingOptions.length;++t){const n=this.cpuThrottlingOptions[t],r=n.title(),s=n.jslogContext,a=e.createOption(r,s);e.addOption(a),i===n&&e.setSelectedIndex(t),o.push(a)}const a=e.createOption(t(),"");return e.addOption(a),o.push(a),{control:e,updateRecommendedOption(e){for(let t=0;t<o.length-1;t++){const n=s[t];o[t].text=n===e?m(w.recommendedThrottling,{PH1:n.title()}):n.title(),o[t].disabled=0===n.rate()}o[o.length-1].textContent=t()}}}createSaveDataOverrideSelector(t){const n=new Option(m(w.noSaveDataOverride),void 0,!0,!0),i=new Option(m(w.saveDataOn)),o=new Option(m(w.saveDataOff)),s=new r.Toolbar.ToolbarComboBox(t=>{const r=t.target;switch(r.selectedOptions.item(0)){case n:for(const t of e.TargetManager.TargetManager.instance().models(e.EmulationModel.EmulationModel))this.#n.push(t.setDataSaverOverride("unset"));break;case i:for(const t of e.TargetManager.TargetManager.instance().models(e.EmulationModel.EmulationModel))this.#n.push(t.setDataSaverOverride("enabled"));break;case o:for(const t of e.TargetManager.TargetManager.instance().models(e.EmulationModel.EmulationModel))this.#n.push(t.setDataSaverOverride("disabled"))}this.dispatchEventToListeners("SaveDataOverrideChanged",r.selectedIndex)},m(w.saveDataSettingTooltip),t);return s.addOption(n),s.addOption(i),s.addOption(o),this.addEventListener("SaveDataOverrideChanged",({data:t})=>s.setSelectedIndex(t)),s}createHardwareConcurrencySelector(){const t=new r.Toolbar.ToolbarItem(r.UIUtils.createInput("devtools-text-input","number","hardware-concurrency"));t.setTitle(m(w.hardwareConcurrencySettingLabel));const e=t.element;e.min="1",t.setEnabled(!1);const n=r.UIUtils.CheckboxLabel.create(m(w.hardwareConcurrency),!1,m(w.hardwareConcurrencySettingLabel),"hardware-concurrency"),i=new r.Toolbar.ToolbarButton("Reset concurrency","undo",void 0,"hardware-concurrency-reset");i.setTitle(m(w.resetConcurrency));const s=new o.Icon.Icon;s.name="warning-filled",s.classList.add("small");const a=new r.Toolbar.ToolbarItem(s);return a.setTitle(m(w.excessConcurrency)),n.disabled=!0,i.element.classList.add("concurrency-hidden"),a.element.classList.add("concurrency-hidden"),this.cpuThrottlingManager.getHardwareConcurrency().then(o=>{if(void 0===o)return;const r=t=>{t>=1&&this.cpuThrottlingManager.setHardwareConcurrency(t),t>o?a.element.classList.remove("concurrency-hidden"):a.element.classList.add("concurrency-hidden"),t===o?i.element.classList.add("concurrency-hidden"):i.element.classList.remove("concurrency-hidden")};e.value=`${o}`,e.oninput=()=>r(Number(e.value)),n.disabled=!1,n.addEventListener("change",()=>{this.#e=n.checked,t.setEnabled(this.hardwareConcurrencyOverrideEnabled),r(this.hardwareConcurrencyOverrideEnabled?Number(e.value):o)}),i.addEventListener("Click",()=>{e.value=`${o}`,r(o)})}),{numericInput:t,reset:i,warning:a,checkbox:n}}setHardwareConcurrency(t){this.cpuThrottlingManager.setHardwareConcurrency(t)}isDirty(){const t=e.NetworkManager.MultitargetNetworkManager.instance().networkConditions(),n=this.#i();return!e.NetworkManager.networkConditionsEqual(t,n)}}function T(){return v.instance()}var f=Object.freeze({__proto__:null,ActionDelegate:class{handleAction(t,n){return"network-conditions.network-online"===n?(e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(e.NetworkManager.NoThrottlingConditions),!0):"network-conditions.network-low-end-mobile"===n?(e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(e.NetworkManager.Slow3GConditions),!0):"network-conditions.network-mid-tier-mobile"===n?(e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(e.NetworkManager.Slow4GConditions),!0):"network-conditions.network-offline"===n&&(e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(e.NetworkManager.OfflineConditions),!0)}},ThrottlingManager:v,throttlingManager:T});const M={disabled:"Disabled",presets:"Presets",advanced:"Advanced"},y=t.i18n.registerUIStrings("panels/mobile_throttling/MobileThrottlingSelector.ts",M),x=t.i18n.getLocalizedString.bind(void 0,y);class N{populateCallback;selectCallback;options;constructor(t,n){this.populateCallback=t,this.selectCallback=n,e.CPUThrottlingManager.CPUThrottlingManager.instance().addEventListener("RateChanged",this.conditionsChanged,this),e.NetworkManager.MultitargetNetworkManager.instance().addEventListener("ConditionsChanged",this.conditionsChanged,this),this.options=this.populateOptions(),this.conditionsChanged()}optionSelected(t){e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(t.network),T().setCPUThrottlingOption(t.cpuThrottlingOption)}populateOptions(){const t={title:x(M.disabled),items:[h.getNoThrottlingConditions()]},e={title:x(M.presets),items:h.getMobilePresets()},n={title:x(M.advanced),items:h.getAdvancedMobilePresets()};return this.populateCallback([t,e,n])}conditionsChanged(){this.populateOptions();const t=e.NetworkManager.MultitargetNetworkManager.instance().networkConditions(),n=e.CPUThrottlingManager.CPUThrottlingManager.instance().cpuThrottlingOption();for(let e=0;e<this.options.length;++e){const i=this.options[e];if(i&&"network"in i&&i.network===t&&i.cpuThrottlingOption===n)return void this.selectCallback(e)}const i=h.getCustomConditions();for(let t=0;t<this.options.length;++t){const e=this.options[t];if(e&&e.title===i.title&&e.description===i.description)return void this.selectCallback(t)}}}var S=Object.freeze({__proto__:null,MobileThrottlingSelector:N});const P={networkThrottlingIsEnabled:"Network throttling is enabled",requestsMayBeOverridden:"Requests may be overridden locally, see the Sources panel",requestsMayBeBlocked:"Requests may be blocked, see the Network request blocking panel",acceptedEncodingOverrideSet:"The set of accepted `Content-Encoding` headers has been modified by DevTools, see the Network conditions panel"},O=t.i18n.registerUIStrings("panels/mobile_throttling/NetworkPanelIndicator.ts",P),E=t.i18n.getLocalizedString.bind(void 0,O);var U=Object.freeze({__proto__:null,NetworkPanelIndicator:class{constructor(){if(!r.InspectorView.InspectorView.instance().hasPanel("network"))return;const t=e.NetworkManager.MultitargetNetworkManager.instance();function i(){const n=[];t.isThrottling()&&n.push(E(P.networkThrottlingIsEnabled)),e.NetworkManager.MultitargetNetworkManager.instance().isIntercepting()&&n.push(E(P.requestsMayBeOverridden)),t.isBlocking()&&n.push(E(P.requestsMayBeBlocked)),t.isAcceptedEncodingOverrideSet()&&n.push(E(P.acceptedEncodingOverrideSet)),r.InspectorView.InspectorView.instance().setPanelWarnings("network",n)}t.addEventListener("ConditionsChanged",i),t.addEventListener("BlockedPatternsChanged",i),t.addEventListener("InterceptorsChanged",i),t.addEventListener("AcceptedEncodingsChanged",i),n.Settings.Settings.instance().moduleSetting("cache-disabled").addChangeListener(i,this),i()}}});const{render:L,html:I,Directives:B,nothing:D}=l,H={disabled:"Disabled",presets:"Presets",custom:"Custom",blockingGroup:"Blocking",sS:"{PH1}: {PH2}",addS:"Add {PH1}",add:"Add…",recommendedThrottling:"{PH1} – recommended"},_=t.i18n.registerUIStrings("panels/mobile_throttling/NetworkThrottlingSelector.ts",H),j=t.i18n.getLocalizedString.bind(void 0,_),G=(t,n,i)=>{const o=t=>"function"==typeof t.title?t.title():t.title,r=new WeakMap;let l=t.selectedConditions;L(I`<select
      aria-label=${t.title??D}
      jslog=${s.dropDown().track({change:!0}).context(t.jslogContext)}
      @change=${function(e){const n=e.target;if(!n)return;const i=n.selectedOptions[0];if(i)if(i===n.options[n.options.length-1])t.onAddCustomConditions(),e.consume(!0),l&&(n.value=o(l));else{const e=r.get(i);e&&(l=e,t.onSelect(e))}}}>
          ${t.throttlingGroups.map(n=>I`<optgroup
            label=${n.title}>
            ${n.items.map(i=>I`<option
              ${B.ref(t=>t&&r.set(t,i))}
              ?selected=${l?e.NetworkManager.networkConditionsEqual(i,l):n===t.throttlingGroups[0]}
              value=${o(i)}
              aria-label=${j(H.sS,{PH1:n.title,PH2:o(i)})}
              jslog=${((t,e)=>`${s.item(a.StringUtilities.toKebabCase("i18nTitleKey"in e&&e.i18nTitleKey||o(e))).track({click:!0})}`)(0,i)}>
                ${i===t.recommendedConditions?j(H.recommendedThrottling,{PH1:o(i)}):o(i)}
            </option>`)}
        </optgroup>`)}
        <optgroup label=${t.customConditionsGroup.title}>
          ${t.customConditionsGroup.items.map(n=>I`<option
              ${B.ref(t=>t&&r.set(t,n))}
              ?selected=${l&&e.NetworkManager.networkConditionsEqual(n,l)}
              value=${o(n)}
              aria-label=${j(H.sS,{PH1:t.customConditionsGroup.title,PH2:o(n)})}
              jslog=${s.item("custom-network-throttling-item").track({click:!0})}>
                ${n===t.recommendedConditions?j(H.recommendedThrottling,{PH1:o(n)}):o(n)}
          </option>`)}
          <option
            value=${j(H.add)}
            aria-label=${j(H.addS,{PH1:t.customConditionsGroup.title})}
            jslog=${s.action("add").track({click:!0})}>
              ${j(H.add)}
          </option>
        </optgroup>
      </select>`,i)};class R extends n.ObjectWrapper.ObjectWrapper{#o=null;#r;#s;#a;#l;#c;#d="global-conditions";static createForGlobalConditions(t,n){v.instance();const i=new R(t,{title:n,jslogContext:e.NetworkManager.activeNetworkThrottlingKeySetting().name,currentConditions:e.NetworkManager.MultitargetNetworkManager.instance().networkConditions()});return i.addEventListener("conditionsChanged",t=>!("block"in t.data)&&e.NetworkManager.MultitargetNetworkManager.instance().setNetworkConditions(t.data)),e.NetworkManager.MultitargetNetworkManager.instance().addEventListener("ConditionsChanged",()=>{i.currentConditions=e.NetworkManager.MultitargetNetworkManager.instance().networkConditions()}),i}constructor(t,n={},i=G){super(),e.NetworkManager.customUserNetworkConditionsSetting().addChangeListener(this.#g,this),this.#r=t,this.#s=n.jslogContext,this.#a=n.currentConditions,this.#l=n.title,this.#c=i,this.#g()}get recommendedConditions(){return this.#o}set recommendedConditions(t){this.#o=t,this.#g()}get currentConditions(){return this.#a}set currentConditions(t){this.#a=t,this.#g()}get jslogContext(){return this.#s}set jslogContext(t){this.#s=t,this.#g()}get variant(){return this.#d}set variant(t){this.#d=t,this.#g()}#g(){const t=e.NetworkManager.customUserNetworkConditionsSetting().get(),i=[];switch(this.#d){case"global-conditions":i.push({title:j(H.disabled),items:[e.NetworkManager.NoThrottlingConditions]},{title:j(H.presets),items:[e.NetworkManager.Fast4GConditions,e.NetworkManager.Slow4GConditions,e.NetworkManager.Slow3GConditions,e.NetworkManager.OfflineConditions]});break;case"individual-request-conditions":i.push({title:j(H.blockingGroup),items:[e.NetworkManager.BlockingConditions]},{title:j(H.presets),items:[e.NetworkManager.Fast4GConditions,e.NetworkManager.Slow4GConditions,e.NetworkManager.Slow3GConditions]})}const o={title:j(H.custom),items:t},r={recommendedConditions:this.#o,selectedConditions:this.#a,jslogContext:this.#s,title:this.#l,onSelect:t=>{this.dispatchEventToListeners("conditionsChanged",t)},onAddCustomConditions:()=>{n.Revealer.reveal(e.NetworkManager.customUserNetworkConditionsSetting())},throttlingGroups:i,customConditionsGroup:o};this.#c(r,{},this.#r)}}class $ extends r.Widget.VBox{#u;#h;constructor(t,e=G){super(t,{useShadowDom:!0}),this.#u=new R(this.contentElement,{},e),this.#u.addEventListener("conditionsChanged",({data:t})=>this.#h?.(t))}set variant(t){this.#u.variant=t}set jslogContext(t){this.#u.jslogContext=t}set currentConditions(t){this.#u.currentConditions=t}set onConditionsChanged(t){this.#h=t}}var A=Object.freeze({__proto__:null,DEFAULT_VIEW:G,NetworkThrottlingSelect:R,NetworkThrottlingSelectorWidget:$});const W={runningCalibration:"Running CPU calibration, please do not leave this tab or close DevTools."},z=t.i18n.registerUIStrings("panels/mobile_throttling/CalibrationController.ts",W),q=t.i18n.getLocalizedString.bind(void 0,z),Q=1e3,F=264;function K(t){return Number(t.toFixed(2))}class V{#p;#w;#C;#m;#b="idle";async start(){const t=e.TargetManager.TargetManager.instance().primaryPageTarget();if(!t)return!1;const n=t.model(e.RuntimeModel.RuntimeModel),i=t.model(e.EmulationModel.EmulationModel);if(!n||!i)return!1;return this.#b="running",this.#p=n,this.#w=i,this.#C=t.inspectedURL(),await t.pageAgent().invoke_navigate({url:"about:blank"}),await n.agent.invoke_evaluate({expression:`\n          (${function(t){const e=document.createElement("span");e.textContent=t,document.body.append(e),document.body.style.cssText="\n        font-family: system-ui, sans-serif;\n        height: 100vh;\n        margin: 0;\n        background-color: antiquewhite;\n        font-size: 18px;\n        text-align: center;\n\n        display: flex;\n        flex-direction: column;\n        align-items: center;\n        justify-content: center;\n      ";const n=document.createElement("span");document.body.append(n),n.id="moon",n.textContent="🌑",n.style.cssText="font-size: 5em"}})(${JSON.stringify(q(W.runningCalibration))});\n\n          window.runBenchmark = () => {\n            window.runs = window.runs ?? 0;\n            moon.textContent = ['🌑', '🌒', '🌓', '🌔', '🌕', '🌖', '🌗', '🌘'][window.runs++ % 8];\n            return (${X})(250);\n          }`}),await this.#k(),!0}async#v(t){if("running"!==this.#b)throw this.#m=void 0,new Error("Calibration has been canceled");await this.#w.setCPUThrottlingRate(t)}async#k(){if("running"!==this.#b)throw this.#m=void 0,new Error("Calibration has been canceled");const{result:t}=await this.#p.agent.invoke_evaluate({expression:"runBenchmark()"});if(!Number.isFinite(t.value)){let e=`unexpected score from benchmark: ${t.value}`;throw t.description&&(e+=`\n${t.description}`),new Error(e)}return t.value}async*iterator(){const t=this;let n=!1;yield{progress:0};const i=new Map;async function o(e){const n=i.get(e);if(void 0!==n)return n;await t.#v(e);const o=await t.#k();return i.set(e,o),o}async function*r(t,e,i){const r={rate:e,score:await o(e)},s={rate:i,score:await o(i)};let a=0,l=0;for(;l++<8;){a=K((s.rate+r.rate)/2);const e=await o(a);if(Math.abs(t-e)<10)break;e<t?(s.rate=a,s.score=e):(r.rate=a,r.score=e),yield{progress:l/8/2+(n?.5:0)}}return K(a)}this.#m={};let s=await o(1);if(s<Q&&(i.clear(),s=await o(1),s<Q)){if(s<F)return void(this.#m={low:e.CPUThrottlingManager.CalibrationError.DEVICE_TOO_WEAK,mid:e.CPUThrottlingManager.CalibrationError.DEVICE_TOO_WEAK});this.#m={mid:e.CPUThrottlingManager.CalibrationError.DEVICE_TOO_WEAK},n=!0}const a=s/F*1.5,l=yield*r(F,1,a);if(this.#m.low=l,!this.#m.mid){n=!0,yield{progress:.5};const t=l/3.787878787878788,e=yield*r(Q,t-t/4,t+t/4);this.#m.mid=e}yield{progress:1}}abort(){"running"===this.#b&&(this.#b="aborting")}result(){return this.#m}async end(){"idle"!==this.#b&&(this.#b="idle",this.#C.startsWith("chrome://")?await this.#p.agent.invoke_evaluate({expression:"history.back()"}):await this.#p.agent.invoke_evaluate({expression:`window.location.href = ${JSON.stringify(this.#C)}`}))}}function X(t=1e3){const e=t/2;return(function(){const t=Date.now();let n=0;for(;Date.now()-t<e;){let t="";for(let e=0;e<1e4;e++)t+="a";if(1===t.length)throw new Error("will never happen, but prevents compiler optimizations");n++}const i=(Date.now()-t)/1e3;return Math.round(n/10/i)}()+function(){const t=[],n=[];for(let e=0;e<1e5;e++)t[e]=n[e]=e;const i=Date.now();let o=0;for(;o%10!=0||Date.now()-i<e;){const e=o%2==0?t:n,i=o%2==0?n:t;for(let t=0;t<e.length;t++)i[t]=e[t];o++}const r=(Date.now()-i)/1e3;return Math.round(o/10/r)}())/2}var J=`.add-conditions-button{margin:var(--sys-size-5) 0;border:none}.conditions-list{flex:auto;&:has(.list-item){margin-top:var(--sys-size-3)}}.settings-container{display:flex;overflow-x:auto}.settings-container::-webkit-scrollbar{-webkit-appearance:none;height:var(--sys-size-4)}.settings-container::-webkit-scrollbar-thumb{border-radius:var( --sys-size-3);background-color:var(--sys-color-primary)}.setting{display:flex;flex-direction:column;justify-content:space-between;align-items:flex-start;gap:var( --sys-size-3);padding:var( --sys-size-4);flex-shrink:0;width:74px}.input{width:100%}.conditions-list-item{padding:3px 5px;height:30px;display:flex;align-items:center;position:relative;flex:auto 1 1}.conditions-list-text{white-space:nowrap;text-overflow:ellipsis;overflow:hidden;flex-basis:var( --sys-size-24);user-select:none;color:var(--sys-color-on-surface);text-align:center;position:relative;& > input{scroll-margin-left:5px}}.conditions-list-text:last-child{flex-basis:100px;text-align:left}.conditions-list-title{text-align:start;display:flex;flex-grow:1;align-items:flex-start}.conditions-list-title-text{flex:auto;text-overflow:ellipsis;overflow:hidden;white-space:nowrap}.conditions-list-separator{flex:0 0 1px;background-color:var(--sys-color-divider);height:30px;margin:0 4px}.conditions-list-separator-invisible{visibility:hidden;height:100%!important}.settings-card-container-wrapper{scrollbar-gutter:stable;padding:var(--sys-size-8) 0;overflow:auto;position:absolute;inset:var(--sys-size-8) 0 0}.settings-card-container{display:flex;flex-direction:column;align-items:center;gap:var(--sys-size-9)}.cpu-preset-section{padding:14px;display:flex;justify-content:space-between}.cpu-preset-result.not-calibrated{font-style:italic}.cpu-preset-calibrate{flex-direction:column;gap:14px}.cpu-preset-calibrate .button-container{display:flex;gap:10px}.cpu-preset-calibrate .text-container{display:flex;flex-direction:column;gap:10px}.text-with-icon{display:flex;align-items:center;gap:5px}\n/*# sourceURL=${import.meta.resolve("./throttlingSettingsTab.css")} */`;const Z={networkThrottlingProfiles:"Network throttling profiles",addCustomProfile:"Add profile",dms:"{PH1} `ms`",profileName:"Profile Name",download:"Download",upload:"Upload",latency:"Latency",packetLoss:"Packet Loss",packetQueueLength:"Packet Queue Length",packetReordering:"Packet Reordering",packet:"packet",optional:"optional",profileNameCharactersLengthMust:"Profile Name characters length must be between 1 to {PH1} inclusive",sMustBeANumberBetweenSkbsToSkbs:"{PH1} must be a number between {PH2} `kbit/s` to {PH3} `kbit/s` inclusive",latencyMustBeAnIntegerBetweenSms:"Latency must be an integer between {PH1} `ms` to {PH2} `ms` inclusive",packetLossMustBeAnIntegerBetweenSpct:"Packet Loss must be a number between {PH1} `%` to {PH2} `%` inclusive",packetQueueLengthMustBeAnIntegerGreaterOrEqualToZero:"Packet Queue Length must be greater or equal to 0",dskbits:"{PH1} `kbit/s`",fsmbits:"{PH1} `Mbit/s`",on:"On",off:"Off",cpuThrottlingPresets:"CPU throttling presets",calibrate:"Calibrate",recalibrate:"Recalibrate",continue:"Continue",cancel:"Cancel",needsCalibration:"Needs calibration",calibrationCTA:"To use the CPU throttling presets, run the calibration process to determine the ideal throttling rate for your device.",cpuCalibrationDescription:"These presets throttle your CPU to approximate the performance of typical low or mid-tier mobile devices.",calibrationConfirmationPrompt:"Calibration will take ~5 seconds, and temporarily navigate away from your current page. Do you wish to continue?",calibrationWarningHighCPU:"CPU utilization is too high",calibrationWarningRunningOnBattery:"Device is running on battery, please plug in charger for best results",calibrationWarningLowBattery:"Device battery is low (<20%), results may be impacted by CPU throttling",dSlowdown:"{PH1}× slowdown"},Y=t.i18n.registerUIStrings("panels/mobile_throttling/ThrottlingSettingsTab.ts",Z),tt=t.i18n.getLocalizedString.bind(void 0,Y);class et{element;setting;computePressurePromise;controller;lowTierMobileDeviceEl;midTierMobileDeviceEl;calibrateEl;textEl;calibrateButton;cancelButton;progress;state="cta";warnings=[];constructor(){this.setting=n.Settings.Settings.instance().createSetting("calibrated-cpu-throttling",{},"Global"),this.element=document.createElement("devtools-card"),this.element.heading=tt(Z.cpuThrottlingPresets);this.element.createChild("span").textContent=tt(Z.cpuCalibrationDescription),this.lowTierMobileDeviceEl=this.element.createChild("div","cpu-preset-section"),this.lowTierMobileDeviceEl.append("Low-tier mobile device"),this.lowTierMobileDeviceEl.createChild("div","cpu-preset-result"),this.midTierMobileDeviceEl=this.element.createChild("div","cpu-preset-section"),this.midTierMobileDeviceEl.append("Mid-tier mobile device"),this.midTierMobileDeviceEl.createChild("div","cpu-preset-result"),this.calibrateEl=this.element.createChild("div","cpu-preset-section cpu-preset-calibrate");const t=this.calibrateEl.createChild("div","button-container");this.calibrateButton=new c.Button.Button,this.calibrateButton.classList.add("calibrate-button"),this.calibrateButton.data={variant:"primary",jslogContext:"throttling.calibrate"},this.calibrateButton.addEventListener("click",()=>this.calibrateButtonClicked()),t.append(this.calibrateButton),this.cancelButton=new c.Button.Button,this.cancelButton.classList.add("cancel-button"),this.cancelButton.data={variant:"outlined",jslogContext:"throttling.calibrate-cancel"},this.cancelButton.textContent=tt(Z.cancel),this.cancelButton.addEventListener("click",()=>this.cancelButtonClicked()),t.append(this.cancelButton),this.textEl=this.calibrateEl.createChild("div","text-container"),this.progress=this.calibrateEl.createChild("devtools-progress"),this.progress.setAttribute("no-stop-button",""),this.updateState()}wasShown(){this.computePressurePromise=function(){const t={state:""};return new Promise(e=>{new PressureObserver(n=>{t.state=n.at(-1).state,e(t)}).observe("cpu",{sampleInterval:1e3})})}(),this.state="cta",this.updateState()}willHide(){this.computePressurePromise=void 0,this.controller&&this.controller.abort()}updateState(){"calibrating"!==this.state&&(this.controller=void 0);const t=this.setting.get(),n=t.low||t.mid;if(this.calibrateButton.style.display="none",this.textEl.style.display="none",this.cancelButton.style.display="none",this.progress.style.display="none","cta"===this.state)this.calibrateButton.style.display="",this.calibrateButton.textContent=tt(n?Z.recalibrate:Z.calibrate),n||(this.textEl.style.display="",this.textEl.textContent="",this.textEl.append(this.createTextWithIcon(tt(Z.calibrationCTA),"info")));else if("prompting"===this.state){this.calibrateButton.style.display="",this.calibrateButton.textContent=tt(Z.continue),this.cancelButton.style.display="",this.textEl.style.display="",this.textEl.textContent="";for(const t of this.warnings)this.textEl.append(this.createTextWithIcon(t,"warning"));this.textEl.append(this.createTextWithIcon(tt(Z.calibrationConfirmationPrompt),"info"))}else"calibrating"===this.state&&(this.cancelButton.style.display="",this.progress.style.display="");const i=(t,n)=>{if(!t)throw new Error("expected HTMLElement");t.textContent=(t=>void 0===t?tt(Z.needsCalibration):"string"==typeof t?e.CPUThrottlingManager.calibrationErrorToString(t):"number"!=typeof t?`Invalid: ${t}`:tt(Z.dSlowdown,{PH1:t.toFixed(1)}))(n),t.classList.toggle("not-calibrated",void 0===n)};i(this.lowTierMobileDeviceEl.querySelector(".cpu-preset-result"),t.low),i(this.midTierMobileDeviceEl.querySelector(".cpu-preset-result"),t.mid)}createTextWithIcon(t,e){const n=document.createElement("div");return n.classList.add("text-with-icon"),n.append(o.Icon.create(e)),n.append(t),n}async getCalibrationWarnings(){const t=[];if(this.computePressurePromise){const e=await this.computePressurePromise;"critical"!==e.state&&"serious"!==e.state||t.push(tt(Z.calibrationWarningHighCPU))}const e=await navigator.getBattery();return e.charging?e.level<.2&&t.push(tt(Z.calibrationWarningLowBattery)):t.push(tt(Z.calibrationWarningRunningOnBattery)),t}async calibrateButtonClicked(){"cta"===this.state?(this.warnings=await this.getCalibrationWarnings(),this.state="prompting",this.updateState()):"prompting"===this.state&&(this.state="calibrating",this.updateState(),this.runCalibration())}cancelButtonClicked(){this.controller?this.controller.abort():(this.state="cta",this.updateState())}async runCalibration(){this.progress.worked=0,this.progress.totalWork=1,this.controller=new V;try{if(!await this.controller.start())return void console.error("Calibration failed to start");for await(const t of this.controller.iterator())this.progress.worked=t.progress}catch(t){console.error(t)}finally{await this.controller.end()}const t=this.controller.result();t&&(t.low||t.mid)&&(this.setting.set(t),this.progress.worked=1,await new Promise(t=>setTimeout(t,200))),this.state="cta",this.updateState()}}class nt extends r.Widget.VBox{list;customUserConditions;editor;cpuThrottlingCard;#T;constructor(){super({jslog:`${s.pane("throttling-conditions")}`,useShadowDom:!0}),this.registerRequiredCSS(J);const t=this.contentElement.createChild("div","settings-card-container-wrapper").createChild("div");t.classList.add("settings-card-container","throttling-conditions-settings"),this.cpuThrottlingCard=new et,t.append(this.cpuThrottlingCard.element);const n=new c.Button.Button;n.classList.add("add-conditions-button"),n.data={variant:"outlined",iconName:"plus",jslogContext:"network.add-conditions"},n.textContent=tt(Z.addCustomProfile),n.addEventListener("click",()=>this.addButtonClicked());const i=t.createChild("devtools-card");i.heading=tt(Z.networkThrottlingProfiles);const o=i.createChild("div");this.list=new r.ListWidget.ListWidget(this),this.list.element.classList.add("conditions-list"),this.list.registerRequiredCSS(J),this.list.show(o),o.appendChild(n),this.customUserConditions=e.NetworkManager.customUserNetworkConditionsSetting(),this.customUserConditions.addChangeListener(this.conditionsUpdated,this);const a=this.customUserConditions.get().at(-1),l=a?.key;if(l&&e.NetworkManager.keyIsCustomUser(l)){const t=function(t){const e=t.match(/USER_CUSTOM_SETTING_(\d+)/);return e?.[1]?parseInt(e[1],10):0}(l);this.#T=t}else this.#T=0}wasShown(){super.wasShown(),this.cpuThrottlingCard.wasShown(),this.conditionsUpdated()}willHide(){super.willHide(),this.cpuThrottlingCard.willHide()}conditionsUpdated(){this.list.clear();const t=this.customUserConditions.get();for(let e=0;e<t.length;++e)this.list.appendItem(t[e],!0);this.list.appendSeparator()}addButtonClicked(){this.#T++,this.list.addNewItem(this.customUserConditions.get().length,{key:`USER_CUSTOM_SETTING_${this.#T}`,title:()=>"",download:-1,upload:-1,latency:0,packetLoss:0,packetReordering:!1})}renderItem(t,e){const n=document.createElement("div");n.classList.add("conditions-list-item");const i=n.createChild("div","conditions-list-text conditions-list-title").createChild("div","conditions-list-title-text"),o=this.retrieveOptionsTitle(t);return i.textContent=o,r.Tooltip.Tooltip.install(i,o),n.createChild("div","conditions-list-separator"),n.createChild("div","conditions-list-text").textContent=it(t.download),n.createChild("div","conditions-list-separator"),n.createChild("div","conditions-list-text").textContent=it(t.upload),n.createChild("div","conditions-list-separator"),n.createChild("div","conditions-list-text").textContent=tt(Z.dms,{PH1:t.latency}),n.createChild("div","conditions-list-separator"),n.createChild("div","conditions-list-text").textContent=function(t){if(t<0)return"";return String(t)+"%"}(t.packetLoss??0),n.createChild("div","conditions-list-separator"),n.createChild("div","conditions-list-text").textContent=String(t.packetQueueLength??0),n.createChild("div","conditions-list-separator"),n.createChild("div","conditions-list-text").textContent=t.packetReordering?tt(Z.on):tt(Z.off),n}removeItemRequested(t,e){const n=this.customUserConditions.get();n.splice(e,1),this.customUserConditions.set(n)}retrieveOptionsTitle(t){return"function"==typeof t.title?t.title():t.title}commitEdit(t,e,n){t.title=e.control("title").value.trim();const i=e.control("download").value.trim();t.download=i?125*parseInt(i,10):-1;const o=e.control("upload").value.trim();t.upload=o?125*parseInt(o,10):-1;const r=e.control("latency").value.trim();t.latency=r?parseInt(r,10):0;const s=e.control("packetLoss").value.trim();t.packetLoss=s?parseFloat(s):0;const a=e.control("packetQueueLength").value.trim();t.packetQueueLength=a?parseFloat(a):0;const l=e.control("packetReordering").checked;t.packetReordering=l;const c=this.customUserConditions.get();n&&c.push(t),this.customUserConditions.set(c)}beginEdit(t){const e=this.createEditor();return e.control("title").value=this.retrieveOptionsTitle(t),e.control("download").value=t.download<=0?"":String(t.download/125),e.control("upload").value=t.upload<=0?"":String(t.upload/125),e.control("latency").value=t.latency?String(t.latency):"",e.control("packetLoss").value=t.packetLoss?String(t.packetLoss):"",e.control("packetQueueLength").value=t.packetQueueLength?String(t.packetQueueLength):"",e.control("packetReordering").checked=t.packetReordering??!1,e}createEditor(){if(this.editor)return this.editor;const e=[{name:"title",labelText:tt(Z.profileName),inputType:"text",placeholder:"",validator:function(t,e,n){const i=n.value.trim(),o=i.length>0&&i.length<=49;if(!o){return{valid:o,errorMessage:tt(Z.profileNameCharactersLengthMust,{PH1:49})}}return{valid:o,errorMessage:void 0}},isOptional:!1},{name:"download",labelText:tt(Z.download),inputType:"text",placeholder:t.i18n.lockedString("kbit/s"),validator:o},{name:"upload",labelText:tt(Z.upload),inputType:"text",placeholder:t.i18n.lockedString("kbit/s"),validator:o},{name:"latency",labelText:tt(Z.latency),inputType:"text",placeholder:t.i18n.lockedString("ms"),validator:function(t,e,n){const i=1e6,o=n.value.trim(),r=Number(o),s=Number.isInteger(r)&&r>=0&&r<=i;if(!s){return{valid:s,errorMessage:tt(Z.latencyMustBeAnIntegerBetweenSms,{PH1:0,PH2:i})}}return{valid:s,errorMessage:void 0}}},{name:"packetLoss",labelText:tt(Z.packetLoss),inputType:"text",placeholder:t.i18n.lockedString("percent"),validator:function(t,e,n){const i=n.value.trim(),o=Number(i),r=o>=0&&o<=100;if(!r){return{valid:r,errorMessage:tt(Z.packetLossMustBeAnIntegerBetweenSpct,{PH1:0,PH2:100})}}return{valid:r,errorMessage:void 0}}},{name:"packetQueueLength",labelText:tt(Z.packetQueueLength),inputType:"text",placeholder:tt(Z.packet),validator:function(t,e,n){const i=n.value.trim(),o=Number(i)>=0;if(!o){return{valid:o,errorMessage:tt(Z.packetQueueLengthMustBeAnIntegerGreaterOrEqualToZero)}}return{valid:o,errorMessage:void 0}}},{name:"packetReordering",labelText:tt(Z.packetReordering),inputType:"checkbox",placeholder:"",validator:function(t,e,n){return{valid:!0,errorMessage:void 0}},isOptional:!1}],n=new r.ListWidget.Editor;this.editor=n;const i=n.contentElement().createChild("div","settings-container");return e.forEach(t=>{((t,e,o,s,a,l=!0)=>{const c=i.createChild("div","setting");c.createChild("div").textContent=e;const d=c.createChild("div"),g=n.createInput(t,o,s,a);g.classList.add("input"),r.ARIAUtils.setLabel(g,e),d.appendChild(g);const u=d.createChild("div"),h=tt(Z.optional);u.textContent=h,r.ARIAUtils.setDescription(g,h),l||(u.style.visibility="hidden")})(t.name,t.labelText,t.inputType,t.placeholder,t.validator,t.isOptional)}),n;function o(t,e,n){const i=1e7,o=n.value.trim(),r=Number(o),s=n.getAttribute("aria-label"),a=!Number.isNaN(r)&&r>=0&&r<=i;if(!a){return{valid:a,errorMessage:tt(Z.sMustBeANumberBetweenSkbsToSkbs,{PH1:String(s),PH2:0,PH3:i})}}return{valid:a,errorMessage:void 0}}}}function it(t){if(t<0)return"";const e=t/125;if(e<1e3)return tt(Z.dskbits,{PH1:e});if(e<1e4){const t=(e/1e3).toFixed(1);return tt(Z.fsmbits,{PH1:t})}return tt(Z.fsmbits,{PH1:e/1e3|0})}var ot=Object.freeze({__proto__:null,CPUThrottlingCard:et,ThrottlingSettingsTab:nt});export{S as MobileThrottlingSelector,U as NetworkPanelIndicator,A as NetworkThrottlingSelector,f as ThrottlingManager,p as ThrottlingPresets,ot as ThrottlingSettingsTab};
//# sourceMappingURL=mobile_throttling.js.map
