import*as e from"../../core/common/common.js";import*as t from"../../core/host/host.js";import*as s from"../../core/i18n/i18n.js";import*as i from"../../core/sdk/sdk.js";import*as r from"../../third_party/marked/marked.js";import*as n from"../../core/root/root.js";import*as o from"../../third_party/third-party-web/third-party-web.js";import*as a from"../bindings/bindings.js";import*as u from"../workspace/workspace.js";const l={improvements:"Improvements",pageErrors:"Page Errors",breakingChanges:"Breaking Changes",pageErrorIssue:"A page error issue: the page is not working correctly",breakingChangeIssue:"A breaking change issue: the page may stop working in an upcoming version of Chrome",improvementIssue:"An improvement issue: there is an opportunity to improve the page"},d=s.i18n.registerUIStrings("models/issues_manager/Issue.ts",l),c=s.i18n.getLocalizedString.bind(void 0,d);class g{#e;#t;issueId=void 0;#s;constructor(e,s=null,i){this.#e="object"==typeof e?e.code:e,this.#t=s,this.issueId=i,t.userMetrics.issueCreated("string"==typeof e?e:e.umaCode),this.#s=!1}code(){return this.#e}getBlockedByResponseDetails(){return[]}cookies(){return[]}rawCookieLines(){return[]}elements(){return[]}requests(){return[]}sources(){return[]}trackingSites(){return[]}isAssociatedWithRequestId(e){for(const t of this.requests())if(t.requestId===e)return!0;return!1}model(){return this.#t}isCausedByThirdParty(){return!1}getIssueId(){return this.issueId}isHidden(){return this.#s}setHidden(e){this.#s=e}maybeCreateConsoleMessage(){}}function h(e){if(e)return{url:e.url,scriptId:e.scriptId,lineNumber:e.lineNumber,columnNumber:0===e.columnNumber?void 0:e.columnNumber-1}}var m=Object.freeze({__proto__:null,Issue:g,getIssueKindDescription:function(e){switch(e){case"PageError":return c(l.pageErrorIssue);case"BreakingChange":return c(l.breakingChangeIssue);case"Improvement":return c(l.improvementIssue)}},getIssueKindName:function(e){switch(e){case"BreakingChange":return c(l.breakingChanges);case"Improvement":return c(l.improvements);case"PageError":return c(l.pageErrors)}},getShowThirdPartyIssuesSetting:function(){return e.Settings.Settings.instance().createSetting("show-third-party-issues",!0)},toZeroBasedLocation:h,unionIssueKind:function(e,t){return"PageError"===e||"PageError"===t?"PageError":"BreakingChange"===e||"BreakingChange"===t?"BreakingChange":"Improvement"}});const p={link:"https://tools.ietf.org/id/draft-ietf-httpbis-header-structure-15.html#rfc.section.4.2.2",linkTitle:"Structured Headers RFC"};class I extends g{issueDetails;constructor(e,t){super(function(e){switch(e.violationType){case"PermissionPolicyDisabled":return"AttributionReportingIssue::PermissionPolicyDisabled";case"UntrustworthyReportingOrigin":return"AttributionReportingIssue::UntrustworthyReportingOrigin";case"InsecureContext":return"AttributionReportingIssue::InsecureContext";case"InvalidHeader":return"AttributionReportingIssue::InvalidRegisterSourceHeader";case"InvalidRegisterTriggerHeader":return"AttributionReportingIssue::InvalidRegisterTriggerHeader";case"SourceAndTriggerHeaders":return"AttributionReportingIssue::SourceAndTriggerHeaders";case"SourceIgnored":return"AttributionReportingIssue::SourceIgnored";case"TriggerIgnored":return"AttributionReportingIssue::TriggerIgnored";case"OsSourceIgnored":return"AttributionReportingIssue::OsSourceIgnored";case"OsTriggerIgnored":return"AttributionReportingIssue::OsTriggerIgnored";case"InvalidRegisterOsSourceHeader":return"AttributionReportingIssue::InvalidRegisterOsSourceHeader";case"InvalidRegisterOsTriggerHeader":return"AttributionReportingIssue::InvalidRegisterOsTriggerHeader";case"WebAndOsHeaders":return"AttributionReportingIssue::WebAndOsHeaders";case"NoWebOrOsSupport":return"AttributionReportingIssue::NoWebOrOsSupport";case"NavigationRegistrationWithoutTransientUserActivation":return"AttributionReportingIssue::NavigationRegistrationWithoutTransientUserActivation";case"InvalidInfoHeader":return"AttributionReportingIssue::InvalidInfoHeader";case"NoRegisterSourceHeader":return"AttributionReportingIssue::NoRegisterSourceHeader";case"NoRegisterTriggerHeader":return"AttributionReportingIssue::NoRegisterTriggerHeader";case"NoRegisterOsSourceHeader":return"AttributionReportingIssue::NoRegisterOsSourceHeader";case"NoRegisterOsTriggerHeader":return"AttributionReportingIssue::NoRegisterOsTriggerHeader";case"NavigationRegistrationUniqueScopeAlreadySet":return"AttributionReportingIssue::NavigationRegistrationUniqueScopeAlreadySet";default:return"AttributionReportingIssue::Unknown"}}(e),t),this.issueDetails=e}getCategory(){return"AttributionReporting"}getHeaderValidatorLink(e){const t=new URL("https://wicg.github.io/attribution-reporting-api/validate-headers");return t.searchParams.set("header",e),this.issueDetails.invalidParameter&&t.searchParams.set("json",this.issueDetails.invalidParameter),{link:t.toString(),linkTitle:"Header Validator"}}getDescription(){switch(this.code()){case"AttributionReportingIssue::PermissionPolicyDisabled":return{file:"arPermissionPolicyDisabled.md",links:[]};case"AttributionReportingIssue::UntrustworthyReportingOrigin":return{file:"arUntrustworthyReportingOrigin.md",links:[]};case"AttributionReportingIssue::InsecureContext":return{file:"arInsecureContext.md",links:[]};case"AttributionReportingIssue::InvalidRegisterSourceHeader":return{file:"arInvalidRegisterSourceHeader.md",links:[this.getHeaderValidatorLink("source")]};case"AttributionReportingIssue::InvalidRegisterTriggerHeader":return{file:"arInvalidRegisterTriggerHeader.md",links:[this.getHeaderValidatorLink("trigger")]};case"AttributionReportingIssue::InvalidRegisterOsSourceHeader":return{file:"arInvalidRegisterOsSourceHeader.md",links:[this.getHeaderValidatorLink("os-source")]};case"AttributionReportingIssue::InvalidRegisterOsTriggerHeader":return{file:"arInvalidRegisterOsTriggerHeader.md",links:[this.getHeaderValidatorLink("os-trigger")]};case"AttributionReportingIssue::SourceAndTriggerHeaders":return{file:"arSourceAndTriggerHeaders.md",links:[]};case"AttributionReportingIssue::WebAndOsHeaders":return{file:"arWebAndOsHeaders.md",links:[]};case"AttributionReportingIssue::SourceIgnored":return{file:"arSourceIgnored.md",links:[p]};case"AttributionReportingIssue::TriggerIgnored":return{file:"arTriggerIgnored.md",links:[p]};case"AttributionReportingIssue::OsSourceIgnored":return{file:"arOsSourceIgnored.md",links:[p]};case"AttributionReportingIssue::OsTriggerIgnored":return{file:"arOsTriggerIgnored.md",links:[p]};case"AttributionReportingIssue::NavigationRegistrationWithoutTransientUserActivation":return{file:"arNavigationRegistrationWithoutTransientUserActivation.md",links:[]};case"AttributionReportingIssue::NoWebOrOsSupport":return{file:"arNoWebOrOsSupport.md",links:[]};case"AttributionReportingIssue::InvalidInfoHeader":return{file:"arInvalidInfoHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterSourceHeader":return{file:"arNoRegisterSourceHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterTriggerHeader":return{file:"arNoRegisterTriggerHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterOsSourceHeader":return{file:"arNoRegisterOsSourceHeader.md",links:[]};case"AttributionReportingIssue::NoRegisterOsTriggerHeader":return{file:"arNoRegisterOsTriggerHeader.md",links:[]};case"AttributionReportingIssue::NavigationRegistrationUniqueScopeAlreadySet":return{file:"arNavigationRegistrationUniqueScopeAlreadySet.md",links:[]};case"AttributionReportingIssue::Unknown":return null}}primaryKey(){return JSON.stringify(this.issueDetails)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const{attributionReportingIssueDetails:s}=t.details;return s?[new I(s,e)]:(console.warn("Attribution Reporting issue without details received."),[])}}var f=Object.freeze({__proto__:null,AttributionReportingIssue:I});let k=null;class C{constructor(){i.TargetManager.TargetManager.instance().addModelListener(i.ResourceTreeModel.ResourceTreeModel,i.ResourceTreeModel.Events.Load,this.#i,this,{scoped:!0});for(const e of i.TargetManager.TargetManager.instance().models(i.ResourceTreeModel.ResourceTreeModel))e.target().outermostTarget()===e.target()&&this.#r(e)}static instance({forceNew:e}={forceNew:!1}){return k&&!e||(k=new C),k}#r(e){e.target().auditsAgent().invoke_checkFormsIssues()}#i(e){const{resourceTreeModel:t}=e.data;this.#r(t)}}var y=Object.freeze({__proto__:null,CheckFormsIssuesTrigger:C});function S(e){const t=new Map;e.substitutions?.forEach((e,s)=>{t.set(s,e())});return{file:e.file,links:e.links.map(function(e){return{link:e.link,linkTitle:e.linkTitle()}}),substitutions:t}}async function b(e){try{const t=await fetch(e.toString());return await t.text()}catch{throw new Error(`Markdown file ${e.toString()} not found. Make sure it is correctly listed in the relevant BUILD.gn files.`)}}async function v(e){return await b(new URL(`descriptions/${e}`,import.meta.url))}function w(e,t){const s=r.Marked.lexer(e),i=A(s);if(!i)throw new Error("Markdown issue descriptions must start with a heading");return{title:i,markdown:s.slice(1),links:t.links}}const D=/\{(PLACEHOLDER_[a-zA-Z][a-zA-Z0-9]*)\}/g,T=/PLACEHOLDER_[a-zA-Z][a-zA-Z0-9]*/;function R(e,t){const s=new Set(t?t.keys():[]);!function(e){const t=[...e].filter(e=>!T.test(e));if(t.length>0)throw new Error(`Invalid placeholders provided in the substitutions map: ${t}`)}(s);const i=e.replace(D,(e,i)=>{const r=t?t.get(i):void 0;if(void 0===r)throw new Error(`No replacement provided for placeholder '${i}'.`);return s.delete(i),r});if(s.size>0)throw new Error(`Unused replacements provided: ${[...s]}`);return i}function A(e){return 0===e.length||"heading"!==e[0].type||1!==e[0].depth?null:e[0].text}async function E(e){const t=await v(e.file);return A(r.Marked.lexer(t))}var P=Object.freeze({__proto__:null,createIssueDescriptionFromMarkdown:async function(e){return w(R(await v(e.file),e.substitutions),e)},createIssueDescriptionFromRawMarkdown:w,findTitleFromMarkdownAst:A,getFileContent:b,getIssueTitleFromMarkdownDescription:E,getMarkdownFileContent:v,resolveLazyDescription:S,substitutePlaceholders:R});const M={clientHintsInfrastructure:"Client Hints Infrastructure"},N=s.i18n.registerUIStrings("models/issues_manager/ClientHintIssue.ts",M),F=s.i18n.getLazilyComputedLocalizedString.bind(void 0,N);class L extends g{issueDetails;constructor(e,t){super({code:"ClientHintIssue",umaCode:["ClientHintIssue",e.clientHintIssueReason].join("::")},t),this.issueDetails=e}getCategory(){return"Other"}details(){return this.issueDetails}getDescription(){const e=O.get(this.issueDetails.clientHintIssueReason);return e?S(e):null}sources(){return[this.issueDetails.sourceCodeLocation]}primaryKey(){return JSON.stringify(this.issueDetails)}getKind(){return"BreakingChange"}static fromInspectorIssue(e,t){const s=t.details.clientHintIssueDetails;return s?[new L(s,e)]:(console.warn("Client Hint issue without details received."),[])}}const O=new Map([["MetaTagAllowListInvalidOrigin",{file:"clientHintMetaTagAllowListInvalidOrigin.md",links:[{link:"https://wicg.github.io/client-hints-infrastructure/",linkTitle:F(M.clientHintsInfrastructure)}]}],["MetaTagModifiedHTML",{file:"clientHintMetaTagModifiedHTML.md",links:[{link:"https://wicg.github.io/client-hints-infrastructure/",linkTitle:F(M.clientHintsInfrastructure)}]}]]);var x=Object.freeze({__proto__:null,ClientHintIssue:L});const W={contentSecurityPolicySource:"Content Security Policy - Source Allowlists",contentSecurityPolicyInlineCode:"Content Security Policy - Inline Code",contentSecurityPolicyEval:"Content Security Policy - Eval",trustedTypesFixViolations:"Trusted Types - Fix violations",trustedTypesPolicyViolation:"Trusted Types - Policy violation"},U=s.i18n.registerUIStrings("models/issues_manager/ContentSecurityPolicyIssue.ts",W),H=s.i18n.getLazilyComputedLocalizedString.bind(void 0,U);class _ extends g{#n;constructor(e,t,s){super(["ContentSecurityPolicyIssue",e.contentSecurityPolicyViolationType].join("::"),t,s),this.#n=e}getCategory(){return"ContentSecurityPolicy"}primaryKey(){return JSON.stringify(this.#n,["blockedURL","contentSecurityPolicyViolationType","violatedDirective","isReportOnly","sourceCodeLocation","url","lineNumber","columnNumber","violatingNodeId"])}getDescription(){const e=Y.get(this.#n.contentSecurityPolicyViolationType);return e?S(e):null}details(){return this.#n}getKind(){return this.#n.isReportOnly?"Improvement":"PageError"}static fromInspectorIssue(e,t){const s=t.details.contentSecurityPolicyIssueDetails;return s?[new _(s,e,t.issueId)]:(console.warn("Content security policy issue without details received."),[])}}const q={file:"cspURLViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#source_allowlists",linkTitle:H(W.contentSecurityPolicySource)}]},B={file:"cspInlineViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#inline_code_is_considered_harmful",linkTitle:H(W.contentSecurityPolicyInlineCode)}]},z={file:"cspEvalViolation.md",links:[{link:"https://developers.google.com/web/fundamentals/security/csp#eval_too",linkTitle:H(W.contentSecurityPolicyEval)}]},V={file:"cspTrustedTypesSinkViolation.md",links:[{link:"https://web.dev/trusted-types/#fix-the-violations",linkTitle:H(W.trustedTypesFixViolations)}]},j={file:"cspTrustedTypesPolicyViolation.md",links:[{link:"https://web.dev/trusted-types/",linkTitle:H(W.trustedTypesPolicyViolation)}]},K=["ContentSecurityPolicyIssue","kURLViolation"].join("::"),$=["ContentSecurityPolicyIssue","kInlineViolation"].join("::"),G=["ContentSecurityPolicyIssue","kEvalViolation"].join("::"),J=["ContentSecurityPolicyIssue","kTrustedTypesSinkViolation"].join("::"),Q=["ContentSecurityPolicyIssue","kTrustedTypesPolicyViolation"].join("::"),Y=new Map([["kURLViolation",q],["kInlineViolation",B],["kEvalViolation",z],["kTrustedTypesSinkViolation",V],["kTrustedTypesPolicyViolation",j]]);var X=Object.freeze({__proto__:null,ContentSecurityPolicyIssue:_,evalViolationCode:G,inlineViolationCode:$,trustedTypesPolicyViolationCode:Q,trustedTypesSinkViolationCode:J,urlViolationCode:K});let Z=null;class ee{#o=new WeakMap;#a=new WeakMap;constructor(){i.TargetManager.TargetManager.instance().observeModels(i.ResourceTreeModel.ResourceTreeModel,this)}static instance({forceNew:e}={forceNew:!1}){return Z&&!e||(Z=new ee),Z}async modelAdded(e){this.#o.set(e,e.addEventListener(i.ResourceTreeModel.Events.Load,this.#i,this)),this.#a.set(e,e.addEventListener(i.ResourceTreeModel.Events.FrameAdded,this.#u,this))}modelRemoved(t){const s=this.#o.get(t);s&&e.EventTarget.removeEventListeners([s]);const i=this.#a.get(t);i&&e.EventTarget.removeEventListeners([i])}#l(e){n.Runtime.experiments.isEnabled("contrast-issues")&&e.target().auditsAgent().invoke_checkContrast({})}#i(e){const{resourceTreeModel:t}=e.data;this.#l(t)}async#u(e){if(!n.Runtime.experiments.isEnabled("contrast-issues"))return;const t=e.data;if(!t.isMainFrame())return;const s=await t.resourceTreeModel().target().runtimeAgent().invoke_evaluate({expression:"document.readyState",returnByValue:!0});s.result&&"complete"===s.result.value&&this.#l(t.resourceTreeModel())}}var te=Object.freeze({__proto__:null,ContrastCheckTrigger:ee});const se={thirdPartyPhaseoutExplained:"Changes to Chrome's treatment of third-party cookies"},ie=s.i18n.registerUIStrings("models/issues_manager/CookieDeprecationMetadataIssue.ts",se),re=s.i18n.getLocalizedString.bind(void 0,ie);class ne extends g{#n;constructor(e,t){super("CookieDeprecationMetadataIssue_"+e.operation,t),this.#n=e}getCategory(){return"Other"}getDescription(){const e="SetCookie"===this.#n.operation?"cookieWarnMetadataGrantSet.md":"cookieWarnMetadataGrantRead.md";let t="";return this.#n.isOptOutTopLevel&&(t="\n\n (Top level site opt-out: "+this.#n.optOutPercentage+"% - [learn more](gracePeriodStagedControlExplainer))"),{file:e,substitutions:new Map([["PLACEHOLDER_topleveloptout",t]]),links:[{link:"https://goo.gle/changes-to-chrome-browsing",linkTitle:re(se.thirdPartyPhaseoutExplained)}]}}details(){return this.#n}getKind(){return"BreakingChange"}primaryKey(){return JSON.stringify(this.#n)}static fromInspectorIssue(e,t){const s=t.details.cookieDeprecationMetadataIssueDetails;return s?[new ne(s,e)]:(console.warn("Cookie deprecation metadata issue without details received."),[])}}var oe=Object.freeze({__proto__:null,CookieDeprecationMetadataIssue:ne});const ae={samesiteCookiesExplained:"SameSite cookies explained",howSchemefulSamesiteWorks:"How Schemeful Same-Site Works",firstPartySetsExplained:"`First-Party Sets` and the `SameParty` attribute",fileCrosSiteRedirectBug:"File a bug",consoleTpcdErrorMessage:"Third-party cookie is blocked in Chrome either because of Chrome flags or browser configuration."},ue=s.i18n.registerUIStrings("models/issues_manager/CookieIssue.ts",ae),le=s.i18n.getLazilyComputedLocalizedString.bind(void 0,ue);class de extends g{#n;constructor(e,t,s,i){super(e,s,i),this.#n=t}cookieId(){if(this.#n.cookie){const{domain:e,path:t,name:s}=this.#n.cookie;return`${e};${t};${s}`}return this.#n.rawCookieLine??"no-cookie-info"}primaryKey(){const e=this.#n.request?this.#n.request.requestId:"no-request";return`${this.code()}-(${this.cookieId()})-(${e})`}static createIssuesFromCookieIssueDetails(e,t,s){const i=[];if(e.cookieExclusionReasons&&e.cookieExclusionReasons.length>0){for(const r of e.cookieExclusionReasons){const n=de.codeForCookieIssueDetails(r,e.cookieWarningReasons,e.operation,e.cookieUrl);n&&i.push(new de(n,e,t,s))}return i}if(e.cookieWarningReasons)for(const r of e.cookieWarningReasons){const n=de.codeForCookieIssueDetails(r,[],e.operation,e.cookieUrl);n&&i.push(new de(n,e,t,s))}return i}static codeForCookieIssueDetails(t,s,i,r){const n=r&&(e.ParsedURL.schemeIs(r,"https:")||e.ParsedURL.schemeIs(r,"wss:"))?"Secure":"Insecure";if("ExcludeSameSiteStrict"===t||"ExcludeSameSiteLax"===t||"ExcludeSameSiteUnspecifiedTreatedAsLax"===t){if(s&&s.length>0){if(s.includes("WarnSameSiteStrictLaxDowngradeStrict"))return["CookieIssue","ExcludeNavigationContextDowngrade",n].join("::");if(s.includes("WarnSameSiteStrictCrossDowngradeStrict")||s.includes("WarnSameSiteStrictCrossDowngradeLax")||s.includes("WarnSameSiteLaxCrossDowngradeStrict")||s.includes("WarnSameSiteLaxCrossDowngradeLax"))return["CookieIssue","ExcludeContextDowngrade",i,n].join("::")}return s.includes("WarnCrossSiteRedirectDowngradeChangesInclusion")?["CookieIssue","CrossSiteRedirectDowngradeChangesInclusion"].join("::"):"ExcludeSameSiteUnspecifiedTreatedAsLax"===t?["CookieIssue",t,i].join("::"):null}return"WarnSameSiteStrictLaxDowngradeStrict"===t?["CookieIssue",t,n].join("::"):"WarnSameSiteStrictCrossDowngradeStrict"===t||"WarnSameSiteStrictCrossDowngradeLax"===t||"WarnSameSiteLaxCrossDowngradeLax"===t||"WarnSameSiteLaxCrossDowngradeStrict"===t?["CookieIssue","WarnCrossDowngrade",i,n].join("::"):"ExcludePortMismatch"===t?["CookieIssue","ExcludePortMismatch"].join("::"):"ExcludeSchemeMismatch"===t?["CookieIssue","ExcludeSchemeMismatch"].join("::"):["CookieIssue",t,i].join("::")}cookies(){return this.#n.cookie?[this.#n.cookie]:[]}rawCookieLines(){return this.#n.rawCookieLine?[this.#n.rawCookieLine]:[]}requests(){return this.#n.request?[this.#n.request]:[]}getCategory(){return"Cookie"}getDescription(){const e=Le.get(this.code());return e?S(e):null}isCausedByThirdParty(){return ce(i.FrameManager.FrameManager.instance().getOutermostFrame(),this.#n.cookieUrl,this.#n.siteForCookies)}getKind(){return this.#n.cookieExclusionReasons?.length>0?"PageError":"BreakingChange"}makeCookieReportEntry(){const e=de.getCookieStatus(this.#n);if(this.#n.cookie&&this.#n.cookieUrl&&void 0!==e){const t=o.ThirdPartyWeb.getEntity(this.#n.cookieUrl);return{name:this.#n.cookie.name,domain:this.#n.cookie.domain,type:t?.category,platform:t?.name,status:e,insight:this.#n.insight}}}static getCookieStatus(e){return e.cookieExclusionReasons.includes("ExcludeThirdPartyPhaseout")?0:e.cookieWarningReasons.includes("WarnDeprecationTrialMetadata")?2:e.cookieWarningReasons.includes("WarnThirdPartyCookieHeuristic")?3:e.cookieWarningReasons.includes("WarnThirdPartyPhaseout")?1:void 0}static fromInspectorIssue(e,t){const s=t.details.cookieIssueDetails;return s?de.createIssuesFromCookieIssueDetails(s,e,t.issueId):(console.warn("Cookie issue without details received."),[])}static getSubCategory(e){return e.includes("SameSite")||e.includes("Downgrade")?"SameSiteCookie":e.includes("ThirdPartyPhaseout")?"ThirdPartyPhaseoutCookie":"GenericCookie"}static isThirdPartyCookiePhaseoutRelatedIssue(e){return["WarnThirdPartyCookieHeuristic","WarnDeprecationTrialMetadata","WarnThirdPartyPhaseout","ExcludeThirdPartyPhaseout"].some(t=>e.code().includes(t))}maybeCreateConsoleMessage(){const t=this.model();if(t&&this.code().includes("ExcludeThirdPartyPhaseout"))return new i.ConsoleModel.ConsoleMessage(t.target().model(i.RuntimeModel.RuntimeModel),e.Console.FrontendMessageSource.ISSUE_PANEL,"warning",ae.consoleTpcdErrorMessage,{url:this.#n.request?.url,affectedResources:{requestId:this.#n.request?.requestId,issueId:this.issueId},isCookieReportIssue:!0})}}function ce(t,s,i){if(!t)return!0;if(!i)return!0;if(!s||""===t.domainAndRegistry())return!1;const r=e.ParsedURL.ParsedURL.fromString(s);return!!r&&!function(e,t){if(e.length<=t.length)return e===t;if(!e.endsWith(t))return!1;return e.substr(0,e.length-t.length).endsWith(".")}(r.domain(),t.domainAndRegistry())}const ge={file:"SameSiteUnspecifiedLaxAllowUnsafeRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},he={file:"SameSiteUnspecifiedLaxAllowUnsafeSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},me={file:"SameSiteNoneInsecureErrorRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},pe={file:"SameSiteNoneInsecureErrorSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},Ie={file:"SameSiteNoneInsecureWarnRead.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},fe={file:"SameSiteNoneInsecureWarnSet.md",links:[{link:"https://web.dev/samesite-cookies-explained/",linkTitle:le(ae.samesiteCookiesExplained)}]},ke=[{link:"https://web.dev/schemeful-samesite/",linkTitle:le(ae.howSchemefulSamesiteWorks)}];function Ce({isDestinationSecure:e,isOriginSecure:t}){return new Map([["PLACEHOLDER_destination",()=>e?"a secure":"an insecure"],["PLACEHOLDER_origin",()=>t?"a secure":"an insecure"]])}function ye(e){return{file:"SameSiteWarnStrictLaxDowngradeStrict.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function Se(e){return{file:"SameSiteExcludeNavigationContextDowngrade.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function be(e){return{file:"SameSiteWarnCrossDowngradeRead.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function ve(e){return{file:"SameSiteExcludeContextDowngradeRead.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}function we(e){return{file:"SameSiteWarnCrossDowngradeSet.md",substitutions:Ce({isDestinationSecure:!e,isOriginSecure:e}),links:ke}}function De(e){return{file:"SameSiteExcludeContextDowngradeSet.md",substitutions:Ce({isDestinationSecure:e,isOriginSecure:!e}),links:ke}}const Te={file:"SameSiteInvalidSameParty.md",links:[{link:"https://developer.chrome.com/blog/first-party-sets-sameparty/",linkTitle:le(ae.firstPartySetsExplained)}]},Re={file:"SameSiteSamePartyCrossPartyContextSet.md",links:[{link:"https://developer.chrome.com/blog/first-party-sets-sameparty/",linkTitle:le(ae.firstPartySetsExplained)}]},Ae={file:"CookieAttributeValueExceedsMaxSize.md",links:[]},Ee={file:"cookieWarnDomainNonAscii.md",links:[]},Pe={file:"cookieExcludeDomainNonAscii.md",links:[]},Me={file:"cookieExcludeBlockedWithinRelatedWebsiteSet.md",links:[]},Ne={file:"cookieCrossSiteRedirectDowngrade.md",links:[{link:"https://bugs.chromium.org/p/chromium/issues/entry?template=Defect%20report%20from%20user&summary=[Cross-Site Redirect Chain] <INSERT BUG SUMMARY HERE>&comment=Chrome Version: (copy from chrome://version)%0AChannel: (e.g. Canary, Dev, Beta, Stable)%0A%0AAffected URLs:%0A%0AWhat is the expected result?%0A%0AWhat happens instead?%0A%0AWhat is the purpose of the cross-site redirect?:%0A%0AWhat steps will reproduce the problem?:%0A(1)%0A(2)%0A(3)%0A%0APlease provide any additional information below.&components=Internals%3ENetwork%3ECookies",linkTitle:le(ae.fileCrosSiteRedirectBug)}]},Fe={file:"placeholderDescriptionForInvisibleIssues.md",links:[]},Le=new Map([["CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::ReadCookie",ge],["CookieIssue::WarnSameSiteUnspecifiedLaxAllowUnsafe::SetCookie",he],["CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::ReadCookie",ge],["CookieIssue::WarnSameSiteUnspecifiedCrossSiteContext::SetCookie",he],["CookieIssue::ExcludeSameSiteNoneInsecure::ReadCookie",me],["CookieIssue::ExcludeSameSiteNoneInsecure::SetCookie",pe],["CookieIssue::WarnSameSiteNoneInsecure::ReadCookie",Ie],["CookieIssue::WarnSameSiteNoneInsecure::SetCookie",fe],["CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Secure",ye(!0)],["CookieIssue::WarnSameSiteStrictLaxDowngradeStrict::Insecure",ye(!1)],["CookieIssue::WarnCrossDowngrade::ReadCookie::Secure",be(!0)],["CookieIssue::WarnCrossDowngrade::ReadCookie::Insecure",be(!1)],["CookieIssue::WarnCrossDowngrade::SetCookie::Secure",we(!0)],["CookieIssue::WarnCrossDowngrade::SetCookie::Insecure",we(!1)],["CookieIssue::ExcludeNavigationContextDowngrade::Secure",Se(!0)],["CookieIssue::ExcludeNavigationContextDowngrade::Insecure",Se(!1)],["CookieIssue::ExcludeContextDowngrade::ReadCookie::Secure",ve(!0)],["CookieIssue::ExcludeContextDowngrade::ReadCookie::Insecure",ve(!1)],["CookieIssue::ExcludeContextDowngrade::SetCookie::Secure",De(!0)],["CookieIssue::ExcludeContextDowngrade::SetCookie::Insecure",De(!1)],["CookieIssue::ExcludeInvalidSameParty::SetCookie",Te],["CookieIssue::ExcludeSamePartyCrossPartyContext::SetCookie",Re],["CookieIssue::WarnAttributeValueExceedsMaxSize::ReadCookie",Ae],["CookieIssue::WarnAttributeValueExceedsMaxSize::SetCookie",Ae],["CookieIssue::WarnDomainNonASCII::ReadCookie",Ee],["CookieIssue::WarnDomainNonASCII::SetCookie",Ee],["CookieIssue::ExcludeDomainNonASCII::ReadCookie",Pe],["CookieIssue::ExcludeDomainNonASCII::SetCookie",Pe],["CookieIssue::ExcludeThirdPartyCookieBlockedInRelatedWebsiteSet::ReadCookie",Me],["CookieIssue::ExcludeThirdPartyCookieBlockedInRelatedWebsiteSet::SetCookie",Me],["CookieIssue::WarnThirdPartyPhaseout::ReadCookie",Fe],["CookieIssue::WarnThirdPartyPhaseout::SetCookie",Fe],["CookieIssue::WarnDeprecationTrialMetadata::ReadCookie",Fe],["CookieIssue::WarnDeprecationTrialMetadata::SetCookie",Fe],["CookieIssue::WarnThirdPartyCookieHeuristic::ReadCookie",Fe],["CookieIssue::WarnThirdPartyCookieHeuristic::SetCookie",Fe],["CookieIssue::ExcludeThirdPartyPhaseout::ReadCookie",Fe],["CookieIssue::ExcludeThirdPartyPhaseout::SetCookie",Fe],["CookieIssue::CrossSiteRedirectDowngradeChangesInclusion",Ne],["CookieIssue::ExcludePortMismatch",{file:"cookieExcludePortMismatch.md",links:[]}],["CookieIssue::ExcludeSchemeMismatch",{file:"cookieExcludeSchemeMismatch.md",links:[]}]]);var Oe=Object.freeze({__proto__:null,CookieIssue:de,isCausedByThirdParty:ce});const xe={corsLocalNetworkAccess:"Local Network Access",corsPrivateNetworkAccess:"Private Network Access",CORS:"Cross-Origin Resource Sharing (`CORS`)"},We=s.i18n.registerUIStrings("models/issues_manager/CorsIssue.ts",xe),Ue=s.i18n.getLocalizedString.bind(void 0,We);function He(e){switch(e.corsErrorStatus.corsError){case"InvalidAllowMethodsPreflightResponse":case"InvalidAllowHeadersPreflightResponse":case"PreflightMissingAllowOriginHeader":case"PreflightMultipleAllowOriginValues":case"PreflightInvalidAllowOriginValue":case"MissingAllowOriginHeader":case"MultipleAllowOriginValues":case"InvalidAllowOriginValue":return"CorsIssue::InvalidHeaders";case"PreflightWildcardOriginNotAllowed":case"WildcardOriginNotAllowed":return"CorsIssue::WildcardOriginWithCredentials";case"PreflightInvalidStatus":case"PreflightDisallowedRedirect":case"InvalidResponse":return"CorsIssue::PreflightResponseInvalid";case"AllowOriginMismatch":case"PreflightAllowOriginMismatch":return"CorsIssue::OriginMismatch";case"InvalidAllowCredentials":case"PreflightInvalidAllowCredentials":return"CorsIssue::AllowCredentialsRequired";case"MethodDisallowedByPreflightResponse":return"CorsIssue::MethodDisallowedByPreflightResponse";case"HeaderDisallowedByPreflightResponse":return"CorsIssue::HeaderDisallowedByPreflightResponse";case"RedirectContainsCredentials":return"CorsIssue::RedirectContainsCredentials";case"DisallowedByMode":return"CorsIssue::DisallowedByMode";case"CorsDisabledScheme":return"CorsIssue::CorsDisabledScheme";case"PreflightMissingAllowExternal":return"CorsIssue::PreflightMissingAllowExternal";case"PreflightInvalidAllowExternal":return"CorsIssue::PreflightInvalidAllowExternal";case"InsecurePrivateNetwork":return"CorsIssue::InsecurePrivateNetwork";case"NoCorsRedirectModeNotFollow":return"CorsIssue::NoCorsRedirectModeNotFollow";case"InvalidPrivateNetworkAccess":return"CorsIssue::InvalidPrivateNetworkAccess";case"UnexpectedPrivateNetworkAccess":return"CorsIssue::UnexpectedPrivateNetworkAccess";case"PreflightMissingAllowPrivateNetwork":case"PreflightInvalidAllowPrivateNetwork":return"CorsIssue::PreflightAllowPrivateNetworkError";case"PreflightMissingPrivateNetworkAccessId":return"CorsIssue::PreflightMissingPrivateNetworkAccessId";case"PreflightMissingPrivateNetworkAccessName":return"CorsIssue::PreflightMissingPrivateNetworkAccessName";case"PrivateNetworkAccessPermissionUnavailable":return"CorsIssue::PrivateNetworkAccessPermissionUnavailable";case"PrivateNetworkAccessPermissionDenied":return"CorsIssue::PrivateNetworkAccessPermissionDenied";case"LocalNetworkAccessPermissionDenied":return"CorsIssue::LocalNetworkAccessPermissionDenied"}}class _e extends g{#n;constructor(e,t,s){super(He(e),t,s),this.#n=e}getCategory(){return"Cors"}details(){return this.#n}getDescription(){switch(He(this.#n)){case"CorsIssue::InsecurePrivateNetwork":return{file:"corsInsecurePrivateNetwork.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Ue(xe.corsPrivateNetworkAccess)}]};case"CorsIssue::PreflightAllowPrivateNetworkError":return{file:"corsPreflightAllowPrivateNetworkError.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Ue(xe.corsPrivateNetworkAccess)}]};case"CorsIssue::InvalidHeaders":return{file:"corsInvalidHeaderValues.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::WildcardOriginWithCredentials":return{file:"corsWildcardOriginNotAllowed.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::PreflightResponseInvalid":return{file:"corsPreflightResponseInvalid.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::OriginMismatch":return{file:"corsOriginMismatch.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::AllowCredentialsRequired":return{file:"corsAllowCredentialsRequired.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::MethodDisallowedByPreflightResponse":return{file:"corsMethodDisallowedByPreflightResponse.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::HeaderDisallowedByPreflightResponse":return{file:"corsHeaderDisallowedByPreflightResponse.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::RedirectContainsCredentials":return{file:"corsRedirectContainsCredentials.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::DisallowedByMode":return{file:"corsDisallowedByMode.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::CorsDisabledScheme":return{file:"corsDisabledScheme.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::NoCorsRedirectModeNotFollow":return{file:"corsNoCorsRedirectModeNotFollow.md",links:[{link:"https://web.dev/cross-origin-resource-sharing",linkTitle:Ue(xe.CORS)}]};case"CorsIssue::PreflightMissingPrivateNetworkAccessId":case"CorsIssue::PreflightMissingPrivateNetworkAccessName":return{file:"corsPrivateNetworkPermissionDenied.md",links:[{link:"https://developer.chrome.com/blog/private-network-access-update",linkTitle:Ue(xe.corsPrivateNetworkAccess)}]};case"CorsIssue::LocalNetworkAccessPermissionDenied":return{file:"corsLocalNetworkAccessPermissionDenied.md",links:[{link:"https://chromestatus.com/feature/5152728072060928",linkTitle:Ue(xe.corsLocalNetworkAccess)}]};case"CorsIssue::PreflightMissingAllowExternal":case"CorsIssue::PreflightInvalidAllowExternal":case"CorsIssue::InvalidPrivateNetworkAccess":case"CorsIssue::UnexpectedPrivateNetworkAccess":case"CorsIssue::PrivateNetworkAccessPermissionUnavailable":case"CorsIssue::PrivateNetworkAccessPermissionDenied":return null}}primaryKey(){return JSON.stringify(this.#n)}getKind(){return!this.#n.isWarning||"InsecurePrivateNetwork"!==this.#n.corsErrorStatus.corsError&&"PreflightMissingAllowPrivateNetwork"!==this.#n.corsErrorStatus.corsError&&"PreflightInvalidAllowPrivateNetwork"!==this.#n.corsErrorStatus.corsError?"PageError":"BreakingChange"}static fromInspectorIssue(e,t){const s=t.details.corsIssueDetails;return s?[new _e(s,e,t.issueId)]:(console.warn("Cors issue without details received."),[])}}var qe=Object.freeze({__proto__:null,CorsIssue:_e});const Be={coopAndCoep:"COOP and COEP",samesiteAndSameorigin:"Same-Site and Same-Origin"},ze=s.i18n.registerUIStrings("models/issues_manager/CrossOriginEmbedderPolicyIssue.ts",Be),Ve=s.i18n.getLazilyComputedLocalizedString.bind(void 0,ze);function je(e){switch(e){case"CoepFrameResourceNeedsCoepHeader":case"CoopSandboxedIFrameCannotNavigateToCoopPage":case"CorpNotSameOrigin":case"CorpNotSameOriginAfterDefaultedToSameOriginByCoep":case"CorpNotSameSite":return!0}return!1}class Ke extends g{#n;constructor(e,t){super(`CrossOriginEmbedderPolicyIssue::${e.reason}`,t),this.#n=e}primaryKey(){return`${this.code()}-(${this.#n.request.requestId})`}getBlockedByResponseDetails(){return[this.#n]}requests(){return[this.#n.request]}getCategory(){return"CrossOriginEmbedderPolicy"}getDescription(){const e=$e.get(this.code());return e?S(e):null}getKind(){return"PageError"}}const $e=new Map([["CrossOriginEmbedderPolicyIssue::CorpNotSameOriginAfterDefaultedToSameOriginByCoep",{file:"CoepCorpNotSameOriginAfterDefaultedToSameOriginByCoep.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ve(Be.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:Ve(Be.samesiteAndSameorigin)}]}],["CrossOriginEmbedderPolicyIssue::CoepFrameResourceNeedsCoepHeader",{file:"CoepFrameResourceNeedsCoepHeader.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ve(Be.coopAndCoep)}]}],["CrossOriginEmbedderPolicyIssue::CoopSandboxedIframeCannotNavigateToCoopPage",{file:"CoepCoopSandboxedIframeCannotNavigateToCoopPage.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ve(Be.coopAndCoep)}]}],["CrossOriginEmbedderPolicyIssue::CorpNotSameSite",{file:"CoepCorpNotSameSite.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ve(Be.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:Ve(Be.samesiteAndSameorigin)}]}],["CrossOriginEmbedderPolicyIssue::CorpNotSameOrigin",{file:"CoepCorpNotSameOrigin.md",links:[{link:"https://web.dev/coop-coep/",linkTitle:Ve(Be.coopAndCoep)},{link:"https://web.dev/same-site-same-origin/",linkTitle:Ve(Be.samesiteAndSameorigin)}]}]]);var Ge=Object.freeze({__proto__:null,CrossOriginEmbedderPolicyIssue:Ke,isCrossOriginEmbedderPolicyIssue:je});const Je={AuthorizationCoveredByWildcard:"Authorization will not be covered by the wildcard symbol (*) in CORS `Access-Control-Allow-Headers` handling.",CanRequestURLHTTPContainingNewline:"Resource requests whose URLs contained both removed whitespace `\\(n|r|t)` characters and less-than characters (`<`) are blocked. Please remove newlines and encode less-than characters from places like element attribute values in order to load these resources.",ChromeLoadTimesConnectionInfo:"`chrome.loadTimes()` is deprecated, instead use standardized API: Navigation Timing 2.",ChromeLoadTimesFirstPaintAfterLoadTime:"`chrome.loadTimes()` is deprecated, instead use standardized API: Paint Timing.",ChromeLoadTimesWasAlternateProtocolAvailable:"`chrome.loadTimes()` is deprecated, instead use standardized API: `nextHopProtocol` in Navigation Timing 2.",CookieWithTruncatingChar:"Cookies containing a `\\(0|r|n)` character will be rejected instead of truncated.",CrossOriginAccessBasedOnDocumentDomain:"Relaxing the same-origin policy by setting `document.domain` is deprecated, and will be disabled by default. This deprecation warning is for a cross-origin access that was enabled by setting `document.domain`.",CrossOriginWindowAlert:"Triggering window.alert from cross origin iframes has been deprecated and will be removed in the future.",CrossOriginWindowConfirm:"Triggering window.confirm from cross origin iframes has been deprecated and will be removed in the future.",CSSSelectorInternalMediaControlsOverlayCastButton:"The `disableRemotePlayback` attribute should be used in order to disable the default Cast integration instead of using `-internal-media-controls-overlay-cast-button` selector.",CSSValueAppearanceSliderVertical:"CSS appearance value `slider-vertical` is not standardized and will be removed.",DataUrlInSvgUse:"Support for data: URLs in SVGUseElement is deprecated and it will be removed in the future.",GeolocationInsecureOrigin:"`getCurrentPosition()` and `watchPosition()` no longer work on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://www.chromium.org/Home/chromium-security/deprecating-powerful-features-on-insecure-origins/ for more details.",GeolocationInsecureOriginDeprecatedNotRemoved:"`getCurrentPosition()` and `watchPosition()` are deprecated on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://www.chromium.org/Home/chromium-security/deprecating-powerful-features-on-insecure-origins/ for more details.",GetUserMediaInsecureOrigin:"`getUserMedia()` no longer works on insecure origins. To use this feature, you should consider switching your application to a secure origin, such as HTTPS. See https://www.chromium.org/Home/chromium-security/deprecating-powerful-features-on-insecure-origins/ for more details.",HostCandidateAttributeGetter:"`RTCPeerConnectionIceErrorEvent.hostCandidate` is deprecated. Please use `RTCPeerConnectionIceErrorEvent.address` or `RTCPeerConnectionIceErrorEvent.port` instead.",IdentityInCanMakePaymentEvent:"The merchant origin and arbitrary data from the `canmakepayment` service worker event are deprecated and will be removed: `topOrigin`, `paymentRequestOrigin`, `methodData`, `modifiers`.",InsecurePrivateNetworkSubresourceRequest:"The website requested a subresource from a network that it could only access because of its users' privileged network position. These requests expose non-public devices and servers to the internet, increasing the risk of a cross-site request forgery (CSRF) attack, and/or information leakage. To mitigate these risks, Chrome deprecates requests to non-public subresources when initiated from non-secure contexts, and will start blocking them.",InterestGroupDailyUpdateUrl:"The `dailyUpdateUrl` field of `InterestGroups` passed to `joinAdInterestGroup()` has been renamed to `updateUrl`, to more accurately reflect its behavior.",IntlV8BreakIterator:"`Intl.v8BreakIterator` is deprecated. Please use `Intl.Segmenter` instead.",LocalCSSFileExtensionRejected:"CSS cannot be loaded from `file:` URLs unless they end in a `.css` file extension.",MediaSourceAbortRemove:"Using `SourceBuffer.abort()` to abort `remove()`'s asynchronous range removal is deprecated due to specification change. Support will be removed in the future. You should listen to the `updateend` event instead. `abort()` is intended to only abort an asynchronous media append or reset parser state.",MediaSourceDurationTruncatingBuffered:"Setting `MediaSource.duration` below the highest presentation timestamp of any buffered coded frames is deprecated due to specification change. Support for implicit removal of truncated buffered media will be removed in the future. You should instead perform explicit `remove(newDuration, oldDuration)` on all `sourceBuffers`, where `newDuration < oldDuration`.",NoSysexWebMIDIWithoutPermission:"Web MIDI will ask a permission to use even if the sysex is not specified in the `MIDIOptions`.",NotificationInsecureOrigin:"The Notification API may no longer be used from insecure origins. You should consider switching your application to a secure origin, such as HTTPS. See https://www.chromium.org/Home/chromium-security/deprecating-powerful-features-on-insecure-origins/ for more details.",NotificationPermissionRequestedIframe:"Permission for the Notification API may no longer be requested from a cross-origin iframe. You should consider requesting permission from a top-level frame or opening a new window instead.",ObsoleteCreateImageBitmapImageOrientationNone:"Option `imageOrientation: 'none'` in createImageBitmap is deprecated. Please use createImageBitmap with option '{imageOrientation: 'from-image'}' instead.",ObsoleteWebRtcCipherSuite:"Your partner is negotiating an obsolete (D)TLS version. Please check with your partner to have this fixed.",OverflowVisibleOnReplacedElement:"Specifying `overflow: visible` on img, video and canvas tags may cause them to produce visual content outside of the element bounds. See https://github.com/WICG/shared-element-transitions/blob/main/debugging_overflow_on_images.md.",OverrideFlashEmbedwithHTML:"Legacy flash video embed has been rewritten to HTML iframe. Flash is long gone, this rewriting hack is deprecated and may be removed in the future.",PaymentInstruments:"`paymentManager.instruments` is deprecated. Please use just-in-time install for payment handlers instead.",PaymentRequestCSPViolation:"Your `PaymentRequest` call bypassed Content-Security-Policy (CSP) `connect-src` directive. This bypass is deprecated. Please add the payment method identifier from the `PaymentRequest` API (in `supportedMethods` field) to your CSP `connect-src` directive.",PersistentQuotaType:"`StorageType.persistent` is deprecated. Please use standardized `navigator.storage` instead.",PictureSourceSrc:"`<source src>` with a `<picture>` parent is invalid and therefore ignored. Please use `<source srcset>` instead.",PrefixedCancelAnimationFrame:"webkitCancelAnimationFrame is vendor-specific. Please use the standard cancelAnimationFrame instead.",PrefixedRequestAnimationFrame:"webkitRequestAnimationFrame is vendor-specific. Please use the standard requestAnimationFrame instead.",PrefixedVideoDisplayingFullscreen:"HTMLVideoElement.webkitDisplayingFullscreen is deprecated. Please use Document.fullscreenElement instead.",PrefixedVideoEnterFullScreen:"HTMLVideoElement.webkitEnterFullScreen() is deprecated. Please use Element.requestFullscreen() instead.",PrefixedVideoEnterFullscreen:"HTMLVideoElement.webkitEnterFullscreen() is deprecated. Please use Element.requestFullscreen() instead.",PrefixedVideoExitFullScreen:"HTMLVideoElement.webkitExitFullScreen() is deprecated. Please use Document.exitFullscreen() instead.",PrefixedVideoExitFullscreen:"HTMLVideoElement.webkitExitFullscreen() is deprecated. Please use Document.exitFullscreen() instead.",PrefixedVideoSupportsFullscreen:"HTMLVideoElement.webkitSupportsFullscreen is deprecated. Please use Document.fullscreenEnabled instead.",PrivacySandboxExtensionsAPI:"We're deprecating the API `chrome.privacy.websites.privacySandboxEnabled`, though it will remain active for backward compatibility until release M113. Instead, please use `chrome.privacy.websites.topicsEnabled`, `chrome.privacy.websites.fledgeEnabled` and `chrome.privacy.websites.adMeasurementEnabled`. See https://developer.chrome.com/docs/extensions/reference/privacy/#property-websites-privacySandboxEnabled.",RangeExpand:"Range.expand() is deprecated. Please use Selection.modify() instead.",RequestedSubresourceWithEmbeddedCredentials:"Subresource requests whose URLs contain embedded credentials (e.g. `https://user:pass@host/`) are blocked.",RTCConstraintEnableDtlsSrtpFalse:"The constraint `DtlsSrtpKeyAgreement` is removed. You have specified a `false` value for this constraint, which is interpreted as an attempt to use the removed `SDES key negotiation` method. This functionality is removed; use a service that supports `DTLS key negotiation` instead.",RTCConstraintEnableDtlsSrtpTrue:"The constraint `DtlsSrtpKeyAgreement` is removed. You have specified a `true` value for this constraint, which had no effect, but you can remove this constraint for tidiness.",RTCPeerConnectionGetStatsLegacyNonCompliant:"The callback-based getStats() is deprecated and will be removed. Use the spec-compliant getStats() instead.",RtcpMuxPolicyNegotiate:"The `rtcpMuxPolicy` option is deprecated and will be removed.",SharedArrayBufferConstructedWithoutIsolation:"`SharedArrayBuffer` will require cross-origin isolation. See https://developer.chrome.com/blog/enabling-shared-array-buffer/ for more details.",TextToSpeech_DisallowedByAutoplay:"`speechSynthesis.speak()` without user activation is deprecated and will be removed.",UnloadHandler:"Unload event listeners are deprecated and will be removed.",V8SharedArrayBufferConstructedInExtensionWithoutIsolation:"Extensions should opt into cross-origin isolation to continue using `SharedArrayBuffer`. See https://developer.chrome.com/docs/extensions/mv3/cross-origin-isolation/.",WebBluetoothRemoteCharacteristicWriteValue:"`BluetoothRemoteGATTCharacteristic.writeValue()` is deprecated. Use `writeValueWithResponse()` or `writeValueWithoutResponse()` instead.",XHRJSONEncodingDetection:"UTF-16 is not supported by response json in `XMLHttpRequest`",XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload:"Synchronous `XMLHttpRequest` on the main thread is deprecated because of its detrimental effects to the end user's experience. For more help, check https://xhr.spec.whatwg.org/."},Qe={AuthorizationCoveredByWildcard:{milestone:97},CSSSelectorInternalMediaControlsOverlayCastButton:{chromeStatusFeature:5714245488476160},CSSValueAppearanceSliderVertical:{chromeStatusFeature:6001359429566464},CanRequestURLHTTPContainingNewline:{chromeStatusFeature:5735596811091968},ChromeLoadTimesConnectionInfo:{chromeStatusFeature:5637885046816768},ChromeLoadTimesFirstPaintAfterLoadTime:{chromeStatusFeature:5637885046816768},ChromeLoadTimesWasAlternateProtocolAvailable:{chromeStatusFeature:5637885046816768},CookieWithTruncatingChar:{milestone:103},CrossOriginAccessBasedOnDocumentDomain:{milestone:115},DataUrlInSvgUse:{chromeStatusFeature:5128825141198848,milestone:119},IdentityInCanMakePaymentEvent:{chromeStatusFeature:5190978431352832},InsecurePrivateNetworkSubresourceRequest:{chromeStatusFeature:5436853517811712,milestone:92},LocalCSSFileExtensionRejected:{milestone:64},MediaSourceAbortRemove:{chromeStatusFeature:6107495151960064},MediaSourceDurationTruncatingBuffered:{chromeStatusFeature:6107495151960064},NoSysexWebMIDIWithoutPermission:{chromeStatusFeature:5138066234671104,milestone:82},NotificationPermissionRequestedIframe:{chromeStatusFeature:6451284559265792},ObsoleteCreateImageBitmapImageOrientationNone:{milestone:111},ObsoleteWebRtcCipherSuite:{milestone:81},OverflowVisibleOnReplacedElement:{chromeStatusFeature:5137515594383360,milestone:108},OverrideFlashEmbedwithHTML:{milestone:140},PaymentInstruments:{chromeStatusFeature:5099285054488576},PaymentRequestCSPViolation:{chromeStatusFeature:6286595631087616},PersistentQuotaType:{chromeStatusFeature:5176235376246784,milestone:106},RTCConstraintEnableDtlsSrtpFalse:{milestone:97},RTCConstraintEnableDtlsSrtpTrue:{milestone:97},RTCPeerConnectionGetStatsLegacyNonCompliant:{chromeStatusFeature:4631626228695040,milestone:117},RequestedSubresourceWithEmbeddedCredentials:{chromeStatusFeature:5669008342777856},RtcpMuxPolicyNegotiate:{chromeStatusFeature:5654810086866944,milestone:62},SharedArrayBufferConstructedWithoutIsolation:{milestone:106},TextToSpeech_DisallowedByAutoplay:{chromeStatusFeature:5687444770914304,milestone:71},UnloadHandler:{chromeStatusFeature:5579556305502208},V8SharedArrayBufferConstructedInExtensionWithoutIsolation:{milestone:96},WebBluetoothRemoteCharacteristicWriteValue:{chromeStatusFeature:5088568590598144},XHRJSONEncodingDetection:{milestone:93}},Ye={feature:"Check the feature status page for more details.",milestone:"This change will go into effect with milestone {milestone}.",title:"Deprecated feature used"},Xe=s.i18n.registerUIStrings("models/issues_manager/DeprecationIssue.ts",Ye),Ze=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Xe),et=s.i18n.registerUIStrings("generated/Deprecation.ts",Je),tt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,et);class st extends g{#n;constructor(e,t){super({code:["DeprecationIssue",e.type].join("::"),umaCode:"DeprecationIssue"},t),this.#n=e}getCategory(){return"Other"}details(){return this.#n}getDescription(){let e=()=>"";const t=Je[this.#n.type];t&&(e=tt(t));const s=[],i=Qe[this.#n.type],r=i?.chromeStatusFeature??0;0!==r&&s.push({link:`https://chromestatus.com/feature/${r}`,linkTitle:Ze(Ye.feature)});const n=i?.milestone??0;return 0!==n&&s.push({link:"https://chromiumdash.appspot.com/schedule",linkTitle:Ze(Ye.milestone,{milestone:n})}),S({file:"deprecation.md",substitutions:new Map([["PLACEHOLDER_title",Ze(Ye.title)],["PLACEHOLDER_message",e]]),links:s})}sources(){return this.#n.sourceCodeLocation?[this.#n.sourceCodeLocation]:[]}primaryKey(){return JSON.stringify(this.#n)}getKind(){return"BreakingChange"}static fromInspectorIssue(e,t){const s=t.details.deprecationIssueDetails;return s?[new st(s,e)]:(console.warn("Deprecation issue without details received."),[])}}var it=Object.freeze({__proto__:null,DeprecationIssue:st});class rt extends g{issueDetails;constructor(e,t,s){super(["ElementAccessibilityIssue",e.elementAccessibilityIssueReason].join("::"),t,s),this.issueDetails=e}primaryKey(){return JSON.stringify(this.issueDetails)}getDescription(){if(this.isInteractiveContentAttributesSelectDescendantIssue())return{file:"selectElementAccessibilityInteractiveContentAttributesSelectDescendant.md",links:[]};const e=nt.get(this.issueDetails.elementAccessibilityIssueReason);return e?S(e):null}getKind(){return"PageError"}getCategory(){return"Other"}details(){return this.issueDetails}isInteractiveContentAttributesSelectDescendantIssue(){return this.issueDetails.hasDisallowedAttributes&&"InteractiveContentOptionChild"!==this.issueDetails.elementAccessibilityIssueReason&&"InteractiveContentSummaryDescendant"!==this.issueDetails.elementAccessibilityIssueReason}static fromInspectorIssue(e,t){const s=t.details.elementAccessibilityIssueDetails;return s?[new rt(s,e,t.issueId)]:(console.warn("Element Accessibility issue without details received."),[])}}const nt=new Map([["DisallowedSelectChild",{file:"selectElementAccessibilityDisallowedSelectChild.md",links:[]}],["DisallowedOptGroupChild",{file:"selectElementAccessibilityDisallowedOptGroupChild.md",links:[]}],["NonPhrasingContentOptionChild",{file:"selectElementAccessibilityNonPhrasingContentOptionChild.md",links:[]}],["InteractiveContentOptionChild",{file:"selectElementAccessibilityInteractiveContentOptionChild.md",links:[]}],["InteractiveContentLegendChild",{file:"selectElementAccessibilityInteractiveContentLegendChild.md",links:[]}],["InteractiveContentSummaryDescendant",{file:"summaryElementAccessibilityInteractiveContentSummaryDescendant.md",links:[]}]]);var ot=Object.freeze({__proto__:null,ElementAccessibilityIssue:rt});const at={fedCmUserInfo:"Federated Credential Management User Info API"},ut=s.i18n.registerUIStrings("models/issues_manager/FederatedAuthUserInfoRequestIssue.ts",at),lt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,ut);class dt extends g{#n;constructor(e,t){super({code:"FederatedAuthUserInfoRequestIssue",umaCode:["FederatedAuthUserInfoRequestIssue",e.federatedAuthUserInfoRequestIssueReason].join("::")},t),this.#n=e}getCategory(){return"Other"}details(){return this.#n}getDescription(){const e=ct.get(this.#n.federatedAuthUserInfoRequestIssueReason);return e?S(e):null}primaryKey(){return JSON.stringify(this.#n)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.federatedAuthUserInfoRequestIssueDetails;return s?[new dt(s,e)]:(console.warn("Federated auth user info request issue without details received."),[])}}const ct=new Map([["NotSameOrigin",{file:"federatedAuthUserInfoRequestNotSameOrigin.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["NotIframe",{file:"federatedAuthUserInfoRequestNotIframe.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["NotPotentiallyTrustworthy",{file:"federatedAuthUserInfoRequestNotPotentiallyTrustworthy.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["NoApiPermission",{file:"federatedAuthUserInfoRequestNoApiPermission.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["NotSignedInWithIdp",{file:"federatedAuthUserInfoRequestNotSignedInWithIdp.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["NoAccountSharingPermission",{file:"federatedAuthUserInfoRequestNoAccountSharingPermission.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["InvalidConfigOrWellKnown",{file:"federatedAuthUserInfoRequestInvalidConfigOrWellKnown.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["InvalidAccountsResponse",{file:"federatedAuthUserInfoRequestInvalidAccountsResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}],["NoReturningUserFromFetchedAccounts",{file:"federatedAuthUserInfoRequestNoReturningUserFromFetchedAccounts.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:lt(at.fedCmUserInfo)}]}]]);var gt=Object.freeze({__proto__:null,FederatedAuthUserInfoRequestIssue:dt});const ht={howDoesAutofillWorkPageTitle:"How does autofill work?",labelFormlementsPageTitle:"The label elements",inputFormElementPageTitle:"The form input element",autocompleteAttributePageTitle:"HTML attribute: autocomplete",corbExplainerPageTitle:"CORB explainer"},mt=s.i18n.registerUIStrings("models/issues_manager/GenericIssue.ts",ht),pt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,mt);class It extends g{#n;constructor(e,t,s){super(["GenericIssue",e.errorType].join("::"),t,s),this.#n=e}requests(){return this.#n.request?[this.#n.request]:[]}getCategory(){return"Generic"}primaryKey(){const e=this.#n.request?this.#n.request.requestId:"no-request";return`${this.code()}-(${this.#n.frameId})-(${this.#n.violatingNodeId})-(${this.#n.violatingNodeAttribute})-(${e})`}getDescription(){const e=At.get(this.#n.errorType);return e?S(e):null}details(){return this.#n}getKind(){return Et.get(this.#n.errorType)||"Improvement"}static fromInspectorIssue(e,t){const s=t.details.genericIssueDetails;return s?[new It(s,e,t.issueId)]:(console.warn("Generic issue without details received."),[])}}const ft={file:"genericFormLabelForNameError.md",links:[{link:"https://html.spec.whatwg.org/multipage/forms.html#attr-label-for",linkTitle:s.i18n.lockedLazyString("HTML Standard")}]},kt={file:"genericFormInputWithNoLabelError.md",links:[]},Ct={file:"genericFormAutocompleteAttributeEmptyError.md",links:[]},yt={file:"genericFormDuplicateIdForInputError.md",links:[{link:"https://web.dev/learn/forms/autofill/#how-does-autofill-work",linkTitle:pt(ht.howDoesAutofillWorkPageTitle)}]},St={file:"genericFormAriaLabelledByToNonExistingId.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:pt(ht.labelFormlementsPageTitle)}]},bt={file:"genericFormEmptyIdAndNameAttributesForInputError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input",linkTitle:pt(ht.inputFormElementPageTitle)}]},vt={file:"genericFormInputAssignedAutocompleteValueToIdOrNameAttributeError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values",linkTitle:pt(ht.autocompleteAttributePageTitle)}]},wt={file:"genericFormInputHasWrongButWellIntendedAutocompleteValueError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete#values",linkTitle:pt(ht.autocompleteAttributePageTitle)}]},Dt={file:"genericFormLabelForMatchesNonExistingIdError.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:pt(ht.labelFormlementsPageTitle)}]},Tt={file:"genericFormLabelHasNeitherForNorNestedInput.md",links:[{link:"https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label",linkTitle:pt(ht.labelFormlementsPageTitle)}]},Rt={file:"genericResponseWasBlockedByORB.md",links:[{link:"https://www.chromium.org/Home/chromium-security/corb-for-developers/",linkTitle:pt(ht.corbExplainerPageTitle)}]},At=new Map([["FormLabelForNameError",ft],["FormInputWithNoLabelError",kt],["FormAutocompleteAttributeEmptyError",Ct],["FormDuplicateIdForInputError",yt],["FormAriaLabelledByToNonExistingId",St],["FormEmptyIdAndNameAttributesForInputError",bt],["FormInputAssignedAutocompleteValueToIdOrNameAttributeError",vt],["FormLabelForMatchesNonExistingIdError",Dt],["FormLabelHasNeitherForNorNestedInput",Tt],["FormInputHasWrongButWellIntendedAutocompleteValueError",wt],["ResponseWasBlockedByORB",Rt]]),Et=new Map([["FormLabelForNameError","PageError"],["FormInputWithNoLabelError","Improvement"],["FormAutocompleteAttributeEmptyError","PageError"],["FormDuplicateIdForInputError","PageError"],["FormAriaLabelledByToNonExistingId","Improvement"],["FormEmptyIdAndNameAttributesForInputError","Improvement"],["FormInputAssignedAutocompleteValueToIdOrNameAttributeError","Improvement"],["FormLabelForMatchesNonExistingIdError","PageError"],["FormLabelHasNeitherForNorNestedInput","Improvement"],["FormInputHasWrongButWellIntendedAutocompleteValueError","Improvement"]]);var Pt=Object.freeze({__proto__:null,GenericIssue:It,genericFormAriaLabelledByToNonExistingId:St,genericFormAutocompleteAttributeEmptyError:Ct,genericFormDuplicateIdForInputError:yt,genericFormEmptyIdAndNameAttributesForInputError:bt,genericFormInputAssignedAutocompleteValueToIdOrNameAttributeError:vt,genericFormInputHasWrongButWellIntendedAutocompleteValue:wt,genericFormInputWithNoLabelError:kt,genericFormLabelForMatchesNonExistingIdError:Dt,genericFormLabelForNameError:ft,genericFormLabelHasNeitherForNorNestedInput:Tt,genericResponseWasBlockedbyORB:Rt});const Mt={handlingHeavyAdInterventions:"Handling Heavy Ad Interventions"},Nt=s.i18n.registerUIStrings("models/issues_manager/HeavyAdIssue.ts",Mt),Ft=s.i18n.getLocalizedString.bind(void 0,Nt);class Lt extends g{#n;constructor(e,t){super({code:"HeavyAdIssue",umaCode:["HeavyAdIssue",e.reason].join("::")},t),this.#n=e}details(){return this.#n}primaryKey(){return`HeavyAdIssue-${JSON.stringify(this.#n)}`}getDescription(){return{file:"heavyAd.md",links:[{link:"https://developers.google.com/web/updates/2020/05/heavy-ad-interventions",linkTitle:Ft(Mt.handlingHeavyAdInterventions)}]}}getCategory(){return"HeavyAd"}getKind(){switch(this.#n.resolution){case"HeavyAdBlocked":return"PageError";case"HeavyAdWarning":return"BreakingChange"}}static fromInspectorIssue(e,t){const s=t.details.heavyAdIssueDetails;return s?[new Lt(s,e)]:(console.warn("Heavy Ad issue without details received."),[])}}var Ot=Object.freeze({__proto__:null,HeavyAdIssue:Lt});const xt={bounceTrackingMitigations:"Bounce tracking mitigations"},Wt=s.i18n.registerUIStrings("models/issues_manager/BounceTrackingIssue.ts",xt),Ut=s.i18n.getLocalizedString.bind(void 0,Wt);class Ht extends g{#n;constructor(e,t){super("BounceTrackingIssue",t),this.#n=e}getCategory(){return"Other"}getDescription(){return{file:"bounceTrackingMitigations.md",links:[{link:"https://privacycg.github.io/nav-tracking-mitigations/#bounce-tracking-mitigations",linkTitle:Ut(xt.bounceTrackingMitigations)}]}}details(){return this.#n}getKind(){return"BreakingChange"}primaryKey(){return JSON.stringify(this.#n)}trackingSites(){return this.#n.trackingSites?this.#n.trackingSites:[]}static fromInspectorIssue(e,t){const s=t.details.bounceTrackingIssueDetails;return s?[new Ht(s,e)]:(console.warn("Bounce tracking issue without details received."),[])}}const _t={fedCm:"Federated Credential Management API"},qt=s.i18n.registerUIStrings("models/issues_manager/FederatedAuthRequestIssue.ts",_t),Bt=s.i18n.getLazilyComputedLocalizedString.bind(void 0,qt);class zt extends g{#n;constructor(e,t){super({code:"FederatedAuthRequestIssue",umaCode:["FederatedAuthRequestIssue",e.federatedAuthRequestIssueReason].join("::")},t),this.#n=e}getCategory(){return"Other"}details(){return this.#n}getDescription(){const e=Vt.get(this.#n.federatedAuthRequestIssueReason);return e?S(e):null}primaryKey(){return JSON.stringify(this.#n)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.federatedAuthRequestIssueDetails;return s?[new zt(s,e)]:(console.warn("Federated auth request issue without details received."),[])}}const Vt=new Map([["TooManyRequests",{file:"federatedAuthRequestTooManyRequests.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ConfigHttpNotFound",{file:"federatedAuthRequestManifestHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ConfigNoResponse",{file:"federatedAuthRequestManifestNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ConfigInvalidResponse",{file:"federatedAuthRequestManifestInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ClientMetadataHttpNotFound",{file:"federatedAuthRequestClientMetadataHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ClientMetadataNoResponse",{file:"federatedAuthRequestClientMetadataNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ClientMetadataInvalidResponse",{file:"federatedAuthRequestClientMetadataInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ErrorFetchingSignin",{file:"federatedAuthRequestErrorFetchingSignin.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["InvalidSigninResponse",{file:"federatedAuthRequestInvalidSigninResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["AccountsHttpNotFound",{file:"federatedAuthRequestAccountsHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["AccountsNoResponse",{file:"federatedAuthRequestAccountsNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["AccountsInvalidResponse",{file:"federatedAuthRequestAccountsInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["IdTokenHttpNotFound",{file:"federatedAuthRequestIdTokenHttpNotFound.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["IdTokenNoResponse",{file:"federatedAuthRequestIdTokenNoResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["IdTokenInvalidResponse",{file:"federatedAuthRequestIdTokenInvalidResponse.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["IdTokenInvalidRequest",{file:"federatedAuthRequestIdTokenInvalidRequest.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["ErrorIdToken",{file:"federatedAuthRequestErrorIdToken.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}],["Canceled",{file:"federatedAuthRequestCanceled.md",links:[{link:"https://fedidcg.github.io/FedCM/",linkTitle:Bt(_t.fedCm)}]}]]),jt={colorAndContrastAccessibility:"Color and contrast accessibility"},Kt=s.i18n.registerUIStrings("models/issues_manager/LowTextContrastIssue.ts",jt),$t=s.i18n.getLocalizedString.bind(void 0,Kt);class Gt extends g{#n;constructor(e,t){super("LowTextContrastIssue",t),this.#n=e}primaryKey(){return`${this.code()}-(${this.#n.violatingNodeId})`}getCategory(){return"LowTextContrast"}details(){return this.#n}getDescription(){return{file:"LowTextContrast.md",links:[{link:"https://web.dev/color-and-contrast-accessibility/",linkTitle:$t(jt.colorAndContrastAccessibility)}]}}getKind(){return"Improvement"}static fromInspectorIssue(e,t){const s=t.details.lowTextContrastIssueDetails;return s?[new Gt(s,e)]:(console.warn("LowTextContrast issue without details received."),[])}}var Jt=Object.freeze({__proto__:null,LowTextContrastIssue:Gt});const Qt={preventingMixedContent:"Preventing mixed content"},Yt=s.i18n.registerUIStrings("models/issues_manager/MixedContentIssue.ts",Qt),Xt=s.i18n.getLocalizedString.bind(void 0,Yt);class Zt extends g{#n;constructor(e,t){super("MixedContentIssue",t),this.#n=e}requests(){return this.#n.request?[this.#n.request]:[]}getDetails(){return this.#n}getCategory(){return"MixedContent"}getDescription(){return{file:"mixedContent.md",links:[{link:"https://web.dev/what-is-mixed-content/",linkTitle:Xt(Qt.preventingMixedContent)}]}}primaryKey(){return JSON.stringify(this.#n)}getKind(){switch(this.#n.resolutionStatus){case"MixedContentAutomaticallyUpgraded":case"MixedContentWarning":return"Improvement";case"MixedContentBlocked":return"PageError"}}static fromInspectorIssue(e,t){const s=t.details.mixedContentIssueDetails;return s?[new Zt(s,e)]:(console.warn("Mixed content issue without details received."),[])}}var es=Object.freeze({__proto__:null,MixedContentIssue:Zt});const ts={partitioningBlobURL:"Partitioning BlobURL",chromeStatusEntry:"Chrome Status Entry"},ss=s.i18n.registerUIStrings("models/issues_manager/PartitioningBlobURLIssue.ts",ts),is=s.i18n.getLocalizedString.bind(void 0,ss);class rs extends g{#n;constructor(e,t){super("PartitioningBlobURLIssue",t),this.#n=e}getCategory(){return"Other"}getDescription(){return{file:"BlockedCrossPartitionFetching"===this.#n.partitioningBlobURLInfo?"fetchingPartitionedBlobURL.md":"navigatingPartitionedBlobURL.md",links:[{link:"https://developers.google.com/privacy-sandbox/cookies/storage-partitioning",linkTitle:is(ts.partitioningBlobURL)},{link:"https://chromestatus.com/feature/5130361898795008",linkTitle:is(ts.chromeStatusEntry)}]}}details(){return this.#n}getKind(){return"BreakingChange"}primaryKey(){return JSON.stringify(this.#n)}static fromInspectorIssue(e,t){const s=t.details.partitioningBlobURLIssueDetails;return s?[new rs(s,e)]:(console.warn("Partitioning BlobURL issue without details received."),[])}}var ns=Object.freeze({__proto__:null,PartitioningBlobURLIssue:rs});class os extends g{#n;#d;constructor(e,t){const s=JSON.stringify(e);super(s,t),this.#d=s,this.#n=e}sources(){return[this.#n.sourceCodeLocation]}details(){return this.#n}primaryKey(){return this.#d}getPropertyName(){switch(this.#n.propertyRuleIssueReason){case"InvalidInherits":return"inherits";case"InvalidInitialValue":return"initial-value";case"InvalidSyntax":return"syntax"}return""}getDescription(){if("InvalidName"===this.#n.propertyRuleIssueReason)return{file:"propertyRuleInvalidNameIssue.md",links:[]};const e=this.#n.propertyValue?`: ${this.#n.propertyValue}`:"",t=`${this.getPropertyName()}${e}`;return{file:"propertyRuleIssue.md",substitutions:new Map([["PLACEHOLDER_property",t]]),links:[]}}getCategory(){return"Other"}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.propertyRuleIssueDetails;return s?[new os(s,e)]:(console.warn("Property rule issue without details received"),[])}}var as=Object.freeze({__proto__:null,PropertyRuleIssue:os});const us={documentCompatibilityMode:"Document compatibility mode"},ls=s.i18n.registerUIStrings("models/issues_manager/QuirksModeIssue.ts",us),ds=s.i18n.getLocalizedString.bind(void 0,ls);class cs extends g{#n;constructor(e,t){super({code:"QuirksModeIssue",umaCode:["QuirksModeIssue",e.isLimitedQuirksMode?"LimitedQuirksMode":"QuirksMode"].join("::")},t),this.#n=e}primaryKey(){return`${this.code()}-(${this.#n.documentNodeId})-(${this.#n.url})`}getCategory(){return"QuirksMode"}details(){return this.#n}getDescription(){return{file:"CompatibilityModeQuirks.md",links:[{link:"https://web.dev/doctype/",linkTitle:ds(us.documentCompatibilityMode)}]}}getKind(){return"Improvement"}static fromInspectorIssue(e,t){const s=t.details.quirksModeIssueDetails;return s?[new cs(s,e)]:(console.warn("Quirks Mode issue without details received."),[])}}var gs=Object.freeze({__proto__:null,QuirksModeIssue:cs});const hs={enablingSharedArrayBuffer:"Enabling `SharedArrayBuffer`"},ms=s.i18n.registerUIStrings("models/issues_manager/SharedArrayBufferIssue.ts",hs),ps=s.i18n.getLocalizedString.bind(void 0,ms);class Is extends g{#n;constructor(e,t){super({code:"SharedArrayBufferIssue",umaCode:["SharedArrayBufferIssue",e.type].join("::")},t),this.#n=e}getCategory(){return"Other"}details(){return this.#n}getDescription(){return{file:"sharedArrayBuffer.md",links:[{link:"https://developer.chrome.com/blog/enabling-shared-array-buffer/",linkTitle:ps(hs.enablingSharedArrayBuffer)}]}}primaryKey(){return JSON.stringify(this.#n)}getKind(){return this.#n.isWarning?"BreakingChange":"PageError"}static fromInspectorIssue(e,t){const s=t.details.sharedArrayBufferIssueDetails;return s?[new Is(s,e)]:(console.warn("SAB transfer issue without details received."),[])}}var fs=Object.freeze({__proto__:null,SharedArrayBufferIssue:Is});const ks={compressionDictionaryTransport:"Compression Dictionary Transport"},Cs=s.i18n.registerUIStrings("models/issues_manager/SharedDictionaryIssue.ts",ks),ys=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Cs);function Ss(e){switch(e.sharedDictionaryError){case"UseErrorCrossOriginNoCorsRequest":return"SharedDictionaryIssue::UseErrorCrossOriginNoCorsRequest";case"UseErrorDictionaryLoadFailure":return"SharedDictionaryIssue::UseErrorDictionaryLoadFailure";case"UseErrorMatchingDictionaryNotUsed":return"SharedDictionaryIssue::UseErrorMatchingDictionaryNotUsed";case"UseErrorUnexpectedContentDictionaryHeader":return"SharedDictionaryIssue::UseErrorUnexpectedContentDictionaryHeader";case"WriteErrorCossOriginNoCorsRequest":return"SharedDictionaryIssue::WriteErrorCossOriginNoCorsRequest";case"WriteErrorDisallowedBySettings":return"SharedDictionaryIssue::WriteErrorDisallowedBySettings";case"WriteErrorExpiredResponse":return"SharedDictionaryIssue::WriteErrorExpiredResponse";case"WriteErrorFeatureDisabled":return"SharedDictionaryIssue::WriteErrorFeatureDisabled";case"WriteErrorInsufficientResources":return"SharedDictionaryIssue::WriteErrorInsufficientResources";case"WriteErrorInvalidMatchField":return"SharedDictionaryIssue::WriteErrorInvalidMatchField";case"WriteErrorInvalidStructuredHeader":return"SharedDictionaryIssue::WriteErrorInvalidStructuredHeader";case"WriteErrorInvalidTTLField":return"SharedDictionaryIssue::WriteErrorInvalidTTLField";case"WriteErrorNavigationRequest":return"SharedDictionaryIssue::WriteErrorNavigationRequest";case"WriteErrorNoMatchField":return"SharedDictionaryIssue::WriteErrorNoMatchField";case"WriteErrorNonIntegerTTLField":return"SharedDictionaryIssue::WriteErrorNonIntegerTTLField";case"WriteErrorNonListMatchDestField":return"SharedDictionaryIssue::WriteErrorNonListMatchDestField";case"WriteErrorNonSecureContext":return"SharedDictionaryIssue::WriteErrorNonSecureContext";case"WriteErrorNonStringIdField":return"SharedDictionaryIssue::WriteErrorNonStringIdField";case"WriteErrorNonStringInMatchDestList":return"SharedDictionaryIssue::WriteErrorNonStringInMatchDestList";case"WriteErrorNonStringMatchField":return"SharedDictionaryIssue::WriteErrorNonStringMatchField";case"WriteErrorNonTokenTypeField":return"SharedDictionaryIssue::WriteErrorNonTokenTypeField";case"WriteErrorRequestAborted":return"SharedDictionaryIssue::WriteErrorRequestAborted";case"WriteErrorShuttingDown":return"SharedDictionaryIssue::WriteErrorShuttingDown";case"WriteErrorTooLongIdField":return"SharedDictionaryIssue::WriteErrorTooLongIdField";case"WriteErrorUnsupportedType":return"SharedDictionaryIssue::WriteErrorUnsupportedType";default:return"SharedDictionaryIssue::WriteErrorUnknown"}}class bs extends g{#n;constructor(e,t){super({code:Ss(e),umaCode:["SharedDictionaryIssue",e.sharedDictionaryError].join("::")},t),this.#n=e}requests(){return this.#n.request?[this.#n.request]:[]}getCategory(){return"Other"}details(){return this.#n}getDescription(){const e=ws.get(this.#n.sharedDictionaryError);return e?S(e):null}primaryKey(){return JSON.stringify(this.#n)}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.sharedDictionaryIssueDetails;return s?[new bs(s,e)]:(console.warn("Shared Dictionary issue without details received."),[])}}const vs=[{link:"https://datatracker.ietf.org/doc/draft-ietf-httpbis-compression-dictionary/",linkTitle:ys(ks.compressionDictionaryTransport)}],ws=new Map([["UseErrorCrossOriginNoCorsRequest",{file:"sharedDictionaryUseErrorCrossOriginNoCorsRequest.md",links:vs}],["UseErrorDictionaryLoadFailure",{file:"sharedDictionaryUseErrorDictionaryLoadFailure.md",links:vs}],["UseErrorMatchingDictionaryNotUsed",{file:"sharedDictionaryUseErrorMatchingDictionaryNotUsed.md",links:vs}],["UseErrorUnexpectedContentDictionaryHeader",{file:"sharedDictionaryUseErrorUnexpectedContentDictionaryHeader.md",links:vs}],["WriteErrorCossOriginNoCorsRequest",{file:"sharedDictionaryWriteErrorCossOriginNoCorsRequest.md",links:vs}],["WriteErrorDisallowedBySettings",{file:"sharedDictionaryWriteErrorDisallowedBySettings.md",links:vs}],["WriteErrorExpiredResponse",{file:"sharedDictionaryWriteErrorExpiredResponse.md",links:vs}],["WriteErrorFeatureDisabled",{file:"sharedDictionaryWriteErrorFeatureDisabled.md",links:vs}],["WriteErrorInsufficientResources",{file:"sharedDictionaryWriteErrorInsufficientResources.md",links:vs}],["WriteErrorInvalidMatchField",{file:"sharedDictionaryWriteErrorInvalidMatchField.md",links:vs}],["WriteErrorInvalidStructuredHeader",{file:"sharedDictionaryWriteErrorInvalidStructuredHeader.md",links:vs}],["WriteErrorInvalidTTLField",{file:"sharedDictionaryWriteErrorInvalidTTLField.md",links:vs}],["WriteErrorNavigationRequest",{file:"sharedDictionaryWriteErrorNavigationRequest.md",links:vs}],["WriteErrorNoMatchField",{file:"sharedDictionaryWriteErrorNoMatchField.md",links:vs}],["WriteErrorNonIntegerTTLField",{file:"sharedDictionaryWriteErrorNonIntegerTTLField.md",links:vs}],["WriteErrorNonListMatchDestField",{file:"sharedDictionaryWriteErrorNonListMatchDestField.md",links:vs}],["WriteErrorNonSecureContext",{file:"sharedDictionaryWriteErrorNonSecureContext.md",links:vs}],["WriteErrorNonStringIdField",{file:"sharedDictionaryWriteErrorNonStringIdField.md",links:vs}],["WriteErrorNonStringInMatchDestList",{file:"sharedDictionaryWriteErrorNonStringInMatchDestList.md",links:vs}],["WriteErrorNonStringMatchField",{file:"sharedDictionaryWriteErrorNonStringMatchField.md",links:vs}],["WriteErrorNonTokenTypeField",{file:"sharedDictionaryWriteErrorNonTokenTypeField.md",links:vs}],["WriteErrorRequestAborted",{file:"sharedDictionaryWriteErrorRequestAborted.md",links:vs}],["WriteErrorShuttingDown",{file:"sharedDictionaryWriteErrorShuttingDown.md",links:vs}],["WriteErrorTooLongIdField",{file:"sharedDictionaryWriteErrorTooLongIdField.md",links:vs}],["WriteErrorUnsupportedType",{file:"sharedDictionaryWriteErrorUnsupportedType.md",links:vs}]]);var Ds=Object.freeze({__proto__:null,SharedDictionaryIssue:bs});const Ts=["StylesheetLoadingIssue","LateImportRule"].join("::");class Rs extends g{#n;constructor(e,t){super(`StylesheetLoadingIssue::${e.styleSheetLoadingIssueReason}`,t),this.#n=e}sources(){return[this.#n.sourceCodeLocation]}requests(){if(!this.#n.failedRequestInfo)return[];const{url:e,requestId:t}=this.#n.failedRequestInfo;return t?[{url:e,requestId:t}]:[]}details(){return this.#n}primaryKey(){return JSON.stringify(this.#n)}getDescription(){switch(this.#n.styleSheetLoadingIssueReason){case"LateImportRule":return{file:"stylesheetLateImport.md",links:[]};case"RequestFailed":return{file:"stylesheetRequestFailed.md",links:[]}}}getCategory(){return"Other"}getKind(){return"PageError"}static fromInspectorIssue(e,t){const s=t.details.stylesheetLoadingIssueDetails;return s?[new Rs(s,e)]:(console.warn("Stylesheet loading issue without details received"),[])}}var As=Object.freeze({__proto__:null,StylesheetLoadingIssue:Rs,lateImportStylesheetLoadingCode:Ts});class Es{issuesManager;#c=new a.PresentationConsoleMessageHelper.PresentationSourceFrameMessageManager;constructor(e){this.issuesManager=e,this.issuesManager.addEventListener("IssueAdded",this.#g,this),this.issuesManager.addEventListener("FullUpdateRequired",this.#h,this)}#g(e){const{issue:t}=e.data;this.#m(t)}async#m(t){if(!this.#p(t)&&!this.#I(t)&&!this.#f(t))return;const s=t.model();if(!s)return;const i=h(t.details().sourceCodeLocation),r=t.getDescription();if(!r||!i)return;const n=await E(r);if(!n)return;this.#c.addMessage(new Ps(n,t.getKind(),()=>{e.Revealer.reveal(t)}),{line:i.lineNumber,column:i.columnNumber??-1,url:i.url,scriptId:i.scriptId},s.target())}#h(){this.#k();const e=this.issuesManager.issues();for(const t of e)this.#m(t)}#p(e){return e instanceof _&&e.code()===J||e.code()===Q}#f(e){return e instanceof os}#I(e){return e.code()===Ts}#k(){this.#c.clear()}}class Ps extends u.UISourceCode.Message{#C;constructor(e,t,s){super("Issue",e,s),this.#C=t}getIssueKind(){return this.#C}}var Ms=Object.freeze({__proto__:null,IssueMessage:Ps,SourceFrameIssuesManager:Es});const Ns={httpMessageSignatures:"HTTP Message Signatures (RFC9421)",signatureBasedIntegrity:"Signature-based Integrity"},Fs=s.i18n.registerUIStrings("models/issues_manager/SRIMessageSignatureIssue.ts",Ns),Ls=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Fs);function Os(e){const t=`SRIMessageSignatureIssue::${e.error}`;return"ValidationFailedSignatureMismatch"===e.error?t+e.signatureBase:"ValidationFailedIntegrityMismatch"===e.error?t+e.integrityAssertions.join():t}class xs extends g{#n;constructor(e,t){super({code:Os(e),umaCode:`SRIMessageSignatureIssue::${e.error}`},t),this.#n=e}details(){return this.#n}primaryKey(){return JSON.stringify(this.details())}getDescription(){const e={file:`sri${this.details().error}.md`,links:[{link:"https://www.rfc-editor.org/rfc/rfc9421.html",linkTitle:Ls(Ns.httpMessageSignatures)},{link:"https://wicg.github.io/signature-based-sri/",linkTitle:Ls(Ns.signatureBasedIntegrity)}],substitutions:new Map};return"ValidationFailedSignatureMismatch"===this.#n.error&&e.substitutions?.set("PLACEHOLDER_signatureBase",()=>this.#n.signatureBase),"ValidationFailedIntegrityMismatch"===this.#n.error&&e.substitutions?.set("PLACEHOLDER_integrityAssertions",()=>"\n* "+this.details().integrityAssertions.join("\n* ")),S(e)}getCategory(){return"Other"}getKind(){return"PageError"}requests(){return this.details().request?[this.details().request]:[]}static fromInspectorIssue(e,t){const s=t.details.sriMessageSignatureIssueDetails;return s?[new xs(s,e)]:(console.warn("SRI Message Signature issue without details received."),[])}}var Ws=Object.freeze({__proto__:null,SRIMessageSignatureIssue:xs});const Us={unencodedDigestHeader:"HTTP Unencoded Digest specification",integrityIntegration:"Server-Initiated Integrity Checks"},Hs=s.i18n.registerUIStrings("models/issues_manager/UnencodedDigestIssue.ts",Us),_s=s.i18n.getLazilyComputedLocalizedString.bind(void 0,Hs);class qs extends g{#n;constructor(e,t){super({code:`UnencodedDigestIssue::${e.error}`,umaCode:`UnencodedDigestIssue::${e.error}`},t),this.#n=e}details(){return this.#n}primaryKey(){return JSON.stringify(this.details())}getDescription(){return S({file:`unencodedDigest${this.details().error}.md`,links:[{link:"https://www.ietf.org/archive/id/draft-ietf-httpbis-unencoded-digest-01.html",linkTitle:_s(Us.unencodedDigestHeader)},{link:"https://wicg.github.io/signature-based-sri/#unencoded-digest-validation",linkTitle:_s(Us.integrityIntegration)}]})}getCategory(){return"Other"}getKind(){return"PageError"}requests(){return this.details().request?[this.details().request]:[]}static fromInspectorIssue(e,t){const s=t.details.unencodedDigestIssueDetails;return s?[new qs(s,e)]:(console.warn("Unencoded-Digest issue without details received."),[])}}var Bs=Object.freeze({__proto__:null,UnencodedDigestIssue:qs});class zs extends g{#n;constructor(e,t){super("UserReidentificationIssue",t),this.#n=e}primaryKey(){const e=this.#n.request?this.#n.request.requestId:"no-request";return`${this.code()}-(${e})`}requests(){return this.#n.request?[this.#n.request]:[]}getCategory(){return"Other"}getDescription(){const e=Vs.get(this.code());return e?S(e):null}getKind(){return"Improvement"}static fromInspectorIssue(e,t){const s=t.details.userReidentificationIssueDetails;return s?[new zs(s,e)]:(console.warn("User Reidentification issue without details received."),[])}}const Vs=new Map([["UserReidentificationIssue",{file:"userReidentificationBlocked.md",links:[]}]]);let js=null;const Ks=new Map([["CookieIssue",de.fromInspectorIssue],["MixedContentIssue",Zt.fromInspectorIssue],["HeavyAdIssue",Lt.fromInspectorIssue],["ContentSecurityPolicyIssue",_.fromInspectorIssue],["BlockedByResponseIssue",function(e,t){const s=t.details.blockedByResponseIssueDetails;return s?je(s.reason)?[new Ke(s,e)]:[]:(console.warn("BlockedByResponse issue without details received."),[])}],["SharedArrayBufferIssue",Is.fromInspectorIssue],["SharedDictionaryIssue",bs.fromInspectorIssue],["LowTextContrastIssue",Gt.fromInspectorIssue],["CorsIssue",_e.fromInspectorIssue],["QuirksModeIssue",cs.fromInspectorIssue],["AttributionReportingIssue",I.fromInspectorIssue],["GenericIssue",It.fromInspectorIssue],["DeprecationIssue",st.fromInspectorIssue],["ClientHintIssue",L.fromInspectorIssue],["FederatedAuthRequestIssue",zt.fromInspectorIssue],["BounceTrackingIssue",Ht.fromInspectorIssue],["StylesheetLoadingIssue",Rs.fromInspectorIssue],["PartitioningBlobURLIssue",rs.fromInspectorIssue],["PropertyRuleIssue",os.fromInspectorIssue],["CookieDeprecationMetadataIssue",ne.fromInspectorIssue],["ElementAccessibilityIssue",rt.fromInspectorIssue],["SRIMessageSignatureIssue",xs.fromInspectorIssue],["UnencodedDigestIssue",qs.fromInspectorIssue],["UserReidentificationIssue",zs.fromInspectorIssue]]);function $s(e,t){const s=Ks.get(t.code);return s?s(e,t):(console.warn(`No handler registered for issue code ${t.code}`),[])}function Gs(){return{}}class Js extends e.ObjectWrapper.ObjectWrapper{showThirdPartyIssuesSetting;hideIssueSetting;#y=new WeakMap;#S=new Map;#b=new Map;#v=new Map;#w=new Map;#D=new Map;#T=new Map;#R=new Map;#A=!1;constructor(e,t){super(),this.showThirdPartyIssuesSetting=e,this.hideIssueSetting=t,new Es(this),i.TargetManager.TargetManager.instance().observeModels(i.IssuesModel.IssuesModel,this),i.TargetManager.TargetManager.instance().addModelListener(i.ResourceTreeModel.ResourceTreeModel,i.ResourceTreeModel.Events.PrimaryPageChanged,this.#E,this),i.FrameManager.FrameManager.instance().addEventListener("FrameAddedToTarget",this.#P,this),this.showThirdPartyIssuesSetting?.addChangeListener(()=>this.#M()),this.hideIssueSetting?.addChangeListener(()=>this.#M()),i.TargetManager.TargetManager.instance().observeTargets({targetAdded:e=>{e.outermostTarget()===e&&this.#M()},targetRemoved:e=>{}},{scoped:!0})}static instance(e={forceNew:!1,ensureFirst:!1}){if(js&&e.ensureFirst)throw new Error('IssuesManager was already created. Either set "ensureFirst" to false or make sure that this invocation is really the first one.');return js&&!e.forceNew||(js=new Js(e.showThirdPartyIssuesSetting,e.hideIssueSetting)),js}static removeInstance(){js=null}#E(e){const{frame:t,type:s}=e.data,r=new Map;for(const[e,n]of this.#S.entries())if(n.isAssociatedWithRequestId(t.loaderId))r.set(e,n);else if("Activation"===s&&t.resourceTreeModel().target()===n.model()?.target())r.set(e,n);else if("BounceTrackingIssue"===n.code()||"CookieIssue"===n.code()){const s=t.resourceTreeModel().target().model(i.NetworkManager.NetworkManager);!1===s?.requestForLoaderId(t.loaderId)?.hasUserGesture()&&r.set(e,n)}this.#S=r,this.#M()}#P(e){const{frame:t}=e.data;t.isOutermostFrame()&&i.TargetManager.TargetManager.instance().isInScope(t.resourceTreeModel())&&this.#M()}modelAdded(e){const t=e.addEventListener("IssueAdded",this.#N,this);this.#y.set(e,t)}modelRemoved(t){const s=this.#y.get(t);s&&e.EventTarget.removeEventListeners([s])}#N(e){const{issuesModel:t,inspectorIssue:s}=e.data,r=n.Runtime.hostConfig.devToolsPrivacyUI?.enabled,o=$s(t,s);for(const e of o){this.addIssue(t,e);const s=e.maybeCreateConsoleMessage();if(!s)continue;const n="ThirdPartyPhaseoutCookie"===de.getSubCategory(e.code());n&&r&&this.#A||t.target().model(i.ConsoleModel.ConsoleModel)?.addMessage(s),n&&r&&(this.#A=!0)}}addIssue(e,t){if(!t.getDescription())return;const s=t.primaryKey();if(this.#S.has(s))return;this.#S.set(s,t);const i=e.target().outermostTarget();if(i){let e=this.#R.get(i);e||(e=new Set,this.#R.set(i,e)),e.add(t)}if(this.#F(t)){this.#b.set(s,t),this.#v.set(t.getKind(),1+(this.#v.get(t.getKind())||0));const i=t.getIssueId();i&&this.#T.set(i,t);const r=this.hideIssueSetting?.get();this.#L(t,r),de.isThirdPartyCookiePhaseoutRelatedIssue(t)?this.#D.set(t.getKind(),1+(this.#D.get(t.getKind())||0)):t.isHidden()&&this.#w.set(t.getKind(),1+(this.#w.get(t.getKind())||0)),this.dispatchEventToListeners("IssueAdded",{issuesModel:e,issue:t})}this.dispatchEventToListeners("IssuesCountUpdated")}issues(){return this.#b.values()}numberOfIssues(e){return e?(this.#v.get(e)??0)-this.numberOfHiddenIssues(e)-this.numberOfThirdPartyCookiePhaseoutIssues(e):this.#b.size-this.numberOfHiddenIssues()-this.numberOfThirdPartyCookiePhaseoutIssues()}numberOfHiddenIssues(e){if(e)return this.#w.get(e)??0;let t=0;for(const e of this.#w.values())t+=e;return t}numberOfThirdPartyCookiePhaseoutIssues(e){if(e)return this.#D.get(e)??0;let t=0;for(const e of this.#D.values())t+=e;return t}numberOfAllStoredIssues(){return this.#S.size}#F(e){const t=i.TargetManager.TargetManager.instance().scopeTarget();return!!t&&(!!this.#R.get(t)?.has(e)&&(this.showThirdPartyIssuesSetting?.get()||!e.isCausedByThirdParty()))}#L(e,t){const s=e.code();if(t?.[s])return"Hidden"===t[s]?void e.setHidden(!0):void e.setHidden(!1)}#M(){this.#b.clear(),this.#v.clear(),this.#T.clear(),this.#w.clear(),this.#D.clear(),this.#A=!1;const e=this.hideIssueSetting?.get();for(const[t,s]of this.#S)if(this.#F(s)){this.#L(s,e),this.#b.set(t,s),this.#v.set(s.getKind(),1+(this.#v.get(s.getKind())??0)),s.isHidden()&&this.#w.set(s.getKind(),1+(this.#w.get(s.getKind())||0));const i=s.getIssueId();i&&this.#T.set(i,s)}this.dispatchEventToListeners("FullUpdateRequired"),this.dispatchEventToListeners("IssuesCountUpdated")}unhideAllIssues(){for(const e of this.#S.values())e.setHidden(!1);this.hideIssueSetting?.set({})}getIssueById(e){return this.#T.get(e)}}globalThis.addIssueForTest=e=>{const t=i.TargetManager.TargetManager.instance().primaryPageTarget(),s=t?.model(i.IssuesModel.IssuesModel);s?.issueAdded({issue:e})};var Qs=Object.freeze({__proto__:null,IssuesManager:Js,createIssuesFromProtocolIssue:$s,defaultHideIssueByCodeSetting:Gs,getHideIssueByCodeSetting:function(){return e.Settings.Settings.instance().createSetting("hide-issue-by-code-setting-experiment-2021",{})}});class Ys extends e.ResolverBase.ResolverBase{#O=null;#x;constructor(e=Js.instance()){super(),this.#x=e}getForId(e){return this.#x.getIssueById(e)||null}#g(e){const{issue:t}=e.data,s=t.getIssueId();s&&this.onResolve(s,t)}startListening(){this.#O||(this.#O=this.#x.addEventListener("IssueAdded",this.#g,this))}stopListening(){this.#O&&(e.EventTarget.removeEventListeners([this.#O]),this.#O=null)}}var Xs=Object.freeze({__proto__:null,IssueResolver:Ys});function Zs(e,t){if(t instanceof i.NetworkRequest.NetworkRequest)return function(e,t){return e.filter(e=>{for(const s of e.requests())if(s.requestId===t.requestId())return!0;return!1})}(e,t);if(t instanceof i.Cookie.Cookie)return function(e,t,s,i){return e.filter(e=>{for(const r of e.cookies())if(r.domain===t&&r.name===s&&r.path===i)return!0;return!1})}(e,t.domain(),t.name(),t.path());throw new Error(`issues can not be associated with ${JSON.stringify(t)}`)}var ei=Object.freeze({__proto__:null,hasIssueOfCategory:function(e,t){return Zs(Array.from(Js.instance().issues()),e).some(e=>e.getCategory()===t)},hasIssues:function(e){return Zs(Array.from(Js.instance().issues()),e).length>0},hasThirdPartyPhaseoutCookieIssue:function(e){return Zs(Array.from(Js.instance().issues()),e).some(e=>"ThirdPartyPhaseoutCookie"===de.getSubCategory(e.code()))},hasThirdPartyPhaseoutCookieIssueForDomain:function(e){return Array.from(Js.instance().issues()).filter(t=>Array.from(t.cookies()).some(t=>t.domain===e)).some(e=>"ThirdPartyPhaseoutCookie"===de.getSubCategory(e.code()))},issuesAssociatedWith:Zs,reveal:async function(t,s){if("string"==typeof t){const s=Js.instance().getIssueById(t);if(s)return await e.Revealer.reveal(s)}const i=Zs(Array.from(Js.instance().issues()),t).filter(e=>!s||e.getCategory()===s);if(i.length>0)return await e.Revealer.reveal(i[0])}});export{f as AttributionReportingIssue,y as CheckFormsIssuesTrigger,x as ClientHintIssue,X as ContentSecurityPolicyIssue,te as ContrastCheckTrigger,oe as CookieDeprecationMetadataIssue,Oe as CookieIssue,qe as CorsIssue,Ge as CrossOriginEmbedderPolicyIssue,it as DeprecationIssue,ot as ElementAccessibilityIssue,gt as FederatedAuthUserInfoRequestIssue,Pt as GenericIssue,Ot as HeavyAdIssue,m as Issue,Xs as IssueResolver,Qs as IssuesManager,Jt as LowTextContrastIssue,P as MarkdownIssueDescription,es as MixedContentIssue,ns as PartitioningBlobURLIssue,as as PropertyRuleIssue,gs as QuirksModeIssue,ei as RelatedIssue,Ws as SRIMessageSignatureIssue,fs as SharedArrayBufferIssue,Ds as SharedDictionaryIssue,Ms as SourceFrameIssuesManager,As as StylesheetLoadingIssue,Bs as UnencodedDigestIssue};
//# sourceMappingURL=issues_manager.js.map
