// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/internal_runtime_flags.h.tmpl
// and input files:
//   ../../third_party/blink/renderer/platform/runtime_enabled_features.json5


#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_TESTING_INTERNAL_RUNTIME_FLAGS_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_TESTING_INTERNAL_RUNTIME_FLAGS_H_

#include "third_party/blink/renderer/platform/bindings/script_wrappable.h"
#include "third_party/blink/renderer/platform/heap/garbage_collected.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"
#include "base/memory/scoped_refptr.h"
#include "third_party/blink/renderer/platform/wtf/ref_counted.h"

namespace blink {

class InternalRuntimeFlags : public ScriptWrappable {
  DEFINE_WRAPPERTYPEINFO();
 public:
  static InternalRuntimeFlags* create() {
    return MakeGarbageCollected<InternalRuntimeFlags>();
  }

  InternalRuntimeFlags() {}

  // These are reset between web tests from Internals::resetToConsistentState
  // using RuntimeEnabledFeatures::Backup.
  void setAccelerated2dCanvasEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetAccelerated2dCanvasEnabled(isEnabled);
  }
  void setAutomationControlledEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetAutomationControlledEnabled(isEnabled);
  }
  void setImplicitRootScrollerEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetImplicitRootScrollerEnabled(isEnabled);
  }
  void setLangAttributeAwareFormControlUIEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetLangAttributeAwareFormControlUIEnabled(isEnabled);
  }
  void setMediaControlsOverlayPlayButtonEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetMediaControlsOverlayPlayButtonEnabled(isEnabled);
  }
  void setPaintUnderInvalidationCheckingEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetPaintUnderInvalidationCheckingEnabled(isEnabled);
  }
  void setPreferNonCompositedScrollingEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetPreferNonCompositedScrollingEnabled(isEnabled);
  }
  void setRemotePlaybackBackendEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetRemotePlaybackBackendEnabled(isEnabled);
  }
  void setSelectionSetBaseAndExtentNonNullNodeEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetSelectionSetBaseAndExtentNonNullNodeEnabled(isEnabled);
  }
  void setVideoAutoFullscreenEnabled(bool isEnabled) {
    RuntimeEnabledFeatures::SetVideoAutoFullscreenEnabled(isEnabled);
  }

  bool abortByPlaceholderLayoutEnabled() {
    return RuntimeEnabledFeatures::AbortByPlaceholderLayoutEnabled();
  }
  bool aboutBlankPageRespectsDarkModeOnUserActionEnabled() {
    return RuntimeEnabledFeatures::AboutBlankPageRespectsDarkModeOnUserActionEnabled();
  }
  bool accelerated2dCanvasEnabled() {
    return RuntimeEnabledFeatures::Accelerated2dCanvasEnabled();
  }
  bool acceleratedSmallCanvasesEnabled() {
    return RuntimeEnabledFeatures::AcceleratedSmallCanvasesEnabled();
  }
  bool accessibilityAriaVirtualContentEnabled() {
    return RuntimeEnabledFeatures::AccessibilityAriaVirtualContentEnabled();
  }
  bool accessibilityCustomElementRoleNoneEnabled() {
    return RuntimeEnabledFeatures::AccessibilityCustomElementRoleNoneEnabled();
  }
  bool accessibilityExposeDisplayNoneEnabled() {
    return RuntimeEnabledFeatures::AccessibilityExposeDisplayNoneEnabled();
  }
  bool accessibilityImplicitActionsEnabled() {
    return RuntimeEnabledFeatures::AccessibilityImplicitActionsEnabled();
  }
  bool accessibilityMinRoleTabbableEnabled() {
    return RuntimeEnabledFeatures::AccessibilityMinRoleTabbableEnabled();
  }
  bool accessibilityOSLevelBoldTextEnabled() {
    return RuntimeEnabledFeatures::AccessibilityOSLevelBoldTextEnabled();
  }
  bool accessibilityProhibitedNamesEnabled() {
    return RuntimeEnabledFeatures::AccessibilityProhibitedNamesEnabled();
  }
  bool accessibilitySerializationSizeMetricsEnabled() {
    return RuntimeEnabledFeatures::AccessibilitySerializationSizeMetricsEnabled();
  }
  bool accessibilityUseAXPositionForDocumentMarkersEnabled() {
    return RuntimeEnabledFeatures::AccessibilityUseAXPositionForDocumentMarkersEnabled();
  }
  bool accessKeyLabelEnabled() {
    return RuntimeEnabledFeatures::AccessKeyLabelEnabled();
  }
  bool addressSpaceEnabled() {
    return RuntimeEnabledFeatures::AddressSpaceEnabled();
  }
  bool adInterestGroupAPIEnabled() {
    return RuntimeEnabledFeatures::AdInterestGroupAPIEnabledByRuntimeFlag();
  }
  bool adjustDOMOffsetToLayoutOffsetForSecureTextEnabled() {
    return RuntimeEnabledFeatures::AdjustDOMOffsetToLayoutOffsetForSecureTextEnabled();
  }
  bool adjustEndOfNextParagraphIfMovedParagraphIsUpdatedEnabled() {
    return RuntimeEnabledFeatures::AdjustEndOfNextParagraphIfMovedParagraphIsUpdatedEnabled();
  }
  bool adTaggingEnabled() {
    return RuntimeEnabledFeatures::AdTaggingEnabled();
  }
  bool aiPageContentPaidContentAnnotationEnabled() {
    return RuntimeEnabledFeatures::AIPageContentPaidContentAnnotationEnabled();
  }
  bool aiPageContentZOrderEarlyFilteringEnabled() {
    return RuntimeEnabledFeatures::AIPageContentZOrderEarlyFilteringEnabled();
  }
  bool aiPromptAPIEnabled() {
    return RuntimeEnabledFeatures::AIPromptAPIEnabledByRuntimeFlag();
  }
  bool aiPromptAPIForExtensionEnabled() {
    return RuntimeEnabledFeatures::AIPromptAPIForExtensionEnabled();
  }
  bool aiPromptAPIForWorkersEnabled() {
    return RuntimeEnabledFeatures::AIPromptAPIForWorkersEnabled();
  }
  bool aiPromptAPIMultimodalInputEnabled() {
    return RuntimeEnabledFeatures::AIPromptAPIMultimodalInputEnabledByRuntimeFlag();
  }
  bool aiPromptAPIStructuredOutputEnabled() {
    return RuntimeEnabledFeatures::AIPromptAPIStructuredOutputEnabled();
  }
  bool aiProofreadingAPIEnabled() {
    return RuntimeEnabledFeatures::AIProofreadingAPIEnabledByRuntimeFlag();
  }
  bool aiRewriterAPIEnabled() {
    return RuntimeEnabledFeatures::AIRewriterAPIEnabledByRuntimeFlag();
  }
  bool aiRewriterAPIForWorkersEnabled() {
    return RuntimeEnabledFeatures::AIRewriterAPIForWorkersEnabled();
  }
  bool aiSummarizationAPIEnabled() {
    return RuntimeEnabledFeatures::AISummarizationAPIEnabled();
  }
  bool aiSummarizationAPIForWorkersEnabled() {
    return RuntimeEnabledFeatures::AISummarizationAPIForWorkersEnabled();
  }
  bool aiWriterAPIEnabled() {
    return RuntimeEnabledFeatures::AIWriterAPIEnabledByRuntimeFlag();
  }
  bool aiWriterAPIForWorkersEnabled() {
    return RuntimeEnabledFeatures::AIWriterAPIForWorkersEnabled();
  }
  bool alignZoomToCenterEnabled() {
    return RuntimeEnabledFeatures::AlignZoomToCenterEnabled();
  }
  bool allowContentInitiatedDataUrlNavigationsEnabled() {
    return RuntimeEnabledFeatures::AllowContentInitiatedDataUrlNavigationsEnabled();
  }
  bool allowCopyingEmptyLastTableCellEnabled() {
    return RuntimeEnabledFeatures::AllowCopyingEmptyLastTableCellEnabled();
  }
  bool allowPreloadingWithCSPMetaTagEnabled() {
    return RuntimeEnabledFeatures::AllowPreloadingWithCSPMetaTagEnabled();
  }
  bool allowSameSiteNoneCookiesInSandboxEnabled() {
    return RuntimeEnabledFeatures::AllowSameSiteNoneCookiesInSandboxEnabled();
  }
  bool allowSkippingEditingBoundaryToMergeEndEnabled() {
    return RuntimeEnabledFeatures::AllowSkippingEditingBoundaryToMergeEndEnabled();
  }
  bool allowSvgUseToReferenceExternalDocumentRootEnabled() {
    return RuntimeEnabledFeatures::AllowSvgUseToReferenceExternalDocumentRootEnabled();
  }
  bool allowSyntheticTimingForCanvasCaptureEnabled() {
    return RuntimeEnabledFeatures::AllowSyntheticTimingForCanvasCaptureEnabled();
  }
  bool allowURNsInIframesEnabled() {
    return RuntimeEnabledFeatures::AllowURNsInIframesEnabled();
  }
  bool ancestorRevealingNewSpecEnabled() {
    return RuntimeEnabledFeatures::AncestorRevealingNewSpecEnabled();
  }
  bool anchorPositionAdjustmentWithoutOverflowEnabled() {
    return RuntimeEnabledFeatures::AnchorPositionAdjustmentWithoutOverflowEnabled();
  }
  bool anchorsVisibleInitialValueEnabled() {
    return RuntimeEnabledFeatures::AnchorsVisibleInitialValueEnabled();
  }
  bool androidDownloadableFontsMatchingEnabled() {
    return RuntimeEnabledFeatures::AndroidDownloadableFontsMatchingEnabled();
  }
  bool animationProgressAPIEnabled() {
    return RuntimeEnabledFeatures::AnimationProgressAPIEnabled();
  }
  bool animationTriggerEnabled() {
    return RuntimeEnabledFeatures::AnimationTriggerEnabled();
  }
  bool animationWorkletEnabled() {
    return RuntimeEnabledFeatures::AnimationWorkletEnabled();
  }
  bool anonymousIframeEnabled() {
    return RuntimeEnabledFeatures::AnonymousIframeEnabled();
  }
  bool aomAriaRelationshipPropertiesEnabled() {
    return RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesEnabled();
  }
  bool aomAriaRelationshipPropertiesAriaOwnsEnabled() {
    return RuntimeEnabledFeatures::AOMAriaRelationshipPropertiesAriaOwnsEnabled();
  }
  bool appearanceBaseEnabled() {
    return RuntimeEnabledFeatures::AppearanceBaseEnabled();
  }
  bool approximateGeolocationPermissionEnabled() {
    return RuntimeEnabledFeatures::ApproximateGeolocationPermissionEnabled();
  }
  bool appTitleEnabled() {
    return RuntimeEnabledFeatures::AppTitleEnabledByRuntimeFlag();
  }
  bool ariaActionsEnabled() {
    return RuntimeEnabledFeatures::AriaActionsEnabled();
  }
  bool ariaNotifyEnabled() {
    return RuntimeEnabledFeatures::AriaNotifyEnabled();
  }
  bool ariaNotifyV2Enabled() {
    return RuntimeEnabledFeatures::AriaNotifyV2Enabled();
  }
  bool ariaRowColIndexTextEnabled() {
    return RuntimeEnabledFeatures::AriaRowColIndexTextEnabled();
  }
  bool asymmetricWordBoundaryFixEnabled() {
    return RuntimeEnabledFeatures::AsymmetricWordBoundaryFixEnabled();
  }
  bool asyncSetCookieEnabled() {
    return RuntimeEnabledFeatures::AsyncSetCookieEnabled();
  }
  bool attributionReportingEnabled() {
    return RuntimeEnabledFeatures::AttributionReportingEnabled();
  }
  bool audioContextOnErrorEnabled() {
    return RuntimeEnabledFeatures::AudioContextOnErrorEnabled();
  }
  bool audioContextPlayoutStatsEnabled() {
    return RuntimeEnabledFeatures::AudioContextPlayoutStatsEnabledByRuntimeFlag();
  }
  bool audioContextSetSinkIdEnabled() {
    return RuntimeEnabledFeatures::AudioContextSetSinkIdEnabled();
  }
  bool audioOutputDevicesEnabled() {
    return RuntimeEnabledFeatures::AudioOutputDevicesEnabled();
  }
  bool audioVideoTracksEnabled() {
    return RuntimeEnabledFeatures::AudioVideoTracksEnabled();
  }
  bool authenticatorPasswordsOnlyImmediateRequestsEnabled() {
    return RuntimeEnabledFeatures::AuthenticatorPasswordsOnlyImmediateRequestsEnabled();
  }
  bool autoDarkModeEnabled() {
    return RuntimeEnabledFeatures::AutoDarkModeEnabledByRuntimeFlag();
  }
  bool automationControlledEnabled() {
    return RuntimeEnabledFeatures::AutomationControlledEnabled();
  }
  bool autoPictureInPictureVideoHeuristicsEnabled() {
    return RuntimeEnabledFeatures::AutoPictureInPictureVideoHeuristicsEnabled();
  }
  bool avoidForcedLayoutOnInvisibleDocumentCloseEnabled() {
    return RuntimeEnabledFeatures::AvoidForcedLayoutOnInvisibleDocumentCloseEnabled();
  }
  bool avoidNormalizingVisiblePositionsWhenStartEqualsEndEnabled() {
    return RuntimeEnabledFeatures::AvoidNormalizingVisiblePositionsWhenStartEqualsEndEnabled();
  }
  bool backdropRootForClipPathWithBackdropFilterEnabled() {
    return RuntimeEnabledFeatures::BackdropRootForClipPathWithBackdropFilterEnabled();
  }
  bool backfaceVisibilityInteropEnabled() {
    return RuntimeEnabledFeatures::BackfaceVisibilityInteropEnabled();
  }
  bool backForwardCacheEnabled() {
    return RuntimeEnabledFeatures::BackForwardCacheEnabled();
  }
  bool backForwardCacheExperimentHTTPHeaderEnabled() {
    return RuntimeEnabledFeatures::BackForwardCacheExperimentHTTPHeaderEnabledByRuntimeFlag();
  }
  bool backForwardCacheNotRestoredReasonsEnabled() {
    return RuntimeEnabledFeatures::BackForwardCacheNotRestoredReasonsEnabledByRuntimeFlag();
  }
  bool backForwardCacheRestorationPerformanceEntryEnabled() {
    return RuntimeEnabledFeatures::BackForwardCacheRestorationPerformanceEntryEnabled();
  }
  bool backForwardCacheUpdateNotRestoredReasonsNameEnabled() {
    return RuntimeEnabledFeatures::BackForwardCacheUpdateNotRestoredReasonsNameEnabled();
  }
  bool backgroundFetchEnabled() {
    return RuntimeEnabledFeatures::BackgroundFetchEnabled();
  }
  bool backgroundPageFreezeOptOutEnabled() {
    return RuntimeEnabledFeatures::BackgroundPageFreezeOptOutEnabledByRuntimeFlag();
  }
  bool barcodeDetectorEnabled() {
    return RuntimeEnabledFeatures::BarcodeDetectorEnabled();
  }
  bool bidiCaretAffinityEnabled() {
    return RuntimeEnabledFeatures::BidiCaretAffinityEnabled();
  }
  bool blinkExtensionChromeOSEnabled() {
    return RuntimeEnabledFeatures::BlinkExtensionChromeOSEnabled();
  }
  bool blinkExtensionChromeOSKioskEnabled() {
    return RuntimeEnabledFeatures::BlinkExtensionChromeOSKioskEnabled();
  }
  bool blinkExtensionWebViewEnabled() {
    return RuntimeEnabledFeatures::BlinkExtensionWebViewEnabled();
  }
  bool blinkExtensionWebViewMediaIntegrityEnabled() {
    return RuntimeEnabledFeatures::BlinkExtensionWebViewMediaIntegrityEnabled();
  }
  bool blinkLifecycleScriptForbiddenEnabled() {
    return RuntimeEnabledFeatures::BlinkLifecycleScriptForbiddenEnabled();
  }
  bool blinkRuntimeCallStatsEnabled() {
    return RuntimeEnabledFeatures::BlinkRuntimeCallStatsEnabled();
  }
  bool blobBytesEnabled() {
    return RuntimeEnabledFeatures::BlobBytesEnabled();
  }
  bool blockCanvasReadbackEnabled() {
    return RuntimeEnabledFeatures::BlockCanvasReadbackEnabled();
  }
  bool blockingFocusWithoutUserActivationEnabled() {
    return RuntimeEnabledFeatures::BlockingFocusWithoutUserActivationEnabled();
  }
  bool borderRadiusCorrectionCoverageFactorEnabled() {
    return RuntimeEnabledFeatures::BorderRadiusCorrectionCoverageFactorEnabled();
  }
  bool boundaryEventDispatchTracksNodeRemovalEnabled() {
    return RuntimeEnabledFeatures::BoundaryEventDispatchTracksNodeRemovalEnabled();
  }
  bool browserInitiatedAutomaticPictureInPictureEnabled() {
    return RuntimeEnabledFeatures::BrowserInitiatedAutomaticPictureInPictureEnabled();
  }
  bool browserVerifiedUserActivationKeyboardEnabled() {
    return RuntimeEnabledFeatures::BrowserVerifiedUserActivationKeyboardEnabled();
  }
  bool browserVerifiedUserActivationMouseEnabled() {
    return RuntimeEnabledFeatures::BrowserVerifiedUserActivationMouseEnabled();
  }
  bool bufferedBytesConsumerLimitSizeEnabled() {
    return RuntimeEnabledFeatures::BufferedBytesConsumerLimitSizeEnabled();
  }
  bool builtInAIAPIEnabled() {
    return RuntimeEnabledFeatures::BuiltInAIAPIEnabledByRuntimeFlag();
  }
  bool bypassPepcSecurityForTestingEnabled() {
    return RuntimeEnabledFeatures::BypassPepcSecurityForTestingEnabled();
  }
  bool cacheStorageCodeCacheHintEnabled() {
    return RuntimeEnabledFeatures::CacheStorageCodeCacheHintEnabledByRuntimeFlag();
  }
  bool callExitNodeWithoutLayoutObjectEnabled() {
    return RuntimeEnabledFeatures::CallExitNodeWithoutLayoutObjectEnabled();
  }
  bool canvas2dCanvasFilterEnabled() {
    return RuntimeEnabledFeatures::Canvas2dCanvasFilterEnabled();
  }
  bool canvas2dGPUTransferEnabled() {
    return RuntimeEnabledFeatures::Canvas2dGPUTransferEnabled();
  }
  bool canvas2dImageChromiumEnabled() {
    return RuntimeEnabledFeatures::Canvas2dImageChromiumEnabled();
  }
  bool canvas2dLayersEnabled() {
    return RuntimeEnabledFeatures::Canvas2dLayersEnabled();
  }
  bool canvas2dLayersWithOptionsEnabled() {
    return RuntimeEnabledFeatures::Canvas2dLayersWithOptionsEnabled();
  }
  bool canvas2dMeshEnabled() {
    return RuntimeEnabledFeatures::Canvas2dMeshEnabledByRuntimeFlag();
  }
  bool canvasDrawElementEnabled() {
    return RuntimeEnabledFeatures::CanvasDrawElementEnabled();
  }
  bool canvasDrawElementInSubtreeEnabled() {
    return RuntimeEnabledFeatures::CanvasDrawElementInSubtreeEnabled();
  }
  bool canvasFloatingPointEnabled() {
    return RuntimeEnabledFeatures::CanvasFloatingPointEnabled();
  }
  bool canvasGlobalHDRHeadroomEnabled() {
    return RuntimeEnabledFeatures::CanvasGlobalHDRHeadroomEnabled();
  }
  bool canvasGradientCSSColor4Enabled() {
    return RuntimeEnabledFeatures::CanvasGradientCSSColor4Enabled();
  }
  bool canvasHDREnabled() {
    return RuntimeEnabledFeatures::CanvasHDREnabled();
  }
  bool canvasInterventionsTestEnabled() {
    return RuntimeEnabledFeatures::CanvasInterventionsTestEnabled();
  }
  bool canvasTextCacheLimitEnabled() {
    return RuntimeEnabledFeatures::CanvasTextCacheLimitEnabled();
  }
  bool canvasTextMemoryPressureEnabled() {
    return RuntimeEnabledFeatures::CanvasTextMemoryPressureEnabled();
  }
  bool canvasTextSwitchFrameOnFinalizeEnabled() {
    return RuntimeEnabledFeatures::CanvasTextSwitchFrameOnFinalizeEnabled();
  }
  bool canvasTextTexImage2DFixEnabled() {
    return RuntimeEnabledFeatures::CanvasTextTexImage2DFixEnabled();
  }
  bool canvasToneMappingEnabled() {
    return RuntimeEnabledFeatures::CanvasToneMappingEnabled();
  }
  bool canvasUsesArcPaintOpEnabled() {
    return RuntimeEnabledFeatures::CanvasUsesArcPaintOpEnabled();
  }
  bool capabilityDelegationDisplayCaptureRequestEnabled() {
    return RuntimeEnabledFeatures::CapabilityDelegationDisplayCaptureRequestEnabled();
  }
  bool captureControllerEnabled() {
    return RuntimeEnabledFeatures::CaptureControllerEnabled();
  }
  bool capturedMouseEventsEnabled() {
    return RuntimeEnabledFeatures::CapturedMouseEventsEnabled();
  }
  bool capturedSurfaceControlEnabled() {
    return RuntimeEnabledFeatures::CapturedSurfaceControlEnabled();
  }
  bool capturedSurfaceResolutionEnabled() {
    return RuntimeEnabledFeatures::CapturedSurfaceResolutionEnabled();
  }
  bool captureHandleEnabled() {
    return RuntimeEnabledFeatures::CaptureHandleEnabled();
  }
  bool caretPositionFromPointTextareaFixEnabled() {
    return RuntimeEnabledFeatures::CaretPositionFromPointTextareaFixEnabled();
  }
  bool caretWithTextAffinityUpstreamEnabled() {
    return RuntimeEnabledFeatures::CaretWithTextAffinityUpstreamEnabled();
  }
  bool cctNewRFMPushBehaviorEnabled() {
    return RuntimeEnabledFeatures::CCTNewRFMPushBehaviorEnabled();
  }
  bool checkForCanonicalPositionInIdleSpellCheckEnabled() {
    return RuntimeEnabledFeatures::CheckForCanonicalPositionInIdleSpellCheckEnabled();
  }
  bool checkVisibilityExtraPropertiesEnabled() {
    return RuntimeEnabledFeatures::CheckVisibilityExtraPropertiesEnabled();
  }
  bool clearCurrentTargetAfterDispatchEnabled() {
    return RuntimeEnabledFeatures::ClearCurrentTargetAfterDispatchEnabled();
  }
  bool clearTargetOnlyIfInShadowTreeEnabled() {
    return RuntimeEnabledFeatures::ClearTargetOnlyIfInShadowTreeEnabled();
  }
  bool clientHintUAHighEntropyValuesPermissionPolicyEnabled() {
    return RuntimeEnabledFeatures::ClientHintUAHighEntropyValuesPermissionPolicyEnabled();
  }
  bool clipboardChangeEventEnabled() {
    return RuntimeEnabledFeatures::ClipboardChangeEventEnabledByRuntimeFlag();
  }
  bool clipboardEventTargetCanBeFocusedElementEnabled() {
    return RuntimeEnabledFeatures::ClipboardEventTargetCanBeFocusedElementEnabled();
  }
  bool clipboardItemGetTypeCounterEnabled() {
    return RuntimeEnabledFeatures::ClipboardItemGetTypeCounterEnabled();
  }
  bool clipboardItemWithDOMStringSupportEnabled() {
    return RuntimeEnabledFeatures::ClipboardItemWithDOMStringSupportEnabled();
  }
  bool clipElementVisibleBoundsInLocalRootEnabled() {
    return RuntimeEnabledFeatures::ClipElementVisibleBoundsInLocalRootEnabled();
  }
  bool clipPathNestedRasterOptimizationEnabled() {
    return RuntimeEnabledFeatures::ClipPathNestedRasterOptimizationEnabled();
  }
  bool coalesceSelectionchangeEventEnabled() {
    return RuntimeEnabledFeatures::CoalesceSelectionchangeEventEnabled();
  }
  bool coepReflectionEnabled() {
    return RuntimeEnabledFeatures::CoepReflectionEnabled();
  }
  bool collapseZeroWidthSpaceWhenReuseItemEnabled() {
    return RuntimeEnabledFeatures::CollapseZeroWidthSpaceWhenReuseItemEnabled();
  }
  bool collectWidthAndHeightAsStylesForNestedSvgEnabled() {
    return RuntimeEnabledFeatures::CollectWidthAndHeightAsStylesForNestedSvgEnabled();
  }
  bool colorSpaceDisplayP3LinearEnabled() {
    return RuntimeEnabledFeatures::ColorSpaceDisplayP3LinearEnabled();
  }
  bool colorSpacePredefinedLinearSpacesEnabled() {
    return RuntimeEnabledFeatures::ColorSpacePredefinedLinearSpacesEnabled();
  }
  bool colorSpaceRec2100LinearEnabled() {
    return RuntimeEnabledFeatures::ColorSpaceRec2100LinearEnabled();
  }
  bool commandEventNotComposedEnabled() {
    return RuntimeEnabledFeatures::CommandEventNotComposedEnabled();
  }
  bool composedPathReturnTargetBeingDispatchedEnabled() {
    return RuntimeEnabledFeatures::ComposedPathReturnTargetBeingDispatchedEnabled();
  }
  bool compositeBGColorAnimationEnabled() {
    return RuntimeEnabledFeatures::CompositeBGColorAnimationEnabled();
  }
  bool compositeBoxShadowAnimationEnabled() {
    return RuntimeEnabledFeatures::CompositeBoxShadowAnimationEnabled();
  }
  bool compositeClipPathAnimationEnabled() {
    return RuntimeEnabledFeatures::CompositeClipPathAnimationEnabled();
  }
  bool compositedAnimationsCancelledAsynchronouslyEnabled() {
    return RuntimeEnabledFeatures::CompositedAnimationsCancelledAsynchronouslyEnabled();
  }
  bool compositedSelectionUpdateEnabled() {
    return RuntimeEnabledFeatures::CompositedSelectionUpdateEnabled();
  }
  bool compositingDecisionAtAnimationPhaseBoundariesEnabled() {
    return RuntimeEnabledFeatures::CompositingDecisionAtAnimationPhaseBoundariesEnabled();
  }
  bool compositionForegroundMarkersEnabled() {
    return RuntimeEnabledFeatures::CompositionForegroundMarkersEnabled();
  }
  bool compressionDictionaryTransportEnabled() {
    return RuntimeEnabledFeatures::CompressionDictionaryTransportEnabled();
  }
  bool computedAccessibilityInfoEnabled() {
    return RuntimeEnabledFeatures::ComputedAccessibilityInfoEnabled();
  }
  bool computeInlineContentsSafeRetargetEnabled() {
    return RuntimeEnabledFeatures::ComputeInlineContentsSafeRetargetEnabled();
  }
  bool computePressureEnabled() {
    return RuntimeEnabledFeatures::ComputePressureEnabled();
  }
  bool computePressureOwnContributionEstimateEnabled() {
    return RuntimeEnabledFeatures::ComputePressureOwnContributionEstimateEnabled();
  }
  bool considerSubOrSuperScriptAncestorAlignForCaretSelectionEnabled() {
    return RuntimeEnabledFeatures::ConsiderSubOrSuperScriptAncestorAlignForCaretSelectionEnabled();
  }
  bool contactsManagerEnabled() {
    return RuntimeEnabledFeatures::ContactsManagerEnabled();
  }
  bool contactsManagerExtraPropertiesEnabled() {
    return RuntimeEnabledFeatures::ContactsManagerExtraPropertiesEnabled();
  }
  bool containerTimingEnabled() {
    return RuntimeEnabledFeatures::ContainerTimingEnabled();
  }
  bool containerTypeNoLayoutContainmentEnabled() {
    return RuntimeEnabledFeatures::ContainerTypeNoLayoutContainmentEnabled();
  }
  bool contentIndexEnabled() {
    return RuntimeEnabledFeatures::ContentIndexEnabled();
  }
  bool contextMenuEnabled() {
    return RuntimeEnabledFeatures::ContextMenuEnabled();
  }
  bool controlledFrameEnabled() {
    return RuntimeEnabledFeatures::ControlledFrameEnabled();
  }
  bool cookieDeprecationFacilitatedTestingEnabled() {
    return RuntimeEnabledFeatures::CookieDeprecationFacilitatedTestingEnabled();
  }
  bool coopRestrictPropertiesEnabled() {
    return RuntimeEnabledFeatures::CoopRestrictPropertiesEnabledByRuntimeFlag();
  }
  bool correctTemplateFormParsingEnabled() {
    return RuntimeEnabledFeatures::CorrectTemplateFormParsingEnabled();
  }
  bool corsRFC1918Enabled() {
    return RuntimeEnabledFeatures::CorsRFC1918Enabled();
  }
  bool cpuPerformanceEnabled() {
    return RuntimeEnabledFeatures::CpuPerformanceEnabled();
  }
  bool crashReportingStorageAPIEnabled() {
    return RuntimeEnabledFeatures::CrashReportingStorageAPIEnabledByRuntimeFlag();
  }
  bool createInlineContentsExcludeOutOfFlowEnabled() {
    return RuntimeEnabledFeatures::CreateInlineContentsExcludeOutOfFlowEnabled();
  }
  bool cspHashesV1Enabled() {
    return RuntimeEnabledFeatures::CSPHashesV1EnabledByRuntimeFlag();
  }
  bool cspReportHashEnabled() {
    return RuntimeEnabledFeatures::CSPReportHashEnabled();
  }
  bool cssAccentColorKeywordEnabled() {
    return RuntimeEnabledFeatures::CSSAccentColorKeywordEnabled();
  }
  bool cssAltCounterEnabled() {
    return RuntimeEnabledFeatures::CSSAltCounterEnabled();
  }
  bool cssAnchorSimplifiedFragmentationEnabled() {
    return RuntimeEnabledFeatures::CSSAnchorSimplifiedFragmentationEnabled();
  }
  bool cssAnchorUpdateEnabled() {
    return RuntimeEnabledFeatures::CSSAnchorUpdateEnabled();
  }
  bool cssAnchorWithTransformsEnabled() {
    return RuntimeEnabledFeatures::CSSAnchorWithTransformsEnabled();
  }
  bool cssAtRuleCounterStyleImageSymbolsEnabled() {
    return RuntimeEnabledFeatures::CSSAtRuleCounterStyleImageSymbolsEnabled();
  }
  bool cssAtRuleCounterStyleSpeakAsDescriptorEnabled() {
    return RuntimeEnabledFeatures::CSSAtRuleCounterStyleSpeakAsDescriptorEnabled();
  }
  bool cssBorderShapeEnabled() {
    return RuntimeEnabledFeatures::CSSBorderShapeEnabled();
  }
  bool cssCalcSimplificationAndSerializationEnabled() {
    return RuntimeEnabledFeatures::CSSCalcSimplificationAndSerializationEnabled();
  }
  bool cssCaretAnimationEnabled() {
    return RuntimeEnabledFeatures::CSSCaretAnimationEnabled();
  }
  bool cssCaretShapeEnabled() {
    return RuntimeEnabledFeatures::CSSCaretShapeEnabled();
  }
  bool cssCaseSensitiveSelectorEnabled() {
    return RuntimeEnabledFeatures::CSSCaseSensitiveSelectorEnabled();
  }
  bool cssChUnitSpecCompliantFallbackEnabled() {
    return RuntimeEnabledFeatures::CSSChUnitSpecCompliantFallbackEnabled();
  }
  bool cssColorContrastEnabled() {
    return RuntimeEnabledFeatures::CSSColorContrastEnabled();
  }
  bool cssColorTypedOMEnabled() {
    return RuntimeEnabledFeatures::CSSColorTypedOMEnabled();
  }
  bool cssContainerNameNotTreeScopedEnabled() {
    return RuntimeEnabledFeatures::CSSContainerNameNotTreeScopedEnabled();
  }
  bool cssContainerProgressNotationEnabled() {
    return RuntimeEnabledFeatures::CSSContainerProgressNotationEnabled();
  }
  bool cssContainerStyleQueriesRangeEnabled() {
    return RuntimeEnabledFeatures::CSSContainerStyleQueriesRangeEnabled();
  }
  bool cssCornerShapeEnabled() {
    return RuntimeEnabledFeatures::CSSCornerShapeEnabled();
  }
  bool cssCornersShorthandEnabled() {
    return RuntimeEnabledFeatures::CSSCornersShorthandEnabled();
  }
  bool cssCrossFadeEnabled() {
    return RuntimeEnabledFeatures::CSSCrossFadeEnabled();
  }
  bool cssCustomMediaEnabled() {
    return RuntimeEnabledFeatures::CSSCustomMediaEnabled();
  }
  bool cssDynamicRangeLimitEnabled() {
    return RuntimeEnabledFeatures::CSSDynamicRangeLimitEnabled();
  }
  bool cssEnumeratedCustomPropertiesEnabled() {
    return RuntimeEnabledFeatures::CSSEnumeratedCustomPropertiesEnabled();
  }
  bool cssFallbackContainerQueriesEnabled() {
    return RuntimeEnabledFeatures::CSSFallbackContainerQueriesEnabled();
  }
  bool cssFitWidthTextEnabled() {
    return RuntimeEnabledFeatures::CssFitWidthTextEnabled();
  }
  bool cssFontSizeAdjustEnabled() {
    return RuntimeEnabledFeatures::CSSFontSizeAdjustEnabled();
  }
  bool cssFunctionsEnabled() {
    return RuntimeEnabledFeatures::CSSFunctionsEnabled();
  }
  bool cssGapDecorationEnabled() {
    return RuntimeEnabledFeatures::CSSGapDecorationEnabled();
  }
  bool cssGridGapSuppressionEnabled() {
    return RuntimeEnabledFeatures::CSSGridGapSuppressionEnabled();
  }
  bool cssHexAlphaColorEnabled() {
    return RuntimeEnabledFeatures::CSSHexAlphaColorEnabled();
  }
  bool cssIdentFunctionEnabled() {
    return RuntimeEnabledFeatures::CSSIdentFunctionEnabled();
  }
  bool cssInheritFunctionEnabled() {
    return RuntimeEnabledFeatures::CSSInheritFunctionEnabled();
  }
  bool cssInlineIfForMediaQueriesEnabled() {
    return RuntimeEnabledFeatures::CSSInlineIfForMediaQueriesEnabled();
  }
  bool cssInlineIfForStyleQueriesEnabled() {
    return RuntimeEnabledFeatures::CSSInlineIfForStyleQueriesEnabled();
  }
  bool cssInlineIfForSupportsQueriesEnabled() {
    return RuntimeEnabledFeatures::CSSInlineIfForSupportsQueriesEnabled();
  }
  bool cssKeyframesRuleLengthEnabled() {
    return RuntimeEnabledFeatures::CSSKeyframesRuleLengthEnabled();
  }
  bool cssLayoutAPIEnabled() {
    return RuntimeEnabledFeatures::CSSLayoutAPIEnabled();
  }
  bool cssLetterAndWordSpacingPercentageEnabled() {
    return RuntimeEnabledFeatures::CSSLetterAndWordSpacingPercentageEnabled();
  }
  bool cssLineClampEnabled() {
    return RuntimeEnabledFeatures::CSSLineClampEnabled();
  }
  bool cssLineClampLineBreakingEllipsisEnabled() {
    return RuntimeEnabledFeatures::CSSLineClampLineBreakingEllipsisEnabled();
  }
  bool cssLogicalCombinationPseudoEnabled() {
    return RuntimeEnabledFeatures::CSSLogicalCombinationPseudoEnabled();
  }
  bool cssMarkerNestedPseudoElementEnabled() {
    return RuntimeEnabledFeatures::CSSMarkerNestedPseudoElementEnabled();
  }
  bool cssMasonryLayoutEnabled() {
    return RuntimeEnabledFeatures::CSSMasonryLayoutEnabled();
  }
  bool cssMediaProgressNotationEnabled() {
    return RuntimeEnabledFeatures::CSSMediaProgressNotationEnabled();
  }
  bool cssMixinsEnabled() {
    return RuntimeEnabledFeatures::CSSMixinsEnabled();
  }
  bool cssNestedPseudoElementsEnabled() {
    return RuntimeEnabledFeatures::CSSNestedPseudoElementsEnabled();
  }
  bool cssOverscrollGesturesEnabled() {
    return RuntimeEnabledFeatures::CSSOverscrollGesturesEnabled();
  }
  bool cssPaintAPIArgumentsEnabled() {
    return RuntimeEnabledFeatures::CSSPaintAPIArgumentsEnabled();
  }
  bool cssParserIgnoreCharsetForURLsEnabled() {
    return RuntimeEnabledFeatures::CSSParserIgnoreCharsetForURLsEnabled();
  }
  bool cssPositionStickyStaticScrollPositionEnabled() {
    return RuntimeEnabledFeatures::CSSPositionStickyStaticScrollPositionEnabled();
  }
  bool cssPreferredTextScaleEnabled() {
    return RuntimeEnabledFeatures::CSSPreferredTextScaleEnabled();
  }
  bool cssProgressNotationEnabled() {
    return RuntimeEnabledFeatures::CSSProgressNotationEnabled();
  }
  bool cssPseudoColumnEnabled() {
    return RuntimeEnabledFeatures::CSSPseudoColumnEnabled();
  }
  bool cssPseudoElementInterfaceEnabled() {
    return RuntimeEnabledFeatures::CSSPseudoElementInterfaceEnabled();
  }
  bool cssPseudoHasSlottedEnabled() {
    return RuntimeEnabledFeatures::CSSPseudoHasSlottedEnabled();
  }
  bool cssPseudoPlayingPausedEnabled() {
    return RuntimeEnabledFeatures::CSSPseudoPlayingPausedEnabled();
  }
  bool cssPseudoScrollButtonsEnabled() {
    return RuntimeEnabledFeatures::CSSPseudoScrollButtonsEnabled();
  }
  bool cssPseudoScrollMarkersEnabled() {
    return RuntimeEnabledFeatures::CSSPseudoScrollMarkersEnabled();
  }
  bool cssResizeAutoEnabled() {
    return RuntimeEnabledFeatures::CSSResizeAutoEnabled();
  }
  bool cssRevertRuleEnabled() {
    return RuntimeEnabledFeatures::CSSRevertRuleEnabled();
  }
  bool cssRubyOverhangEnabled() {
    return RuntimeEnabledFeatures::CSSRubyOverhangEnabled();
  }
  bool cssSafePrintableInsetEnabled() {
    return RuntimeEnabledFeatures::CSSSafePrintableInsetEnabled();
  }
  bool cssScopeifiedParentPseudoClassEnabled() {
    return RuntimeEnabledFeatures::CSSScopeifiedParentPseudoClassEnabled();
  }
  bool cssScopeImportEnabled() {
    return RuntimeEnabledFeatures::CSSScopeImportEnabled();
  }
  bool cssScrolledContainerQueriesEnabled() {
    return RuntimeEnabledFeatures::CSSScrolledContainerQueriesEnabled();
  }
  bool cssScrollInitialTargetEnabled() {
    return RuntimeEnabledFeatures::CSSScrollInitialTargetEnabled();
  }
  bool cssScrollMarkerGroupModesEnabled() {
    return RuntimeEnabledFeatures::CSSScrollMarkerGroupModesEnabled();
  }
  bool cssScrollMarkerTargetBeforeAfterEnabled() {
    return RuntimeEnabledFeatures::CSSScrollMarkerTargetBeforeAfterEnabled();
  }
  bool cssScrollSnapChangeEventEnabled() {
    return RuntimeEnabledFeatures::CSSScrollSnapChangeEventEnabled();
  }
  bool cssScrollSnapChangingEventEnabled() {
    return RuntimeEnabledFeatures::CSSScrollSnapChangingEventEnabled();
  }
  bool cssScrollSnapEventConstructorExposedEnabled() {
    return RuntimeEnabledFeatures::CSSScrollSnapEventConstructorExposedEnabled();
  }
  bool cssScrollSnapEventsEnabled() {
    return RuntimeEnabledFeatures::CSSScrollSnapEventsEnabled();
  }
  bool cssScrollStartEnabled() {
    return RuntimeEnabledFeatures::CSSScrollStartEnabled();
  }
  bool cssScrollTargetGroupEnabled() {
    return RuntimeEnabledFeatures::CSSScrollTargetGroupEnabled();
  }
  bool cssScrollTargetGroupAriaCurrentEnabled() {
    return RuntimeEnabledFeatures::CSSScrollTargetGroupAriaCurrentEnabled();
  }
  bool cssSelectorFragmentAnchorEnabled() {
    return RuntimeEnabledFeatures::CSSSelectorFragmentAnchorEnabled();
  }
  bool cssSignRelatedFunctionsEnabled() {
    return RuntimeEnabledFeatures::CSSSignRelatedFunctionsEnabled();
  }
  bool cssSupportsAtRuleFunctionEnabled() {
    return RuntimeEnabledFeatures::CSSSupportsAtRuleFunctionEnabled();
  }
  bool cssSupportsForImportRulesEnabled() {
    return RuntimeEnabledFeatures::CSSSupportsForImportRulesEnabled();
  }
  bool cssSystemAccentColorEnabled() {
    return RuntimeEnabledFeatures::CSSSystemAccentColorEnabled();
  }
  bool cssTextAlignMatchParentEnabled() {
    return RuntimeEnabledFeatures::CSSTextAlignMatchParentEnabled();
  }
  bool cssTextAutoSpaceEnabled() {
    return RuntimeEnabledFeatures::CSSTextAutoSpaceEnabled();
  }
  bool cssTextJustifyEnabled() {
    return RuntimeEnabledFeatures::CssTextJustifyEnabled();
  }
  bool cssTextSpacingEnabled() {
    return RuntimeEnabledFeatures::CSSTextSpacingEnabled();
  }
  bool cssTextTransformFullWidthEnabled() {
    return RuntimeEnabledFeatures::CSSTextTransformFullWidthEnabled();
  }
  bool cssTreeScopedTimelinesEnabled() {
    return RuntimeEnabledFeatures::CSSTreeScopedTimelinesEnabled();
  }
  bool cssTypedArithmeticEnabled() {
    return RuntimeEnabledFeatures::CSSTypedArithmeticEnabled();
  }
  bool cssUserSelectContainEnabled() {
    return RuntimeEnabledFeatures::CSSUserSelectContainEnabled();
  }
  bool cssVideoDynamicRangeMediaQueriesEnabled() {
    return RuntimeEnabledFeatures::CSSVideoDynamicRangeMediaQueriesEnabled();
  }
  bool cssViewTransitionAutoNameEnabled() {
    return RuntimeEnabledFeatures::CSSViewTransitionAutoNameEnabled();
  }
  bool customizableSelectInPageEnabled() {
    return RuntimeEnabledFeatures::CustomizableSelectInPageEnabled();
  }
  bool customizableSelectMultiplePopupEnabled() {
    return RuntimeEnabledFeatures::CustomizableSelectMultiplePopupEnabled();
  }
  bool customScrollbarApplyMinimumThumbLengthEnabled() {
    return RuntimeEnabledFeatures::CustomScrollbarApplyMinimumThumbLengthEnabled();
  }
  bool databaseEnabled() {
    return RuntimeEnabledFeatures::DatabaseEnabled();
  }
  bool declarativeCSSModulesEnabled() {
    return RuntimeEnabledFeatures::DeclarativeCSSModulesEnabled();
  }
  bool decoupleComputedBorderWidthFromStyleEnabled() {
    return RuntimeEnabledFeatures::DecoupleComputedBorderWidthFromStyleEnabled();
  }
  bool decoupleResolvedColumnRuleWidthFromStyleEnabled() {
    return RuntimeEnabledFeatures::DecoupleResolvedColumnRuleWidthFromStyleEnabled();
  }
  bool delegatesFocusTextControlInputFixEnabled() {
    return RuntimeEnabledFeatures::DelegatesFocusTextControlInputFixEnabled();
  }
  bool deprecateCursorMovementIteratorEnabled() {
    return RuntimeEnabledFeatures::DeprecateCursorMovementIteratorEnabled();
  }
  bool deprecateUnloadOptOutEnabled() {
    return RuntimeEnabledFeatures::DeprecateUnloadOptOutEnabledByRuntimeFlag();
  }
  bool desktopCaptureDisableLocalEchoControlEnabled() {
    return RuntimeEnabledFeatures::DesktopCaptureDisableLocalEchoControlEnabled();
  }
  bool desktopPWAsAdditionalWindowingControlsEnabled() {
    return RuntimeEnabledFeatures::DesktopPWAsAdditionalWindowingControlsEnabled();
  }
  bool desktopPWAsSubAppsEnabled() {
    return RuntimeEnabledFeatures::DesktopPWAsSubAppsEnabled();
  }
  bool deviceAttributesEnabled() {
    return RuntimeEnabledFeatures::DeviceAttributesEnabled();
  }
  bool deviceAttributesPermissionPolicyEnabled() {
    return RuntimeEnabledFeatures::DeviceAttributesPermissionPolicyEnabled();
  }
  bool deviceBoundSessionCredentialsEnabled() {
    return RuntimeEnabledFeatures::DeviceBoundSessionCredentialsEnabledByRuntimeFlag();
  }
  bool deviceBoundSessionCredentials2Enabled() {
    return RuntimeEnabledFeatures::DeviceBoundSessionCredentials2EnabledByRuntimeFlag();
  }
  bool deviceOrientationRequestPermissionEnabled() {
    return RuntimeEnabledFeatures::DeviceOrientationRequestPermissionEnabled();
  }
  bool devicePostureEnabled() {
    return RuntimeEnabledFeatures::DevicePostureEnabled();
  }
  bool dialogCloseWhenOpenRemovedEnabled() {
    return RuntimeEnabledFeatures::DialogCloseWhenOpenRemovedEnabled();
  }
  bool dialogNewFocusBehaviorEnabled() {
    return RuntimeEnabledFeatures::DialogNewFocusBehaviorEnabled();
  }
  bool digitalGoodsEnabled() {
    return RuntimeEnabledFeatures::DigitalGoodsEnabledByRuntimeFlag();
  }
  bool digitalGoodsV21Enabled() {
    return RuntimeEnabledFeatures::DigitalGoodsV2_1Enabled();
  }
  bool directSocketsEnabled() {
    return RuntimeEnabledFeatures::DirectSocketsEnabled();
  }
  bool directSocketsInServiceWorkersEnabled() {
    return RuntimeEnabledFeatures::DirectSocketsInServiceWorkersEnabled();
  }
  bool directSocketsInSharedWorkersEnabled() {
    return RuntimeEnabledFeatures::DirectSocketsInSharedWorkersEnabled();
  }
  bool disableDifferentOriginSubframeDialogSuppressionEnabled() {
    return RuntimeEnabledFeatures::DisableDifferentOriginSubframeDialogSuppressionEnabledByRuntimeFlag();
  }
  bool disableReduceAcceptLanguageEnabled() {
    return RuntimeEnabledFeatures::DisableReduceAcceptLanguageEnabledByRuntimeFlag();
  }
  bool dispatchHiddenVisibilityTransitionsEnabled() {
    return RuntimeEnabledFeatures::DispatchHiddenVisibilityTransitionsEnabled();
  }
  bool dispatchSelectionchangeEventPerElementEnabled() {
    return RuntimeEnabledFeatures::DispatchSelectionchangeEventPerElementEnabled();
  }
  bool displayContentsFocusableEnabled() {
    return RuntimeEnabledFeatures::DisplayContentsFocusableEnabled();
  }
  bool displayCutoutAPIEnabled() {
    return RuntimeEnabledFeatures::DisplayCutoutAPIEnabled();
  }
  bool documentActiveViewTransitionEnabled() {
    return RuntimeEnabledFeatures::DocumentActiveViewTransitionEnabled();
  }
  bool documentCookieEnabled() {
    return RuntimeEnabledFeatures::DocumentCookieEnabled();
  }
  bool documentDomainEnabled() {
    return RuntimeEnabledFeatures::DocumentDomainEnabled();
  }
  bool documentIsolationPolicyEnabled() {
    return RuntimeEnabledFeatures::DocumentIsolationPolicyEnabledByRuntimeFlag();
  }
  bool documentOpenOriginAliasRemovalEnabled() {
    return RuntimeEnabledFeatures::DocumentOpenOriginAliasRemovalEnabled();
  }
  bool documentOpenSandboxInheritanceRemovalEnabled() {
    return RuntimeEnabledFeatures::DocumentOpenSandboxInheritanceRemovalEnabled();
  }
  bool documentPatchingEnabled() {
    return RuntimeEnabledFeatures::DocumentPatchingEnabled();
  }
  bool documentPictureInPictureAPIEnabled() {
    return RuntimeEnabledFeatures::DocumentPictureInPictureAPIEnabled();
  }
  bool documentPictureInPicturePreferInitialPlacementEnabled() {
    return RuntimeEnabledFeatures::DocumentPictureInPicturePreferInitialPlacementEnabled();
  }
  bool documentPictureInPictureUserActivationEnabled() {
    return RuntimeEnabledFeatures::DocumentPictureInPictureUserActivationEnabled();
  }
  bool documentPolicyDocumentDomainEnabled() {
    return RuntimeEnabledFeatures::DocumentPolicyDocumentDomainEnabled();
  }
  bool documentPolicyExpectNoLinkedResourcesEnabled() {
    return RuntimeEnabledFeatures::DocumentPolicyExpectNoLinkedResourcesEnabled();
  }
  bool documentPolicyIncludeJSCallStacksInCrashReportsEnabled() {
    return RuntimeEnabledFeatures::DocumentPolicyIncludeJSCallStacksInCrashReportsEnabled();
  }
  bool documentPolicyNegotiationEnabled() {
    return RuntimeEnabledFeatures::DocumentPolicyNegotiationEnabledByRuntimeFlag();
  }
  bool documentPolicyNetworkEfficiencyGuardrailsEnabled() {
    return RuntimeEnabledFeatures::DocumentPolicyNetworkEfficiencyGuardrailsEnabled();
  }
  bool documentPolicySyncXHREnabled() {
    return RuntimeEnabledFeatures::DocumentPolicySyncXHREnabled();
  }
  bool documentWriteEnabled() {
    return RuntimeEnabledFeatures::DocumentWriteEnabled();
  }
  bool domPartsAPIEnabled() {
    return RuntimeEnabledFeatures::DOMPartsAPIEnabled();
  }
  bool domPartsAPIMinimalEnabled() {
    return RuntimeEnabledFeatures::DOMPartsAPIMinimalEnabled();
  }
  bool editContextHandleTextOrSelectionUpdateDuringCompositionEnabled() {
    return RuntimeEnabledFeatures::EditContextHandleTextOrSelectionUpdateDuringCompositionEnabled();
  }
  bool editEmojiUnicode11Enabled() {
    return RuntimeEnabledFeatures::EditEmojiUnicode11Enabled();
  }
  bool elementCaptureEnabled() {
    return RuntimeEnabledFeatures::ElementCaptureEnabled();
  }
  bool elementInnerTextHandleFirstLineStyleEnabled() {
    return RuntimeEnabledFeatures::ElementInnerTextHandleFirstLineStyleEnabled();
  }
  bool elementInternalsDotTypeEnabled() {
    return RuntimeEnabledFeatures::ElementInternalsDotTypeEnabled();
  }
  bool emphasisMarkShapeCacheEnabled() {
    return RuntimeEnabledFeatures::EmphasisMarkShapeCacheEnabled();
  }
  bool enforceAnonymityExposureEnabled() {
    return RuntimeEnabledFeatures::EnforceAnonymityExposureEnabled();
  }
  bool enterInOpenShadowRootsEnabled() {
    return RuntimeEnabledFeatures::EnterInOpenShadowRootsEnabled();
  }
  bool entropyIgnoredForFirstVideoFrameLCPEnabled() {
    return RuntimeEnabledFeatures::EntropyIgnoredForFirstVideoFrameLCPEnabled();
  }
  bool eventPseudoTargetPropertyEnabled() {
    return RuntimeEnabledFeatures::EventPseudoTargetPropertyEnabled();
  }
  bool eventTargetStringIdentifierUsesQuotesEnabled() {
    return RuntimeEnabledFeatures::EventTargetStringIdentifierUsesQuotesEnabled();
  }
  bool eventTimingInteractionCountEnabled() {
    return RuntimeEnabledFeatures::EventTimingInteractionCountEnabled();
  }
  bool eventTimingTargetSelectorEnabled() {
    return RuntimeEnabledFeatures::EventTimingTargetSelectorEnabled();
  }
  bool eventTriggerEnabled() {
    return RuntimeEnabledFeatures::EventTriggerEnabled();
  }
  bool experimentalContentSecurityPolicyFeaturesEnabled() {
    return RuntimeEnabledFeatures::ExperimentalContentSecurityPolicyFeaturesEnabled();
  }
  bool experimentalJSProfilerMarkersEnabled() {
    return RuntimeEnabledFeatures::ExperimentalJSProfilerMarkersEnabled();
  }
  bool experimentalMachineLearningNeuralNetworkEnabled() {
    return RuntimeEnabledFeatures::ExperimentalMachineLearningNeuralNetworkEnabled();
  }
  bool experimentalPoliciesEnabled() {
    return RuntimeEnabledFeatures::ExperimentalPoliciesEnabled();
  }
  bool exposeCSSFontFeatureValuesRuleEnabled() {
    return RuntimeEnabledFeatures::ExposeCSSFontFeatureValuesRuleEnabled();
  }
  bool exposeRenderTimeNonTaoDelayedImageEnabled() {
    return RuntimeEnabledFeatures::ExposeRenderTimeNonTaoDelayedImageEnabled();
  }
  bool extendedTextMetricsEnabled() {
    return RuntimeEnabledFeatures::ExtendedTextMetricsEnabled();
  }
  bool externalPopupMenuClickEventEnabled() {
    return RuntimeEnabledFeatures::ExternalPopupMenuClickEventEnabled();
  }
  bool eyeDropperAPIEnabled() {
    return RuntimeEnabledFeatures::EyeDropperAPIEnabled();
  }
  bool faceDetectorEnabled() {
    return RuntimeEnabledFeatures::FaceDetectorEnabled();
  }
  bool fastPositionIteratorEnabled() {
    return RuntimeEnabledFeatures::FastPositionIteratorEnabled();
  }
  bool fedCmEnabled() {
    return RuntimeEnabledFeatures::FedCmEnabled();
  }
  bool fedCmAutofillEnabled() {
    return RuntimeEnabledFeatures::FedCmAutofillEnabled();
  }
  bool fedCmDelegationEnabled() {
    return RuntimeEnabledFeatures::FedCmDelegationEnabled();
  }
  bool fedCmErrorAttributeEnabled() {
    return RuntimeEnabledFeatures::FedCmErrorAttributeEnabled();
  }
  bool fedCmIdPRegistrationEnabled() {
    return RuntimeEnabledFeatures::FedCmIdPRegistrationEnabled();
  }
  bool fedCmLightweightModeEnabled() {
    return RuntimeEnabledFeatures::FedCmLightweightModeEnabled();
  }
  bool fedCmMultipleIdentityProvidersEnabled() {
    return RuntimeEnabledFeatures::FedCmMultipleIdentityProvidersEnabledByRuntimeFlag();
  }
  bool fedCmNonStringTokenEnabled() {
    return RuntimeEnabledFeatures::FedCmNonStringTokenEnabled();
  }
  bool fencedFramesEnabled() {
    return RuntimeEnabledFeatures::FencedFramesEnabled();
  }
  bool fencedFramesAPIChangesEnabled() {
    return RuntimeEnabledFeatures::FencedFramesAPIChangesEnabled();
  }
  bool fencedFramesDefaultModeEnabled() {
    return RuntimeEnabledFeatures::FencedFramesDefaultModeEnabled();
  }
  bool fencedFramesLocalUnpartitionedDataAccessEnabled() {
    return RuntimeEnabledFeatures::FencedFramesLocalUnpartitionedDataAccessEnabled();
  }
  bool fetchBodyBytesEnabled() {
    return RuntimeEnabledFeatures::FetchBodyBytesEnabled();
  }
  bool fetchLaterAPIEnabled() {
    return RuntimeEnabledFeatures::FetchLaterAPIEnabled();
  }
  bool fetchRetryEnabled() {
    return RuntimeEnabledFeatures::FetchRetryEnabledByRuntimeFlag();
  }
  bool fetchUploadStreamingEnabled() {
    return RuntimeEnabledFeatures::FetchUploadStreamingEnabled();
  }
  bool fileHandlingEnabled() {
    return RuntimeEnabledFeatures::FileHandlingEnabled();
  }
  bool fileHandlingIconsEnabled() {
    return RuntimeEnabledFeatures::FileHandlingIconsEnabled();
  }
  bool fileSystemEnabled() {
    return RuntimeEnabledFeatures::FileSystemEnabled();
  }
  bool fileSystemAccessEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessEnabled();
  }
  bool fileSystemAccessAPIExperimentalEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessAPIExperimentalEnabled();
  }
  bool fileSystemAccessGetCloudIdentifiersEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessGetCloudIdentifiersEnabled();
  }
  bool fileSystemAccessLocalEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessLocalEnabled();
  }
  bool fileSystemAccessLockingSchemeEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessLockingSchemeEnabled();
  }
  bool fileSystemAccessOriginPrivateEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessOriginPrivateEnabled();
  }
  bool fileSystemAccessRevokeReadOnRemoveEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessRevokeReadOnRemoveEnabled();
  }
  bool fileSystemAccessWriteModeEnabled() {
    return RuntimeEnabledFeatures::FileSystemAccessWriteModeEnabled();
  }
  bool fileSystemObserverEnabled() {
    return RuntimeEnabledFeatures::FileSystemObserverEnabled();
  }
  bool fileSystemObserverUnobserveEnabled() {
    return RuntimeEnabledFeatures::FileSystemObserverUnobserveEnabled();
  }
  bool findAcrossParagraphsInTextareaEnabled() {
    return RuntimeEnabledFeatures::FindAcrossParagraphsInTextareaEnabled();
  }
  bool findFirstMisspellingEndWhenNonEditableEnabled() {
    return RuntimeEnabledFeatures::FindFirstMisspellingEndWhenNonEditableEnabled();
  }
  bool firstLineOnListItemEnabled() {
    return RuntimeEnabledFeatures::FirstLineOnListItemEnabled();
  }
  bool firstLineTextMetricsEnabled() {
    return RuntimeEnabledFeatures::FirstLineTextMetricsEnabled();
  }
  bool fixNextPositionCalculationInInsertListEnabled() {
    return RuntimeEnabledFeatures::FixNextPositionCalculationInInsertListEnabled();
  }
  bool fledgeEnabled() {
    return RuntimeEnabledFeatures::FledgeEnabled();
  }
  bool fledgeAuctionDealSupportEnabled() {
    return RuntimeEnabledFeatures::FledgeAuctionDealSupportEnabled();
  }
  bool fledgeBiddingAndAuctionServerAPIEnabled() {
    return RuntimeEnabledFeatures::FledgeBiddingAndAuctionServerAPIEnabledByRuntimeFlag();
  }
  bool fledgeBiddingAndAuctionServerAPIMultiSellerEnabled() {
    return RuntimeEnabledFeatures::FledgeBiddingAndAuctionServerAPIMultiSellerEnabled();
  }
  bool fledgeClickinessEnabled() {
    return RuntimeEnabledFeatures::FledgeClickinessEnabled();
  }
  bool fledgeCustomMaxAuctionAdComponentsEnabled() {
    return RuntimeEnabledFeatures::FledgeCustomMaxAuctionAdComponentsEnabled();
  }
  bool fledgeDeprecatedRenderURLReplacementsEnabled() {
    return RuntimeEnabledFeatures::FledgeDeprecatedRenderURLReplacementsEnabled();
  }
  bool fledgeDirectFromSellerSignalsHeaderAdSlotEnabled() {
    return RuntimeEnabledFeatures::FledgeDirectFromSellerSignalsHeaderAdSlotEnabled();
  }
  bool fledgeDirectFromSellerSignalsWebBundlesEnabled() {
    return RuntimeEnabledFeatures::FledgeDirectFromSellerSignalsWebBundlesEnabled();
  }
  bool fledgeMultiBidEnabled() {
    return RuntimeEnabledFeatures::FledgeMultiBidEnabled();
  }
  bool fledgePrivateModelTrainingEnabled() {
    return RuntimeEnabledFeatures::FledgePrivateModelTrainingEnabled();
  }
  bool fledgeRealTimeReportingEnabled() {
    return RuntimeEnabledFeatures::FledgeRealTimeReportingEnabled();
  }
  bool fledgeSellerNonceEnabled() {
    return RuntimeEnabledFeatures::FledgeSellerNonceEnabled();
  }
  bool fledgeSellerScriptExecutionModeEnabled() {
    return RuntimeEnabledFeatures::FledgeSellerScriptExecutionModeEnabled();
  }
  bool fledgeTrustedSignalsKVv1CreativeScanningEnabled() {
    return RuntimeEnabledFeatures::FledgeTrustedSignalsKVv1CreativeScanningEnabled();
  }
  bool fledgeTrustedSignalsKVv2ContextualDataEnabled() {
    return RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2ContextualDataEnabled();
  }
  bool fledgeTrustedSignalsKVv2SupportEnabled() {
    return RuntimeEnabledFeatures::FledgeTrustedSignalsKVv2SupportEnabled();
  }
  bool flexWrapBalanceEnabled() {
    return RuntimeEnabledFeatures::FlexWrapBalanceEnabled();
  }
  bool fluentOverlayScrollbarsEnabled() {
    return RuntimeEnabledFeatures::FluentOverlayScrollbarsEnabled();
  }
  bool fluentScrollbarsEnabled() {
    return RuntimeEnabledFeatures::FluentScrollbarsEnabled();
  }
  bool focusgroupEnabled() {
    return RuntimeEnabledFeatures::FocusgroupEnabledByRuntimeFlag();
  }
  bool focusgroupGridEnabled() {
    return RuntimeEnabledFeatures::FocusgroupGridEnabledByRuntimeFlag();
  }
  bool fontAccessEnabled() {
    return RuntimeEnabledFeatures::FontAccessEnabled();
  }
  bool fontFallbackForTabSizeEnabled() {
    return RuntimeEnabledFeatures::FontFallbackForTabSizeEnabled();
  }
  bool fontFamilyPostscriptMatchingCTMigrationEnabled() {
    return RuntimeEnabledFeatures::FontFamilyPostscriptMatchingCTMigrationEnabled();
  }
  bool fontFamilyStyleMatchingCTMigrationEnabled() {
    return RuntimeEnabledFeatures::FontFamilyStyleMatchingCTMigrationEnabled();
  }
  bool fontFeatureSettingsDescriptorEnabled() {
    return RuntimeEnabledFeatures::FontFeatureSettingsDescriptorEnabled();
  }
  bool fontLanguageOverrideEnabled() {
    return RuntimeEnabledFeatures::FontLanguageOverrideEnabled();
  }
  bool fontMatchAliasesAsLastResortEnabled() {
    return RuntimeEnabledFeatures::FontMatchAliasesAsLastResortEnabled();
  }
  bool fontSrcLocalMatchingEnabled() {
    return RuntimeEnabledFeatures::FontSrcLocalMatchingEnabled();
  }
  bool fontStyleObliqueZeroDegreeAsNormalEnabled() {
    return RuntimeEnabledFeatures::FontStyleObliqueZeroDegreeAsNormalEnabled();
  }
  bool fontVariationSettingsDescriptorEnabled() {
    return RuntimeEnabledFeatures::FontVariationSettingsDescriptorEnabled();
  }
  bool forcedColorsEnabled() {
    return RuntimeEnabledFeatures::ForcedColorsEnabled();
  }
  bool forceEagerMeasureMemoryEnabled() {
    return RuntimeEnabledFeatures::ForceEagerMeasureMemoryEnabled();
  }
  bool forceReduceMotionEnabled() {
    return RuntimeEnabledFeatures::ForceReduceMotionEnabled();
  }
  bool formControlRangeEnabled() {
    return RuntimeEnabledFeatures::FormControlRangeEnabled();
  }
  bool formControlRestoreStateIfAutocompleteOffEnabled() {
    return RuntimeEnabledFeatures::FormControlRestoreStateIfAutocompleteOffEnabled();
  }
  bool fractionalScrollOffsetsEnabled() {
    return RuntimeEnabledFeatures::FractionalScrollOffsetsEnabled();
  }
  bool freezeFramesOnVisibilityEnabled() {
    return RuntimeEnabledFeatures::FreezeFramesOnVisibilityEnabled();
  }
  bool gamepadMultitouchEnabled() {
    return RuntimeEnabledFeatures::GamepadMultitouchEnabled();
  }
  bool gamepadWindowEventHandlersEnabled() {
    return RuntimeEnabledFeatures::GamepadWindowEventHandlersEnabled();
  }
  bool geolocationElementEnabled() {
    return RuntimeEnabledFeatures::GeolocationElementEnabled();
  }
  bool getAllScreensMediaEnabled() {
    return RuntimeEnabledFeatures::GetAllScreensMediaEnabled();
  }
  bool getComputedStyleOutsideFlatTreeEnabled() {
    return RuntimeEnabledFeatures::GetComputedStyleOutsideFlatTreeEnabled();
  }
  bool getDisplayMediaEnabled() {
    return RuntimeEnabledFeatures::GetDisplayMediaEnabled();
  }
  bool getDisplayMediaRequiresUserActivationEnabled() {
    return RuntimeEnabledFeatures::GetDisplayMediaRequiresUserActivationEnabled();
  }
  bool getDisplayMediaWindowAudioCaptureEnabled() {
    return RuntimeEnabledFeatures::GetDisplayMediaWindowAudioCaptureEnabled();
  }
  bool getElementsByNameOnlyHTMLElementsEnabled() {
    return RuntimeEnabledFeatures::GetElementsByNameOnlyHTMLElementsEnabled();
  }
  bool getUserMediaEchoCancellationModesEnabled() {
    return RuntimeEnabledFeatures::GetUserMediaEchoCancellationModesEnabled();
  }
  bool groupEffectEnabled() {
    return RuntimeEnabledFeatures::GroupEffectEnabled();
  }
  bool handleDeletionAtStartAndEndBoundaryContainingHiddenElementEnabled() {
    return RuntimeEnabledFeatures::HandleDeletionAtStartAndEndBoundaryContainingHiddenElementEnabled();
  }
  bool handleDisconnectedSelectionDuringDOMChangesEnabled() {
    return RuntimeEnabledFeatures::HandleDisconnectedSelectionDuringDOMChangesEnabled();
  }
  bool handleShadowDOMInSubstringUtilEnabled() {
    return RuntimeEnabledFeatures::HandleShadowDOMInSubstringUtilEnabled();
  }
  bool handwritingRecognitionEnabled() {
    return RuntimeEnabledFeatures::HandwritingRecognitionEnabled();
  }
  bool hasUAVisualTransitionEnabled() {
    return RuntimeEnabledFeatures::HasUAVisualTransitionEnabled();
  }
  bool headingOffsetEnabled() {
    return RuntimeEnabledFeatures::HeadingOffsetEnabled();
  }
  bool highlightByLayoutObjectEnabled() {
    return RuntimeEnabledFeatures::HighlightByLayoutObjectEnabled();
  }
  bool highlightPointerEventsEnabled() {
    return RuntimeEnabledFeatures::HighlightPointerEventsEnabled();
  }
  bool highlightsFromPointEnabled() {
    return RuntimeEnabledFeatures::HighlightsFromPointEnabled();
  }
  bool hitTestBorderRadiusForStackingContextEnabled() {
    return RuntimeEnabledFeatures::HitTestBorderRadiusForStackingContextEnabled();
  }
  bool hrefTranslateEnabled() {
    return RuntimeEnabledFeatures::HrefTranslateEnabledByRuntimeFlag();
  }
  bool htmlAnchorAttributeEnabled() {
    return RuntimeEnabledFeatures::HTMLAnchorAttributeEnabled();
  }
  bool htmlCommandActionsV2Enabled() {
    return RuntimeEnabledFeatures::HTMLCommandActionsV2Enabled();
  }
  bool htmlCommandRequestCloseEnabled() {
    return RuntimeEnabledFeatures::HTMLCommandRequestCloseEnabled();
  }
  bool htmlElementScrollParentEnabled() {
    return RuntimeEnabledFeatures::HTMLElementScrollParentEnabled();
  }
  bool htmlImageElementActualNaturalSizeEnabled() {
    return RuntimeEnabledFeatures::HTMLImageElementActualNaturalSizeEnabled();
  }
  bool htmlInterestForAttributeEnabled() {
    return RuntimeEnabledFeatures::HTMLInterestForAttributeEnabled();
  }
  bool htmlInterestForInterestHintPseudoEnabled() {
    return RuntimeEnabledFeatures::HTMLInterestForInterestHintPseudoEnabled();
  }
  bool htmlLinkElementAttributeValueChangesEnabled() {
    return RuntimeEnabledFeatures::HTMLLinkElementAttributeValueChangesEnabled();
  }
  bool htmlParserYieldAndDelayOftenForTestingEnabled() {
    return RuntimeEnabledFeatures::HTMLParserYieldAndDelayOftenForTestingEnabled();
  }
  bool htmlParserYieldByUserTimingEnabled() {
    return RuntimeEnabledFeatures::HTMLParserYieldByUserTimingEnabled();
  }
  bool htmlPrintingArtifactAnnotationsEnabled() {
    return RuntimeEnabledFeatures::HTMLPrintingArtifactAnnotationsEnabled();
  }
  bool icuCapitalizationEnabled() {
    return RuntimeEnabledFeatures::ICUCapitalizationEnabled();
  }
  bool ignoreLetterSpacingInCursiveScriptsEnabled() {
    return RuntimeEnabledFeatures::IgnoreLetterSpacingInCursiveScriptsEnabled();
  }
  bool imageDataPixelFormatEnabled() {
    return RuntimeEnabledFeatures::ImageDataPixelFormatEnabled();
  }
  bool imageDocumentUseLayoutWidthEnabled() {
    return RuntimeEnabledFeatures::ImageDocumentUseLayoutWidthEnabled();
  }
  bool implicitRootScrollerEnabled() {
    return RuntimeEnabledFeatures::ImplicitRootScrollerEnabled();
  }
  bool improvedSourceRetargetingEnabled() {
    return RuntimeEnabledFeatures::ImprovedSourceRetargetingEnabled();
  }
  bool incomingCallNotificationsEnabled() {
    return RuntimeEnabledFeatures::IncomingCallNotificationsEnabledByRuntimeFlag();
  }
  bool indexedDbGetAllRecordsEnabled() {
    return RuntimeEnabledFeatures::IndexedDbGetAllRecordsEnabled();
  }
  bool inertElementNonEditableEnabled() {
    return RuntimeEnabledFeatures::InertElementNonEditableEnabled();
  }
  bool infiniteCullRectEnabled() {
    return RuntimeEnabledFeatures::InfiniteCullRectEnabled();
  }
  bool inheritUserModifyWithoutContenteditableEnabled() {
    return RuntimeEnabledFeatures::InheritUserModifyWithoutContenteditableEnabled();
  }
  bool innerHTMLParserFastpathLogFailureEnabled() {
    return RuntimeEnabledFeatures::InnerHTMLParserFastpathLogFailureEnabled();
  }
  bool inputEventDataTransferForInsertCmdEnabled() {
    return RuntimeEnabledFeatures::InputEventDataTransferForInsertCmdEnabled();
  }
  bool inputInSelectEnabled() {
    return RuntimeEnabledFeatures::InputInSelectEnabled();
  }
  bool inputMultipleFieldsUIEnabled() {
    return RuntimeEnabledFeatures::InputMultipleFieldsUIEnabled();
  }
  bool insertBlockquoteBeforeOuterBlockEnabled() {
    return RuntimeEnabledFeatures::InsertBlockquoteBeforeOuterBlockEnabled();
  }
  bool insertLineBreakIfPhrasingContentEnabled() {
    return RuntimeEnabledFeatures::InsertLineBreakIfPhrasingContentEnabled();
  }
  bool installedAppEnabled() {
    return RuntimeEnabledFeatures::InstalledAppEnabled();
  }
  bool installOnDeviceSpeechRecognitionEnabled() {
    return RuntimeEnabledFeatures::InstallOnDeviceSpeechRecognitionEnabled();
  }
  bool integrityPolicyScriptEnabled() {
    return RuntimeEnabledFeatures::IntegrityPolicyScriptEnabled();
  }
  bool interactivityInertImportantEnabled() {
    return RuntimeEnabledFeatures::InteractivityInertImportantEnabled();
  }
  bool interestGroupsInSharedStorageWorkletEnabled() {
    return RuntimeEnabledFeatures::InterestGroupsInSharedStorageWorkletEnabled();
  }
  bool intersectionObserverCompositedAnimationsForceMainFramesEnabled() {
    return RuntimeEnabledFeatures::IntersectionObserverCompositedAnimationsForceMainFramesEnabled();
  }
  bool invertedColorsEnabled() {
    return RuntimeEnabledFeatures::InvertedColorsEnabled();
  }
  bool invisibleSVGAnimationThrottlingEnabled() {
    return RuntimeEnabledFeatures::InvisibleSVGAnimationThrottlingEnabled();
  }
  bool javaScriptCompileHintsPerFunctionMagicRuntimeEnabled() {
    return RuntimeEnabledFeatures::JavaScriptCompileHintsPerFunctionMagicRuntimeEnabledByRuntimeFlag();
  }
  bool javaScriptSourcePhaseImportsEnabled() {
    return RuntimeEnabledFeatures::JavaScriptSourcePhaseImportsEnabled();
  }
  bool keyboardAccessibleTooltipEnabled() {
    return RuntimeEnabledFeatures::KeyboardAccessibleTooltipEnabled();
  }
  bool keyboardFocusabilityAfterFindInPageEnabled() {
    return RuntimeEnabledFeatures::KeyboardFocusabilityAfterFindInPageEnabled();
  }
  bool langAttributeAwareFormControlUIEnabled() {
    return RuntimeEnabledFeatures::LangAttributeAwareFormControlUIEnabled();
  }
  bool languageDetectionAPIEnabled() {
    return RuntimeEnabledFeatures::LanguageDetectionAPIEnabledByRuntimeFlag();
  }
  bool languageDetectionAPIForWorkersEnabled() {
    return RuntimeEnabledFeatures::LanguageDetectionAPIForWorkersEnabled();
  }
  bool layoutFlexNewRowAlgorithmEnabled() {
    return RuntimeEnabledFeatures::LayoutFlexNewRowAlgorithmEnabled();
  }
  bool layoutIgnoreMarginsForStickyEnabled() {
    return RuntimeEnabledFeatures::LayoutIgnoreMarginsForStickyEnabled();
  }
  bool leftClickToHandleSuggestionEnabled() {
    return RuntimeEnabledFeatures::LeftClickToHandleSuggestionEnabled();
  }
  bool lightDismissFromClickEnabled() {
    return RuntimeEnabledFeatures::LightDismissFromClickEnabled();
  }
  bool limitThirdPartyCookiesEnabled() {
    return RuntimeEnabledFeatures::LimitThirdPartyCookiesEnabledByRuntimeFlag();
  }
  bool linkBlurImprovementEnabled() {
    return RuntimeEnabledFeatures::LinkBlurImprovementEnabled();
  }
  bool listOwnerMustHaveCSSBoxEnabled() {
    return RuntimeEnabledFeatures::ListOwnerMustHaveCSSBoxEnabled();
  }
  bool localNetworkAccessNonSecureContextAllowedEnabled() {
    return RuntimeEnabledFeatures::LocalNetworkAccessNonSecureContextAllowedEnabledByRuntimeFlag();
  }
  bool localNetworkAccessPermissionPolicyEnabled() {
    return RuntimeEnabledFeatures::LocalNetworkAccessPermissionPolicyEnabled();
  }
  bool localNetworkAccessWebRTCEnabled() {
    return RuntimeEnabledFeatures::LocalNetworkAccessWebRTCEnabled();
  }
  bool lockedModeEnabled() {
    return RuntimeEnabledFeatures::LockedModeEnabled();
  }
  bool longAnimationFrameSourceCharPositionEnabled() {
    return RuntimeEnabledFeatures::LongAnimationFrameSourceCharPositionEnabled();
  }
  bool longAnimationFrameSourceLineColumnEnabled() {
    return RuntimeEnabledFeatures::LongAnimationFrameSourceLineColumnEnabled();
  }
  bool longAnimationFrameSourceLineColumnInterfaceEnabled() {
    return RuntimeEnabledFeatures::LongAnimationFrameSourceLineColumnInterfaceEnabled();
  }
  bool longPressLinkSelectTextEnabled() {
    return RuntimeEnabledFeatures::LongPressLinkSelectTextEnabled();
  }
  bool longTaskFromLongAnimationFrameEnabled() {
    return RuntimeEnabledFeatures::LongTaskFromLongAnimationFrameEnabled();
  }
  bool macCharacterFallbackCacheEnabled() {
    return RuntimeEnabledFeatures::MacCharacterFallbackCacheEnabled();
  }
  bool macDisableCtrlHomeEndEnabled() {
    return RuntimeEnabledFeatures::MacDisableCtrlHomeEndEnabled();
  }
  bool machineLearningNeuralNetworkEnabled() {
    return RuntimeEnabledFeatures::MachineLearningNeuralNetworkEnabled();
  }
  bool macSystemClipboardPermissionCheckEnabled() {
    return RuntimeEnabledFeatures::MacSystemClipboardPermissionCheckEnabled();
  }
  bool managedConfigurationEnabled() {
    return RuntimeEnabledFeatures::ManagedConfigurationEnabled();
  }
  bool maskDeserializationTimeForCrossOriginMessagesEnabled() {
    return RuntimeEnabledFeatures::MaskDeserializationTimeForCrossOriginMessagesEnabled();
  }
  bool mathmlOperatorRTLMirroringEnabled() {
    return RuntimeEnabledFeatures::MathMLOperatorRTLMirroringEnabled();
  }
  bool mathmlSerializationOnCopyEnabled() {
    return RuntimeEnabledFeatures::MathMLSerializationOnCopyEnabled();
  }
  bool measureMemoryEnabled() {
    return RuntimeEnabledFeatures::MeasureMemoryEnabled();
  }
  bool mediaCapabilitiesEncodingInfoEnabled() {
    return RuntimeEnabledFeatures::MediaCapabilitiesEncodingInfoEnabled();
  }
  bool mediaCapabilitiesSpatialAudioEnabled() {
    return RuntimeEnabledFeatures::MediaCapabilitiesSpatialAudioEnabled();
  }
  bool mediaCaptureEnabled() {
    return RuntimeEnabledFeatures::MediaCaptureEnabled();
  }
  bool mediaCaptureBackgroundBlurEnabled() {
    return RuntimeEnabledFeatures::MediaCaptureBackgroundBlurEnabledByRuntimeFlag();
  }
  bool mediaCaptureCameraControlsEnabled() {
    return RuntimeEnabledFeatures::MediaCaptureCameraControlsEnabled();
  }
  bool mediaCaptureConfigurationChangeEnabled() {
    return RuntimeEnabledFeatures::MediaCaptureConfigurationChangeEnabledByRuntimeFlag();
  }
  bool mediaCaptureVoiceIsolationEnabled() {
    return RuntimeEnabledFeatures::MediaCaptureVoiceIsolationEnabled();
  }
  bool mediaControlsExpandGestureEnabled() {
    return RuntimeEnabledFeatures::MediaControlsExpandGestureEnabled();
  }
  bool mediaControlsOverlayPlayButtonEnabled() {
    return RuntimeEnabledFeatures::MediaControlsOverlayPlayButtonEnabled();
  }
  bool mediaElementVolumeGreaterThanOneEnabled() {
    return RuntimeEnabledFeatures::MediaElementVolumeGreaterThanOneEnabled();
  }
  bool mediaEngagementBypassAutoplayPoliciesEnabled() {
    return RuntimeEnabledFeatures::MediaEngagementBypassAutoplayPoliciesEnabled();
  }
  bool mediaLatencyHintEnabled() {
    return RuntimeEnabledFeatures::MediaLatencyHintEnabled();
  }
  bool mediaPlaybackWhileNotVisiblePermissionPolicyEnabled() {
    return RuntimeEnabledFeatures::MediaPlaybackWhileNotVisiblePermissionPolicyEnabledByRuntimeFlag();
  }
  bool mediaQueryNavigationControlsEnabled() {
    return RuntimeEnabledFeatures::MediaQueryNavigationControlsEnabled();
  }
  bool mediaSessionEnabled() {
    return RuntimeEnabledFeatures::MediaSessionEnabled();
  }
  bool mediaSessionChapterInformationEnabled() {
    return RuntimeEnabledFeatures::MediaSessionChapterInformationEnabled();
  }
  bool mediaSessionEnterPictureInPictureEnabled() {
    return RuntimeEnabledFeatures::MediaSessionEnterPictureInPictureEnabled();
  }
  bool mediaSourceExperimentalEnabled() {
    return RuntimeEnabledFeatures::MediaSourceExperimentalEnabled();
  }
  bool mediaSourceExtensionsForWebCodecsEnabled() {
    return RuntimeEnabledFeatures::MediaSourceExtensionsForWebCodecsEnabledByRuntimeFlag();
  }
  bool mediaSourceNewAbortAndDurationEnabled() {
    return RuntimeEnabledFeatures::MediaSourceNewAbortAndDurationEnabled();
  }
  bool mediaStreamTrackTransferEnabled() {
    return RuntimeEnabledFeatures::MediaStreamTrackTransferEnabled();
  }
  bool mediaStreamTrackWebSpeechEnabled() {
    return RuntimeEnabledFeatures::MediaStreamTrackWebSpeechEnabled();
  }
  bool menuElementsEnabled() {
    return RuntimeEnabledFeatures::MenuElementsEnabled();
  }
  bool messagePortCloseEventEnabled() {
    return RuntimeEnabledFeatures::MessagePortCloseEventEnabled();
  }
  bool middleClickAutoscrollEnabled() {
    return RuntimeEnabledFeatures::MiddleClickAutoscrollEnabled();
  }
  bool mixedContentAutoupgradesUseIsMixedContentRestrictedInFrameEnabled() {
    return RuntimeEnabledFeatures::MixedContentAutoupgradesUseIsMixedContentRestrictedInFrameEnabled();
  }
  bool mobileLayoutThemeEnabled() {
    return RuntimeEnabledFeatures::MobileLayoutThemeEnabled();
  }
  bool modifyParagraphCrossEditingoundaryEnabled() {
    return RuntimeEnabledFeatures::ModifyParagraphCrossEditingoundaryEnabled();
  }
  bool modulePreloadReferrerEnabled() {
    return RuntimeEnabledFeatures::ModulePreloadReferrerEnabled();
  }
  bool mojoJSEnabled() {
    return RuntimeEnabledFeatures::MojoJSEnabled();
  }
  bool mojoJSTestEnabled() {
    return RuntimeEnabledFeatures::MojoJSTestEnabled();
  }
  bool moveEndingSelectionToListChildEnabled() {
    return RuntimeEnabledFeatures::MoveEndingSelectionToListChildEnabled();
  }
  bool moveToParagraphStartOrEndSkipsNonEditableEnabled() {
    return RuntimeEnabledFeatures::MoveToParagraphStartOrEndSkipsNonEditableEnabled();
  }
  bool multicastInDirectSocketsEnabled() {
    return RuntimeEnabledFeatures::MulticastInDirectSocketsEnabled();
  }
  bool multicolColumnWrappingEnabled() {
    return RuntimeEnabledFeatures::MulticolColumnWrappingEnabled();
  }
  bool navigateEventCanTransitionEnabled() {
    return RuntimeEnabledFeatures::NavigateEventCanTransitionEnabled();
  }
  bool navigateEventCommitBehaviorEnabled() {
    return RuntimeEnabledFeatures::NavigateEventCommitBehaviorEnabled();
  }
  bool navigateEventPopstateLimitationsEnabled() {
    return RuntimeEnabledFeatures::NavigateEventPopstateLimitationsEnabled();
  }
  bool navigateEventSourceElementEnabled() {
    return RuntimeEnabledFeatures::NavigateEventSourceElementEnabled();
  }
  bool navigationIdEnabled() {
    return RuntimeEnabledFeatures::NavigationIdEnabledByRuntimeFlag();
  }
  bool navigationTransitionDestinationEnabled() {
    return RuntimeEnabledFeatures::NavigationTransitionDestinationEnabled();
  }
  bool navigatorContentUtilsEnabled() {
    return RuntimeEnabledFeatures::NavigatorContentUtilsEnabled();
  }
  bool nestedRubyMinMaxFixEnabled() {
    return RuntimeEnabledFeatures::NestedRubyMinMaxFixEnabled();
  }
  bool nestedViewTransitionEnabled() {
    return RuntimeEnabledFeatures::NestedViewTransitionEnabled();
  }
  bool netInfoConstantTypeEnabled() {
    return RuntimeEnabledFeatures::NetInfoConstantTypeEnabled();
  }
  bool netInfoDownlinkMaxEnabled() {
    return RuntimeEnabledFeatures::NetInfoDownlinkMaxEnabled();
  }
  bool noFontAntialiasingEnabled() {
    return RuntimeEnabledFeatures::NoFontAntialiasingEnabled();
  }
  bool noIdleEncodingForWebTestsEnabled() {
    return RuntimeEnabledFeatures::NoIdleEncodingForWebTestsEnabled();
  }
  bool nonEmptyBlockquotesOnOutdentingEnabled() {
    return RuntimeEnabledFeatures::NonEmptyBlockquotesOnOutdentingEnabled();
  }
  bool nonEmptyVisibleTextSelectionForTextFragmentEnabled() {
    return RuntimeEnabledFeatures::NonEmptyVisibleTextSelectionForTextFragmentEnabled();
  }
  bool nonStandardAppearanceValueSliderVerticalEnabled() {
    return RuntimeEnabledFeatures::NonStandardAppearanceValueSliderVerticalEnabled();
  }
  bool notificationConstructorEnabled() {
    return RuntimeEnabledFeatures::NotificationConstructorEnabled();
  }
  bool notificationContentImageEnabled() {
    return RuntimeEnabledFeatures::NotificationContentImageEnabled();
  }
  bool notificationsEnabled() {
    return RuntimeEnabledFeatures::NotificationsEnabled();
  }
  bool notificationTriggersEnabled() {
    return RuntimeEnabledFeatures::NotificationTriggersEnabledByRuntimeFlag();
  }
  bool numberInputFullWidthCharsEnabled() {
    return RuntimeEnabledFeatures::NumberInputFullWidthCharsEnabled();
  }
  bool offMainThreadCSSPaintEnabled() {
    return RuntimeEnabledFeatures::OffMainThreadCSSPaintEnabled();
  }
  bool offscreenCanvasGetContextAttributesEnabled() {
    return RuntimeEnabledFeatures::OffscreenCanvasGetContextAttributesEnabled();
  }
  bool offsetParentNewSpecBehaviorForFixedPositionEnabled() {
    return RuntimeEnabledFeatures::OffsetParentNewSpecBehaviorForFixedPositionEnabled();
  }
  bool omitBlurEventOnElementRemovalEnabled() {
    return RuntimeEnabledFeatures::OmitBlurEventOnElementRemovalEnabled();
  }
  bool onDeviceWebSpeechAvailableEnabled() {
    return RuntimeEnabledFeatures::OnDeviceWebSpeechAvailableEnabled();
  }
  bool openPopoverInvokerRestrictToSameTreeScopeEnabled() {
    return RuntimeEnabledFeatures::OpenPopoverInvokerRestrictToSameTreeScopeEnabled();
  }
  bool orientationEventEnabled() {
    return RuntimeEnabledFeatures::OrientationEventEnabled();
  }
  bool originAPIEnabled() {
    return RuntimeEnabledFeatures::OriginAPIEnabled();
  }
  bool originatingElementIsImplicitAnchorEnabled() {
    return RuntimeEnabledFeatures::OriginatingElementIsImplicitAnchorEnabled();
  }
  bool originIsolationHeaderEnabled() {
    return RuntimeEnabledFeatures::OriginIsolationHeaderEnabled();
  }
  bool originPolicyEnabled() {
    return RuntimeEnabledFeatures::OriginPolicyEnabled();
  }
  bool originTrialsSampleAPIEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIBrowserReadWriteEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIBrowserReadWriteEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIDependentEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIDependentEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIDeprecationEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIDeprecationEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIExpiryGracePeriodEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIExpiryGracePeriodEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIExpiryGracePeriodThirdPartyEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIExpiryGracePeriodThirdPartyEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIImpliedEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIImpliedEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIInvalidOSEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIInvalidOSEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPINavigationEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPINavigationEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIPersistentExpiryGracePeriodEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIPersistentExpiryGracePeriodEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIPersistentFeatureEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIPersistentFeatureEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIPersistentInvalidOSEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIPersistentInvalidOSEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIPersistentThirdPartyDeprecationFeatureEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIPersistentThirdPartyDeprecationFeatureEnabledByRuntimeFlag();
  }
  bool originTrialsSampleAPIThirdPartyEnabled() {
    return RuntimeEnabledFeatures::OriginTrialsSampleAPIThirdPartyEnabledByRuntimeFlag();
  }
  bool overscrollCustomizationEnabled() {
    return RuntimeEnabledFeatures::OverscrollCustomizationEnabled();
  }
  bool pagePopupEnabled() {
    return RuntimeEnabledFeatures::PagePopupEnabled();
  }
  bool pagePopupCopyPasteEnabled() {
    return RuntimeEnabledFeatures::PagePopupCopyPasteEnabled();
  }
  bool pageRevealEventEnabled() {
    return RuntimeEnabledFeatures::PageRevealEventEnabled();
  }
  bool pageSwapEventEnabled() {
    return RuntimeEnabledFeatures::PageSwapEventEnabled();
  }
  bool paintHoldingForIframesEnabled() {
    return RuntimeEnabledFeatures::PaintHoldingForIframesEnabled();
  }
  bool paintOffsetTranslationForBackdropFilterWithInlineElementEnabled() {
    return RuntimeEnabledFeatures::PaintOffsetTranslationForBackdropFilterWithInlineElementEnabled();
  }
  bool paintOffsetTranslationForCompositedEnabled() {
    return RuntimeEnabledFeatures::PaintOffsetTranslationForCompositedEnabled();
  }
  bool paintTimingMixinEnabled() {
    return RuntimeEnabledFeatures::PaintTimingMixinEnabled();
  }
  bool paintUnderInvalidationCheckingEnabled() {
    return RuntimeEnabledFeatures::PaintUnderInvalidationCheckingEnabled();
  }
  bool parakeetEnabled() {
    return RuntimeEnabledFeatures::ParakeetEnabledByRuntimeFlag();
  }
  bool partialCompletionNotAllowedInMoveParagraphsEnabled() {
    return RuntimeEnabledFeatures::PartialCompletionNotAllowedInMoveParagraphsEnabled();
  }
  bool partitionedPopinsEnabled() {
    return RuntimeEnabledFeatures::PartitionedPopinsEnabled();
  }
  bool partitionVisitedLinkDatabaseWithSelfLinksEnabled() {
    return RuntimeEnabledFeatures::PartitionVisitedLinkDatabaseWithSelfLinksEnabled();
  }
  bool passwordRevealEnabled() {
    return RuntimeEnabledFeatures::PasswordRevealEnabled();
  }
  bool paymentAppEnabled() {
    return RuntimeEnabledFeatures::PaymentAppEnabled();
  }
  bool paymentLinkDetectionEnabled() {
    return RuntimeEnabledFeatures::PaymentLinkDetectionEnabled();
  }
  bool paymentMethodChangeEventEnabled() {
    return RuntimeEnabledFeatures::PaymentMethodChangeEventEnabled();
  }
  bool paymentRequestEnabled() {
    return RuntimeEnabledFeatures::PaymentRequestEnabled();
  }
  bool performanceManagerInstrumentationEnabled() {
    return RuntimeEnabledFeatures::PerformanceManagerInstrumentationEnabled();
  }
  bool performanceMarkFeatureUsageEnabled() {
    return RuntimeEnabledFeatures::PerformanceMarkFeatureUsageEnabled();
  }
  bool performanceNavigateSystemEntropyEnabled() {
    return RuntimeEnabledFeatures::PerformanceNavigateSystemEntropyEnabled();
  }
  bool performanceNavigationTimingConfidenceEnabled() {
    return RuntimeEnabledFeatures::PerformanceNavigationTimingConfidenceEnabledByRuntimeFlag();
  }
  bool periodicBackgroundSyncEnabled() {
    return RuntimeEnabledFeatures::PeriodicBackgroundSyncEnabled();
  }
  bool perMethodCanMakePaymentQuotaEnabled() {
    return RuntimeEnabledFeatures::PerMethodCanMakePaymentQuotaEnabledByRuntimeFlag();
  }
  bool permissionElementEnabled() {
    return RuntimeEnabledFeatures::PermissionElementEnabledByRuntimeFlag();
  }
  bool permissionElementIconEnabled() {
    return RuntimeEnabledFeatures::PermissionElementIconEnabledByRuntimeFlag();
  }
  bool permissionsEnabled() {
    return RuntimeEnabledFeatures::PermissionsEnabled();
  }
  bool permissionsRequestRevokeEnabled() {
    return RuntimeEnabledFeatures::PermissionsRequestRevokeEnabled();
  }
  bool placeholderVisibilityEnabled() {
    return RuntimeEnabledFeatures::PlaceholderVisibilityEnabled();
  }
  bool pNaClEnabled() {
    return RuntimeEnabledFeatures::PNaClEnabledByRuntimeFlag();
  }
  bool pointerEventDeviceIdEnabled() {
    return RuntimeEnabledFeatures::PointerEventDeviceIdEnabled();
  }
  bool pointerLockOnAndroidEnabled() {
    return RuntimeEnabledFeatures::PointerLockOnAndroidEnabled();
  }
  bool pointerRawUpdateOnlyInSecureContextEnabled() {
    return RuntimeEnabledFeatures::PointerRawUpdateOnlyInSecureContextEnabled();
  }
  bool positionAreaXYSelfEnabled() {
    return RuntimeEnabledFeatures::PositionAreaXYSelfEnabled();
  }
  bool positionOutsideTabSpanCheckSiblingNodeEnabled() {
    return RuntimeEnabledFeatures::PositionOutsideTabSpanCheckSiblingNodeEnabled();
  }
  bool positionVisibilityIgnoreNonClipAncestorsEnabled() {
    return RuntimeEnabledFeatures::PositionVisibilityIgnoreNonClipAncestorsEnabled();
  }
  bool potentialPermissionsPolicyReportingEnabled() {
    return RuntimeEnabledFeatures::PotentialPermissionsPolicyReportingEnabled();
  }
  bool preciseMemoryInfoEnabled() {
    return RuntimeEnabledFeatures::PreciseMemoryInfoEnabled();
  }
  bool preferDefaultScrollbarStylesEnabled() {
    return RuntimeEnabledFeatures::PreferDefaultScrollbarStylesEnabled();
  }
  bool preferNonCompositedScrollingEnabled() {
    return RuntimeEnabledFeatures::PreferNonCompositedScrollingEnabled();
  }
  bool preferredAudioOutputDevicesEnabled() {
    return RuntimeEnabledFeatures::PreferredAudioOutputDevicesEnabledByRuntimeFlag();
  }
  bool prefersReducedDataEnabled() {
    return RuntimeEnabledFeatures::PrefersReducedDataEnabled();
  }
  bool preloadLinkRelDataUrlsEnabled() {
    return RuntimeEnabledFeatures::PreloadLinkRelDataUrlsEnabled();
  }
  bool prerender2Enabled() {
    return RuntimeEnabledFeatures::Prerender2Enabled();
  }
  bool prerender2CrossOriginIframesEnabled() {
    return RuntimeEnabledFeatures::Prerender2CrossOriginIframesEnabledByRuntimeFlag();
  }
  bool prerenderUntilScriptEnabled() {
    return RuntimeEnabledFeatures::PrerenderUntilScriptEnabled();
  }
  bool presentationEnabled() {
    return RuntimeEnabledFeatures::PresentationEnabled();
  }
  bool preserveDropEffectEnabled() {
    return RuntimeEnabledFeatures::PreserveDropEffectEnabled();
  }
  bool preventUndoIfNotEditableEnabled() {
    return RuntimeEnabledFeatures::PreventUndoIfNotEditableEnabled();
  }
  bool privateAggregationApiErrorReportingEnabled() {
    return RuntimeEnabledFeatures::PrivateAggregationApiErrorReportingEnabled();
  }
  bool privateAggregationApiMaxContributionsEnabled() {
    return RuntimeEnabledFeatures::PrivateAggregationApiMaxContributionsEnabled();
  }
  bool privateNetworkAccessNullIpAddressEnabled() {
    return RuntimeEnabledFeatures::PrivateNetworkAccessNullIpAddressEnabled();
  }
  bool privateStateTokensEnabled() {
    return RuntimeEnabledFeatures::PrivateStateTokensEnabled();
  }
  bool privateStateTokensAlwaysAllowIssuanceEnabled() {
    return RuntimeEnabledFeatures::PrivateStateTokensAlwaysAllowIssuanceEnabled();
  }
  bool programmaticScrollPromiseEnabled() {
    return RuntimeEnabledFeatures::ProgrammaticScrollPromiseEnabled();
  }
  bool propagateOverscrollBehaviorFromRootEnabled() {
    return RuntimeEnabledFeatures::PropagateOverscrollBehaviorFromRootEnabled();
  }
  bool protectedOriginTrialsSampleAPIEnabled() {
    return RuntimeEnabledFeatures::ProtectedOriginTrialsSampleAPIEnabledByRuntimeFlag();
  }
  bool protectedOriginTrialsSampleAPIDependentEnabled() {
    return RuntimeEnabledFeatures::ProtectedOriginTrialsSampleAPIDependentEnabledByRuntimeFlag();
  }
  bool protectedOriginTrialsSampleAPIImpliedEnabled() {
    return RuntimeEnabledFeatures::ProtectedOriginTrialsSampleAPIImpliedEnabledByRuntimeFlag();
  }
  bool pseudoElementsFocusableEnabled() {
    return RuntimeEnabledFeatures::PseudoElementsFocusableEnabled();
  }
  bool pushMessageDataBytesEnabled() {
    return RuntimeEnabledFeatures::PushMessageDataBytesEnabled();
  }
  bool pushMessagingEnabled() {
    return RuntimeEnabledFeatures::PushMessagingEnabled();
  }
  bool pushMessagingSubscriptionChangeEnabled() {
    return RuntimeEnabledFeatures::PushMessagingSubscriptionChangeEnabled();
  }
  bool quotaExceededErrorUpdateEnabled() {
    return RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled();
  }
  bool quoteFirstLineStyleEnabled() {
    return RuntimeEnabledFeatures::QuoteFirstLineStyleEnabled();
  }
  bool rasterInducingScrollEnabled() {
    return RuntimeEnabledFeatures::RasterInducingScrollEnabled();
  }
  bool readableStreamBYOBReaderReadMinOptionEnabled() {
    return RuntimeEnabledFeatures::ReadableStreamBYOBReaderReadMinOptionEnabled();
  }
  bool recordSameDocumentPresentationTimeOnceEnabled() {
    return RuntimeEnabledFeatures::RecordSameDocumentPresentationTimeOnceEnabled();
  }
  bool reduceAcceptLanguageEnabled() {
    return RuntimeEnabledFeatures::ReduceAcceptLanguageEnabled();
  }
  bool reduceUserAgentAndroidVersionDeviceModelEnabled() {
    return RuntimeEnabledFeatures::ReduceUserAgentAndroidVersionDeviceModelEnabled();
  }
  bool reduceUserAgentDataLinuxPlatformVersionEnabled() {
    return RuntimeEnabledFeatures::ReduceUserAgentDataLinuxPlatformVersionEnabled();
  }
  bool reduceUserAgentMinorVersionEnabled() {
    return RuntimeEnabledFeatures::ReduceUserAgentMinorVersionEnabled();
  }
  bool reduceUserAgentPlatformOsCpuEnabled() {
    return RuntimeEnabledFeatures::ReduceUserAgentPlatformOsCpuEnabled();
  }
  bool regionCaptureEnabled() {
    return RuntimeEnabledFeatures::RegionCaptureEnabled();
  }
  bool relatedWebsitePartitionAPIEnabled() {
    return RuntimeEnabledFeatures::RelatedWebsitePartitionAPIEnabled();
  }
  bool relaxDOMValidNamesEnabled() {
    return RuntimeEnabledFeatures::RelaxDOMValidNamesEnabled();
  }
  bool relOpenerBcgDependencyHintEnabled() {
    return RuntimeEnabledFeatures::RelOpenerBcgDependencyHintEnabled();
  }
  bool remotePlaybackEnabled() {
    return RuntimeEnabledFeatures::RemotePlaybackEnabled();
  }
  bool remotePlaybackBackendEnabled() {
    return RuntimeEnabledFeatures::RemotePlaybackBackendEnabled();
  }
  bool removeCharsetAutoDetectionForISO2022JPEnabled() {
    return RuntimeEnabledFeatures::RemoveCharsetAutoDetectionForISO2022JPEnabled();
  }
  bool removeCollapsedPlaceholderForContentEditableEnabled() {
    return RuntimeEnabledFeatures::RemoveCollapsedPlaceholderForContentEditableEnabled();
  }
  bool removeDanglingMarkupInTargetEnabled() {
    return RuntimeEnabledFeatures::RemoveDanglingMarkupInTargetEnabled();
  }
  bool removeDataUrlInSvgUseEnabled() {
    return RuntimeEnabledFeatures::RemoveDataUrlInSvgUseEnabled();
  }
  bool removeFormatFilterBackgroundColorEnabled() {
    return RuntimeEnabledFeatures::RemoveFormatFilterBackgroundColorEnabled();
  }
  bool removeSelectionCanonicalizationInMoveParagraphEnabled() {
    return RuntimeEnabledFeatures::RemoveSelectionCanonicalizationInMoveParagraphEnabled();
  }
  bool removeVisibleSelectionInDOMSelectionEnabled() {
    return RuntimeEnabledFeatures::RemoveVisibleSelectionInDOMSelectionEnabled();
  }
  bool renderBlockingFullFrameRateEnabled() {
    return RuntimeEnabledFeatures::RenderBlockingFullFrameRateEnabledByRuntimeFlag();
  }
  bool renderBlockingStatusEnabled() {
    return RuntimeEnabledFeatures::RenderBlockingStatusEnabled();
  }
  bool renderPriorityAttributeEnabled() {
    return RuntimeEnabledFeatures::RenderPriorityAttributeEnabled();
  }
  bool replacedElementCursorPositioningFixEnabled() {
    return RuntimeEnabledFeatures::ReplacedElementCursorPositioningFixEnabled();
  }
  bool reportFirstFrameTimeAsRenderTimeEnabled() {
    return RuntimeEnabledFeatures::ReportFirstFrameTimeAsRenderTimeEnabled();
  }
  bool reportLayoutShiftRectsInCssPixelsEnabled() {
    return RuntimeEnabledFeatures::ReportLayoutShiftRectsInCssPixelsEnabled();
  }
  bool requestMainFrameAfterFirstVideoFrameEnabled() {
    return RuntimeEnabledFeatures::RequestMainFrameAfterFirstVideoFrameEnabled();
  }
  bool resolveVarStylesOnCopyEnabled() {
    return RuntimeEnabledFeatures::ResolveVarStylesOnCopyEnabled();
  }
  bool resourceTimingContentEncodingEnabled() {
    return RuntimeEnabledFeatures::ResourceTimingContentEncodingEnabled();
  }
  bool resourceTimingContentTypeEnabled() {
    return RuntimeEnabledFeatures::ResourceTimingContentTypeEnabled();
  }
  bool resourceTimingInitiatorEnabled() {
    return RuntimeEnabledFeatures::ResourceTimingInitiatorEnabled();
  }
  bool resourceTimingUseCORSForBodySizesEnabled() {
    return RuntimeEnabledFeatures::ResourceTimingUseCORSForBodySizesEnabled();
  }
  bool responsiveIframesEnabled() {
    return RuntimeEnabledFeatures::ResponsiveIframesEnabled();
  }
  bool restrictGamepadAccessEnabled() {
    return RuntimeEnabledFeatures::RestrictGamepadAccessEnabled();
  }
  bool restrictOwnAudioEnabled() {
    return RuntimeEnabledFeatures::RestrictOwnAudioEnabled();
  }
  bool restrictTabFocusForHiddenSVGElementsEnabled() {
    return RuntimeEnabledFeatures::RestrictTabFocusForHiddenSVGElementsEnabled();
  }
  bool restrictTableCellSelectionToBoundaryEnabled() {
    return RuntimeEnabledFeatures::RestrictTableCellSelectionToBoundaryEnabled();
  }
  bool rootScrollbarFollowsBrowserThemeEnabled() {
    return RuntimeEnabledFeatures::RootScrollbarFollowsBrowserThemeEnabled();
  }
  bool routeMatchingEnabled() {
    return RuntimeEnabledFeatures::RouteMatchingEnabled();
  }
  bool rtcAudioJitterBufferMaxPacketsEnabled() {
    return RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabledByRuntimeFlag();
  }
  bool rtcDataChannelPriorityEnabled() {
    return RuntimeEnabledFeatures::RTCDataChannelPriorityEnabled();
  }
  bool rtcEncodedFrameAudioLevelEnabled() {
    return RuntimeEnabledFeatures::RTCEncodedFrameAudioLevelEnabled();
  }
  bool rtcEncodedFrameSetMetadataEnabled() {
    return RuntimeEnabledFeatures::RTCEncodedFrameSetMetadataEnabledByRuntimeFlag();
  }
  bool rtcEncodedFrameTimestampsEnabled() {
    return RuntimeEnabledFeatures::RTCEncodedFrameTimestampsEnabled();
  }
  bool rtcEncodedVideoFrameAdditionalMetadataEnabled() {
    return RuntimeEnabledFeatures::RTCEncodedVideoFrameAdditionalMetadataEnabled();
  }
  bool rtcJitterBufferTargetEnabled() {
    return RuntimeEnabledFeatures::RTCJitterBufferTargetEnabled();
  }
  bool rtcLegacyCallbackBasedGetStatsEnabled() {
    return RuntimeEnabledFeatures::RTCLegacyCallbackBasedGetStatsEnabledByRuntimeFlag();
  }
  bool rtcRtpEncodingParametersCodecEnabled() {
    return RuntimeEnabledFeatures::RTCRtpEncodingParametersCodecEnabled();
  }
  bool rtcRtpScaleResolutionDownToEnabled() {
    return RuntimeEnabledFeatures::RTCRtpScaleResolutionDownToEnabled();
  }
  bool rtcRtpScriptTransformEnabled() {
    return RuntimeEnabledFeatures::RTCRtpScriptTransformEnabled();
  }
  bool rtcRtpTransportEnabled() {
    return RuntimeEnabledFeatures::RTCRtpTransportEnabled();
  }
  bool rtcStatsRelativePacketArrivalDelayEnabled() {
    return RuntimeEnabledFeatures::RTCStatsRelativePacketArrivalDelayEnabledByRuntimeFlag();
  }
  bool rtcSvcScalabilityModeEnabled() {
    return RuntimeEnabledFeatures::RTCSvcScalabilityModeEnabled();
  }
  bool runSnapshotPostLayoutStateStepsEnabled() {
    return RuntimeEnabledFeatures::RunSnapshotPostLayoutStateStepsEnabled();
  }
  bool sanitizerAPIEnabled() {
    return RuntimeEnabledFeatures::SanitizerAPIEnabled();
  }
  bool scopedCustomElementRegistryEnabled() {
    return RuntimeEnabledFeatures::ScopedCustomElementRegistryEnabled();
  }
  bool scopedViewTransitionsEnabled() {
    return RuntimeEnabledFeatures::ScopedViewTransitionsEnabled();
  }
  bool screenDetailedHdrHeadroomEnabled() {
    return RuntimeEnabledFeatures::ScreenDetailedHdrHeadroomEnabled();
  }
  bool scriptedSpeechRecognitionEnabled() {
    return RuntimeEnabledFeatures::ScriptedSpeechRecognitionEnabled();
  }
  bool scriptedSpeechSynthesisEnabled() {
    return RuntimeEnabledFeatures::ScriptedSpeechSynthesisEnabled();
  }
  bool scriptRunIteratorCombiningMarkAlwaysEnabled() {
    return RuntimeEnabledFeatures::ScriptRunIteratorCombiningMarkAlwaysEnabled();
  }
  bool scriptRunIteratorCombiningMarksEnabled() {
    return RuntimeEnabledFeatures::ScriptRunIteratorCombiningMarksEnabled();
  }
  bool scrollAnchorPriorityCandidateSubtreeEnabled() {
    return RuntimeEnabledFeatures::ScrollAnchorPriorityCandidateSubtreeEnabled();
  }
  bool scrollbarColorEnabled() {
    return RuntimeEnabledFeatures::ScrollbarColorEnabled();
  }
  bool scrollbarWidthEnabled() {
    return RuntimeEnabledFeatures::ScrollbarWidthEnabled();
  }
  bool scrollIntoViewNearestEnabled() {
    return RuntimeEnabledFeatures::ScrollIntoViewNearestEnabled();
  }
  bool scrollIntoViewRootFrameViewportBugFixEnabled() {
    return RuntimeEnabledFeatures::ScrollIntoViewRootFrameViewportBugFixEnabled();
  }
  bool scrollIntoViewSelfScrollFixEnabled() {
    return RuntimeEnabledFeatures::ScrollIntoViewSelfScrollFixEnabled();
  }
  bool scrollTimelineCurrentTimeEnabled() {
    return RuntimeEnabledFeatures::ScrollTimelineCurrentTimeEnabled();
  }
  bool scrollTimelineNamedRangeScrollEnabled() {
    return RuntimeEnabledFeatures::ScrollTimelineNamedRangeScrollEnabled();
  }
  bool scrollTopLeftInteropEnabled() {
    return RuntimeEnabledFeatures::ScrollTopLeftInteropEnabled();
  }
  bool searchTextHighlightPseudoEnabled() {
    return RuntimeEnabledFeatures::SearchTextHighlightPseudoEnabled();
  }
  bool securePaymentConfirmationEnabled() {
    return RuntimeEnabledFeatures::SecurePaymentConfirmationEnabled();
  }
  bool securePaymentConfirmationAvailabilityAPIEnabled() {
    return RuntimeEnabledFeatures::SecurePaymentConfirmationAvailabilityAPIEnabled();
  }
  bool securePaymentConfirmationBrowserBoundKeysEnabled() {
    return RuntimeEnabledFeatures::SecurePaymentConfirmationBrowserBoundKeysEnabled();
  }
  bool securePaymentConfirmationDebugEnabled() {
    return RuntimeEnabledFeatures::SecurePaymentConfirmationDebugEnabled();
  }
  bool securePaymentConfirmationOptOutEnabled() {
    return RuntimeEnabledFeatures::SecurePaymentConfirmationOptOutEnabledByRuntimeFlag();
  }
  bool securePaymentConfirmationUxRefreshEnabled() {
    return RuntimeEnabledFeatures::SecurePaymentConfirmationUxRefreshEnabled();
  }
  bool selectAudioOutputEnabled() {
    return RuntimeEnabledFeatures::SelectAudioOutputEnabled();
  }
  bool selectChildrenRemovedFixEnabled() {
    return RuntimeEnabledFeatures::SelectChildrenRemovedFixEnabled();
  }
  bool selectedcontentelementAttributeEnabled() {
    return RuntimeEnabledFeatures::SelectedcontentelementAttributeEnabled();
  }
  bool selectionAndFocusedVisiblePositionMatchEnabled() {
    return RuntimeEnabledFeatures::SelectionAndFocusedVisiblePositionMatchEnabled();
  }
  bool selectionCollapsedDirectionNoneEnabled() {
    return RuntimeEnabledFeatures::SelectionCollapsedDirectionNoneEnabled();
  }
  bool selectionHandleWithBottomClippedEnabled() {
    return RuntimeEnabledFeatures::SelectionHandleWithBottomClippedEnabled();
  }
  bool selectionRemoveRangeNotFoundErrorEnabled() {
    return RuntimeEnabledFeatures::SelectionRemoveRangeNotFoundErrorEnabled();
  }
  bool selectionSetBaseAndExtentNonNullNodeEnabled() {
    return RuntimeEnabledFeatures::SelectionSetBaseAndExtentNonNullNodeEnabled();
  }
  bool selectionUpdateToInitialSelectionInListifyEnabled() {
    return RuntimeEnabledFeatures::SelectionUpdateToInitialSelectionInListifyEnabled();
  }
  bool selectiveClipboardFormatReadEnabled() {
    return RuntimeEnabledFeatures::SelectiveClipboardFormatReadEnabled();
  }
  bool selectivePermissionsInterventionEnabled() {
    return RuntimeEnabledFeatures::SelectivePermissionsInterventionEnabled();
  }
  bool selectMobileDesktopParityEnabled() {
    return RuntimeEnabledFeatures::SelectMobileDesktopParityEnabled();
  }
  bool sendBeaconThrowForBlobWithNonSimpleTypeEnabled() {
    return RuntimeEnabledFeatures::SendBeaconThrowForBlobWithNonSimpleTypeEnabled();
  }
  bool sensorExtraClassesEnabled() {
    return RuntimeEnabledFeatures::SensorExtraClassesEnabled();
  }
  bool separateDeferModuleScriptTasksEnabled() {
    return RuntimeEnabledFeatures::SeparateDeferModuleScriptTasksEnabled();
  }
  bool serialEnabled() {
    return RuntimeEnabledFeatures::SerialEnabled();
  }
  bool serializeViewTransitionStateInSPAEnabled() {
    return RuntimeEnabledFeatures::SerializeViewTransitionStateInSPAEnabled();
  }
  bool serialPortConnectedEnabled() {
    return RuntimeEnabledFeatures::SerialPortConnectedEnabled();
  }
  bool serviceWorkerBackgroundSyncInDedicatedWorkerEnabled() {
    return RuntimeEnabledFeatures::ServiceWorkerBackgroundSyncInDedicatedWorkerEnabled();
  }
  bool serviceWorkerClientLifecycleStateEnabled() {
    return RuntimeEnabledFeatures::ServiceWorkerClientLifecycleStateEnabled();
  }
  bool serviceWorkerInDedicatedWorkerEnabled() {
    return RuntimeEnabledFeatures::ServiceWorkerInDedicatedWorkerEnabled();
  }
  bool serviceWorkerStaticRouterTimingInfoEnabled() {
    return RuntimeEnabledFeatures::ServiceWorkerStaticRouterTimingInfoEnabled();
  }
  bool setSequentialFocusStartingPointEnabled() {
    return RuntimeEnabledFeatures::SetSequentialFocusStartingPointEnabled();
  }
  bool shadowRootReferenceTargetEnabled() {
    return RuntimeEnabledFeatures::ShadowRootReferenceTargetEnabledByRuntimeFlag();
  }
  bool shadowRootReferenceTargetAriaOwnsEnabled() {
    return RuntimeEnabledFeatures::ShadowRootReferenceTargetAriaOwnsEnabled();
  }
  bool sharedArrayBufferEnabled() {
    return RuntimeEnabledFeatures::SharedArrayBufferEnabled();
  }
  bool sharedArrayBufferUnrestrictedAccessAllowedEnabled() {
    return RuntimeEnabledFeatures::SharedArrayBufferUnrestrictedAccessAllowedEnabled();
  }
  bool sharedAutofillEnabled() {
    return RuntimeEnabledFeatures::SharedAutofillEnabled();
  }
  bool sharedStorageAPIEnabled() {
    return RuntimeEnabledFeatures::SharedStorageAPIEnabled();
  }
  bool sharedStorageWebLocksEnabled() {
    return RuntimeEnabledFeatures::SharedStorageWebLocksEnabled();
  }
  bool sharedWorkerEnabled() {
    return RuntimeEnabledFeatures::SharedWorkerEnabledByRuntimeFlag();
  }
  bool sharedWorkerExtendedLifetimeEnabled() {
    return RuntimeEnabledFeatures::SharedWorkerExtendedLifetimeEnabledByRuntimeFlag();
  }
  bool sideRelativeBackgroundPositionEnabled() {
    return RuntimeEnabledFeatures::SideRelativeBackgroundPositionEnabled();
  }
  bool signatureBasedInlineIntegrityEnabled() {
    return RuntimeEnabledFeatures::SignatureBasedInlineIntegrityEnabled();
  }
  bool signatureBasedIntegrityEnabled() {
    return RuntimeEnabledFeatures::SignatureBasedIntegrityEnabled();
  }
  bool skipAdEnabled() {
    return RuntimeEnabledFeatures::SkipAdEnabled();
  }
  bool skipCallbacksWhenDevToolsNotOpenEnabled() {
    return RuntimeEnabledFeatures::SkipCallbacksWhenDevToolsNotOpenEnabled();
  }
  bool skipDateTimeFieldDisableChecksEnabled() {
    return RuntimeEnabledFeatures::SkipDateTimeFieldDisableChecksEnabled();
  }
  bool skipOofItemForBreakCandidateEnabled() {
    return RuntimeEnabledFeatures::SkipOofItemForBreakCandidateEnabled();
  }
  bool skipTouchEventFilterEnabled() {
    return RuntimeEnabledFeatures::SkipTouchEventFilterEnabled();
  }
  bool skipUnselectableContentInSerializationEnabled() {
    return RuntimeEnabledFeatures::SkipUnselectableContentInSerializationEnabled();
  }
  bool smartCardEnabled() {
    return RuntimeEnabledFeatures::SmartCardEnabled();
  }
  bool smartZoomEnabled() {
    return RuntimeEnabledFeatures::SmartZoomEnabled();
  }
  bool softNavigationDetectionEnabled() {
    return RuntimeEnabledFeatures::SoftNavigationDetectionEnabled();
  }
  bool softNavigationDetectionAdvancedPaintAttributionEnabled() {
    return RuntimeEnabledFeatures::SoftNavigationDetectionAdvancedPaintAttributionEnabled();
  }
  bool softNavigationDetectionPrePaintBasedAttributionEnabled() {
    return RuntimeEnabledFeatures::SoftNavigationDetectionPrePaintBasedAttributionEnabled();
  }
  bool softNavigationHeuristicsEnabled() {
    return RuntimeEnabledFeatures::SoftNavigationHeuristicsEnabledByRuntimeFlag();
  }
  bool spatNavUsesCursorInheritanceEnabled() {
    return RuntimeEnabledFeatures::SpatNavUsesCursorInheritanceEnabled();
  }
  bool speakerSelectionEnabled() {
    return RuntimeEnabledFeatures::SpeakerSelectionEnabled();
  }
  bool specialRulesForNestedH1ElementsEnabled() {
    return RuntimeEnabledFeatures::SpecialRulesForNestedH1ElementsEnabled();
  }
  bool speculationRulesPrefetchWithSubresourcesEnabled() {
    return RuntimeEnabledFeatures::SpeculationRulesPrefetchWithSubresourcesEnabled();
  }
  bool splitTextNotCleanupDummySpansEnabled() {
    return RuntimeEnabledFeatures::SplitTextNotCleanupDummySpansEnabled();
  }
  bool srcsetSelectionMatchesImageSetEnabled() {
    return RuntimeEnabledFeatures::SrcsetSelectionMatchesImageSetEnabled();
  }
  bool stableBlinkFeaturesEnabled() {
    return RuntimeEnabledFeatures::StableBlinkFeaturesEnabled();
  }
  bool standardizedBrowserZoomEnabled() {
    return RuntimeEnabledFeatures::StandardizedBrowserZoomEnabled();
  }
  bool standardizedBrowserZoomOptOutEnabled() {
    return RuntimeEnabledFeatures::StandardizedBrowserZoomOptOutEnabledByRuntimeFlag();
  }
  bool stickyUserActivationAcrossSameOriginNavigationEnabled() {
    return RuntimeEnabledFeatures::StickyUserActivationAcrossSameOriginNavigationEnabled();
  }
  bool storageBucketsEnabled() {
    return RuntimeEnabledFeatures::StorageBucketsEnabled();
  }
  bool storageBucketsDurabilityEnabled() {
    return RuntimeEnabledFeatures::StorageBucketsDurabilityEnabled();
  }
  bool storageBucketsLocksEnabled() {
    return RuntimeEnabledFeatures::StorageBucketsLocksEnabled();
  }
  bool strictJsonMimeTypeTokenValidationEnabled() {
    return RuntimeEnabledFeatures::StrictJsonMimeTypeTokenValidationEnabled();
  }
  bool strictMimeTypesForWorkersEnabled() {
    return RuntimeEnabledFeatures::StrictMimeTypesForWorkersEnabled();
  }
  bool stylusHandwritingEnabled() {
    return RuntimeEnabledFeatures::StylusHandwritingEnabled();
  }
  bool svg2CascadeEnabled() {
    return RuntimeEnabledFeatures::Svg2CascadeEnabled();
  }
  bool svgAnchorElementAttributesEnabled() {
    return RuntimeEnabledFeatures::SvgAnchorElementAttributesEnabled();
  }
  bool svgAnchorElementDownloadAttributeEnabled() {
    return RuntimeEnabledFeatures::SvgAnchorElementDownloadAttributeEnabled();
  }
  bool svgAvoidCullingElementsWithTransformOperationsEnabled() {
    return RuntimeEnabledFeatures::SvgAvoidCullingElementsWithTransformOperationsEnabled();
  }
  bool svgEmbeddedAsReplacedElementEnabled() {
    return RuntimeEnabledFeatures::SVGEmbeddedAsReplacedElementEnabled();
  }
  bool svgEnableTextDecorationCssStylingEnabled() {
    return RuntimeEnabledFeatures::SvgEnableTextDecorationCssStylingEnabled();
  }
  bool svgFallBackToContainerSizeEnabled() {
    return RuntimeEnabledFeatures::SvgFallBackToContainerSizeEnabled();
  }
  bool svgFilterPaintsForHiddenContentEnabled() {
    return RuntimeEnabledFeatures::SvgFilterPaintsForHiddenContentEnabled();
  }
  bool svgIgnoreNegativeEllipseRadiiEnabled() {
    return RuntimeEnabledFeatures::SvgIgnoreNegativeEllipseRadiiEnabled();
  }
  bool svgImageNoExternalXsltEnabled() {
    return RuntimeEnabledFeatures::SvgImageNoExternalXsltEnabled();
  }
  bool svgInlineRootPixelSnappingScaleAdjustmentEnabled() {
    return RuntimeEnabledFeatures::SvgInlineRootPixelSnappingScaleAdjustmentEnabled();
  }
  bool svgPartitionSVGDocumentResourcesInMemoryCacheEnabled() {
    return RuntimeEnabledFeatures::SvgPartitionSVGDocumentResourcesInMemoryCacheEnabled();
  }
  bool svgScriptElementAsyncAttributeEnabled() {
    return RuntimeEnabledFeatures::SvgScriptElementAsyncAttributeEnabled();
  }
  bool svgSizingWithPreserveAspectRatioNoneEnabled() {
    return RuntimeEnabledFeatures::SvgSizingWithPreserveAspectRatioNoneEnabled();
  }
  bool svgSmilPruneInstanceTimesEnabled() {
    return RuntimeEnabledFeatures::SvgSmilPruneInstanceTimesEnabled();
  }
  bool svgTransformOnNestedSvgElementEnabled() {
    return RuntimeEnabledFeatures::SvgTransformOnNestedSvgElementEnabled();
  }
  bool synthesizedKeyboardEventsForAccessibilityActionsEnabled() {
    return RuntimeEnabledFeatures::SynthesizedKeyboardEventsForAccessibilityActionsEnabled();
  }
  bool systemDefaultAccentColorsEnabled() {
    return RuntimeEnabledFeatures::SystemDefaultAccentColorsEnabled();
  }
  bool systemFallbackEmojiVSSupportEnabled() {
    return RuntimeEnabledFeatures::SystemFallbackEmojiVSSupportEnabled();
  }
  bool systemWakeLockEnabled() {
    return RuntimeEnabledFeatures::SystemWakeLockEnabled();
  }
  bool tableIsAutoFixedLayoutEnabled() {
    return RuntimeEnabledFeatures::TableIsAutoFixedLayoutEnabled();
  }
  bool tabSizeAncestorEnabled() {
    return RuntimeEnabledFeatures::TabSizeAncestorEnabled();
  }
  bool tabSizeWithSpacingEnabled() {
    return RuntimeEnabledFeatures::TabSizeWithSpacingEnabled();
  }
  bool tabWidthNegativePositionEnabled() {
    return RuntimeEnabledFeatures::TabWidthNegativePositionEnabled();
  }
  bool targetInShadowDeterminedBeforeListenerEnabled() {
    return RuntimeEnabledFeatures::TargetInShadowDeterminedBeforeListenerEnabled();
  }
  bool testBlinkFeatureDefaultEnabled() {
    return RuntimeEnabledFeatures::TestBlinkFeatureDefaultEnabled();
  }
  bool testFeatureEnabled() {
    return RuntimeEnabledFeatures::TestFeatureEnabled();
  }
  bool testFeatureDependentEnabled() {
    return RuntimeEnabledFeatures::TestFeatureDependentEnabled();
  }
  bool testFeatureForBrowserProcessReadWriteAccessOriginTrialEnabled() {
    return RuntimeEnabledFeatures::TestFeatureForBrowserProcessReadWriteAccessOriginTrialEnabledByRuntimeFlag();
  }
  bool testFeatureImpliedEnabled() {
    return RuntimeEnabledFeatures::TestFeatureImpliedEnabled();
  }
  bool testFeatureProtectedEnabled() {
    return RuntimeEnabledFeatures::TestFeatureProtectedEnabled();
  }
  bool testFeatureProtectedDependentEnabled() {
    return RuntimeEnabledFeatures::TestFeatureProtectedDependentEnabled();
  }
  bool testFeatureProtectedImpliedEnabled() {
    return RuntimeEnabledFeatures::TestFeatureProtectedImpliedEnabled();
  }
  bool testFeatureStableEnabled() {
    return RuntimeEnabledFeatures::TestFeatureStableEnabled();
  }
  bool textareaLastLineRemovalFixEnabled() {
    return RuntimeEnabledFeatures::TextareaLastLineRemovalFixEnabled();
  }
  bool textareaLineEndingsAsBrEnabled() {
    return RuntimeEnabledFeatures::TextareaLineEndingsAsBrEnabled();
  }
  bool textareaMultipleIfcsEnabled() {
    return RuntimeEnabledFeatures::TextareaMultipleIfcsEnabled();
  }
  bool textDecorationOmitCurrentColorEnabled() {
    return RuntimeEnabledFeatures::TextDecorationOmitCurrentColorEnabled();
  }
  bool textDetectorEnabled() {
    return RuntimeEnabledFeatures::TextDetectorEnabled();
  }
  bool textEmphasisLetterSpacingEnabled() {
    return RuntimeEnabledFeatures::TextEmphasisLetterSpacingEnabled();
  }
  bool textEmphasisPositionAutoEnabled() {
    return RuntimeEnabledFeatures::TextEmphasisPositionAutoEnabled();
  }
  bool textEmphasisPunctuationExceptionsEnabled() {
    return RuntimeEnabledFeatures::TextEmphasisPunctuationExceptionsEnabled();
  }
  bool textEmphasisWithRubyEnabled() {
    return RuntimeEnabledFeatures::TextEmphasisWithRubyEnabled();
  }
  bool textFragmentAPIEnabled() {
    return RuntimeEnabledFeatures::TextFragmentAPIEnabled();
  }
  bool textFragmentIdentifiersEnabled() {
    return RuntimeEnabledFeatures::TextFragmentIdentifiersEnabledByRuntimeFlag();
  }
  bool textFragmentTapOpensContextMenuEnabled() {
    return RuntimeEnabledFeatures::TextFragmentTapOpensContextMenuEnabled();
  }
  bool textMetricsBaselinesEnabled() {
    return RuntimeEnabledFeatures::TextMetricsBaselinesEnabled();
  }
  bool textOverflowStringEnabled() {
    return RuntimeEnabledFeatures::TextOverflowStringEnabled();
  }
  bool textSpacingTrimFallbackEnabled() {
    return RuntimeEnabledFeatures::TextSpacingTrimFallbackEnabled();
  }
  bool textSpacingTrimFallback2Enabled() {
    return RuntimeEnabledFeatures::TextSpacingTrimFallback2Enabled();
  }
  bool textSpacingTrimYuGothicUIEnabled() {
    return RuntimeEnabledFeatures::TextSpacingTrimYuGothicUIEnabled();
  }
  bool thirdPartyStoragePartitioningUserBypassEnabled() {
    return RuntimeEnabledFeatures::ThirdPartyStoragePartitioningUserBypassEnabled();
  }
  bool timelineTriggerEnabled() {
    return RuntimeEnabledFeatures::TimelineTriggerEnabled();
  }
  bool timerThrottlingForBackgroundTabsEnabled() {
    return RuntimeEnabledFeatures::TimerThrottlingForBackgroundTabsEnabled();
  }
  bool timestampBasedCLSTrackingEnabled() {
    return RuntimeEnabledFeatures::TimestampBasedCLSTrackingEnabled();
  }
  bool timeZoneChangeEventEnabled() {
    return RuntimeEnabledFeatures::TimeZoneChangeEventEnabled();
  }
  bool topicsAPIEnabled() {
    return RuntimeEnabledFeatures::TopicsAPIEnabled();
  }
  bool topicsDocumentAPIEnabled() {
    return RuntimeEnabledFeatures::TopicsDocumentAPIEnabled();
  }
  bool topicsImgAPIEnabled() {
    return RuntimeEnabledFeatures::TopicsImgAPIEnabled();
  }
  bool topLevelTpcdEnabled() {
    return RuntimeEnabledFeatures::TopLevelTpcdEnabledByRuntimeFlag();
  }
  bool touchDragAndContextMenuEnabled() {
    return RuntimeEnabledFeatures::TouchDragAndContextMenuEnabled();
  }
  bool touchDragAndDropEnabled() {
    return RuntimeEnabledFeatures::TouchDragAndDropEnabled();
  }
  bool touchDragOnShortPressEnabled() {
    return RuntimeEnabledFeatures::TouchDragOnShortPressEnabled();
  }
  bool touchEventFeatureDetectionEnabled() {
    return RuntimeEnabledFeatures::TouchEventFeatureDetectionEnabledByRuntimeFlag();
  }
  bool touchTextEditingRedesignEnabled() {
    return RuntimeEnabledFeatures::TouchTextEditingRedesignEnabled();
  }
  bool tpcdEnabled() {
    return RuntimeEnabledFeatures::TpcdEnabledByRuntimeFlag();
  }
  bool transferableRTCDataChannelEnabled() {
    return RuntimeEnabledFeatures::TransferableRTCDataChannelEnabled();
  }
  bool translateServiceEnabled() {
    return RuntimeEnabledFeatures::TranslateServiceEnabled();
  }
  bool translationAPIEnabled() {
    return RuntimeEnabledFeatures::TranslationAPIEnabledByRuntimeFlag();
  }
  bool translationAPIForWorkersEnabled() {
    return RuntimeEnabledFeatures::TranslationAPIForWorkersEnabled();
  }
  bool traverseFlatTreeToHandleSlotsEnabled() {
    return RuntimeEnabledFeatures::TraverseFlatTreeToHandleSlotsEnabled();
  }
  bool treatMhtmlInitialDocumentLoadsAsCrossDocumentEnabled() {
    return RuntimeEnabledFeatures::TreatMhtmlInitialDocumentLoadsAsCrossDocumentEnabled();
  }
  bool trustedTypesFromLiteralEnabled() {
    return RuntimeEnabledFeatures::TrustedTypesFromLiteralEnabled();
  }
  bool trustedTypesHTMLEnabled() {
    return RuntimeEnabledFeatures::TrustedTypesHTMLEnabled();
  }
  bool trustedTypesUseCodeLikeEnabled() {
    return RuntimeEnabledFeatures::TrustedTypesUseCodeLikeEnabled();
  }
  bool twoPhaseViewTransitionEnabled() {
    return RuntimeEnabledFeatures::TwoPhaseViewTransitionEnabled();
  }
  bool unclosedFormControlIsInvalidEnabled() {
    return RuntimeEnabledFeatures::UnclosedFormControlIsInvalidEnabled();
  }
  bool unencodedDigestEnabled() {
    return RuntimeEnabledFeatures::UnencodedDigestEnabled();
  }
  bool unexposedTaskIdsEnabled() {
    return RuntimeEnabledFeatures::UnexposedTaskIdsEnabled();
  }
  bool unprefixedSpeechRecognitionEnabled() {
    return RuntimeEnabledFeatures::UnprefixedSpeechRecognitionEnabled();
  }
  bool unrestrictedMeasureUserAgentSpecificMemoryEnabled() {
    return RuntimeEnabledFeatures::UnrestrictedMeasureUserAgentSpecificMemoryEnabled();
  }
  bool unrestrictedSharedArrayBufferEnabled() {
    return RuntimeEnabledFeatures::UnrestrictedSharedArrayBufferEnabledByRuntimeFlag();
  }
  bool unrestrictedUsbEnabled() {
    return RuntimeEnabledFeatures::UnrestrictedUsbEnabled();
  }
  bool updateComplexSafaAreaConstraintsEnabled() {
    return RuntimeEnabledFeatures::UpdateComplexSafaAreaConstraintsEnabled();
  }
  bool updateSelectionOnNodeInsertionEnabled() {
    return RuntimeEnabledFeatures::UpdateSelectionOnNodeInsertionEnabled();
  }
  bool updateTrivalTextAfterFragmentCreationFromTextEnabled() {
    return RuntimeEnabledFeatures::UpdateTrivalTextAfterFragmentCreationFromTextEnabled();
  }
  bool urlPatternCompareComponentEnabled() {
    return RuntimeEnabledFeatures::URLPatternCompareComponentEnabled();
  }
  bool urlPatternGenerateEnabled() {
    return RuntimeEnabledFeatures::URLPatternGenerateEnabled();
  }
  bool urlSearchParamsHasAndDeleteMultipleArgsEnabled() {
    return RuntimeEnabledFeatures::URLSearchParamsHasAndDeleteMultipleArgsEnabled();
  }
  bool useBeginFramePresentationFeedbackEnabled() {
    return RuntimeEnabledFeatures::UseBeginFramePresentationFeedbackEnabled();
  }
  bool useLowQualityInterpolationEnabled() {
    return RuntimeEnabledFeatures::UseLowQualityInterpolationEnabled();
  }
  bool useOriginalDomOffsetsForOffsetMapEnabled() {
    return RuntimeEnabledFeatures::UseOriginalDomOffsetsForOffsetMapEnabled();
  }
  bool usePositionForPointInFlexibleBoxWithSingleChildElementEnabled() {
    return RuntimeEnabledFeatures::UsePositionForPointInFlexibleBoxWithSingleChildElementEnabled();
  }
  bool usePositionIfIsVisuallyEquivalentCandidateEnabled() {
    return RuntimeEnabledFeatures::UsePositionIfIsVisuallyEquivalentCandidateEnabled();
  }
  bool userDefinedEntryPointTimingEnabled() {
    return RuntimeEnabledFeatures::UserDefinedEntryPointTimingEnabled();
  }
  bool useSelectionInDOMTreeAnchorInExtendSelectionEnabled() {
    return RuntimeEnabledFeatures::UseSelectionInDOMTreeAnchorInExtendSelectionEnabled();
  }
  bool useShadowHostStyleCheckEditableEnabled() {
    return RuntimeEnabledFeatures::UseShadowHostStyleCheckEditableEnabled();
  }
  bool useSpecValuesInTextFormatUpdateEventStylesEnabled() {
    return RuntimeEnabledFeatures::UseSpecValuesInTextFormatUpdateEventStylesEnabled();
  }
  bool useUndoStepElementDispatchBeforeInputEnabled() {
    return RuntimeEnabledFeatures::UseUndoStepElementDispatchBeforeInputEnabled();
  }
  bool v8IdleTasksEnabled() {
    return RuntimeEnabledFeatures::V8IdleTasksEnabled();
  }
  bool videoAutoFullscreenEnabled() {
    return RuntimeEnabledFeatures::VideoAutoFullscreenEnabled();
  }
  bool videoFrameMetadataBackgroundBlurEnabled() {
    return RuntimeEnabledFeatures::VideoFrameMetadataBackgroundBlurEnabled();
  }
  bool videoFrameMetadataRtpTimestampEnabled() {
    return RuntimeEnabledFeatures::VideoFrameMetadataRtpTimestampEnabled();
  }
  bool videoFullscreenOrientationLockEnabled() {
    return RuntimeEnabledFeatures::VideoFullscreenOrientationLockEnabled();
  }
  bool videoRotateToFullscreenEnabled() {
    return RuntimeEnabledFeatures::VideoRotateToFullscreenEnabled();
  }
  bool videoTrackGeneratorEnabled() {
    return RuntimeEnabledFeatures::VideoTrackGeneratorEnabled();
  }
  bool videoTrackGeneratorInWindowEnabled() {
    return RuntimeEnabledFeatures::VideoTrackGeneratorInWindowEnabled();
  }
  bool videoTrackGeneratorInWorkerEnabled() {
    return RuntimeEnabledFeatures::VideoTrackGeneratorInWorkerEnabled();
  }
  bool viewportHeightClientHintHeaderEnabled() {
    return RuntimeEnabledFeatures::ViewportHeightClientHintHeaderEnabled();
  }
  bool viewportSegmentsEnabled() {
    return RuntimeEnabledFeatures::ViewportSegmentsEnabled();
  }
  bool viewTransitionAsyncFinishedEnabled() {
    return RuntimeEnabledFeatures::ViewTransitionAsyncFinishedEnabled();
  }
  bool viewTransitionHoistBackdropFilterEffectEnabled() {
    return RuntimeEnabledFeatures::ViewTransitionHoistBackdropFilterEffectEnabled();
  }
  bool viewTransitionLongCallbackTimeoutForTestingEnabled() {
    return RuntimeEnabledFeatures::ViewTransitionLongCallbackTimeoutForTestingEnabled();
  }
  bool viewTransitionUpdateLifecycleBeforeReadyEnabled() {
    return RuntimeEnabledFeatures::ViewTransitionUpdateLifecycleBeforeReadyEnabled();
  }
  bool viewTransitionWaitUntilEnabled() {
    return RuntimeEnabledFeatures::ViewTransitionWaitUntilEnabled();
  }
  bool visibilityCollapseColumnEnabled() {
    return RuntimeEnabledFeatures::VisibilityCollapseColumnEnabled();
  }
  bool wakeLockEnabled() {
    return RuntimeEnabledFeatures::WakeLockEnabled();
  }
  bool warnOnContentVisibilityRenderAccessEnabled() {
    return RuntimeEnabledFeatures::WarnOnContentVisibilityRenderAccessEnabled();
  }
  bool webAppInstallationEnabled() {
    return RuntimeEnabledFeatures::WebAppInstallationEnabledByRuntimeFlag();
  }
  bool webAppLaunchQueueEnabled() {
    return RuntimeEnabledFeatures::WebAppLaunchQueueEnabled();
  }
  bool webAppScopeExtensionsEnabled() {
    return RuntimeEnabledFeatures::WebAppScopeExtensionsEnabledByRuntimeFlag();
  }
  bool webAppTabStripEnabled() {
    return RuntimeEnabledFeatures::WebAppTabStripEnabled();
  }
  bool webAppTabStripCustomizationsEnabled() {
    return RuntimeEnabledFeatures::WebAppTabStripCustomizationsEnabled();
  }
  bool webAppTranslationsEnabled() {
    return RuntimeEnabledFeatures::WebAppTranslationsEnabled();
  }
  bool webAssemblyCustomDescriptorsEnabled() {
    return RuntimeEnabledFeatures::WebAssemblyCustomDescriptorsEnabledByRuntimeFlag();
  }
  bool webAssemblyJSPromiseIntegrationEnabled() {
    return RuntimeEnabledFeatures::WebAssemblyJSPromiseIntegrationEnabledByRuntimeFlag();
  }
  bool webAudioBypassOutputBufferingEnabled() {
    return RuntimeEnabledFeatures::WebAudioBypassOutputBufferingEnabled();
  }
  bool webAudioBypassOutputBufferingOptOutEnabled() {
    return RuntimeEnabledFeatures::WebAudioBypassOutputBufferingOptOutEnabled();
  }
  bool webAudioConfigurableRenderQuantumEnabled() {
    return RuntimeEnabledFeatures::WebAudioConfigurableRenderQuantumEnabled();
  }
  bool webAuthEnabled() {
    return RuntimeEnabledFeatures::WebAuthEnabled();
  }
  bool webAuthAuthenticatorAttachmentEnabled() {
    return RuntimeEnabledFeatures::WebAuthAuthenticatorAttachmentEnabled();
  }
  bool webAuthenticationAmbientEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationAmbientEnabled();
  }
  bool webAuthenticationAttestationFormatsEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationAttestationFormatsEnabledByRuntimeFlag();
  }
  bool webAuthenticationChallengeUrlEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationChallengeUrlEnabled();
  }
  bool webAuthenticationConditionalCreateEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationConditionalCreateEnabled();
  }
  bool webAuthenticationImmediateGetEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationImmediateGetEnabledByRuntimeFlag();
  }
  bool webAuthenticationRemoteDesktopSupportEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationRemoteDesktopSupportEnabled();
  }
  bool webAuthenticationSupplementalPubKeysEnabled() {
    return RuntimeEnabledFeatures::WebAuthenticationSupplementalPubKeysEnabled();
  }
  bool webBluetoothEnabled() {
    return RuntimeEnabledFeatures::WebBluetoothEnabled();
  }
  bool webBluetoothGetDevicesEnabled() {
    return RuntimeEnabledFeatures::WebBluetoothGetDevicesEnabled();
  }
  bool webBluetoothScanningEnabled() {
    return RuntimeEnabledFeatures::WebBluetoothScanningEnabled();
  }
  bool webBluetoothWatchAdvertisementsEnabled() {
    return RuntimeEnabledFeatures::WebBluetoothWatchAdvertisementsEnabled();
  }
  bool webcodecsVideoEncoderBuffersEnabled() {
    return RuntimeEnabledFeatures::WebCodecsVideoEncoderBuffersEnabled();
  }
  bool webCryptoPQCEnabled() {
    return RuntimeEnabledFeatures::WebCryptoPQCEnabled();
  }
  bool webFontResizeLCPEnabled() {
    return RuntimeEnabledFeatures::WebFontResizeLCPEnabled();
  }
  bool webglDeveloperExtensionsEnabled() {
    return RuntimeEnabledFeatures::WebGLDeveloperExtensionsEnabled();
  }
  bool webglDraftExtensionsEnabled() {
    return RuntimeEnabledFeatures::WebGLDraftExtensionsEnabled();
  }
  bool webglDrawingBufferStorageEnabled() {
    return RuntimeEnabledFeatures::WebGLDrawingBufferStorageEnabled();
  }
  bool webglImageChromiumEnabled() {
    return RuntimeEnabledFeatures::WebGLImageChromiumEnabled();
  }
  bool webglOnWebGPUEnabled() {
    return RuntimeEnabledFeatures::WebGLOnWebGPUEnabled();
  }
  bool webgpuCompatibilityModeEnabled() {
    return RuntimeEnabledFeatures::WebGPUCompatibilityModeEnabledByRuntimeFlag();
  }
  bool webgpuDeveloperFeaturesEnabled() {
    return RuntimeEnabledFeatures::WebGPUDeveloperFeaturesEnabled();
  }
  bool webgpuExperimentalFeaturesEnabled() {
    return RuntimeEnabledFeatures::WebGPUExperimentalFeaturesEnabled();
  }
  bool webgpuTextureComponentSwizzleEnabled() {
    return RuntimeEnabledFeatures::WebGPUTextureComponentSwizzleEnabled();
  }
  bool webHIDEnabled() {
    return RuntimeEnabledFeatures::WebHIDEnabled();
  }
  bool webHIDOnServiceWorkersEnabled() {
    return RuntimeEnabledFeatures::WebHIDOnServiceWorkersEnabled();
  }
  bool webIdentityDigitalCredentialsEnabled() {
    return RuntimeEnabledFeatures::WebIdentityDigitalCredentialsEnabled();
  }
  bool webIdentityDigitalCredentialsCreationEnabled() {
    return RuntimeEnabledFeatures::WebIdentityDigitalCredentialsCreationEnabledByRuntimeFlag();
  }
  bool webIDLBigIntUsesToBigIntEnabled() {
    return RuntimeEnabledFeatures::WebIDLBigIntUsesToBigIntEnabled();
  }
  bool webMCPEnabled() {
    return RuntimeEnabledFeatures::WebMCPEnabled();
  }
  bool webMCPTestingEnabled() {
    return RuntimeEnabledFeatures::WebMCPTestingEnabled();
  }
  bool webNFCEnabled() {
    return RuntimeEnabledFeatures::WebNFCEnabled();
  }
  bool webOTPEnabled() {
    return RuntimeEnabledFeatures::WebOTPEnabled();
  }
  bool webOTPAssertionFeaturePolicyEnabled() {
    return RuntimeEnabledFeatures::WebOTPAssertionFeaturePolicyEnabled();
  }
  bool webPreferencesEnabled() {
    return RuntimeEnabledFeatures::WebPreferencesEnabled();
  }
  bool webPrintingEnabled() {
    return RuntimeEnabledFeatures::WebPrintingEnabled();
  }
  bool webShareEnabled() {
    return RuntimeEnabledFeatures::WebShareEnabled();
  }
  bool websocketStreamEnabled() {
    return RuntimeEnabledFeatures::WebSocketStreamEnabled();
  }
  bool webSpeechRecognitionContextEnabled() {
    return RuntimeEnabledFeatures::WebSpeechRecognitionContextEnabled();
  }
  bool webTransportApplicationProtocolEnabled() {
    return RuntimeEnabledFeatures::WebTransportApplicationProtocolEnabled();
  }
  bool webTransportCustomCertificatesEnabled() {
    return RuntimeEnabledFeatures::WebTransportCustomCertificatesEnabledByRuntimeFlag();
  }
  bool webTransportStatsEnabled() {
    return RuntimeEnabledFeatures::WebTransportStatsEnabled();
  }
  bool webUIBundledCodeCacheAsyncFetchEnabled() {
    return RuntimeEnabledFeatures::WebUIBundledCodeCacheAsyncFetchEnabled();
  }
  bool webUSBEnabled() {
    return RuntimeEnabledFeatures::WebUSBEnabled();
  }
  bool webUSBOnDedicatedWorkersEnabled() {
    return RuntimeEnabledFeatures::WebUSBOnDedicatedWorkersEnabled();
  }
  bool webUSBOnServiceWorkersEnabled() {
    return RuntimeEnabledFeatures::WebUSBOnServiceWorkersEnabled();
  }
  bool webVTTRegionsEnabled() {
    return RuntimeEnabledFeatures::WebVTTRegionsEnabled();
  }
  bool webXREnabled() {
    return RuntimeEnabledFeatures::WebXREnabled();
  }
  bool webXREnabledFeaturesEnabled() {
    return RuntimeEnabledFeatures::WebXREnabledFeaturesEnabled();
  }
  bool webXRFrameRateEnabled() {
    return RuntimeEnabledFeatures::WebXRFrameRateEnabled();
  }
  bool webXRFrontFacingEnabled() {
    return RuntimeEnabledFeatures::WebXRFrontFacingEnabled();
  }
  bool webXRGPUBindingEnabled() {
    return RuntimeEnabledFeatures::WebXRGPUBindingEnabled();
  }
  bool webXRHitTestEntityTypesEnabled() {
    return RuntimeEnabledFeatures::WebXRHitTestEntityTypesEnabled();
  }
  bool webXRImageTrackingEnabled() {
    return RuntimeEnabledFeatures::WebXRImageTrackingEnabledByRuntimeFlag();
  }
  bool webXRLayersEnabled() {
    return RuntimeEnabledFeatures::WebXRLayersEnabled();
  }
  bool webXRLayersCommonEnabled() {
    return RuntimeEnabledFeatures::WebXRLayersCommonEnabled();
  }
  bool webXRPlaneDetectionEnabled() {
    return RuntimeEnabledFeatures::WebXRPlaneDetectionEnabledByRuntimeFlag();
  }
  bool webXRPoseMotionDataEnabled() {
    return RuntimeEnabledFeatures::WebXRPoseMotionDataEnabled();
  }
  bool webXRSpecParityEnabled() {
    return RuntimeEnabledFeatures::WebXRSpecParityEnabled();
  }
  bool webXRVisibilityMaskEnabled() {
    return RuntimeEnabledFeatures::WebXRVisibilityMaskEnabled();
  }
  bool widthAndHeightAsPresentationAttributesOnNestedSvgEnabled() {
    return RuntimeEnabledFeatures::WidthAndHeightAsPresentationAttributesOnNestedSvgEnabled();
  }
  bool widthAndHeightStylePropertiesOnUseAndSymbolEnabled() {
    return RuntimeEnabledFeatures::WidthAndHeightStylePropertiesOnUseAndSymbolEnabled();
  }
  bool windowControlsOverlayEnabled() {
    return RuntimeEnabledFeatures::WindowControlsOverlayEnabled();
  }
  bool windowDefaultStatusEnabled() {
    return RuntimeEnabledFeatures::WindowDefaultStatusEnabled();
  }
  bool wordSpacingWhiteSpacePreEnabled() {
    return RuntimeEnabledFeatures::WordSpacingWhiteSpacePreEnabled();
  }
  bool xmlSerializerConsistentDefaultNsDeclMatchingEnabled() {
    return RuntimeEnabledFeatures::XMLSerializerConsistentDefaultNsDeclMatchingEnabled();
  }
  bool xsltEnabled() {
    return RuntimeEnabledFeatures::XSLTEnabled();
  }
  bool zeroCopyTabCaptureEnabled() {
    return RuntimeEnabledFeatures::ZeroCopyTabCaptureEnabled();
  }
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_TESTING_INTERNAL_RUNTIME_FLAGS_H_
