// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Preload_h
#define blink_protocol_Preload_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace blink {
namespace protocol {
namespace Preload {
using RuleSetId = String;
class RuleSet;
using RuleSetErrorType = String;
using SpeculationAction = String;
using SpeculationTargetHint = String;
class PreloadingAttemptKey;
class PreloadingAttemptSource;
using PreloadPipelineId = String;
using PrerenderFinalStatus = String;
using PreloadingStatus = String;
using PrefetchStatus = String;
class PrerenderMismatchedHeaders;

// ------------- Forward and enum declarations.

namespace RuleSetErrorTypeEnum {
CORE_EXPORT extern const char SourceIsNotJsonObject[];
CORE_EXPORT extern const char InvalidRulesSkipped[];
CORE_EXPORT extern const char InvalidRulesetLevelTag[];
} // namespace RuleSetErrorTypeEnum

namespace SpeculationActionEnum {
CORE_EXPORT extern const char Prefetch[];
CORE_EXPORT extern const char Prerender[];
CORE_EXPORT extern const char PrerenderUntilScript[];
} // namespace SpeculationActionEnum

namespace SpeculationTargetHintEnum {
CORE_EXPORT extern const char Blank[];
CORE_EXPORT extern const char Self[];
} // namespace SpeculationTargetHintEnum

namespace PrerenderFinalStatusEnum {
CORE_EXPORT extern const char Activated[];
CORE_EXPORT extern const char Destroyed[];
CORE_EXPORT extern const char LowEndDevice[];
CORE_EXPORT extern const char InvalidSchemeRedirect[];
CORE_EXPORT extern const char InvalidSchemeNavigation[];
CORE_EXPORT extern const char NavigationRequestBlockedByCsp[];
CORE_EXPORT extern const char MojoBinderPolicy[];
CORE_EXPORT extern const char RendererProcessCrashed[];
CORE_EXPORT extern const char RendererProcessKilled[];
CORE_EXPORT extern const char Download[];
CORE_EXPORT extern const char TriggerDestroyed[];
CORE_EXPORT extern const char NavigationNotCommitted[];
CORE_EXPORT extern const char NavigationBadHttpStatus[];
CORE_EXPORT extern const char ClientCertRequested[];
CORE_EXPORT extern const char NavigationRequestNetworkError[];
CORE_EXPORT extern const char CancelAllHostsForTesting[];
CORE_EXPORT extern const char DidFailLoad[];
CORE_EXPORT extern const char Stop[];
CORE_EXPORT extern const char SslCertificateError[];
CORE_EXPORT extern const char LoginAuthRequested[];
CORE_EXPORT extern const char UaChangeRequiresReload[];
CORE_EXPORT extern const char BlockedByClient[];
CORE_EXPORT extern const char AudioOutputDeviceRequested[];
CORE_EXPORT extern const char MixedContent[];
CORE_EXPORT extern const char TriggerBackgrounded[];
CORE_EXPORT extern const char MemoryLimitExceeded[];
CORE_EXPORT extern const char DataSaverEnabled[];
CORE_EXPORT extern const char TriggerUrlHasEffectiveUrl[];
CORE_EXPORT extern const char ActivatedBeforeStarted[];
CORE_EXPORT extern const char InactivePageRestriction[];
CORE_EXPORT extern const char StartFailed[];
CORE_EXPORT extern const char TimeoutBackgrounded[];
CORE_EXPORT extern const char CrossSiteRedirectInInitialNavigation[];
CORE_EXPORT extern const char CrossSiteNavigationInInitialNavigation[];
CORE_EXPORT extern const char SameSiteCrossOriginRedirectNotOptInInInitialNavigation[];
CORE_EXPORT extern const char SameSiteCrossOriginNavigationNotOptInInInitialNavigation[];
CORE_EXPORT extern const char ActivationNavigationParameterMismatch[];
CORE_EXPORT extern const char ActivatedInBackground[];
CORE_EXPORT extern const char EmbedderHostDisallowed[];
CORE_EXPORT extern const char ActivationNavigationDestroyedBeforeSuccess[];
CORE_EXPORT extern const char TabClosedByUserGesture[];
CORE_EXPORT extern const char TabClosedWithoutUserGesture[];
CORE_EXPORT extern const char PrimaryMainFrameRendererProcessCrashed[];
CORE_EXPORT extern const char PrimaryMainFrameRendererProcessKilled[];
CORE_EXPORT extern const char ActivationFramePolicyNotCompatible[];
CORE_EXPORT extern const char PreloadingDisabled[];
CORE_EXPORT extern const char BatterySaverEnabled[];
CORE_EXPORT extern const char ActivatedDuringMainFrameNavigation[];
CORE_EXPORT extern const char PreloadingUnsupportedByWebContents[];
CORE_EXPORT extern const char CrossSiteRedirectInMainFrameNavigation[];
CORE_EXPORT extern const char CrossSiteNavigationInMainFrameNavigation[];
CORE_EXPORT extern const char SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation[];
CORE_EXPORT extern const char SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation[];
CORE_EXPORT extern const char MemoryPressureOnTrigger[];
CORE_EXPORT extern const char MemoryPressureAfterTriggered[];
CORE_EXPORT extern const char PrerenderingDisabledByDevTools[];
CORE_EXPORT extern const char SpeculationRuleRemoved[];
CORE_EXPORT extern const char ActivatedWithAuxiliaryBrowsingContexts[];
CORE_EXPORT extern const char MaxNumOfRunningEagerPrerendersExceeded[];
CORE_EXPORT extern const char MaxNumOfRunningNonEagerPrerendersExceeded[];
CORE_EXPORT extern const char MaxNumOfRunningEmbedderPrerendersExceeded[];
CORE_EXPORT extern const char PrerenderingUrlHasEffectiveUrl[];
CORE_EXPORT extern const char RedirectedPrerenderingUrlHasEffectiveUrl[];
CORE_EXPORT extern const char ActivationUrlHasEffectiveUrl[];
CORE_EXPORT extern const char JavaScriptInterfaceAdded[];
CORE_EXPORT extern const char JavaScriptInterfaceRemoved[];
CORE_EXPORT extern const char AllPrerenderingCanceled[];
CORE_EXPORT extern const char WindowClosed[];
CORE_EXPORT extern const char SlowNetwork[];
CORE_EXPORT extern const char OtherPrerenderedPageActivated[];
CORE_EXPORT extern const char V8OptimizerDisabled[];
CORE_EXPORT extern const char PrerenderFailedDuringPrefetch[];
CORE_EXPORT extern const char BrowsingDataRemoved[];
CORE_EXPORT extern const char PrerenderHostReused[];
} // namespace PrerenderFinalStatusEnum

namespace PreloadingStatusEnum {
CORE_EXPORT extern const char Pending[];
CORE_EXPORT extern const char Running[];
CORE_EXPORT extern const char Ready[];
CORE_EXPORT extern const char Success[];
CORE_EXPORT extern const char Failure[];
CORE_EXPORT extern const char NotSupported[];
} // namespace PreloadingStatusEnum

namespace PrefetchStatusEnum {
CORE_EXPORT extern const char PrefetchAllowed[];
CORE_EXPORT extern const char PrefetchFailedIneligibleRedirect[];
CORE_EXPORT extern const char PrefetchFailedInvalidRedirect[];
CORE_EXPORT extern const char PrefetchFailedMIMENotSupported[];
CORE_EXPORT extern const char PrefetchFailedNetError[];
CORE_EXPORT extern const char PrefetchFailedNon2XX[];
CORE_EXPORT extern const char PrefetchEvictedAfterBrowsingDataRemoved[];
CORE_EXPORT extern const char PrefetchEvictedAfterCandidateRemoved[];
CORE_EXPORT extern const char PrefetchEvictedForNewerPrefetch[];
CORE_EXPORT extern const char PrefetchHeldback[];
CORE_EXPORT extern const char PrefetchIneligibleRetryAfter[];
CORE_EXPORT extern const char PrefetchIsPrivacyDecoy[];
CORE_EXPORT extern const char PrefetchIsStale[];
CORE_EXPORT extern const char PrefetchNotEligibleBrowserContextOffTheRecord[];
CORE_EXPORT extern const char PrefetchNotEligibleDataSaverEnabled[];
CORE_EXPORT extern const char PrefetchNotEligibleExistingProxy[];
CORE_EXPORT extern const char PrefetchNotEligibleHostIsNonUnique[];
CORE_EXPORT extern const char PrefetchNotEligibleNonDefaultStoragePartition[];
CORE_EXPORT extern const char PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy[];
CORE_EXPORT extern const char PrefetchNotEligibleSchemeIsNotHttps[];
CORE_EXPORT extern const char PrefetchNotEligibleUserHasCookies[];
CORE_EXPORT extern const char PrefetchNotEligibleUserHasServiceWorker[];
CORE_EXPORT extern const char PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler[];
CORE_EXPORT extern const char PrefetchNotEligibleRedirectFromServiceWorker[];
CORE_EXPORT extern const char PrefetchNotEligibleRedirectToServiceWorker[];
CORE_EXPORT extern const char PrefetchNotEligibleBatterySaverEnabled[];
CORE_EXPORT extern const char PrefetchNotEligiblePreloadingDisabled[];
CORE_EXPORT extern const char PrefetchNotFinishedInTime[];
CORE_EXPORT extern const char PrefetchNotStarted[];
CORE_EXPORT extern const char PrefetchNotUsedCookiesChanged[];
CORE_EXPORT extern const char PrefetchProxyNotAvailable[];
CORE_EXPORT extern const char PrefetchResponseUsed[];
CORE_EXPORT extern const char PrefetchSuccessfulButNotUsed[];
CORE_EXPORT extern const char PrefetchNotUsedProbeFailed[];
} // namespace PrefetchStatusEnum

// ------------- Type and builder declarations.

class CORE_EXPORT RuleSet : public ::crdtp::ProtocolObject<RuleSet> {
public:
    ~RuleSet() override;  // Defined below

    String getId() { return m_id; }
    void setId(const String& value);  // Defined below

    String getLoaderId() { return m_loaderId; }
    void setLoaderId(const String& value);  // Defined below

    String getSourceText() { return m_sourceText; }
    void setSourceText(const String& value);  // Defined below

    bool hasBackendNodeId() { return !!m_backendNodeId; }
    int getBackendNodeId(int defaultValue) const {
       return m_backendNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getBackendNodeId() const {
       return m_backendNodeId;
    }
    void setBackendNodeId(int value);  // Defined below

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value);  // Defined below

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value);  // Defined below

    bool hasErrorType() { return !!m_errorType; }
    String getErrorType(const String& defaultValue) const {
       return m_errorType.value_or(defaultValue);
    }
    const std::optional<String>& getErrorType() const {
       return m_errorType;
    }
    void setErrorType(const String& value);  // Defined below

    bool hasErrorMessage() { return !!m_errorMessage; }
    String getErrorMessage(const String& defaultValue) const {
       return m_errorMessage.value_or(defaultValue);
    }
    const std::optional<String>& getErrorMessage() const {
       return m_errorMessage;
    }
    void setErrorMessage(const String& value);  // Defined below

    bool hasTag() { return !!m_tag; }
    String getTag(const String& defaultValue) const {
       return m_tag.value_or(defaultValue);
    }
    const std::optional<String>& getTag() const {
       return m_tag;
    }
    void setTag(const String& value);  // Defined below

    template<int STATE>
    class RuleSetBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IdSet = 1 << 1,
            LoaderIdSet = 1 << 2,
            SourceTextSet = 1 << 3,
            AllFieldsSet = (IdSet | LoaderIdSet | SourceTextSet | 0)};


        RuleSetBuilder<STATE | IdSet>& setId(const String& value);  // Defined below

        RuleSetBuilder<STATE | LoaderIdSet>& setLoaderId(const String& value);  // Defined below

        RuleSetBuilder<STATE | SourceTextSet>& setSourceText(const String& value);  // Defined below

        RuleSetBuilder<STATE>& setBackendNodeId(int value);  // Defined below

        RuleSetBuilder<STATE>& setUrl(const String& value);  // Defined below

        RuleSetBuilder<STATE>& setRequestId(const String& value);  // Defined below

        RuleSetBuilder<STATE>& setErrorType(const String& value);  // Defined below

        RuleSetBuilder<STATE>& setErrorMessage(const String& value);  // Defined below

        RuleSetBuilder<STATE>& setTag(const String& value);  // Defined below

        std::unique_ptr<RuleSet> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RuleSet;
        RuleSetBuilder() : m_result(new RuleSet()) { }

        template<int STEP> RuleSetBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RuleSetBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Preload::RuleSet> m_result;
    };

    static RuleSetBuilder<0> create()
    {
        return RuleSetBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RuleSet();  // Defined below

    String m_id;
    String m_loaderId;
    String m_sourceText;
    std::optional<int> m_backendNodeId;
    std::optional<String> m_url;
    std::optional<String> m_requestId;
    std::optional<String> m_errorType;
    std::optional<String> m_errorMessage;
    std::optional<String> m_tag;
};


class CORE_EXPORT PreloadingAttemptKey : public ::crdtp::ProtocolObject<PreloadingAttemptKey> {
public:
    ~PreloadingAttemptKey() override;  // Defined below

    String getLoaderId() { return m_loaderId; }
    void setLoaderId(const String& value);  // Defined below

    String getAction() { return m_action; }
    void setAction(const String& value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    bool hasTargetHint() { return !!m_targetHint; }
    String getTargetHint(const String& defaultValue) const {
       return m_targetHint.value_or(defaultValue);
    }
    const std::optional<String>& getTargetHint() const {
       return m_targetHint;
    }
    void setTargetHint(const String& value);  // Defined below

    template<int STATE>
    class PreloadingAttemptKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LoaderIdSet = 1 << 1,
            ActionSet = 1 << 2,
            UrlSet = 1 << 3,
            AllFieldsSet = (LoaderIdSet | ActionSet | UrlSet | 0)};


        PreloadingAttemptKeyBuilder<STATE | LoaderIdSet>& setLoaderId(const String& value);  // Defined below

        PreloadingAttemptKeyBuilder<STATE | ActionSet>& setAction(const String& value);  // Defined below

        PreloadingAttemptKeyBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        PreloadingAttemptKeyBuilder<STATE>& setTargetHint(const String& value);  // Defined below

        std::unique_ptr<PreloadingAttemptKey> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PreloadingAttemptKey;
        PreloadingAttemptKeyBuilder() : m_result(new PreloadingAttemptKey()) { }

        template<int STEP> PreloadingAttemptKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PreloadingAttemptKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Preload::PreloadingAttemptKey> m_result;
    };

    static PreloadingAttemptKeyBuilder<0> create()
    {
        return PreloadingAttemptKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PreloadingAttemptKey();  // Defined below

    String m_loaderId;
    String m_action;
    String m_url;
    std::optional<String> m_targetHint;
};


class CORE_EXPORT PreloadingAttemptSource : public ::crdtp::ProtocolObject<PreloadingAttemptSource> {
public:
    ~PreloadingAttemptSource() override;  // Defined below

    protocol::Preload::PreloadingAttemptKey* getKey() { return m_key.get(); }
    void setKey(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> value);  // Defined below

    protocol::Array<String>* getRuleSetIds() { return m_ruleSetIds.get(); }
    void setRuleSetIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<int>* getNodeIds() { return m_nodeIds.get(); }
    void setNodeIds(std::unique_ptr<protocol::Array<int>> value);  // Defined below

    template<int STATE>
    class PreloadingAttemptSourceBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            KeySet = 1 << 1,
            RuleSetIdsSet = 1 << 2,
            NodeIdsSet = 1 << 3,
            AllFieldsSet = (KeySet | RuleSetIdsSet | NodeIdsSet | 0)};


        PreloadingAttemptSourceBuilder<STATE | KeySet>& setKey(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> value);  // Defined below

        PreloadingAttemptSourceBuilder<STATE | RuleSetIdsSet>& setRuleSetIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        PreloadingAttemptSourceBuilder<STATE | NodeIdsSet>& setNodeIds(std::unique_ptr<protocol::Array<int>> value);  // Defined below

        std::unique_ptr<PreloadingAttemptSource> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PreloadingAttemptSource;
        PreloadingAttemptSourceBuilder() : m_result(new PreloadingAttemptSource()) { }

        template<int STEP> PreloadingAttemptSourceBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PreloadingAttemptSourceBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Preload::PreloadingAttemptSource> m_result;
    };

    static PreloadingAttemptSourceBuilder<0> create()
    {
        return PreloadingAttemptSourceBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PreloadingAttemptSource();  // Defined below

    std::unique_ptr<protocol::Preload::PreloadingAttemptKey> m_key;
    std::unique_ptr<protocol::Array<String>> m_ruleSetIds;
    std::unique_ptr<protocol::Array<int>> m_nodeIds;
};


class CORE_EXPORT PrerenderMismatchedHeaders : public ::crdtp::ProtocolObject<PrerenderMismatchedHeaders> {
public:
    ~PrerenderMismatchedHeaders() override;  // Defined below

    String getHeaderName() { return m_headerName; }
    void setHeaderName(const String& value);  // Defined below

    bool hasInitialValue() { return !!m_initialValue; }
    String getInitialValue(const String& defaultValue) const {
       return m_initialValue.value_or(defaultValue);
    }
    const std::optional<String>& getInitialValue() const {
       return m_initialValue;
    }
    void setInitialValue(const String& value);  // Defined below

    bool hasActivationValue() { return !!m_activationValue; }
    String getActivationValue(const String& defaultValue) const {
       return m_activationValue.value_or(defaultValue);
    }
    const std::optional<String>& getActivationValue() const {
       return m_activationValue;
    }
    void setActivationValue(const String& value);  // Defined below

    template<int STATE>
    class PrerenderMismatchedHeadersBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HeaderNameSet = 1 << 1,
            AllFieldsSet = (HeaderNameSet | 0)};


        PrerenderMismatchedHeadersBuilder<STATE | HeaderNameSet>& setHeaderName(const String& value);  // Defined below

        PrerenderMismatchedHeadersBuilder<STATE>& setInitialValue(const String& value);  // Defined below

        PrerenderMismatchedHeadersBuilder<STATE>& setActivationValue(const String& value);  // Defined below

        std::unique_ptr<PrerenderMismatchedHeaders> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PrerenderMismatchedHeaders;
        PrerenderMismatchedHeadersBuilder() : m_result(new PrerenderMismatchedHeaders()) { }

        template<int STEP> PrerenderMismatchedHeadersBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PrerenderMismatchedHeadersBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Preload::PrerenderMismatchedHeaders> m_result;
    };

    static PrerenderMismatchedHeadersBuilder<0> create()
    {
        return PrerenderMismatchedHeadersBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PrerenderMismatchedHeaders();  // Defined below

    String m_headerName;
    std::optional<String> m_initialValue;
    std::optional<String> m_activationValue;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline RuleSet::~RuleSet() = default;
inline void RuleSet::setId(const String& value) { m_id = value; }
inline void RuleSet::setLoaderId(const String& value) { m_loaderId = value; }
inline void RuleSet::setSourceText(const String& value) { m_sourceText = value; }
inline void RuleSet::setBackendNodeId(int value) { m_backendNodeId = value; }
inline void RuleSet::setUrl(const String& value) { m_url = value; }
inline void RuleSet::setRequestId(const String& value) { m_requestId = value; }
inline void RuleSet::setErrorType(const String& value) { m_errorType = value; }
inline void RuleSet::setErrorMessage(const String& value) { m_errorMessage = value; }
inline void RuleSet::setTag(const String& value) { m_tag = value; }

template<int STATE>
inline RuleSet::RuleSetBuilder<STATE | RuleSet::RuleSetBuilder<STATE>::IdSet>&
RuleSet::RuleSetBuilder<STATE>::setId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->setId(value);
  return castState<IdSet>();
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE | RuleSet::RuleSetBuilder<STATE>::LoaderIdSet>&
RuleSet::RuleSetBuilder<STATE>::setLoaderId(const String& value) {
  static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
  m_result->setLoaderId(value);
  return castState<LoaderIdSet>();
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE | RuleSet::RuleSetBuilder<STATE>::SourceTextSet>&
RuleSet::RuleSetBuilder<STATE>::setSourceText(const String& value) {
  static_assert(!(STATE & SourceTextSet), "property sourceText should not be set yet");
  m_result->setSourceText(value);
  return castState<SourceTextSet>();
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE>& RuleSet::RuleSetBuilder<STATE>::setBackendNodeId(int value) {
  m_result->setBackendNodeId(value);
  return *this;
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE>& RuleSet::RuleSetBuilder<STATE>::setUrl(const String& value) {
  m_result->setUrl(value);
  return *this;
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE>& RuleSet::RuleSetBuilder<STATE>::setRequestId(const String& value) {
  m_result->setRequestId(value);
  return *this;
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE>& RuleSet::RuleSetBuilder<STATE>::setErrorType(const String& value) {
  m_result->setErrorType(value);
  return *this;
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE>& RuleSet::RuleSetBuilder<STATE>::setErrorMessage(const String& value) {
  m_result->setErrorMessage(value);
  return *this;
}
template<int STATE>
inline RuleSet::RuleSetBuilder<STATE>& RuleSet::RuleSetBuilder<STATE>::setTag(const String& value) {
  m_result->setTag(value);
  return *this;
}

inline RuleSet::RuleSet() {
}
inline PreloadingAttemptKey::~PreloadingAttemptKey() = default;
inline void PreloadingAttemptKey::setLoaderId(const String& value) { m_loaderId = value; }
inline void PreloadingAttemptKey::setAction(const String& value) { m_action = value; }
inline void PreloadingAttemptKey::setUrl(const String& value) { m_url = value; }
inline void PreloadingAttemptKey::setTargetHint(const String& value) { m_targetHint = value; }

template<int STATE>
inline PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE | PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::LoaderIdSet>&
PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::setLoaderId(const String& value) {
  static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
  m_result->setLoaderId(value);
  return castState<LoaderIdSet>();
}
template<int STATE>
inline PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE | PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::ActionSet>&
PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::setAction(const String& value) {
  static_assert(!(STATE & ActionSet), "property action should not be set yet");
  m_result->setAction(value);
  return castState<ActionSet>();
}
template<int STATE>
inline PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE | PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::UrlSet>&
PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>& PreloadingAttemptKey::PreloadingAttemptKeyBuilder<STATE>::setTargetHint(const String& value) {
  m_result->setTargetHint(value);
  return *this;
}

inline PreloadingAttemptKey::PreloadingAttemptKey() {
}
inline PreloadingAttemptSource::~PreloadingAttemptSource() = default;
inline void PreloadingAttemptSource::setKey(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> value) { m_key = std::move(value); }
inline void PreloadingAttemptSource::setRuleSetIds(std::unique_ptr<protocol::Array<String>> value) { m_ruleSetIds = std::move(value); }
inline void PreloadingAttemptSource::setNodeIds(std::unique_ptr<protocol::Array<int>> value) { m_nodeIds = std::move(value); }

template<int STATE>
inline PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE | PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE>::KeySet>&
PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE>::setKey(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> value) {
  static_assert(!(STATE & KeySet), "property key should not be set yet");
  m_result->setKey(std::move(value));
  return castState<KeySet>();
}
template<int STATE>
inline PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE | PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE>::RuleSetIdsSet>&
PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE>::setRuleSetIds(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & RuleSetIdsSet), "property ruleSetIds should not be set yet");
  m_result->setRuleSetIds(std::move(value));
  return castState<RuleSetIdsSet>();
}
template<int STATE>
inline PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE | PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE>::NodeIdsSet>&
PreloadingAttemptSource::PreloadingAttemptSourceBuilder<STATE>::setNodeIds(std::unique_ptr<protocol::Array<int>> value) {
  static_assert(!(STATE & NodeIdsSet), "property nodeIds should not be set yet");
  m_result->setNodeIds(std::move(value));
  return castState<NodeIdsSet>();
}

inline PreloadingAttemptSource::PreloadingAttemptSource() {
}
inline PrerenderMismatchedHeaders::~PrerenderMismatchedHeaders() = default;
inline void PrerenderMismatchedHeaders::setHeaderName(const String& value) { m_headerName = value; }
inline void PrerenderMismatchedHeaders::setInitialValue(const String& value) { m_initialValue = value; }
inline void PrerenderMismatchedHeaders::setActivationValue(const String& value) { m_activationValue = value; }

template<int STATE>
inline PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE | PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE>::HeaderNameSet>&
PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE>::setHeaderName(const String& value) {
  static_assert(!(STATE & HeaderNameSet), "property headerName should not be set yet");
  m_result->setHeaderName(value);
  return castState<HeaderNameSet>();
}
template<int STATE>
inline PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE>& PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE>::setInitialValue(const String& value) {
  m_result->setInitialValue(value);
  return *this;
}
template<int STATE>
inline PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE>& PrerenderMismatchedHeaders::PrerenderMismatchedHeadersBuilder<STATE>::setActivationValue(const String& value) {
  m_result->setActivationValue(value);
  return *this;
}

inline PrerenderMismatchedHeaders::PrerenderMismatchedHeaders() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse disable() = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void ruleSetUpdated(std::unique_ptr<protocol::Preload::RuleSet> ruleSet);
    void ruleSetRemoved(const String& id);
    void preloadEnabledStateUpdated(bool disabledByPreference, bool disabledByDataSaver, bool disabledByBatterySaver, bool disabledByHoldbackPrefetchSpeculationRules, bool disabledByHoldbackPrerenderSpeculationRules);
    void prefetchStatusUpdated(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> key, const String& pipelineId, const String& initiatingFrameId, const String& prefetchUrl, const String& status, const String& prefetchStatus, const String& requestId);
    void prerenderStatusUpdated(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> key, const String& pipelineId, const String& status, std::optional<String> prerenderStatus = {}, std::optional<String> disallowedMojoInterface = {}, std::unique_ptr<protocol::Array<protocol::Preload::PrerenderMismatchedHeaders>> mismatchedHeaders = {});
    void preloadingAttemptSourcesUpdated(const String& loaderId, std::unique_ptr<protocol::Array<protocol::Preload::PreloadingAttemptSource>> preloadingAttemptSources);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Preload
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Preload_h)
