// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/performance.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Performance {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Performance";
const char Metainfo::commandPrefix[] = "Performance.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(Metric)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Metric)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace Enable {
namespace TimeDomainEnum {
const char* TimeTicks = "timeTicks";
const char* ThreadTicks = "threadTicks";
} // namespace TimeDomainEnum
} // namespace Enable

namespace SetTimeDomain {
namespace TimeDomainEnum {
const char* TimeTicks = "timeTicks";
const char* ThreadTicks = "threadTicks";
} // namespace TimeDomainEnum
} // namespace SetTimeDomain

// ------------- Frontend notifications.

void Frontend::metrics(std::unique_ptr<protocol::Array<protocol::Performance::Metric>> metrics, const String& title)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("metrics"), metrics);
    serializer.AddField(crdtp::MakeSpan("title"), title);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Performance.metrics", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void setTimeDomain(const crdtp::Dispatchable& dispatchable);
    void getMetrics(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getMetrics"),
          &DomainDispatcherImpl::getMetrics
    },
    {
          crdtp::SpanFrom("setTimeDomain"),
          &DomainDispatcherImpl::setTimeDomain
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Performance.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<String> timeDomain;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD_OPT("timeDomain", timeDomain),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.timeDomain));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Performance.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setTimeDomainParams : public crdtp::DeserializableProtocolObject<setTimeDomainParams> {
    String timeDomain;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setTimeDomainParams)
    CRDTP_DESERIALIZE_FIELD("timeDomain", timeDomain),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setTimeDomain(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setTimeDomainParams params;
    if (!setTimeDomainParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setTimeDomain(params.timeDomain);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Performance.setTimeDomain"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getMetrics(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Performance::Metric>> out_metrics;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getMetrics(&out_metrics);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Performance.getMetrics"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("metrics"), out_metrics);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Performance"), SortedRedirects(), std::move(dispatcher));
}

} // Performance
} // namespace blink
} // namespace protocol
