// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_Audits_h
#define blink_protocol_Audits_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/network.h"

namespace blink {
namespace protocol {
namespace Audits {
class AffectedCookie;
class AffectedRequest;
class AffectedFrame;
using CookieExclusionReason = String;
using CookieWarningReason = String;
using CookieOperation = String;
using InsightType = String;
class CookieIssueInsight;
class CookieIssueDetails;
using MixedContentResolutionStatus = String;
using MixedContentResourceType = String;
class MixedContentIssueDetails;
using BlockedByResponseReason = String;
class BlockedByResponseIssueDetails;
using HeavyAdResolutionStatus = String;
using HeavyAdReason = String;
class HeavyAdIssueDetails;
using ContentSecurityPolicyViolationType = String;
class SourceCodeLocation;
class ContentSecurityPolicyIssueDetails;
using SharedArrayBufferIssueType = String;
class SharedArrayBufferIssueDetails;
class LowTextContrastIssueDetails;
class CorsIssueDetails;
using AttributionReportingIssueType = String;
using SharedDictionaryError = String;
using SRIMessageSignatureError = String;
using UnencodedDigestError = String;
class AttributionReportingIssueDetails;
class QuirksModeIssueDetails;
class NavigatorUserAgentIssueDetails;
class SharedDictionaryIssueDetails;
class SRIMessageSignatureIssueDetails;
class UnencodedDigestIssueDetails;
using GenericIssueErrorType = String;
class GenericIssueDetails;
class DeprecationIssueDetails;
class BounceTrackingIssueDetails;
class CookieDeprecationMetadataIssueDetails;
using ClientHintIssueReason = String;
class FederatedAuthRequestIssueDetails;
using FederatedAuthRequestIssueReason = String;
class FederatedAuthUserInfoRequestIssueDetails;
using FederatedAuthUserInfoRequestIssueReason = String;
class ClientHintIssueDetails;
class FailedRequestInfo;
using PartitioningBlobURLInfo = String;
class PartitioningBlobURLIssueDetails;
using ElementAccessibilityIssueReason = String;
class ElementAccessibilityIssueDetails;
using StyleSheetLoadingIssueReason = String;
class StylesheetLoadingIssueDetails;
using PropertyRuleIssueReason = String;
class PropertyRuleIssueDetails;
using UserReidentificationIssueType = String;
class UserReidentificationIssueDetails;
using InspectorIssueCode = String;
class InspectorIssueDetails;
using IssueId = String;
class InspectorIssue;

// ------------- Forward and enum declarations.

namespace CookieExclusionReasonEnum {
CORE_EXPORT extern const char ExcludeSameSiteUnspecifiedTreatedAsLax[];
CORE_EXPORT extern const char ExcludeSameSiteNoneInsecure[];
CORE_EXPORT extern const char ExcludeSameSiteLax[];
CORE_EXPORT extern const char ExcludeSameSiteStrict[];
CORE_EXPORT extern const char ExcludeInvalidSameParty[];
CORE_EXPORT extern const char ExcludeSamePartyCrossPartyContext[];
CORE_EXPORT extern const char ExcludeDomainNonASCII[];
CORE_EXPORT extern const char ExcludeThirdPartyCookieBlockedInFirstPartySet[];
CORE_EXPORT extern const char ExcludeThirdPartyPhaseout[];
CORE_EXPORT extern const char ExcludePortMismatch[];
CORE_EXPORT extern const char ExcludeSchemeMismatch[];
} // namespace CookieExclusionReasonEnum

namespace CookieWarningReasonEnum {
CORE_EXPORT extern const char WarnSameSiteUnspecifiedCrossSiteContext[];
CORE_EXPORT extern const char WarnSameSiteNoneInsecure[];
CORE_EXPORT extern const char WarnSameSiteUnspecifiedLaxAllowUnsafe[];
CORE_EXPORT extern const char WarnSameSiteStrictLaxDowngradeStrict[];
CORE_EXPORT extern const char WarnSameSiteStrictCrossDowngradeStrict[];
CORE_EXPORT extern const char WarnSameSiteStrictCrossDowngradeLax[];
CORE_EXPORT extern const char WarnSameSiteLaxCrossDowngradeStrict[];
CORE_EXPORT extern const char WarnSameSiteLaxCrossDowngradeLax[];
CORE_EXPORT extern const char WarnAttributeValueExceedsMaxSize[];
CORE_EXPORT extern const char WarnDomainNonASCII[];
CORE_EXPORT extern const char WarnThirdPartyPhaseout[];
CORE_EXPORT extern const char WarnCrossSiteRedirectDowngradeChangesInclusion[];
CORE_EXPORT extern const char WarnDeprecationTrialMetadata[];
CORE_EXPORT extern const char WarnThirdPartyCookieHeuristic[];
} // namespace CookieWarningReasonEnum

namespace CookieOperationEnum {
CORE_EXPORT extern const char SetCookie[];
CORE_EXPORT extern const char ReadCookie[];
} // namespace CookieOperationEnum

namespace InsightTypeEnum {
CORE_EXPORT extern const char GitHubResource[];
CORE_EXPORT extern const char GracePeriod[];
CORE_EXPORT extern const char Heuristics[];
} // namespace InsightTypeEnum

namespace MixedContentResolutionStatusEnum {
CORE_EXPORT extern const char MixedContentBlocked[];
CORE_EXPORT extern const char MixedContentAutomaticallyUpgraded[];
CORE_EXPORT extern const char MixedContentWarning[];
} // namespace MixedContentResolutionStatusEnum

namespace MixedContentResourceTypeEnum {
CORE_EXPORT extern const char AttributionSrc[];
CORE_EXPORT extern const char Audio[];
CORE_EXPORT extern const char Beacon[];
CORE_EXPORT extern const char CSPReport[];
CORE_EXPORT extern const char Download[];
CORE_EXPORT extern const char EventSource[];
CORE_EXPORT extern const char Favicon[];
CORE_EXPORT extern const char Font[];
CORE_EXPORT extern const char Form[];
CORE_EXPORT extern const char Frame[];
CORE_EXPORT extern const char Image[];
CORE_EXPORT extern const char Import[];
CORE_EXPORT extern const char JSON[];
CORE_EXPORT extern const char Manifest[];
CORE_EXPORT extern const char Ping[];
CORE_EXPORT extern const char PluginData[];
CORE_EXPORT extern const char PluginResource[];
CORE_EXPORT extern const char Prefetch[];
CORE_EXPORT extern const char Resource[];
CORE_EXPORT extern const char Script[];
CORE_EXPORT extern const char ServiceWorker[];
CORE_EXPORT extern const char SharedWorker[];
CORE_EXPORT extern const char SpeculationRules[];
CORE_EXPORT extern const char Stylesheet[];
CORE_EXPORT extern const char Track[];
CORE_EXPORT extern const char Video[];
CORE_EXPORT extern const char Worker[];
CORE_EXPORT extern const char XMLHttpRequest[];
CORE_EXPORT extern const char XSLT[];
} // namespace MixedContentResourceTypeEnum

namespace BlockedByResponseReasonEnum {
CORE_EXPORT extern const char CoepFrameResourceNeedsCoepHeader[];
CORE_EXPORT extern const char CoopSandboxedIFrameCannotNavigateToCoopPage[];
CORE_EXPORT extern const char CorpNotSameOrigin[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[];
CORE_EXPORT extern const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[];
CORE_EXPORT extern const char CorpNotSameSite[];
CORE_EXPORT extern const char SRIMessageSignatureMismatch[];
} // namespace BlockedByResponseReasonEnum

namespace HeavyAdResolutionStatusEnum {
CORE_EXPORT extern const char HeavyAdBlocked[];
CORE_EXPORT extern const char HeavyAdWarning[];
} // namespace HeavyAdResolutionStatusEnum

namespace HeavyAdReasonEnum {
CORE_EXPORT extern const char NetworkTotalLimit[];
CORE_EXPORT extern const char CpuTotalLimit[];
CORE_EXPORT extern const char CpuPeakLimit[];
} // namespace HeavyAdReasonEnum

namespace ContentSecurityPolicyViolationTypeEnum {
CORE_EXPORT extern const char KInlineViolation[];
CORE_EXPORT extern const char KEvalViolation[];
CORE_EXPORT extern const char KURLViolation[];
CORE_EXPORT extern const char KSRIViolation[];
CORE_EXPORT extern const char KTrustedTypesSinkViolation[];
CORE_EXPORT extern const char KTrustedTypesPolicyViolation[];
CORE_EXPORT extern const char KWasmEvalViolation[];
} // namespace ContentSecurityPolicyViolationTypeEnum

namespace SharedArrayBufferIssueTypeEnum {
CORE_EXPORT extern const char TransferIssue[];
CORE_EXPORT extern const char CreationIssue[];
} // namespace SharedArrayBufferIssueTypeEnum

namespace AttributionReportingIssueTypeEnum {
CORE_EXPORT extern const char PermissionPolicyDisabled[];
CORE_EXPORT extern const char UntrustworthyReportingOrigin[];
CORE_EXPORT extern const char InsecureContext[];
CORE_EXPORT extern const char InvalidHeader[];
CORE_EXPORT extern const char InvalidRegisterTriggerHeader[];
CORE_EXPORT extern const char SourceAndTriggerHeaders[];
CORE_EXPORT extern const char SourceIgnored[];
CORE_EXPORT extern const char TriggerIgnored[];
CORE_EXPORT extern const char OsSourceIgnored[];
CORE_EXPORT extern const char OsTriggerIgnored[];
CORE_EXPORT extern const char InvalidRegisterOsSourceHeader[];
CORE_EXPORT extern const char InvalidRegisterOsTriggerHeader[];
CORE_EXPORT extern const char WebAndOsHeaders[];
CORE_EXPORT extern const char NoWebOrOsSupport[];
CORE_EXPORT extern const char NavigationRegistrationWithoutTransientUserActivation[];
CORE_EXPORT extern const char InvalidInfoHeader[];
CORE_EXPORT extern const char NoRegisterSourceHeader[];
CORE_EXPORT extern const char NoRegisterTriggerHeader[];
CORE_EXPORT extern const char NoRegisterOsSourceHeader[];
CORE_EXPORT extern const char NoRegisterOsTriggerHeader[];
CORE_EXPORT extern const char NavigationRegistrationUniqueScopeAlreadySet[];
} // namespace AttributionReportingIssueTypeEnum

namespace SharedDictionaryErrorEnum {
CORE_EXPORT extern const char UseErrorCrossOriginNoCorsRequest[];
CORE_EXPORT extern const char UseErrorDictionaryLoadFailure[];
CORE_EXPORT extern const char UseErrorMatchingDictionaryNotUsed[];
CORE_EXPORT extern const char UseErrorUnexpectedContentDictionaryHeader[];
CORE_EXPORT extern const char WriteErrorCossOriginNoCorsRequest[];
CORE_EXPORT extern const char WriteErrorDisallowedBySettings[];
CORE_EXPORT extern const char WriteErrorExpiredResponse[];
CORE_EXPORT extern const char WriteErrorFeatureDisabled[];
CORE_EXPORT extern const char WriteErrorInsufficientResources[];
CORE_EXPORT extern const char WriteErrorInvalidMatchField[];
CORE_EXPORT extern const char WriteErrorInvalidStructuredHeader[];
CORE_EXPORT extern const char WriteErrorInvalidTTLField[];
CORE_EXPORT extern const char WriteErrorNavigationRequest[];
CORE_EXPORT extern const char WriteErrorNoMatchField[];
CORE_EXPORT extern const char WriteErrorNonIntegerTTLField[];
CORE_EXPORT extern const char WriteErrorNonListMatchDestField[];
CORE_EXPORT extern const char WriteErrorNonSecureContext[];
CORE_EXPORT extern const char WriteErrorNonStringIdField[];
CORE_EXPORT extern const char WriteErrorNonStringInMatchDestList[];
CORE_EXPORT extern const char WriteErrorNonStringMatchField[];
CORE_EXPORT extern const char WriteErrorNonTokenTypeField[];
CORE_EXPORT extern const char WriteErrorRequestAborted[];
CORE_EXPORT extern const char WriteErrorShuttingDown[];
CORE_EXPORT extern const char WriteErrorTooLongIdField[];
CORE_EXPORT extern const char WriteErrorUnsupportedType[];
} // namespace SharedDictionaryErrorEnum

namespace SRIMessageSignatureErrorEnum {
CORE_EXPORT extern const char MissingSignatureHeader[];
CORE_EXPORT extern const char MissingSignatureInputHeader[];
CORE_EXPORT extern const char InvalidSignatureHeader[];
CORE_EXPORT extern const char InvalidSignatureInputHeader[];
CORE_EXPORT extern const char SignatureHeaderValueIsNotByteSequence[];
CORE_EXPORT extern const char SignatureHeaderValueIsParameterized[];
CORE_EXPORT extern const char SignatureHeaderValueIsIncorrectLength[];
CORE_EXPORT extern const char SignatureInputHeaderMissingLabel[];
CORE_EXPORT extern const char SignatureInputHeaderValueNotInnerList[];
CORE_EXPORT extern const char SignatureInputHeaderValueMissingComponents[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidComponentType[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidComponentName[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidHeaderComponentParameter[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidDerivedComponentParameter[];
CORE_EXPORT extern const char SignatureInputHeaderKeyIdLength[];
CORE_EXPORT extern const char SignatureInputHeaderInvalidParameter[];
CORE_EXPORT extern const char SignatureInputHeaderMissingRequiredParameters[];
CORE_EXPORT extern const char ValidationFailedSignatureExpired[];
CORE_EXPORT extern const char ValidationFailedInvalidLength[];
CORE_EXPORT extern const char ValidationFailedSignatureMismatch[];
CORE_EXPORT extern const char ValidationFailedIntegrityMismatch[];
} // namespace SRIMessageSignatureErrorEnum

namespace UnencodedDigestErrorEnum {
CORE_EXPORT extern const char MalformedDictionary[];
CORE_EXPORT extern const char UnknownAlgorithm[];
CORE_EXPORT extern const char IncorrectDigestType[];
CORE_EXPORT extern const char IncorrectDigestLength[];
} // namespace UnencodedDigestErrorEnum

namespace GenericIssueErrorTypeEnum {
CORE_EXPORT extern const char FormLabelForNameError[];
CORE_EXPORT extern const char FormDuplicateIdForInputError[];
CORE_EXPORT extern const char FormInputWithNoLabelError[];
CORE_EXPORT extern const char FormAutocompleteAttributeEmptyError[];
CORE_EXPORT extern const char FormEmptyIdAndNameAttributesForInputError[];
CORE_EXPORT extern const char FormAriaLabelledByToNonExistingId[];
CORE_EXPORT extern const char FormInputAssignedAutocompleteValueToIdOrNameAttributeError[];
CORE_EXPORT extern const char FormLabelHasNeitherForNorNestedInput[];
CORE_EXPORT extern const char FormLabelForMatchesNonExistingIdError[];
CORE_EXPORT extern const char FormInputHasWrongButWellIntendedAutocompleteValueError[];
CORE_EXPORT extern const char ResponseWasBlockedByORB[];
} // namespace GenericIssueErrorTypeEnum

namespace ClientHintIssueReasonEnum {
CORE_EXPORT extern const char MetaTagAllowListInvalidOrigin[];
CORE_EXPORT extern const char MetaTagModifiedHTML[];
} // namespace ClientHintIssueReasonEnum

namespace FederatedAuthRequestIssueReasonEnum {
CORE_EXPORT extern const char ShouldEmbargo[];
CORE_EXPORT extern const char TooManyRequests[];
CORE_EXPORT extern const char WellKnownHttpNotFound[];
CORE_EXPORT extern const char WellKnownNoResponse[];
CORE_EXPORT extern const char WellKnownInvalidResponse[];
CORE_EXPORT extern const char WellKnownListEmpty[];
CORE_EXPORT extern const char WellKnownInvalidContentType[];
CORE_EXPORT extern const char ConfigNotInWellKnown[];
CORE_EXPORT extern const char WellKnownTooBig[];
CORE_EXPORT extern const char ConfigHttpNotFound[];
CORE_EXPORT extern const char ConfigNoResponse[];
CORE_EXPORT extern const char ConfigInvalidResponse[];
CORE_EXPORT extern const char ConfigInvalidContentType[];
CORE_EXPORT extern const char ClientMetadataHttpNotFound[];
CORE_EXPORT extern const char ClientMetadataNoResponse[];
CORE_EXPORT extern const char ClientMetadataInvalidResponse[];
CORE_EXPORT extern const char ClientMetadataInvalidContentType[];
CORE_EXPORT extern const char IdpNotPotentiallyTrustworthy[];
CORE_EXPORT extern const char DisabledInSettings[];
CORE_EXPORT extern const char DisabledInFlags[];
CORE_EXPORT extern const char ErrorFetchingSignin[];
CORE_EXPORT extern const char InvalidSigninResponse[];
CORE_EXPORT extern const char AccountsHttpNotFound[];
CORE_EXPORT extern const char AccountsNoResponse[];
CORE_EXPORT extern const char AccountsInvalidResponse[];
CORE_EXPORT extern const char AccountsListEmpty[];
CORE_EXPORT extern const char AccountsInvalidContentType[];
CORE_EXPORT extern const char IdTokenHttpNotFound[];
CORE_EXPORT extern const char IdTokenNoResponse[];
CORE_EXPORT extern const char IdTokenInvalidResponse[];
CORE_EXPORT extern const char IdTokenIdpErrorResponse[];
CORE_EXPORT extern const char IdTokenCrossSiteIdpErrorResponse[];
CORE_EXPORT extern const char IdTokenInvalidRequest[];
CORE_EXPORT extern const char IdTokenInvalidContentType[];
CORE_EXPORT extern const char ErrorIdToken[];
CORE_EXPORT extern const char Canceled[];
CORE_EXPORT extern const char RpPageNotVisible[];
CORE_EXPORT extern const char SilentMediationFailure[];
CORE_EXPORT extern const char ThirdPartyCookiesBlocked[];
CORE_EXPORT extern const char NotSignedInWithIdp[];
CORE_EXPORT extern const char MissingTransientUserActivation[];
CORE_EXPORT extern const char ReplacedByActiveMode[];
CORE_EXPORT extern const char InvalidFieldsSpecified[];
CORE_EXPORT extern const char RelyingPartyOriginIsOpaque[];
CORE_EXPORT extern const char TypeNotMatching[];
CORE_EXPORT extern const char UiDismissedNoEmbargo[];
CORE_EXPORT extern const char CorsError[];
CORE_EXPORT extern const char SuppressedBySegmentationPlatform[];
} // namespace FederatedAuthRequestIssueReasonEnum

namespace FederatedAuthUserInfoRequestIssueReasonEnum {
CORE_EXPORT extern const char NotSameOrigin[];
CORE_EXPORT extern const char NotIframe[];
CORE_EXPORT extern const char NotPotentiallyTrustworthy[];
CORE_EXPORT extern const char NoApiPermission[];
CORE_EXPORT extern const char NotSignedInWithIdp[];
CORE_EXPORT extern const char NoAccountSharingPermission[];
CORE_EXPORT extern const char InvalidConfigOrWellKnown[];
CORE_EXPORT extern const char InvalidAccountsResponse[];
CORE_EXPORT extern const char NoReturningUserFromFetchedAccounts[];
} // namespace FederatedAuthUserInfoRequestIssueReasonEnum

namespace PartitioningBlobURLInfoEnum {
CORE_EXPORT extern const char BlockedCrossPartitionFetching[];
CORE_EXPORT extern const char EnforceNoopenerForNavigation[];
} // namespace PartitioningBlobURLInfoEnum

namespace ElementAccessibilityIssueReasonEnum {
CORE_EXPORT extern const char DisallowedSelectChild[];
CORE_EXPORT extern const char DisallowedOptGroupChild[];
CORE_EXPORT extern const char NonPhrasingContentOptionChild[];
CORE_EXPORT extern const char InteractiveContentOptionChild[];
CORE_EXPORT extern const char InteractiveContentLegendChild[];
CORE_EXPORT extern const char InteractiveContentSummaryDescendant[];
} // namespace ElementAccessibilityIssueReasonEnum

namespace StyleSheetLoadingIssueReasonEnum {
CORE_EXPORT extern const char LateImportRule[];
CORE_EXPORT extern const char RequestFailed[];
} // namespace StyleSheetLoadingIssueReasonEnum

namespace PropertyRuleIssueReasonEnum {
CORE_EXPORT extern const char InvalidSyntax[];
CORE_EXPORT extern const char InvalidInitialValue[];
CORE_EXPORT extern const char InvalidInherits[];
CORE_EXPORT extern const char InvalidName[];
} // namespace PropertyRuleIssueReasonEnum

namespace UserReidentificationIssueTypeEnum {
CORE_EXPORT extern const char BlockedFrameNavigation[];
CORE_EXPORT extern const char BlockedSubresource[];
CORE_EXPORT extern const char NoisedCanvasReadback[];
} // namespace UserReidentificationIssueTypeEnum

namespace InspectorIssueCodeEnum {
CORE_EXPORT extern const char CookieIssue[];
CORE_EXPORT extern const char MixedContentIssue[];
CORE_EXPORT extern const char BlockedByResponseIssue[];
CORE_EXPORT extern const char HeavyAdIssue[];
CORE_EXPORT extern const char ContentSecurityPolicyIssue[];
CORE_EXPORT extern const char SharedArrayBufferIssue[];
CORE_EXPORT extern const char LowTextContrastIssue[];
CORE_EXPORT extern const char CorsIssue[];
CORE_EXPORT extern const char AttributionReportingIssue[];
CORE_EXPORT extern const char QuirksModeIssue[];
CORE_EXPORT extern const char PartitioningBlobURLIssue[];
CORE_EXPORT extern const char NavigatorUserAgentIssue[];
CORE_EXPORT extern const char GenericIssue[];
CORE_EXPORT extern const char DeprecationIssue[];
CORE_EXPORT extern const char ClientHintIssue[];
CORE_EXPORT extern const char FederatedAuthRequestIssue[];
CORE_EXPORT extern const char BounceTrackingIssue[];
CORE_EXPORT extern const char CookieDeprecationMetadataIssue[];
CORE_EXPORT extern const char StylesheetLoadingIssue[];
CORE_EXPORT extern const char FederatedAuthUserInfoRequestIssue[];
CORE_EXPORT extern const char PropertyRuleIssue[];
CORE_EXPORT extern const char SharedDictionaryIssue[];
CORE_EXPORT extern const char ElementAccessibilityIssue[];
CORE_EXPORT extern const char SRIMessageSignatureIssue[];
CORE_EXPORT extern const char UnencodedDigestIssue[];
CORE_EXPORT extern const char UserReidentificationIssue[];
} // namespace InspectorIssueCodeEnum

namespace GetEncodedResponse {
namespace EncodingEnum {
CORE_EXPORT extern const char* Webp;
CORE_EXPORT extern const char* Jpeg;
CORE_EXPORT extern const char* Png;
} // EncodingEnum
} // GetEncodedResponse

// ------------- Type and builder declarations.

class CORE_EXPORT AffectedCookie : public ::crdtp::ProtocolObject<AffectedCookie> {
public:
    ~AffectedCookie() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getPath() { return m_path; }
    void setPath(const String& value);  // Defined below

    String getDomain() { return m_domain; }
    void setDomain(const String& value);  // Defined below

    template<int STATE>
    class AffectedCookieBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            PathSet = 1 << 2,
            DomainSet = 1 << 3,
            AllFieldsSet = (NameSet | PathSet | DomainSet | 0)};


        AffectedCookieBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        AffectedCookieBuilder<STATE | PathSet>& setPath(const String& value);  // Defined below

        AffectedCookieBuilder<STATE | DomainSet>& setDomain(const String& value);  // Defined below

        std::unique_ptr<AffectedCookie> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedCookie;
        AffectedCookieBuilder() : m_result(new AffectedCookie()) { }

        template<int STEP> AffectedCookieBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedCookieBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedCookie> m_result;
    };

    static AffectedCookieBuilder<0> create()
    {
        return AffectedCookieBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedCookie();  // Defined below

    String m_name;
    String m_path;
    String m_domain;
};


class CORE_EXPORT AffectedRequest : public ::crdtp::ProtocolObject<AffectedRequest> {
public:
    ~AffectedRequest() override;  // Defined below

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    template<int STATE>
    class AffectedRequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        AffectedRequestBuilder<STATE>& setRequestId(const String& value);  // Defined below

        AffectedRequestBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        std::unique_ptr<AffectedRequest> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedRequest;
        AffectedRequestBuilder() : m_result(new AffectedRequest()) { }

        template<int STEP> AffectedRequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedRequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedRequest> m_result;
    };

    static AffectedRequestBuilder<0> create()
    {
        return AffectedRequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedRequest();  // Defined below

    std::optional<String> m_requestId;
    String m_url;
};


class CORE_EXPORT AffectedFrame : public ::crdtp::ProtocolObject<AffectedFrame> {
public:
    ~AffectedFrame() override;  // Defined below

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value);  // Defined below

    template<int STATE>
    class AffectedFrameBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FrameIdSet = 1 << 1,
            AllFieldsSet = (FrameIdSet | 0)};


        AffectedFrameBuilder<STATE | FrameIdSet>& setFrameId(const String& value);  // Defined below

        std::unique_ptr<AffectedFrame> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AffectedFrame;
        AffectedFrameBuilder() : m_result(new AffectedFrame()) { }

        template<int STEP> AffectedFrameBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AffectedFrameBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AffectedFrame> m_result;
    };

    static AffectedFrameBuilder<0> create()
    {
        return AffectedFrameBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AffectedFrame();  // Defined below

    String m_frameId;
};


class CORE_EXPORT CookieIssueInsight : public ::crdtp::ProtocolObject<CookieIssueInsight> {
public:
    ~CookieIssueInsight() override;  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasTableEntryUrl() { return !!m_tableEntryUrl; }
    String getTableEntryUrl(const String& defaultValue) const {
       return m_tableEntryUrl.value_or(defaultValue);
    }
    const std::optional<String>& getTableEntryUrl() const {
       return m_tableEntryUrl;
    }
    void setTableEntryUrl(const String& value);  // Defined below

    template<int STATE>
    class CookieIssueInsightBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        CookieIssueInsightBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        CookieIssueInsightBuilder<STATE>& setTableEntryUrl(const String& value);  // Defined below

        std::unique_ptr<CookieIssueInsight> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueInsight;
        CookieIssueInsightBuilder() : m_result(new CookieIssueInsight()) { }

        template<int STEP> CookieIssueInsightBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueInsightBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueInsight> m_result;
    };

    static CookieIssueInsightBuilder<0> create()
    {
        return CookieIssueInsightBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueInsight();  // Defined below

    String m_type;
    std::optional<String> m_tableEntryUrl;
};


class CORE_EXPORT CookieIssueDetails : public ::crdtp::ProtocolObject<CookieIssueDetails> {
public:
    ~CookieIssueDetails() override;  // Defined below

    bool hasCookie() { return !!m_cookie; }
    protocol::Audits::AffectedCookie* getCookie(protocol::Audits::AffectedCookie* defaultValue) {
       return m_cookie ? m_cookie.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedCookie>& getCookie() const {
       return m_cookie;
    }
    void setCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value);  // Defined below

    bool hasRawCookieLine() { return !!m_rawCookieLine; }
    String getRawCookieLine(const String& defaultValue) const {
       return m_rawCookieLine.value_or(defaultValue);
    }
    const std::optional<String>& getRawCookieLine() const {
       return m_rawCookieLine;
    }
    void setRawCookieLine(const String& value);  // Defined below

    protocol::Array<String>* getCookieWarningReasons() { return m_cookieWarningReasons.get(); }
    void setCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<String>* getCookieExclusionReasons() { return m_cookieExclusionReasons.get(); }
    void setCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    String getOperation() { return m_operation; }
    void setOperation(const String& value);  // Defined below

    bool hasSiteForCookies() { return !!m_siteForCookies; }
    String getSiteForCookies(const String& defaultValue) const {
       return m_siteForCookies.value_or(defaultValue);
    }
    const std::optional<String>& getSiteForCookies() const {
       return m_siteForCookies;
    }
    void setSiteForCookies(const String& value);  // Defined below

    bool hasCookieUrl() { return !!m_cookieUrl; }
    String getCookieUrl(const String& defaultValue) const {
       return m_cookieUrl.value_or(defaultValue);
    }
    const std::optional<String>& getCookieUrl() const {
       return m_cookieUrl;
    }
    void setCookieUrl(const String& value);  // Defined below

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool hasInsight() { return !!m_insight; }
    protocol::Audits::CookieIssueInsight* getInsight(protocol::Audits::CookieIssueInsight* defaultValue) {
       return m_insight ? m_insight.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueInsight>& getInsight() const {
       return m_insight;
    }
    void setInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value);  // Defined below

    template<int STATE>
    class CookieIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CookieWarningReasonsSet = 1 << 1,
            CookieExclusionReasonsSet = 1 << 2,
            OperationSet = 1 << 3,
            AllFieldsSet = (CookieWarningReasonsSet | CookieExclusionReasonsSet | OperationSet | 0)};


        CookieIssueDetailsBuilder<STATE>& setCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& setRawCookieLine(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE | CookieWarningReasonsSet>& setCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CookieIssueDetailsBuilder<STATE | CookieExclusionReasonsSet>& setCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CookieIssueDetailsBuilder<STATE | OperationSet>& setOperation(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& setSiteForCookies(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& setCookieUrl(const String& value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        CookieIssueDetailsBuilder<STATE>& setInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value);  // Defined below

        std::unique_ptr<CookieIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieIssueDetails;
        CookieIssueDetailsBuilder() : m_result(new CookieIssueDetails()) { }

        template<int STEP> CookieIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieIssueDetails> m_result;
    };

    static CookieIssueDetailsBuilder<0> create()
    {
        return CookieIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::AffectedCookie> m_cookie;
    std::optional<String> m_rawCookieLine;
    std::unique_ptr<protocol::Array<String>> m_cookieWarningReasons;
    std::unique_ptr<protocol::Array<String>> m_cookieExclusionReasons;
    String m_operation;
    std::optional<String> m_siteForCookies;
    std::optional<String> m_cookieUrl;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::CookieIssueInsight> m_insight;
};


class CORE_EXPORT MixedContentIssueDetails : public ::crdtp::ProtocolObject<MixedContentIssueDetails> {
public:
    ~MixedContentIssueDetails() override;  // Defined below

    bool hasResourceType() { return !!m_resourceType; }
    String getResourceType(const String& defaultValue) const {
       return m_resourceType.value_or(defaultValue);
    }
    const std::optional<String>& getResourceType() const {
       return m_resourceType;
    }
    void setResourceType(const String& value);  // Defined below

    String getResolutionStatus() { return m_resolutionStatus; }
    void setResolutionStatus(const String& value);  // Defined below

    String getInsecureURL() { return m_insecureURL; }
    void setInsecureURL(const String& value);  // Defined below

    String getMainResourceURL() { return m_mainResourceURL; }
    void setMainResourceURL(const String& value);  // Defined below

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool hasFrame() { return !!m_frame; }
    protocol::Audits::AffectedFrame* getFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frame ? m_frame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getFrame() const {
       return m_frame;
    }
    void setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    template<int STATE>
    class MixedContentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionStatusSet = 1 << 1,
            InsecureURLSet = 1 << 2,
            MainResourceURLSet = 1 << 3,
            AllFieldsSet = (ResolutionStatusSet | InsecureURLSet | MainResourceURLSet | 0)};


        MixedContentIssueDetailsBuilder<STATE>& setResourceType(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE | ResolutionStatusSet>& setResolutionStatus(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE | InsecureURLSet>& setInsecureURL(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE | MainResourceURLSet>& setMainResourceURL(const String& value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        MixedContentIssueDetailsBuilder<STATE>& setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        std::unique_ptr<MixedContentIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class MixedContentIssueDetails;
        MixedContentIssueDetailsBuilder() : m_result(new MixedContentIssueDetails()) { }

        template<int STEP> MixedContentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<MixedContentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_result;
    };

    static MixedContentIssueDetailsBuilder<0> create()
    {
        return MixedContentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    MixedContentIssueDetails();  // Defined below

    std::optional<String> m_resourceType;
    String m_resolutionStatus;
    String m_insecureURL;
    String m_mainResourceURL;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CORE_EXPORT BlockedByResponseIssueDetails : public ::crdtp::ProtocolObject<BlockedByResponseIssueDetails> {
public:
    ~BlockedByResponseIssueDetails() override;  // Defined below

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool hasParentFrame() { return !!m_parentFrame; }
    protocol::Audits::AffectedFrame* getParentFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_parentFrame ? m_parentFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getParentFrame() const {
       return m_parentFrame;
    }
    void setParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    bool hasBlockedFrame() { return !!m_blockedFrame; }
    protocol::Audits::AffectedFrame* getBlockedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_blockedFrame ? m_blockedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getBlockedFrame() const {
       return m_blockedFrame;
    }
    void setBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    String getReason() { return m_reason; }
    void setReason(const String& value);  // Defined below

    template<int STATE>
    class BlockedByResponseIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RequestSet = 1 << 1,
            ReasonSet = 1 << 2,
            AllFieldsSet = (RequestSet | ReasonSet | 0)};


        BlockedByResponseIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        BlockedByResponseIssueDetailsBuilder<STATE>& setParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        BlockedByResponseIssueDetailsBuilder<STATE>& setBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        BlockedByResponseIssueDetailsBuilder<STATE | ReasonSet>& setReason(const String& value);  // Defined below

        std::unique_ptr<BlockedByResponseIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BlockedByResponseIssueDetails;
        BlockedByResponseIssueDetailsBuilder() : m_result(new BlockedByResponseIssueDetails()) { }

        template<int STEP> BlockedByResponseIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BlockedByResponseIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_result;
    };

    static BlockedByResponseIssueDetailsBuilder<0> create()
    {
        return BlockedByResponseIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BlockedByResponseIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_parentFrame;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_blockedFrame;
    String m_reason;
};


class CORE_EXPORT HeavyAdIssueDetails : public ::crdtp::ProtocolObject<HeavyAdIssueDetails> {
public:
    ~HeavyAdIssueDetails() override;  // Defined below

    String getResolution() { return m_resolution; }
    void setResolution(const String& value);  // Defined below

    String getReason() { return m_reason; }
    void setReason(const String& value);  // Defined below

    protocol::Audits::AffectedFrame* getFrame() { return m_frame.get(); }
    void setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    template<int STATE>
    class HeavyAdIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ResolutionSet = 1 << 1,
            ReasonSet = 1 << 2,
            FrameSet = 1 << 3,
            AllFieldsSet = (ResolutionSet | ReasonSet | FrameSet | 0)};


        HeavyAdIssueDetailsBuilder<STATE | ResolutionSet>& setResolution(const String& value);  // Defined below

        HeavyAdIssueDetailsBuilder<STATE | ReasonSet>& setReason(const String& value);  // Defined below

        HeavyAdIssueDetailsBuilder<STATE | FrameSet>& setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        std::unique_ptr<HeavyAdIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class HeavyAdIssueDetails;
        HeavyAdIssueDetailsBuilder() : m_result(new HeavyAdIssueDetails()) { }

        template<int STEP> HeavyAdIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<HeavyAdIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_result;
    };

    static HeavyAdIssueDetailsBuilder<0> create()
    {
        return HeavyAdIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    HeavyAdIssueDetails();  // Defined below

    String m_resolution;
    String m_reason;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frame;
};


class CORE_EXPORT SourceCodeLocation : public ::crdtp::ProtocolObject<SourceCodeLocation> {
public:
    ~SourceCodeLocation() override;  // Defined below

    bool hasScriptId() { return !!m_scriptId; }
    String getScriptId(const String& defaultValue) const {
       return m_scriptId.value_or(defaultValue);
    }
    const std::optional<String>& getScriptId() const {
       return m_scriptId;
    }
    void setScriptId(const String& value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value);  // Defined below

    template<int STATE>
    class SourceCodeLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            LineNumberSet = 1 << 2,
            ColumnNumberSet = 1 << 3,
            AllFieldsSet = (UrlSet | LineNumberSet | ColumnNumberSet | 0)};


        SourceCodeLocationBuilder<STATE>& setScriptId(const String& value);  // Defined below

        SourceCodeLocationBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        SourceCodeLocationBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        SourceCodeLocationBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value);  // Defined below

        std::unique_ptr<SourceCodeLocation> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SourceCodeLocation;
        SourceCodeLocationBuilder() : m_result(new SourceCodeLocation()) { }

        template<int STEP> SourceCodeLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SourceCodeLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SourceCodeLocation> m_result;
    };

    static SourceCodeLocationBuilder<0> create()
    {
        return SourceCodeLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SourceCodeLocation();  // Defined below

    std::optional<String> m_scriptId;
    String m_url;
    int m_lineNumber;
    int m_columnNumber;
};


class CORE_EXPORT ContentSecurityPolicyIssueDetails : public ::crdtp::ProtocolObject<ContentSecurityPolicyIssueDetails> {
public:
    ~ContentSecurityPolicyIssueDetails() override;  // Defined below

    bool hasBlockedURL() { return !!m_blockedURL; }
    String getBlockedURL(const String& defaultValue) const {
       return m_blockedURL.value_or(defaultValue);
    }
    const std::optional<String>& getBlockedURL() const {
       return m_blockedURL;
    }
    void setBlockedURL(const String& value);  // Defined below

    String getViolatedDirective() { return m_violatedDirective; }
    void setViolatedDirective(const String& value);  // Defined below

    bool getIsReportOnly() { return m_isReportOnly; }
    void setIsReportOnly(bool value);  // Defined below

    String getContentSecurityPolicyViolationType() { return m_contentSecurityPolicyViolationType; }
    void setContentSecurityPolicyViolationType(const String& value);  // Defined below

    bool hasFrameAncestor() { return !!m_frameAncestor; }
    protocol::Audits::AffectedFrame* getFrameAncestor(protocol::Audits::AffectedFrame* defaultValue) {
       return m_frameAncestor ? m_frameAncestor.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getFrameAncestor() const {
       return m_frameAncestor;
    }
    void setFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    bool hasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* getSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    bool hasViolatingNodeId() { return !!m_violatingNodeId; }
    int getViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void setViolatingNodeId(int value);  // Defined below

    template<int STATE>
    class ContentSecurityPolicyIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatedDirectiveSet = 1 << 1,
            IsReportOnlySet = 1 << 2,
            ContentSecurityPolicyViolationTypeSet = 1 << 3,
            AllFieldsSet = (ViolatedDirectiveSet | IsReportOnlySet | ContentSecurityPolicyViolationTypeSet | 0)};


        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setBlockedURL(const String& value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ViolatedDirectiveSet>& setViolatedDirective(const String& value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE | IsReportOnlySet>& setIsReportOnly(bool value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyViolationTypeSet>& setContentSecurityPolicyViolationType(const String& value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        ContentSecurityPolicyIssueDetailsBuilder<STATE>& setViolatingNodeId(int value);  // Defined below

        std::unique_ptr<ContentSecurityPolicyIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ContentSecurityPolicyIssueDetails;
        ContentSecurityPolicyIssueDetailsBuilder() : m_result(new ContentSecurityPolicyIssueDetails()) { }

        template<int STEP> ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ContentSecurityPolicyIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_result;
    };

    static ContentSecurityPolicyIssueDetailsBuilder<0> create()
    {
        return ContentSecurityPolicyIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ContentSecurityPolicyIssueDetails();  // Defined below

    std::optional<String> m_blockedURL;
    String m_violatedDirective;
    bool m_isReportOnly;
    String m_contentSecurityPolicyViolationType;
    std::unique_ptr<protocol::Audits::AffectedFrame> m_frameAncestor;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    std::optional<int> m_violatingNodeId;
};


class CORE_EXPORT SharedArrayBufferIssueDetails : public ::crdtp::ProtocolObject<SharedArrayBufferIssueDetails> {
public:
    ~SharedArrayBufferIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    bool getIsWarning() { return m_isWarning; }
    void setIsWarning(bool value);  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    template<int STATE>
    class SharedArrayBufferIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            IsWarningSet = 1 << 2,
            TypeSet = 1 << 3,
            AllFieldsSet = (SourceCodeLocationSet | IsWarningSet | TypeSet | 0)};


        SharedArrayBufferIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        SharedArrayBufferIssueDetailsBuilder<STATE | IsWarningSet>& setIsWarning(bool value);  // Defined below

        SharedArrayBufferIssueDetailsBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        std::unique_ptr<SharedArrayBufferIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedArrayBufferIssueDetails;
        SharedArrayBufferIssueDetailsBuilder() : m_result(new SharedArrayBufferIssueDetails()) { }

        template<int STEP> SharedArrayBufferIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedArrayBufferIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_result;
    };

    static SharedArrayBufferIssueDetailsBuilder<0> create()
    {
        return SharedArrayBufferIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedArrayBufferIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    bool m_isWarning;
    String m_type;
};


class CORE_EXPORT LowTextContrastIssueDetails : public ::crdtp::ProtocolObject<LowTextContrastIssueDetails> {
public:
    ~LowTextContrastIssueDetails() override;  // Defined below

    int getViolatingNodeId() { return m_violatingNodeId; }
    void setViolatingNodeId(int value);  // Defined below

    String getViolatingNodeSelector() { return m_violatingNodeSelector; }
    void setViolatingNodeSelector(const String& value);  // Defined below

    double getContrastRatio() { return m_contrastRatio; }
    void setContrastRatio(double value);  // Defined below

    double getThresholdAA() { return m_thresholdAA; }
    void setThresholdAA(double value);  // Defined below

    double getThresholdAAA() { return m_thresholdAAA; }
    void setThresholdAAA(double value);  // Defined below

    String getFontSize() { return m_fontSize; }
    void setFontSize(const String& value);  // Defined below

    String getFontWeight() { return m_fontWeight; }
    void setFontWeight(const String& value);  // Defined below

    template<int STATE>
    class LowTextContrastIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolatingNodeIdSet = 1 << 1,
            ViolatingNodeSelectorSet = 1 << 2,
            ContrastRatioSet = 1 << 3,
            ThresholdAASet = 1 << 4,
            ThresholdAAASet = 1 << 5,
            FontSizeSet = 1 << 6,
            FontWeightSet = 1 << 7,
            AllFieldsSet = (ViolatingNodeIdSet | ViolatingNodeSelectorSet | ContrastRatioSet | ThresholdAASet | ThresholdAAASet | FontSizeSet | FontWeightSet | 0)};


        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeIdSet>& setViolatingNodeId(int value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ViolatingNodeSelectorSet>& setViolatingNodeSelector(const String& value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ContrastRatioSet>& setContrastRatio(double value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAASet>& setThresholdAA(double value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | ThresholdAAASet>& setThresholdAAA(double value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | FontSizeSet>& setFontSize(const String& value);  // Defined below

        LowTextContrastIssueDetailsBuilder<STATE | FontWeightSet>& setFontWeight(const String& value);  // Defined below

        std::unique_ptr<LowTextContrastIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LowTextContrastIssueDetails;
        LowTextContrastIssueDetailsBuilder() : m_result(new LowTextContrastIssueDetails()) { }

        template<int STEP> LowTextContrastIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LowTextContrastIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_result;
    };

    static LowTextContrastIssueDetailsBuilder<0> create()
    {
        return LowTextContrastIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LowTextContrastIssueDetails();  // Defined below

    int m_violatingNodeId;
    String m_violatingNodeSelector;
    double m_contrastRatio;
    double m_thresholdAA;
    double m_thresholdAAA;
    String m_fontSize;
    String m_fontWeight;
};


class CORE_EXPORT CorsIssueDetails : public ::crdtp::ProtocolObject<CorsIssueDetails> {
public:
    ~CorsIssueDetails() override;  // Defined below

    protocol::Network::CorsErrorStatus* getCorsErrorStatus() { return m_corsErrorStatus.get(); }
    void setCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value);  // Defined below

    bool getIsWarning() { return m_isWarning; }
    void setIsWarning(bool value);  // Defined below

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool hasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* getLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getLocation() const {
       return m_location;
    }
    void setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    bool hasInitiatorOrigin() { return !!m_initiatorOrigin; }
    String getInitiatorOrigin(const String& defaultValue) const {
       return m_initiatorOrigin.value_or(defaultValue);
    }
    const std::optional<String>& getInitiatorOrigin() const {
       return m_initiatorOrigin;
    }
    void setInitiatorOrigin(const String& value);  // Defined below

    bool hasResourceIPAddressSpace() { return !!m_resourceIPAddressSpace; }
    String getResourceIPAddressSpace(const String& defaultValue) const {
       return m_resourceIPAddressSpace.value_or(defaultValue);
    }
    const std::optional<String>& getResourceIPAddressSpace() const {
       return m_resourceIPAddressSpace;
    }
    void setResourceIPAddressSpace(const String& value);  // Defined below

    bool hasClientSecurityState() { return !!m_clientSecurityState; }
    protocol::Network::ClientSecurityState* getClientSecurityState(protocol::Network::ClientSecurityState* defaultValue) {
       return m_clientSecurityState ? m_clientSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Network::ClientSecurityState>& getClientSecurityState() const {
       return m_clientSecurityState;
    }
    void setClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value);  // Defined below

    template<int STATE>
    class CorsIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CorsErrorStatusSet = 1 << 1,
            IsWarningSet = 1 << 2,
            RequestSet = 1 << 3,
            AllFieldsSet = (CorsErrorStatusSet | IsWarningSet | RequestSet | 0)};


        CorsIssueDetailsBuilder<STATE | CorsErrorStatusSet>& setCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value);  // Defined below

        CorsIssueDetailsBuilder<STATE | IsWarningSet>& setIsWarning(bool value);  // Defined below

        CorsIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& setInitiatorOrigin(const String& value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& setResourceIPAddressSpace(const String& value);  // Defined below

        CorsIssueDetailsBuilder<STATE>& setClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value);  // Defined below

        std::unique_ptr<CorsIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CorsIssueDetails;
        CorsIssueDetailsBuilder() : m_result(new CorsIssueDetails()) { }

        template<int STEP> CorsIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CorsIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CorsIssueDetails> m_result;
    };

    static CorsIssueDetailsBuilder<0> create()
    {
        return CorsIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CorsIssueDetails();  // Defined below

    std::unique_ptr<protocol::Network::CorsErrorStatus> m_corsErrorStatus;
    bool m_isWarning;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
    std::optional<String> m_initiatorOrigin;
    std::optional<String> m_resourceIPAddressSpace;
    std::unique_ptr<protocol::Network::ClientSecurityState> m_clientSecurityState;
};


class CORE_EXPORT AttributionReportingIssueDetails : public ::crdtp::ProtocolObject<AttributionReportingIssueDetails> {
public:
    ~AttributionReportingIssueDetails() override;  // Defined below

    String getViolationType() { return m_violationType; }
    void setViolationType(const String& value);  // Defined below

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool hasViolatingNodeId() { return !!m_violatingNodeId; }
    int getViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void setViolatingNodeId(int value);  // Defined below

    bool hasInvalidParameter() { return !!m_invalidParameter; }
    String getInvalidParameter(const String& defaultValue) const {
       return m_invalidParameter.value_or(defaultValue);
    }
    const std::optional<String>& getInvalidParameter() const {
       return m_invalidParameter;
    }
    void setInvalidParameter(const String& value);  // Defined below

    template<int STATE>
    class AttributionReportingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ViolationTypeSet = 1 << 1,
            AllFieldsSet = (ViolationTypeSet | 0)};


        AttributionReportingIssueDetailsBuilder<STATE | ViolationTypeSet>& setViolationType(const String& value);  // Defined below

        AttributionReportingIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        AttributionReportingIssueDetailsBuilder<STATE>& setViolatingNodeId(int value);  // Defined below

        AttributionReportingIssueDetailsBuilder<STATE>& setInvalidParameter(const String& value);  // Defined below

        std::unique_ptr<AttributionReportingIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class AttributionReportingIssueDetails;
        AttributionReportingIssueDetailsBuilder() : m_result(new AttributionReportingIssueDetails()) { }

        template<int STEP> AttributionReportingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<AttributionReportingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_result;
    };

    static AttributionReportingIssueDetailsBuilder<0> create()
    {
        return AttributionReportingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    AttributionReportingIssueDetails();  // Defined below

    String m_violationType;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_invalidParameter;
};


class CORE_EXPORT QuirksModeIssueDetails : public ::crdtp::ProtocolObject<QuirksModeIssueDetails> {
public:
    ~QuirksModeIssueDetails() override;  // Defined below

    bool getIsLimitedQuirksMode() { return m_isLimitedQuirksMode; }
    void setIsLimitedQuirksMode(bool value);  // Defined below

    int getDocumentNodeId() { return m_documentNodeId; }
    void setDocumentNodeId(int value);  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    String getFrameId() { return m_frameId; }
    void setFrameId(const String& value);  // Defined below

    String getLoaderId() { return m_loaderId; }
    void setLoaderId(const String& value);  // Defined below

    template<int STATE>
    class QuirksModeIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            IsLimitedQuirksModeSet = 1 << 1,
            DocumentNodeIdSet = 1 << 2,
            UrlSet = 1 << 3,
            FrameIdSet = 1 << 4,
            LoaderIdSet = 1 << 5,
            AllFieldsSet = (IsLimitedQuirksModeSet | DocumentNodeIdSet | UrlSet | FrameIdSet | LoaderIdSet | 0)};


        QuirksModeIssueDetailsBuilder<STATE | IsLimitedQuirksModeSet>& setIsLimitedQuirksMode(bool value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | DocumentNodeIdSet>& setDocumentNodeId(int value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | FrameIdSet>& setFrameId(const String& value);  // Defined below

        QuirksModeIssueDetailsBuilder<STATE | LoaderIdSet>& setLoaderId(const String& value);  // Defined below

        std::unique_ptr<QuirksModeIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class QuirksModeIssueDetails;
        QuirksModeIssueDetailsBuilder() : m_result(new QuirksModeIssueDetails()) { }

        template<int STEP> QuirksModeIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<QuirksModeIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_result;
    };

    static QuirksModeIssueDetailsBuilder<0> create()
    {
        return QuirksModeIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    QuirksModeIssueDetails();  // Defined below

    bool m_isLimitedQuirksMode;
    int m_documentNodeId;
    String m_url;
    String m_frameId;
    String m_loaderId;
};


class CORE_EXPORT NavigatorUserAgentIssueDetails : public ::crdtp::ProtocolObject<NavigatorUserAgentIssueDetails> {
public:
    ~NavigatorUserAgentIssueDetails() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    bool hasLocation() { return !!m_location; }
    protocol::Audits::SourceCodeLocation* getLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_location ? m_location.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getLocation() const {
       return m_location;
    }
    void setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    template<int STATE>
    class NavigatorUserAgentIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            AllFieldsSet = (UrlSet | 0)};


        NavigatorUserAgentIssueDetailsBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        NavigatorUserAgentIssueDetailsBuilder<STATE>& setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        std::unique_ptr<NavigatorUserAgentIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class NavigatorUserAgentIssueDetails;
        NavigatorUserAgentIssueDetailsBuilder() : m_result(new NavigatorUserAgentIssueDetails()) { }

        template<int STEP> NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<NavigatorUserAgentIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_result;
    };

    static NavigatorUserAgentIssueDetailsBuilder<0> create()
    {
        return NavigatorUserAgentIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    NavigatorUserAgentIssueDetails();  // Defined below

    String m_url;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_location;
};


class CORE_EXPORT SharedDictionaryIssueDetails : public ::crdtp::ProtocolObject<SharedDictionaryIssueDetails> {
public:
    ~SharedDictionaryIssueDetails() override;  // Defined below

    String getSharedDictionaryError() { return m_sharedDictionaryError; }
    void setSharedDictionaryError(const String& value);  // Defined below

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class SharedDictionaryIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SharedDictionaryErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (SharedDictionaryErrorSet | RequestSet | 0)};


        SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryErrorSet>& setSharedDictionaryError(const String& value);  // Defined below

        SharedDictionaryIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<SharedDictionaryIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SharedDictionaryIssueDetails;
        SharedDictionaryIssueDetailsBuilder() : m_result(new SharedDictionaryIssueDetails()) { }

        template<int STEP> SharedDictionaryIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SharedDictionaryIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_result;
    };

    static SharedDictionaryIssueDetailsBuilder<0> create()
    {
        return SharedDictionaryIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SharedDictionaryIssueDetails();  // Defined below

    String m_sharedDictionaryError;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT SRIMessageSignatureIssueDetails : public ::crdtp::ProtocolObject<SRIMessageSignatureIssueDetails> {
public:
    ~SRIMessageSignatureIssueDetails() override;  // Defined below

    String getError() { return m_error; }
    void setError(const String& value);  // Defined below

    String getSignatureBase() { return m_signatureBase; }
    void setSignatureBase(const String& value);  // Defined below

    protocol::Array<String>* getIntegrityAssertions() { return m_integrityAssertions.get(); }
    void setIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class SRIMessageSignatureIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorSet = 1 << 1,
            SignatureBaseSet = 1 << 2,
            IntegrityAssertionsSet = 1 << 3,
            RequestSet = 1 << 4,
            AllFieldsSet = (ErrorSet | SignatureBaseSet | IntegrityAssertionsSet | RequestSet | 0)};


        SRIMessageSignatureIssueDetailsBuilder<STATE | ErrorSet>& setError(const String& value);  // Defined below

        SRIMessageSignatureIssueDetailsBuilder<STATE | SignatureBaseSet>& setSignatureBase(const String& value);  // Defined below

        SRIMessageSignatureIssueDetailsBuilder<STATE | IntegrityAssertionsSet>& setIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        SRIMessageSignatureIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<SRIMessageSignatureIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SRIMessageSignatureIssueDetails;
        SRIMessageSignatureIssueDetailsBuilder() : m_result(new SRIMessageSignatureIssueDetails()) { }

        template<int STEP> SRIMessageSignatureIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SRIMessageSignatureIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> m_result;
    };

    static SRIMessageSignatureIssueDetailsBuilder<0> create()
    {
        return SRIMessageSignatureIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SRIMessageSignatureIssueDetails();  // Defined below

    String m_error;
    String m_signatureBase;
    std::unique_ptr<protocol::Array<String>> m_integrityAssertions;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT UnencodedDigestIssueDetails : public ::crdtp::ProtocolObject<UnencodedDigestIssueDetails> {
public:
    ~UnencodedDigestIssueDetails() override;  // Defined below

    String getError() { return m_error; }
    void setError(const String& value);  // Defined below

    protocol::Audits::AffectedRequest* getRequest() { return m_request.get(); }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class UnencodedDigestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorSet = 1 << 1,
            RequestSet = 1 << 2,
            AllFieldsSet = (ErrorSet | RequestSet | 0)};


        UnencodedDigestIssueDetailsBuilder<STATE | ErrorSet>& setError(const String& value);  // Defined below

        UnencodedDigestIssueDetailsBuilder<STATE | RequestSet>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<UnencodedDigestIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UnencodedDigestIssueDetails;
        UnencodedDigestIssueDetailsBuilder() : m_result(new UnencodedDigestIssueDetails()) { }

        template<int STEP> UnencodedDigestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UnencodedDigestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> m_result;
    };

    static UnencodedDigestIssueDetailsBuilder<0> create()
    {
        return UnencodedDigestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UnencodedDigestIssueDetails();  // Defined below

    String m_error;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT GenericIssueDetails : public ::crdtp::ProtocolObject<GenericIssueDetails> {
public:
    ~GenericIssueDetails() override;  // Defined below

    String getErrorType() { return m_errorType; }
    void setErrorType(const String& value);  // Defined below

    bool hasFrameId() { return !!m_frameId; }
    String getFrameId(const String& defaultValue) const {
       return m_frameId.value_or(defaultValue);
    }
    const std::optional<String>& getFrameId() const {
       return m_frameId;
    }
    void setFrameId(const String& value);  // Defined below

    bool hasViolatingNodeId() { return !!m_violatingNodeId; }
    int getViolatingNodeId(int defaultValue) const {
       return m_violatingNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getViolatingNodeId() const {
       return m_violatingNodeId;
    }
    void setViolatingNodeId(int value);  // Defined below

    bool hasViolatingNodeAttribute() { return !!m_violatingNodeAttribute; }
    String getViolatingNodeAttribute(const String& defaultValue) const {
       return m_violatingNodeAttribute.value_or(defaultValue);
    }
    const std::optional<String>& getViolatingNodeAttribute() const {
       return m_violatingNodeAttribute;
    }
    void setViolatingNodeAttribute(const String& value);  // Defined below

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    template<int STATE>
    class GenericIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ErrorTypeSet = 1 << 1,
            AllFieldsSet = (ErrorTypeSet | 0)};


        GenericIssueDetailsBuilder<STATE | ErrorTypeSet>& setErrorType(const String& value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& setFrameId(const String& value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& setViolatingNodeId(int value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& setViolatingNodeAttribute(const String& value);  // Defined below

        GenericIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        std::unique_ptr<GenericIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class GenericIssueDetails;
        GenericIssueDetailsBuilder() : m_result(new GenericIssueDetails()) { }

        template<int STEP> GenericIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<GenericIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::GenericIssueDetails> m_result;
    };

    static GenericIssueDetailsBuilder<0> create()
    {
        return GenericIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    GenericIssueDetails();  // Defined below

    String m_errorType;
    std::optional<String> m_frameId;
    std::optional<int> m_violatingNodeId;
    std::optional<String> m_violatingNodeAttribute;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
};


class CORE_EXPORT DeprecationIssueDetails : public ::crdtp::ProtocolObject<DeprecationIssueDetails> {
public:
    ~DeprecationIssueDetails() override;  // Defined below

    bool hasAffectedFrame() { return !!m_affectedFrame; }
    protocol::Audits::AffectedFrame* getAffectedFrame(protocol::Audits::AffectedFrame* defaultValue) {
       return m_affectedFrame ? m_affectedFrame.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedFrame>& getAffectedFrame() const {
       return m_affectedFrame;
    }
    void setAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    template<int STATE>
    class DeprecationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | TypeSet | 0)};


        DeprecationIssueDetailsBuilder<STATE>& setAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value);  // Defined below

        DeprecationIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        DeprecationIssueDetailsBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        std::unique_ptr<DeprecationIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DeprecationIssueDetails;
        DeprecationIssueDetailsBuilder() : m_result(new DeprecationIssueDetails()) { }

        template<int STEP> DeprecationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DeprecationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_result;
    };

    static DeprecationIssueDetailsBuilder<0> create()
    {
        return DeprecationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DeprecationIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::AffectedFrame> m_affectedFrame;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_type;
};


class CORE_EXPORT BounceTrackingIssueDetails : public ::crdtp::ProtocolObject<BounceTrackingIssueDetails> {
public:
    ~BounceTrackingIssueDetails() override;  // Defined below

    protocol::Array<String>* getTrackingSites() { return m_trackingSites.get(); }
    void setTrackingSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class BounceTrackingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TrackingSitesSet = 1 << 1,
            AllFieldsSet = (TrackingSitesSet | 0)};


        BounceTrackingIssueDetailsBuilder<STATE | TrackingSitesSet>& setTrackingSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<BounceTrackingIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BounceTrackingIssueDetails;
        BounceTrackingIssueDetailsBuilder() : m_result(new BounceTrackingIssueDetails()) { }

        template<int STEP> BounceTrackingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BounceTrackingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_result;
    };

    static BounceTrackingIssueDetailsBuilder<0> create()
    {
        return BounceTrackingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BounceTrackingIssueDetails();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_trackingSites;
};


class CORE_EXPORT CookieDeprecationMetadataIssueDetails : public ::crdtp::ProtocolObject<CookieDeprecationMetadataIssueDetails> {
public:
    ~CookieDeprecationMetadataIssueDetails() override;  // Defined below

    protocol::Array<String>* getAllowedSites() { return m_allowedSites.get(); }
    void setAllowedSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    double getOptOutPercentage() { return m_optOutPercentage; }
    void setOptOutPercentage(double value);  // Defined below

    bool getIsOptOutTopLevel() { return m_isOptOutTopLevel; }
    void setIsOptOutTopLevel(bool value);  // Defined below

    String getOperation() { return m_operation; }
    void setOperation(const String& value);  // Defined below

    template<int STATE>
    class CookieDeprecationMetadataIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllowedSitesSet = 1 << 1,
            OptOutPercentageSet = 1 << 2,
            IsOptOutTopLevelSet = 1 << 3,
            OperationSet = 1 << 4,
            AllFieldsSet = (AllowedSitesSet | OptOutPercentageSet | IsOptOutTopLevelSet | OperationSet | 0)};


        CookieDeprecationMetadataIssueDetailsBuilder<STATE | AllowedSitesSet>& setAllowedSites(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OptOutPercentageSet>& setOptOutPercentage(double value);  // Defined below

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | IsOptOutTopLevelSet>& setIsOptOutTopLevel(bool value);  // Defined below

        CookieDeprecationMetadataIssueDetailsBuilder<STATE | OperationSet>& setOperation(const String& value);  // Defined below

        std::unique_ptr<CookieDeprecationMetadataIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CookieDeprecationMetadataIssueDetails;
        CookieDeprecationMetadataIssueDetailsBuilder() : m_result(new CookieDeprecationMetadataIssueDetails()) { }

        template<int STEP> CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CookieDeprecationMetadataIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_result;
    };

    static CookieDeprecationMetadataIssueDetailsBuilder<0> create()
    {
        return CookieDeprecationMetadataIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CookieDeprecationMetadataIssueDetails();  // Defined below

    std::unique_ptr<protocol::Array<String>> m_allowedSites;
    double m_optOutPercentage;
    bool m_isOptOutTopLevel;
    String m_operation;
};


class CORE_EXPORT FederatedAuthRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthRequestIssueDetails> {
public:
    ~FederatedAuthRequestIssueDetails() override;  // Defined below

    String getFederatedAuthRequestIssueReason() { return m_federatedAuthRequestIssueReason; }
    void setFederatedAuthRequestIssueReason(const String& value);  // Defined below

    template<int STATE>
    class FederatedAuthRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthRequestIssueReasonSet | 0)};


        FederatedAuthRequestIssueDetailsBuilder<STATE | FederatedAuthRequestIssueReasonSet>& setFederatedAuthRequestIssueReason(const String& value);  // Defined below

        std::unique_ptr<FederatedAuthRequestIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthRequestIssueDetails;
        FederatedAuthRequestIssueDetailsBuilder() : m_result(new FederatedAuthRequestIssueDetails()) { }

        template<int STEP> FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_result;
    };

    static FederatedAuthRequestIssueDetailsBuilder<0> create()
    {
        return FederatedAuthRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthRequestIssueDetails();  // Defined below

    String m_federatedAuthRequestIssueReason;
};


class CORE_EXPORT FederatedAuthUserInfoRequestIssueDetails : public ::crdtp::ProtocolObject<FederatedAuthUserInfoRequestIssueDetails> {
public:
    ~FederatedAuthUserInfoRequestIssueDetails() override;  // Defined below

    String getFederatedAuthUserInfoRequestIssueReason() { return m_federatedAuthUserInfoRequestIssueReason; }
    void setFederatedAuthUserInfoRequestIssueReason(const String& value);  // Defined below

    template<int STATE>
    class FederatedAuthUserInfoRequestIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            FederatedAuthUserInfoRequestIssueReasonSet = 1 << 1,
            AllFieldsSet = (FederatedAuthUserInfoRequestIssueReasonSet | 0)};


        FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | FederatedAuthUserInfoRequestIssueReasonSet>& setFederatedAuthUserInfoRequestIssueReason(const String& value);  // Defined below

        std::unique_ptr<FederatedAuthUserInfoRequestIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FederatedAuthUserInfoRequestIssueDetails;
        FederatedAuthUserInfoRequestIssueDetailsBuilder() : m_result(new FederatedAuthUserInfoRequestIssueDetails()) { }

        template<int STEP> FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_result;
    };

    static FederatedAuthUserInfoRequestIssueDetailsBuilder<0> create()
    {
        return FederatedAuthUserInfoRequestIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FederatedAuthUserInfoRequestIssueDetails();  // Defined below

    String m_federatedAuthUserInfoRequestIssueReason;
};


class CORE_EXPORT ClientHintIssueDetails : public ::crdtp::ProtocolObject<ClientHintIssueDetails> {
public:
    ~ClientHintIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String getClientHintIssueReason() { return m_clientHintIssueReason; }
    void setClientHintIssueReason(const String& value);  // Defined below

    template<int STATE>
    class ClientHintIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            ClientHintIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | ClientHintIssueReasonSet | 0)};


        ClientHintIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        ClientHintIssueDetailsBuilder<STATE | ClientHintIssueReasonSet>& setClientHintIssueReason(const String& value);  // Defined below

        std::unique_ptr<ClientHintIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ClientHintIssueDetails;
        ClientHintIssueDetailsBuilder() : m_result(new ClientHintIssueDetails()) { }

        template<int STEP> ClientHintIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ClientHintIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_result;
    };

    static ClientHintIssueDetailsBuilder<0> create()
    {
        return ClientHintIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ClientHintIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_clientHintIssueReason;
};


class CORE_EXPORT FailedRequestInfo : public ::crdtp::ProtocolObject<FailedRequestInfo> {
public:
    ~FailedRequestInfo() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    String getFailureMessage() { return m_failureMessage; }
    void setFailureMessage(const String& value);  // Defined below

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value);  // Defined below

    template<int STATE>
    class FailedRequestInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            FailureMessageSet = 1 << 2,
            AllFieldsSet = (UrlSet | FailureMessageSet | 0)};


        FailedRequestInfoBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        FailedRequestInfoBuilder<STATE | FailureMessageSet>& setFailureMessage(const String& value);  // Defined below

        FailedRequestInfoBuilder<STATE>& setRequestId(const String& value);  // Defined below

        std::unique_ptr<FailedRequestInfo> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FailedRequestInfo;
        FailedRequestInfoBuilder() : m_result(new FailedRequestInfo()) { }

        template<int STEP> FailedRequestInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FailedRequestInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::FailedRequestInfo> m_result;
    };

    static FailedRequestInfoBuilder<0> create()
    {
        return FailedRequestInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FailedRequestInfo();  // Defined below

    String m_url;
    String m_failureMessage;
    std::optional<String> m_requestId;
};


class CORE_EXPORT PartitioningBlobURLIssueDetails : public ::crdtp::ProtocolObject<PartitioningBlobURLIssueDetails> {
public:
    ~PartitioningBlobURLIssueDetails() override;  // Defined below

    String getUrl() { return m_url; }
    void setUrl(const String& value);  // Defined below

    String getPartitioningBlobURLInfo() { return m_partitioningBlobURLInfo; }
    void setPartitioningBlobURLInfo(const String& value);  // Defined below

    template<int STATE>
    class PartitioningBlobURLIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            PartitioningBlobURLInfoSet = 1 << 2,
            AllFieldsSet = (UrlSet | PartitioningBlobURLInfoSet | 0)};


        PartitioningBlobURLIssueDetailsBuilder<STATE | UrlSet>& setUrl(const String& value);  // Defined below

        PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLInfoSet>& setPartitioningBlobURLInfo(const String& value);  // Defined below

        std::unique_ptr<PartitioningBlobURLIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PartitioningBlobURLIssueDetails;
        PartitioningBlobURLIssueDetailsBuilder() : m_result(new PartitioningBlobURLIssueDetails()) { }

        template<int STEP> PartitioningBlobURLIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PartitioningBlobURLIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> m_result;
    };

    static PartitioningBlobURLIssueDetailsBuilder<0> create()
    {
        return PartitioningBlobURLIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PartitioningBlobURLIssueDetails();  // Defined below

    String m_url;
    String m_partitioningBlobURLInfo;
};


class CORE_EXPORT ElementAccessibilityIssueDetails : public ::crdtp::ProtocolObject<ElementAccessibilityIssueDetails> {
public:
    ~ElementAccessibilityIssueDetails() override;  // Defined below

    int getNodeId() { return m_nodeId; }
    void setNodeId(int value);  // Defined below

    String getElementAccessibilityIssueReason() { return m_elementAccessibilityIssueReason; }
    void setElementAccessibilityIssueReason(const String& value);  // Defined below

    bool getHasDisallowedAttributes() { return m_hasDisallowedAttributes; }
    void setHasDisallowedAttributes(bool value);  // Defined below

    template<int STATE>
    class ElementAccessibilityIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NodeIdSet = 1 << 1,
            ElementAccessibilityIssueReasonSet = 1 << 2,
            HasDisallowedAttributesSet = 1 << 3,
            AllFieldsSet = (NodeIdSet | ElementAccessibilityIssueReasonSet | HasDisallowedAttributesSet | 0)};


        ElementAccessibilityIssueDetailsBuilder<STATE | NodeIdSet>& setNodeId(int value);  // Defined below

        ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueReasonSet>& setElementAccessibilityIssueReason(const String& value);  // Defined below

        ElementAccessibilityIssueDetailsBuilder<STATE | HasDisallowedAttributesSet>& setHasDisallowedAttributes(bool value);  // Defined below

        std::unique_ptr<ElementAccessibilityIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ElementAccessibilityIssueDetails;
        ElementAccessibilityIssueDetailsBuilder() : m_result(new ElementAccessibilityIssueDetails()) { }

        template<int STEP> ElementAccessibilityIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ElementAccessibilityIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> m_result;
    };

    static ElementAccessibilityIssueDetailsBuilder<0> create()
    {
        return ElementAccessibilityIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ElementAccessibilityIssueDetails();  // Defined below

    int m_nodeId;
    String m_elementAccessibilityIssueReason;
    bool m_hasDisallowedAttributes;
};


class CORE_EXPORT StylesheetLoadingIssueDetails : public ::crdtp::ProtocolObject<StylesheetLoadingIssueDetails> {
public:
    ~StylesheetLoadingIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String getStyleSheetLoadingIssueReason() { return m_styleSheetLoadingIssueReason; }
    void setStyleSheetLoadingIssueReason(const String& value);  // Defined below

    bool hasFailedRequestInfo() { return !!m_failedRequestInfo; }
    protocol::Audits::FailedRequestInfo* getFailedRequestInfo(protocol::Audits::FailedRequestInfo* defaultValue) {
       return m_failedRequestInfo ? m_failedRequestInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FailedRequestInfo>& getFailedRequestInfo() const {
       return m_failedRequestInfo;
    }
    void setFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value);  // Defined below

    template<int STATE>
    class StylesheetLoadingIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            StyleSheetLoadingIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | StyleSheetLoadingIssueReasonSet | 0)};


        StylesheetLoadingIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        StylesheetLoadingIssueDetailsBuilder<STATE | StyleSheetLoadingIssueReasonSet>& setStyleSheetLoadingIssueReason(const String& value);  // Defined below

        StylesheetLoadingIssueDetailsBuilder<STATE>& setFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value);  // Defined below

        std::unique_ptr<StylesheetLoadingIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StylesheetLoadingIssueDetails;
        StylesheetLoadingIssueDetailsBuilder() : m_result(new StylesheetLoadingIssueDetails()) { }

        template<int STEP> StylesheetLoadingIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StylesheetLoadingIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_result;
    };

    static StylesheetLoadingIssueDetailsBuilder<0> create()
    {
        return StylesheetLoadingIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StylesheetLoadingIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_styleSheetLoadingIssueReason;
    std::unique_ptr<protocol::Audits::FailedRequestInfo> m_failedRequestInfo;
};


class CORE_EXPORT PropertyRuleIssueDetails : public ::crdtp::ProtocolObject<PropertyRuleIssueDetails> {
public:
    ~PropertyRuleIssueDetails() override;  // Defined below

    protocol::Audits::SourceCodeLocation* getSourceCodeLocation() { return m_sourceCodeLocation.get(); }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    String getPropertyRuleIssueReason() { return m_propertyRuleIssueReason; }
    void setPropertyRuleIssueReason(const String& value);  // Defined below

    bool hasPropertyValue() { return !!m_propertyValue; }
    String getPropertyValue(const String& defaultValue) const {
       return m_propertyValue.value_or(defaultValue);
    }
    const std::optional<String>& getPropertyValue() const {
       return m_propertyValue;
    }
    void setPropertyValue(const String& value);  // Defined below

    template<int STATE>
    class PropertyRuleIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SourceCodeLocationSet = 1 << 1,
            PropertyRuleIssueReasonSet = 1 << 2,
            AllFieldsSet = (SourceCodeLocationSet | PropertyRuleIssueReasonSet | 0)};


        PropertyRuleIssueDetailsBuilder<STATE | SourceCodeLocationSet>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueReasonSet>& setPropertyRuleIssueReason(const String& value);  // Defined below

        PropertyRuleIssueDetailsBuilder<STATE>& setPropertyValue(const String& value);  // Defined below

        std::unique_ptr<PropertyRuleIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PropertyRuleIssueDetails;
        PropertyRuleIssueDetailsBuilder() : m_result(new PropertyRuleIssueDetails()) { }

        template<int STEP> PropertyRuleIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PropertyRuleIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_result;
    };

    static PropertyRuleIssueDetailsBuilder<0> create()
    {
        return PropertyRuleIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PropertyRuleIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
    String m_propertyRuleIssueReason;
    std::optional<String> m_propertyValue;
};


class CORE_EXPORT UserReidentificationIssueDetails : public ::crdtp::ProtocolObject<UserReidentificationIssueDetails> {
public:
    ~UserReidentificationIssueDetails() override;  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool hasRequest() { return !!m_request; }
    protocol::Audits::AffectedRequest* getRequest(protocol::Audits::AffectedRequest* defaultValue) {
       return m_request ? m_request.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AffectedRequest>& getRequest() const {
       return m_request;
    }
    void setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

    bool hasSourceCodeLocation() { return !!m_sourceCodeLocation; }
    protocol::Audits::SourceCodeLocation* getSourceCodeLocation(protocol::Audits::SourceCodeLocation* defaultValue) {
       return m_sourceCodeLocation ? m_sourceCodeLocation.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SourceCodeLocation>& getSourceCodeLocation() const {
       return m_sourceCodeLocation;
    }
    void setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

    template<int STATE>
    class UserReidentificationIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        UserReidentificationIssueDetailsBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        UserReidentificationIssueDetailsBuilder<STATE>& setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value);  // Defined below

        UserReidentificationIssueDetailsBuilder<STATE>& setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value);  // Defined below

        std::unique_ptr<UserReidentificationIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserReidentificationIssueDetails;
        UserReidentificationIssueDetailsBuilder() : m_result(new UserReidentificationIssueDetails()) { }

        template<int STEP> UserReidentificationIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserReidentificationIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> m_result;
    };

    static UserReidentificationIssueDetailsBuilder<0> create()
    {
        return UserReidentificationIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserReidentificationIssueDetails();  // Defined below

    String m_type;
    std::unique_ptr<protocol::Audits::AffectedRequest> m_request;
    std::unique_ptr<protocol::Audits::SourceCodeLocation> m_sourceCodeLocation;
};


class CORE_EXPORT InspectorIssueDetails : public ::crdtp::ProtocolObject<InspectorIssueDetails> {
public:
    ~InspectorIssueDetails() override;  // Defined below

    bool hasCookieIssueDetails() { return !!m_cookieIssueDetails; }
    protocol::Audits::CookieIssueDetails* getCookieIssueDetails(protocol::Audits::CookieIssueDetails* defaultValue) {
       return m_cookieIssueDetails ? m_cookieIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieIssueDetails>& getCookieIssueDetails() const {
       return m_cookieIssueDetails;
    }
    void setCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value);  // Defined below

    bool hasMixedContentIssueDetails() { return !!m_mixedContentIssueDetails; }
    protocol::Audits::MixedContentIssueDetails* getMixedContentIssueDetails(protocol::Audits::MixedContentIssueDetails* defaultValue) {
       return m_mixedContentIssueDetails ? m_mixedContentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::MixedContentIssueDetails>& getMixedContentIssueDetails() const {
       return m_mixedContentIssueDetails;
    }
    void setMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value);  // Defined below

    bool hasBlockedByResponseIssueDetails() { return !!m_blockedByResponseIssueDetails; }
    protocol::Audits::BlockedByResponseIssueDetails* getBlockedByResponseIssueDetails(protocol::Audits::BlockedByResponseIssueDetails* defaultValue) {
       return m_blockedByResponseIssueDetails ? m_blockedByResponseIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails>& getBlockedByResponseIssueDetails() const {
       return m_blockedByResponseIssueDetails;
    }
    void setBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value);  // Defined below

    bool hasHeavyAdIssueDetails() { return !!m_heavyAdIssueDetails; }
    protocol::Audits::HeavyAdIssueDetails* getHeavyAdIssueDetails(protocol::Audits::HeavyAdIssueDetails* defaultValue) {
       return m_heavyAdIssueDetails ? m_heavyAdIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::HeavyAdIssueDetails>& getHeavyAdIssueDetails() const {
       return m_heavyAdIssueDetails;
    }
    void setHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value);  // Defined below

    bool hasContentSecurityPolicyIssueDetails() { return !!m_contentSecurityPolicyIssueDetails; }
    protocol::Audits::ContentSecurityPolicyIssueDetails* getContentSecurityPolicyIssueDetails(protocol::Audits::ContentSecurityPolicyIssueDetails* defaultValue) {
       return m_contentSecurityPolicyIssueDetails ? m_contentSecurityPolicyIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails>& getContentSecurityPolicyIssueDetails() const {
       return m_contentSecurityPolicyIssueDetails;
    }
    void setContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value);  // Defined below

    bool hasSharedArrayBufferIssueDetails() { return !!m_sharedArrayBufferIssueDetails; }
    protocol::Audits::SharedArrayBufferIssueDetails* getSharedArrayBufferIssueDetails(protocol::Audits::SharedArrayBufferIssueDetails* defaultValue) {
       return m_sharedArrayBufferIssueDetails ? m_sharedArrayBufferIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails>& getSharedArrayBufferIssueDetails() const {
       return m_sharedArrayBufferIssueDetails;
    }
    void setSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value);  // Defined below

    bool hasLowTextContrastIssueDetails() { return !!m_lowTextContrastIssueDetails; }
    protocol::Audits::LowTextContrastIssueDetails* getLowTextContrastIssueDetails(protocol::Audits::LowTextContrastIssueDetails* defaultValue) {
       return m_lowTextContrastIssueDetails ? m_lowTextContrastIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails>& getLowTextContrastIssueDetails() const {
       return m_lowTextContrastIssueDetails;
    }
    void setLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value);  // Defined below

    bool hasCorsIssueDetails() { return !!m_corsIssueDetails; }
    protocol::Audits::CorsIssueDetails* getCorsIssueDetails(protocol::Audits::CorsIssueDetails* defaultValue) {
       return m_corsIssueDetails ? m_corsIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CorsIssueDetails>& getCorsIssueDetails() const {
       return m_corsIssueDetails;
    }
    void setCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value);  // Defined below

    bool hasAttributionReportingIssueDetails() { return !!m_attributionReportingIssueDetails; }
    protocol::Audits::AttributionReportingIssueDetails* getAttributionReportingIssueDetails(protocol::Audits::AttributionReportingIssueDetails* defaultValue) {
       return m_attributionReportingIssueDetails ? m_attributionReportingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails>& getAttributionReportingIssueDetails() const {
       return m_attributionReportingIssueDetails;
    }
    void setAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value);  // Defined below

    bool hasQuirksModeIssueDetails() { return !!m_quirksModeIssueDetails; }
    protocol::Audits::QuirksModeIssueDetails* getQuirksModeIssueDetails(protocol::Audits::QuirksModeIssueDetails* defaultValue) {
       return m_quirksModeIssueDetails ? m_quirksModeIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::QuirksModeIssueDetails>& getQuirksModeIssueDetails() const {
       return m_quirksModeIssueDetails;
    }
    void setQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value);  // Defined below

    bool hasPartitioningBlobURLIssueDetails() { return !!m_partitioningBlobURLIssueDetails; }
    protocol::Audits::PartitioningBlobURLIssueDetails* getPartitioningBlobURLIssueDetails(protocol::Audits::PartitioningBlobURLIssueDetails* defaultValue) {
       return m_partitioningBlobURLIssueDetails ? m_partitioningBlobURLIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails>& getPartitioningBlobURLIssueDetails() const {
       return m_partitioningBlobURLIssueDetails;
    }
    void setPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value);  // Defined below

    bool hasNavigatorUserAgentIssueDetails() { return !!m_navigatorUserAgentIssueDetails; }
    protocol::Audits::NavigatorUserAgentIssueDetails* getNavigatorUserAgentIssueDetails(protocol::Audits::NavigatorUserAgentIssueDetails* defaultValue) {
       return m_navigatorUserAgentIssueDetails ? m_navigatorUserAgentIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails>& getNavigatorUserAgentIssueDetails() const {
       return m_navigatorUserAgentIssueDetails;
    }
    void setNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value);  // Defined below

    bool hasGenericIssueDetails() { return !!m_genericIssueDetails; }
    protocol::Audits::GenericIssueDetails* getGenericIssueDetails(protocol::Audits::GenericIssueDetails* defaultValue) {
       return m_genericIssueDetails ? m_genericIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::GenericIssueDetails>& getGenericIssueDetails() const {
       return m_genericIssueDetails;
    }
    void setGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value);  // Defined below

    bool hasDeprecationIssueDetails() { return !!m_deprecationIssueDetails; }
    protocol::Audits::DeprecationIssueDetails* getDeprecationIssueDetails(protocol::Audits::DeprecationIssueDetails* defaultValue) {
       return m_deprecationIssueDetails ? m_deprecationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::DeprecationIssueDetails>& getDeprecationIssueDetails() const {
       return m_deprecationIssueDetails;
    }
    void setDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value);  // Defined below

    bool hasClientHintIssueDetails() { return !!m_clientHintIssueDetails; }
    protocol::Audits::ClientHintIssueDetails* getClientHintIssueDetails(protocol::Audits::ClientHintIssueDetails* defaultValue) {
       return m_clientHintIssueDetails ? m_clientHintIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ClientHintIssueDetails>& getClientHintIssueDetails() const {
       return m_clientHintIssueDetails;
    }
    void setClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value);  // Defined below

    bool hasFederatedAuthRequestIssueDetails() { return !!m_federatedAuthRequestIssueDetails; }
    protocol::Audits::FederatedAuthRequestIssueDetails* getFederatedAuthRequestIssueDetails(protocol::Audits::FederatedAuthRequestIssueDetails* defaultValue) {
       return m_federatedAuthRequestIssueDetails ? m_federatedAuthRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails>& getFederatedAuthRequestIssueDetails() const {
       return m_federatedAuthRequestIssueDetails;
    }
    void setFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value);  // Defined below

    bool hasBounceTrackingIssueDetails() { return !!m_bounceTrackingIssueDetails; }
    protocol::Audits::BounceTrackingIssueDetails* getBounceTrackingIssueDetails(protocol::Audits::BounceTrackingIssueDetails* defaultValue) {
       return m_bounceTrackingIssueDetails ? m_bounceTrackingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails>& getBounceTrackingIssueDetails() const {
       return m_bounceTrackingIssueDetails;
    }
    void setBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value);  // Defined below

    bool hasCookieDeprecationMetadataIssueDetails() { return !!m_cookieDeprecationMetadataIssueDetails; }
    protocol::Audits::CookieDeprecationMetadataIssueDetails* getCookieDeprecationMetadataIssueDetails(protocol::Audits::CookieDeprecationMetadataIssueDetails* defaultValue) {
       return m_cookieDeprecationMetadataIssueDetails ? m_cookieDeprecationMetadataIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails>& getCookieDeprecationMetadataIssueDetails() const {
       return m_cookieDeprecationMetadataIssueDetails;
    }
    void setCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value);  // Defined below

    bool hasStylesheetLoadingIssueDetails() { return !!m_stylesheetLoadingIssueDetails; }
    protocol::Audits::StylesheetLoadingIssueDetails* getStylesheetLoadingIssueDetails(protocol::Audits::StylesheetLoadingIssueDetails* defaultValue) {
       return m_stylesheetLoadingIssueDetails ? m_stylesheetLoadingIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails>& getStylesheetLoadingIssueDetails() const {
       return m_stylesheetLoadingIssueDetails;
    }
    void setStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value);  // Defined below

    bool hasPropertyRuleIssueDetails() { return !!m_propertyRuleIssueDetails; }
    protocol::Audits::PropertyRuleIssueDetails* getPropertyRuleIssueDetails(protocol::Audits::PropertyRuleIssueDetails* defaultValue) {
       return m_propertyRuleIssueDetails ? m_propertyRuleIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails>& getPropertyRuleIssueDetails() const {
       return m_propertyRuleIssueDetails;
    }
    void setPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value);  // Defined below

    bool hasFederatedAuthUserInfoRequestIssueDetails() { return !!m_federatedAuthUserInfoRequestIssueDetails; }
    protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* getFederatedAuthUserInfoRequestIssueDetails(protocol::Audits::FederatedAuthUserInfoRequestIssueDetails* defaultValue) {
       return m_federatedAuthUserInfoRequestIssueDetails ? m_federatedAuthUserInfoRequestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails>& getFederatedAuthUserInfoRequestIssueDetails() const {
       return m_federatedAuthUserInfoRequestIssueDetails;
    }
    void setFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value);  // Defined below

    bool hasSharedDictionaryIssueDetails() { return !!m_sharedDictionaryIssueDetails; }
    protocol::Audits::SharedDictionaryIssueDetails* getSharedDictionaryIssueDetails(protocol::Audits::SharedDictionaryIssueDetails* defaultValue) {
       return m_sharedDictionaryIssueDetails ? m_sharedDictionaryIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails>& getSharedDictionaryIssueDetails() const {
       return m_sharedDictionaryIssueDetails;
    }
    void setSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value);  // Defined below

    bool hasElementAccessibilityIssueDetails() { return !!m_elementAccessibilityIssueDetails; }
    protocol::Audits::ElementAccessibilityIssueDetails* getElementAccessibilityIssueDetails(protocol::Audits::ElementAccessibilityIssueDetails* defaultValue) {
       return m_elementAccessibilityIssueDetails ? m_elementAccessibilityIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails>& getElementAccessibilityIssueDetails() const {
       return m_elementAccessibilityIssueDetails;
    }
    void setElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value);  // Defined below

    bool hasSriMessageSignatureIssueDetails() { return !!m_sriMessageSignatureIssueDetails; }
    protocol::Audits::SRIMessageSignatureIssueDetails* getSriMessageSignatureIssueDetails(protocol::Audits::SRIMessageSignatureIssueDetails* defaultValue) {
       return m_sriMessageSignatureIssueDetails ? m_sriMessageSignatureIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails>& getSriMessageSignatureIssueDetails() const {
       return m_sriMessageSignatureIssueDetails;
    }
    void setSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value);  // Defined below

    bool hasUnencodedDigestIssueDetails() { return !!m_unencodedDigestIssueDetails; }
    protocol::Audits::UnencodedDigestIssueDetails* getUnencodedDigestIssueDetails(protocol::Audits::UnencodedDigestIssueDetails* defaultValue) {
       return m_unencodedDigestIssueDetails ? m_unencodedDigestIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails>& getUnencodedDigestIssueDetails() const {
       return m_unencodedDigestIssueDetails;
    }
    void setUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value);  // Defined below

    bool hasUserReidentificationIssueDetails() { return !!m_userReidentificationIssueDetails; }
    protocol::Audits::UserReidentificationIssueDetails* getUserReidentificationIssueDetails(protocol::Audits::UserReidentificationIssueDetails* defaultValue) {
       return m_userReidentificationIssueDetails ? m_userReidentificationIssueDetails.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails>& getUserReidentificationIssueDetails() const {
       return m_userReidentificationIssueDetails;
    }
    void setUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value);  // Defined below

    template<int STATE>
    class InspectorIssueDetailsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        InspectorIssueDetailsBuilder<STATE>& setCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value);  // Defined below

        InspectorIssueDetailsBuilder<STATE>& setUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value);  // Defined below

        std::unique_ptr<InspectorIssueDetails> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssueDetails;
        InspectorIssueDetailsBuilder() : m_result(new InspectorIssueDetails()) { }

        template<int STEP> InspectorIssueDetailsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueDetailsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_result;
    };

    static InspectorIssueDetailsBuilder<0> create()
    {
        return InspectorIssueDetailsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssueDetails();  // Defined below

    std::unique_ptr<protocol::Audits::CookieIssueDetails> m_cookieIssueDetails;
    std::unique_ptr<protocol::Audits::MixedContentIssueDetails> m_mixedContentIssueDetails;
    std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> m_blockedByResponseIssueDetails;
    std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> m_heavyAdIssueDetails;
    std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> m_contentSecurityPolicyIssueDetails;
    std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> m_sharedArrayBufferIssueDetails;
    std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> m_lowTextContrastIssueDetails;
    std::unique_ptr<protocol::Audits::CorsIssueDetails> m_corsIssueDetails;
    std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> m_attributionReportingIssueDetails;
    std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> m_quirksModeIssueDetails;
    std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> m_partitioningBlobURLIssueDetails;
    std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> m_navigatorUserAgentIssueDetails;
    std::unique_ptr<protocol::Audits::GenericIssueDetails> m_genericIssueDetails;
    std::unique_ptr<protocol::Audits::DeprecationIssueDetails> m_deprecationIssueDetails;
    std::unique_ptr<protocol::Audits::ClientHintIssueDetails> m_clientHintIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> m_federatedAuthRequestIssueDetails;
    std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> m_bounceTrackingIssueDetails;
    std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> m_cookieDeprecationMetadataIssueDetails;
    std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> m_stylesheetLoadingIssueDetails;
    std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> m_propertyRuleIssueDetails;
    std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> m_federatedAuthUserInfoRequestIssueDetails;
    std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> m_sharedDictionaryIssueDetails;
    std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> m_elementAccessibilityIssueDetails;
    std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> m_sriMessageSignatureIssueDetails;
    std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> m_unencodedDigestIssueDetails;
    std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> m_userReidentificationIssueDetails;
};


class CORE_EXPORT InspectorIssue : public ::crdtp::ProtocolObject<InspectorIssue> {
public:
    ~InspectorIssue() override;  // Defined below

    String getCode() { return m_code; }
    void setCode(const String& value);  // Defined below

    protocol::Audits::InspectorIssueDetails* getDetails() { return m_details.get(); }
    void setDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value);  // Defined below

    bool hasIssueId() { return !!m_issueId; }
    String getIssueId(const String& defaultValue) const {
       return m_issueId.value_or(defaultValue);
    }
    const std::optional<String>& getIssueId() const {
       return m_issueId;
    }
    void setIssueId(const String& value);  // Defined below

    template<int STATE>
    class InspectorIssueBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            CodeSet = 1 << 1,
            DetailsSet = 1 << 2,
            AllFieldsSet = (CodeSet | DetailsSet | 0)};


        InspectorIssueBuilder<STATE | CodeSet>& setCode(const String& value);  // Defined below

        InspectorIssueBuilder<STATE | DetailsSet>& setDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value);  // Defined below

        InspectorIssueBuilder<STATE>& setIssueId(const String& value);  // Defined below

        std::unique_ptr<InspectorIssue> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class InspectorIssue;
        InspectorIssueBuilder() : m_result(new InspectorIssue()) { }

        template<int STEP> InspectorIssueBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InspectorIssueBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Audits::InspectorIssue> m_result;
    };

    static InspectorIssueBuilder<0> create()
    {
        return InspectorIssueBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    InspectorIssue();  // Defined below

    String m_code;
    std::unique_ptr<protocol::Audits::InspectorIssueDetails> m_details;
    std::optional<String> m_issueId;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline AffectedCookie::~AffectedCookie() = default;
inline void AffectedCookie::setName(const String& value) { m_name = value; }
inline void AffectedCookie::setPath(const String& value) { m_path = value; }
inline void AffectedCookie::setDomain(const String& value) { m_domain = value; }

template<int STATE>
inline AffectedCookie::AffectedCookieBuilder<STATE | AffectedCookie::AffectedCookieBuilder<STATE>::NameSet>&
AffectedCookie::AffectedCookieBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline AffectedCookie::AffectedCookieBuilder<STATE | AffectedCookie::AffectedCookieBuilder<STATE>::PathSet>&
AffectedCookie::AffectedCookieBuilder<STATE>::setPath(const String& value) {
  static_assert(!(STATE & PathSet), "property path should not be set yet");
  m_result->setPath(value);
  return castState<PathSet>();
}
template<int STATE>
inline AffectedCookie::AffectedCookieBuilder<STATE | AffectedCookie::AffectedCookieBuilder<STATE>::DomainSet>&
AffectedCookie::AffectedCookieBuilder<STATE>::setDomain(const String& value) {
  static_assert(!(STATE & DomainSet), "property domain should not be set yet");
  m_result->setDomain(value);
  return castState<DomainSet>();
}

inline AffectedCookie::AffectedCookie() {
}
inline AffectedRequest::~AffectedRequest() = default;
inline void AffectedRequest::setRequestId(const String& value) { m_requestId = value; }
inline void AffectedRequest::setUrl(const String& value) { m_url = value; }

template<int STATE>
inline AffectedRequest::AffectedRequestBuilder<STATE>& AffectedRequest::AffectedRequestBuilder<STATE>::setRequestId(const String& value) {
  m_result->setRequestId(value);
  return *this;
}
template<int STATE>
inline AffectedRequest::AffectedRequestBuilder<STATE | AffectedRequest::AffectedRequestBuilder<STATE>::UrlSet>&
AffectedRequest::AffectedRequestBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}

inline AffectedRequest::AffectedRequest() {
}
inline AffectedFrame::~AffectedFrame() = default;
inline void AffectedFrame::setFrameId(const String& value) { m_frameId = value; }

template<int STATE>
inline AffectedFrame::AffectedFrameBuilder<STATE | AffectedFrame::AffectedFrameBuilder<STATE>::FrameIdSet>&
AffectedFrame::AffectedFrameBuilder<STATE>::setFrameId(const String& value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->setFrameId(value);
  return castState<FrameIdSet>();
}

inline AffectedFrame::AffectedFrame() {
}
inline CookieIssueInsight::~CookieIssueInsight() = default;
inline void CookieIssueInsight::setType(const String& value) { m_type = value; }
inline void CookieIssueInsight::setTableEntryUrl(const String& value) { m_tableEntryUrl = value; }

template<int STATE>
inline CookieIssueInsight::CookieIssueInsightBuilder<STATE | CookieIssueInsight::CookieIssueInsightBuilder<STATE>::TypeSet>&
CookieIssueInsight::CookieIssueInsightBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline CookieIssueInsight::CookieIssueInsightBuilder<STATE>& CookieIssueInsight::CookieIssueInsightBuilder<STATE>::setTableEntryUrl(const String& value) {
  m_result->setTableEntryUrl(value);
  return *this;
}

inline CookieIssueInsight::CookieIssueInsight() {
}
inline CookieIssueDetails::~CookieIssueDetails() = default;
inline void CookieIssueDetails::setCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) { m_cookie = std::move(value); }
inline void CookieIssueDetails::setRawCookieLine(const String& value) { m_rawCookieLine = value; }
inline void CookieIssueDetails::setCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieWarningReasons = std::move(value); }
inline void CookieIssueDetails::setCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) { m_cookieExclusionReasons = std::move(value); }
inline void CookieIssueDetails::setOperation(const String& value) { m_operation = value; }
inline void CookieIssueDetails::setSiteForCookies(const String& value) { m_siteForCookies = value; }
inline void CookieIssueDetails::setCookieUrl(const String& value) { m_cookieUrl = value; }
inline void CookieIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void CookieIssueDetails::setInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value) { m_insight = std::move(value); }

template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setCookie(std::unique_ptr<protocol::Audits::AffectedCookie> value) {
  m_result->setCookie(std::move(value));
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setRawCookieLine(const String& value) {
  m_result->setRawCookieLine(value);
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE | CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::CookieWarningReasonsSet>&
CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setCookieWarningReasons(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CookieWarningReasonsSet), "property cookieWarningReasons should not be set yet");
  m_result->setCookieWarningReasons(std::move(value));
  return castState<CookieWarningReasonsSet>();
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE | CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::CookieExclusionReasonsSet>&
CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setCookieExclusionReasons(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CookieExclusionReasonsSet), "property cookieExclusionReasons should not be set yet");
  m_result->setCookieExclusionReasons(std::move(value));
  return castState<CookieExclusionReasonsSet>();
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE | CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::OperationSet>&
CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setOperation(const String& value) {
  static_assert(!(STATE & OperationSet), "property operation should not be set yet");
  m_result->setOperation(value);
  return castState<OperationSet>();
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setSiteForCookies(const String& value) {
  m_result->setSiteForCookies(value);
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setCookieUrl(const String& value) {
  m_result->setCookieUrl(value);
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->setRequest(std::move(value));
  return *this;
}
template<int STATE>
inline CookieIssueDetails::CookieIssueDetailsBuilder<STATE>& CookieIssueDetails::CookieIssueDetailsBuilder<STATE>::setInsight(std::unique_ptr<protocol::Audits::CookieIssueInsight> value) {
  m_result->setInsight(std::move(value));
  return *this;
}

inline CookieIssueDetails::CookieIssueDetails() {
}
inline MixedContentIssueDetails::~MixedContentIssueDetails() = default;
inline void MixedContentIssueDetails::setResourceType(const String& value) { m_resourceType = value; }
inline void MixedContentIssueDetails::setResolutionStatus(const String& value) { m_resolutionStatus = value; }
inline void MixedContentIssueDetails::setInsecureURL(const String& value) { m_insecureURL = value; }
inline void MixedContentIssueDetails::setMainResourceURL(const String& value) { m_mainResourceURL = value; }
inline void MixedContentIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void MixedContentIssueDetails::setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>& MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::setResourceType(const String& value) {
  m_result->setResourceType(value);
  return *this;
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE | MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::ResolutionStatusSet>&
MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::setResolutionStatus(const String& value) {
  static_assert(!(STATE & ResolutionStatusSet), "property resolutionStatus should not be set yet");
  m_result->setResolutionStatus(value);
  return castState<ResolutionStatusSet>();
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE | MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::InsecureURLSet>&
MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::setInsecureURL(const String& value) {
  static_assert(!(STATE & InsecureURLSet), "property insecureURL should not be set yet");
  m_result->setInsecureURL(value);
  return castState<InsecureURLSet>();
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE | MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::MainResourceURLSet>&
MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::setMainResourceURL(const String& value) {
  static_assert(!(STATE & MainResourceURLSet), "property mainResourceURL should not be set yet");
  m_result->setMainResourceURL(value);
  return castState<MainResourceURLSet>();
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>& MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->setRequest(std::move(value));
  return *this;
}
template<int STATE>
inline MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>& MixedContentIssueDetails::MixedContentIssueDetailsBuilder<STATE>::setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->setFrame(std::move(value));
  return *this;
}

inline MixedContentIssueDetails::MixedContentIssueDetails() {
}
inline BlockedByResponseIssueDetails::~BlockedByResponseIssueDetails() = default;
inline void BlockedByResponseIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void BlockedByResponseIssueDetails::setParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_parentFrame = std::move(value); }
inline void BlockedByResponseIssueDetails::setBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_blockedFrame = std::move(value); }
inline void BlockedByResponseIssueDetails::setReason(const String& value) { m_reason = value; }

template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE | BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::RequestSet>&
BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->setRequest(std::move(value));
  return castState<RequestSet>();
}
template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>& BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::setParentFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->setParentFrame(std::move(value));
  return *this;
}
template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>& BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::setBlockedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->setBlockedFrame(std::move(value));
  return *this;
}
template<int STATE>
inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE | BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::ReasonSet>&
BlockedByResponseIssueDetails::BlockedByResponseIssueDetailsBuilder<STATE>::setReason(const String& value) {
  static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
  m_result->setReason(value);
  return castState<ReasonSet>();
}

inline BlockedByResponseIssueDetails::BlockedByResponseIssueDetails() {
}
inline HeavyAdIssueDetails::~HeavyAdIssueDetails() = default;
inline void HeavyAdIssueDetails::setResolution(const String& value) { m_resolution = value; }
inline void HeavyAdIssueDetails::setReason(const String& value) { m_reason = value; }
inline void HeavyAdIssueDetails::setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frame = std::move(value); }

template<int STATE>
inline HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE | HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::ResolutionSet>&
HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::setResolution(const String& value) {
  static_assert(!(STATE & ResolutionSet), "property resolution should not be set yet");
  m_result->setResolution(value);
  return castState<ResolutionSet>();
}
template<int STATE>
inline HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE | HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::ReasonSet>&
HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::setReason(const String& value) {
  static_assert(!(STATE & ReasonSet), "property reason should not be set yet");
  m_result->setReason(value);
  return castState<ReasonSet>();
}
template<int STATE>
inline HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE | HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::FrameSet>&
HeavyAdIssueDetails::HeavyAdIssueDetailsBuilder<STATE>::setFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  static_assert(!(STATE & FrameSet), "property frame should not be set yet");
  m_result->setFrame(std::move(value));
  return castState<FrameSet>();
}

inline HeavyAdIssueDetails::HeavyAdIssueDetails() {
}
inline SourceCodeLocation::~SourceCodeLocation() = default;
inline void SourceCodeLocation::setScriptId(const String& value) { m_scriptId = value; }
inline void SourceCodeLocation::setUrl(const String& value) { m_url = value; }
inline void SourceCodeLocation::setLineNumber(int value) { m_lineNumber = value; }
inline void SourceCodeLocation::setColumnNumber(int value) { m_columnNumber = value; }

template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE>& SourceCodeLocation::SourceCodeLocationBuilder<STATE>::setScriptId(const String& value) {
  m_result->setScriptId(value);
  return *this;
}
template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE | SourceCodeLocation::SourceCodeLocationBuilder<STATE>::UrlSet>&
SourceCodeLocation::SourceCodeLocationBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE | SourceCodeLocation::SourceCodeLocationBuilder<STATE>::LineNumberSet>&
SourceCodeLocation::SourceCodeLocationBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline SourceCodeLocation::SourceCodeLocationBuilder<STATE | SourceCodeLocation::SourceCodeLocationBuilder<STATE>::ColumnNumberSet>&
SourceCodeLocation::SourceCodeLocationBuilder<STATE>::setColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->setColumnNumber(value);
  return castState<ColumnNumberSet>();
}

inline SourceCodeLocation::SourceCodeLocation() {
  m_lineNumber = 0;
  m_columnNumber = 0;
}
inline ContentSecurityPolicyIssueDetails::~ContentSecurityPolicyIssueDetails() = default;
inline void ContentSecurityPolicyIssueDetails::setBlockedURL(const String& value) { m_blockedURL = value; }
inline void ContentSecurityPolicyIssueDetails::setViolatedDirective(const String& value) { m_violatedDirective = value; }
inline void ContentSecurityPolicyIssueDetails::setIsReportOnly(bool value) { m_isReportOnly = value; }
inline void ContentSecurityPolicyIssueDetails::setContentSecurityPolicyViolationType(const String& value) { m_contentSecurityPolicyViolationType = value; }
inline void ContentSecurityPolicyIssueDetails::setFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_frameAncestor = std::move(value); }
inline void ContentSecurityPolicyIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void ContentSecurityPolicyIssueDetails::setViolatingNodeId(int value) { m_violatingNodeId = value; }

template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setBlockedURL(const String& value) {
  m_result->setBlockedURL(value);
  return *this;
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::ViolatedDirectiveSet>&
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setViolatedDirective(const String& value) {
  static_assert(!(STATE & ViolatedDirectiveSet), "property violatedDirective should not be set yet");
  m_result->setViolatedDirective(value);
  return castState<ViolatedDirectiveSet>();
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::IsReportOnlySet>&
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setIsReportOnly(bool value) {
  static_assert(!(STATE & IsReportOnlySet), "property isReportOnly should not be set yet");
  m_result->setIsReportOnly(value);
  return castState<IsReportOnlySet>();
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE | ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::ContentSecurityPolicyViolationTypeSet>&
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setContentSecurityPolicyViolationType(const String& value) {
  static_assert(!(STATE & ContentSecurityPolicyViolationTypeSet), "property contentSecurityPolicyViolationType should not be set yet");
  m_result->setContentSecurityPolicyViolationType(value);
  return castState<ContentSecurityPolicyViolationTypeSet>();
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setFrameAncestor(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->setFrameAncestor(std::move(value));
  return *this;
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->setSourceCodeLocation(std::move(value));
  return *this;
}
template<int STATE>
inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>& ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetailsBuilder<STATE>::setViolatingNodeId(int value) {
  m_result->setViolatingNodeId(value);
  return *this;
}

inline ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetails() {
  m_isReportOnly = false;
}
inline SharedArrayBufferIssueDetails::~SharedArrayBufferIssueDetails() = default;
inline void SharedArrayBufferIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void SharedArrayBufferIssueDetails::setIsWarning(bool value) { m_isWarning = value; }
inline void SharedArrayBufferIssueDetails::setType(const String& value) { m_type = value; }

template<int STATE>
inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE | SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->setSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE | SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::IsWarningSet>&
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::setIsWarning(bool value) {
  static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
  m_result->setIsWarning(value);
  return castState<IsWarningSet>();
}
template<int STATE>
inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE | SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::TypeSet>&
SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetailsBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}

inline SharedArrayBufferIssueDetails::SharedArrayBufferIssueDetails() {
  m_isWarning = false;
}
inline LowTextContrastIssueDetails::~LowTextContrastIssueDetails() = default;
inline void LowTextContrastIssueDetails::setViolatingNodeId(int value) { m_violatingNodeId = value; }
inline void LowTextContrastIssueDetails::setViolatingNodeSelector(const String& value) { m_violatingNodeSelector = value; }
inline void LowTextContrastIssueDetails::setContrastRatio(double value) { m_contrastRatio = value; }
inline void LowTextContrastIssueDetails::setThresholdAA(double value) { m_thresholdAA = value; }
inline void LowTextContrastIssueDetails::setThresholdAAA(double value) { m_thresholdAAA = value; }
inline void LowTextContrastIssueDetails::setFontSize(const String& value) { m_fontSize = value; }
inline void LowTextContrastIssueDetails::setFontWeight(const String& value) { m_fontWeight = value; }

template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ViolatingNodeIdSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setViolatingNodeId(int value) {
  static_assert(!(STATE & ViolatingNodeIdSet), "property violatingNodeId should not be set yet");
  m_result->setViolatingNodeId(value);
  return castState<ViolatingNodeIdSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ViolatingNodeSelectorSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setViolatingNodeSelector(const String& value) {
  static_assert(!(STATE & ViolatingNodeSelectorSet), "property violatingNodeSelector should not be set yet");
  m_result->setViolatingNodeSelector(value);
  return castState<ViolatingNodeSelectorSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ContrastRatioSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setContrastRatio(double value) {
  static_assert(!(STATE & ContrastRatioSet), "property contrastRatio should not be set yet");
  m_result->setContrastRatio(value);
  return castState<ContrastRatioSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ThresholdAASet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setThresholdAA(double value) {
  static_assert(!(STATE & ThresholdAASet), "property thresholdAA should not be set yet");
  m_result->setThresholdAA(value);
  return castState<ThresholdAASet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::ThresholdAAASet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setThresholdAAA(double value) {
  static_assert(!(STATE & ThresholdAAASet), "property thresholdAAA should not be set yet");
  m_result->setThresholdAAA(value);
  return castState<ThresholdAAASet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::FontSizeSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setFontSize(const String& value) {
  static_assert(!(STATE & FontSizeSet), "property fontSize should not be set yet");
  m_result->setFontSize(value);
  return castState<FontSizeSet>();
}
template<int STATE>
inline LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE | LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::FontWeightSet>&
LowTextContrastIssueDetails::LowTextContrastIssueDetailsBuilder<STATE>::setFontWeight(const String& value) {
  static_assert(!(STATE & FontWeightSet), "property fontWeight should not be set yet");
  m_result->setFontWeight(value);
  return castState<FontWeightSet>();
}

inline LowTextContrastIssueDetails::LowTextContrastIssueDetails() {
  m_violatingNodeId = 0;
  m_contrastRatio = 0;
  m_thresholdAA = 0;
  m_thresholdAAA = 0;
}
inline CorsIssueDetails::~CorsIssueDetails() = default;
inline void CorsIssueDetails::setCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value) { m_corsErrorStatus = std::move(value); }
inline void CorsIssueDetails::setIsWarning(bool value) { m_isWarning = value; }
inline void CorsIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void CorsIssueDetails::setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }
inline void CorsIssueDetails::setInitiatorOrigin(const String& value) { m_initiatorOrigin = value; }
inline void CorsIssueDetails::setResourceIPAddressSpace(const String& value) { m_resourceIPAddressSpace = value; }
inline void CorsIssueDetails::setClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value) { m_clientSecurityState = std::move(value); }

template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE | CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::CorsErrorStatusSet>&
CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setCorsErrorStatus(std::unique_ptr<protocol::Network::CorsErrorStatus> value) {
  static_assert(!(STATE & CorsErrorStatusSet), "property corsErrorStatus should not be set yet");
  m_result->setCorsErrorStatus(std::move(value));
  return castState<CorsErrorStatusSet>();
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE | CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::IsWarningSet>&
CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setIsWarning(bool value) {
  static_assert(!(STATE & IsWarningSet), "property isWarning should not be set yet");
  m_result->setIsWarning(value);
  return castState<IsWarningSet>();
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE | CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::RequestSet>&
CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->setRequest(std::move(value));
  return castState<RequestSet>();
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->setLocation(std::move(value));
  return *this;
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setInitiatorOrigin(const String& value) {
  m_result->setInitiatorOrigin(value);
  return *this;
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setResourceIPAddressSpace(const String& value) {
  m_result->setResourceIPAddressSpace(value);
  return *this;
}
template<int STATE>
inline CorsIssueDetails::CorsIssueDetailsBuilder<STATE>& CorsIssueDetails::CorsIssueDetailsBuilder<STATE>::setClientSecurityState(std::unique_ptr<protocol::Network::ClientSecurityState> value) {
  m_result->setClientSecurityState(std::move(value));
  return *this;
}

inline CorsIssueDetails::CorsIssueDetails() {
  m_isWarning = false;
}
inline AttributionReportingIssueDetails::~AttributionReportingIssueDetails() = default;
inline void AttributionReportingIssueDetails::setViolationType(const String& value) { m_violationType = value; }
inline void AttributionReportingIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void AttributionReportingIssueDetails::setViolatingNodeId(int value) { m_violatingNodeId = value; }
inline void AttributionReportingIssueDetails::setInvalidParameter(const String& value) { m_invalidParameter = value; }

template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE | AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::ViolationTypeSet>&
AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::setViolationType(const String& value) {
  static_assert(!(STATE & ViolationTypeSet), "property violationType should not be set yet");
  m_result->setViolationType(value);
  return castState<ViolationTypeSet>();
}
template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>& AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->setRequest(std::move(value));
  return *this;
}
template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>& AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::setViolatingNodeId(int value) {
  m_result->setViolatingNodeId(value);
  return *this;
}
template<int STATE>
inline AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>& AttributionReportingIssueDetails::AttributionReportingIssueDetailsBuilder<STATE>::setInvalidParameter(const String& value) {
  m_result->setInvalidParameter(value);
  return *this;
}

inline AttributionReportingIssueDetails::AttributionReportingIssueDetails() {
}
inline QuirksModeIssueDetails::~QuirksModeIssueDetails() = default;
inline void QuirksModeIssueDetails::setIsLimitedQuirksMode(bool value) { m_isLimitedQuirksMode = value; }
inline void QuirksModeIssueDetails::setDocumentNodeId(int value) { m_documentNodeId = value; }
inline void QuirksModeIssueDetails::setUrl(const String& value) { m_url = value; }
inline void QuirksModeIssueDetails::setFrameId(const String& value) { m_frameId = value; }
inline void QuirksModeIssueDetails::setLoaderId(const String& value) { m_loaderId = value; }

template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::IsLimitedQuirksModeSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::setIsLimitedQuirksMode(bool value) {
  static_assert(!(STATE & IsLimitedQuirksModeSet), "property isLimitedQuirksMode should not be set yet");
  m_result->setIsLimitedQuirksMode(value);
  return castState<IsLimitedQuirksModeSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::DocumentNodeIdSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::setDocumentNodeId(int value) {
  static_assert(!(STATE & DocumentNodeIdSet), "property documentNodeId should not be set yet");
  m_result->setDocumentNodeId(value);
  return castState<DocumentNodeIdSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::UrlSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::FrameIdSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::setFrameId(const String& value) {
  static_assert(!(STATE & FrameIdSet), "property frameId should not be set yet");
  m_result->setFrameId(value);
  return castState<FrameIdSet>();
}
template<int STATE>
inline QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE | QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::LoaderIdSet>&
QuirksModeIssueDetails::QuirksModeIssueDetailsBuilder<STATE>::setLoaderId(const String& value) {
  static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
  m_result->setLoaderId(value);
  return castState<LoaderIdSet>();
}

inline QuirksModeIssueDetails::QuirksModeIssueDetails() {
  m_isLimitedQuirksMode = false;
  m_documentNodeId = 0;
}
inline NavigatorUserAgentIssueDetails::~NavigatorUserAgentIssueDetails() = default;
inline void NavigatorUserAgentIssueDetails::setUrl(const String& value) { m_url = value; }
inline void NavigatorUserAgentIssueDetails::setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_location = std::move(value); }

template<int STATE>
inline NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE | NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>::UrlSet>&
NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>& NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetailsBuilder<STATE>::setLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->setLocation(std::move(value));
  return *this;
}

inline NavigatorUserAgentIssueDetails::NavigatorUserAgentIssueDetails() {
}
inline SharedDictionaryIssueDetails::~SharedDictionaryIssueDetails() = default;
inline void SharedDictionaryIssueDetails::setSharedDictionaryError(const String& value) { m_sharedDictionaryError = value; }
inline void SharedDictionaryIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::SharedDictionaryErrorSet>&
SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::setSharedDictionaryError(const String& value) {
  static_assert(!(STATE & SharedDictionaryErrorSet), "property sharedDictionaryError should not be set yet");
  m_result->setSharedDictionaryError(value);
  return castState<SharedDictionaryErrorSet>();
}
template<int STATE>
inline SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE | SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::RequestSet>&
SharedDictionaryIssueDetails::SharedDictionaryIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->setRequest(std::move(value));
  return castState<RequestSet>();
}

inline SharedDictionaryIssueDetails::SharedDictionaryIssueDetails() {
}
inline SRIMessageSignatureIssueDetails::~SRIMessageSignatureIssueDetails() = default;
inline void SRIMessageSignatureIssueDetails::setError(const String& value) { m_error = value; }
inline void SRIMessageSignatureIssueDetails::setSignatureBase(const String& value) { m_signatureBase = value; }
inline void SRIMessageSignatureIssueDetails::setIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value) { m_integrityAssertions = std::move(value); }
inline void SRIMessageSignatureIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::ErrorSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::setError(const String& value) {
  static_assert(!(STATE & ErrorSet), "property error should not be set yet");
  m_result->setError(value);
  return castState<ErrorSet>();
}
template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::SignatureBaseSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::setSignatureBase(const String& value) {
  static_assert(!(STATE & SignatureBaseSet), "property signatureBase should not be set yet");
  m_result->setSignatureBase(value);
  return castState<SignatureBaseSet>();
}
template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::IntegrityAssertionsSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::setIntegrityAssertions(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & IntegrityAssertionsSet), "property integrityAssertions should not be set yet");
  m_result->setIntegrityAssertions(std::move(value));
  return castState<IntegrityAssertionsSet>();
}
template<int STATE>
inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE | SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::RequestSet>&
SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->setRequest(std::move(value));
  return castState<RequestSet>();
}

inline SRIMessageSignatureIssueDetails::SRIMessageSignatureIssueDetails() {
}
inline UnencodedDigestIssueDetails::~UnencodedDigestIssueDetails() = default;
inline void UnencodedDigestIssueDetails::setError(const String& value) { m_error = value; }
inline void UnencodedDigestIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE | UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::ErrorSet>&
UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::setError(const String& value) {
  static_assert(!(STATE & ErrorSet), "property error should not be set yet");
  m_result->setError(value);
  return castState<ErrorSet>();
}
template<int STATE>
inline UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE | UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::RequestSet>&
UnencodedDigestIssueDetails::UnencodedDigestIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  static_assert(!(STATE & RequestSet), "property request should not be set yet");
  m_result->setRequest(std::move(value));
  return castState<RequestSet>();
}

inline UnencodedDigestIssueDetails::UnencodedDigestIssueDetails() {
}
inline GenericIssueDetails::~GenericIssueDetails() = default;
inline void GenericIssueDetails::setErrorType(const String& value) { m_errorType = value; }
inline void GenericIssueDetails::setFrameId(const String& value) { m_frameId = value; }
inline void GenericIssueDetails::setViolatingNodeId(int value) { m_violatingNodeId = value; }
inline void GenericIssueDetails::setViolatingNodeAttribute(const String& value) { m_violatingNodeAttribute = value; }
inline void GenericIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }

template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE | GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::ErrorTypeSet>&
GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::setErrorType(const String& value) {
  static_assert(!(STATE & ErrorTypeSet), "property errorType should not be set yet");
  m_result->setErrorType(value);
  return castState<ErrorTypeSet>();
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::setFrameId(const String& value) {
  m_result->setFrameId(value);
  return *this;
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::setViolatingNodeId(int value) {
  m_result->setViolatingNodeId(value);
  return *this;
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::setViolatingNodeAttribute(const String& value) {
  m_result->setViolatingNodeAttribute(value);
  return *this;
}
template<int STATE>
inline GenericIssueDetails::GenericIssueDetailsBuilder<STATE>& GenericIssueDetails::GenericIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->setRequest(std::move(value));
  return *this;
}

inline GenericIssueDetails::GenericIssueDetails() {
}
inline DeprecationIssueDetails::~DeprecationIssueDetails() = default;
inline void DeprecationIssueDetails::setAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) { m_affectedFrame = std::move(value); }
inline void DeprecationIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void DeprecationIssueDetails::setType(const String& value) { m_type = value; }

template<int STATE>
inline DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>& DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::setAffectedFrame(std::unique_ptr<protocol::Audits::AffectedFrame> value) {
  m_result->setAffectedFrame(std::move(value));
  return *this;
}
template<int STATE>
inline DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE | DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->setSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE | DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::TypeSet>&
DeprecationIssueDetails::DeprecationIssueDetailsBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}

inline DeprecationIssueDetails::DeprecationIssueDetails() {
}
inline BounceTrackingIssueDetails::~BounceTrackingIssueDetails() = default;
inline void BounceTrackingIssueDetails::setTrackingSites(std::unique_ptr<protocol::Array<String>> value) { m_trackingSites = std::move(value); }

template<int STATE>
inline BounceTrackingIssueDetails::BounceTrackingIssueDetailsBuilder<STATE | BounceTrackingIssueDetails::BounceTrackingIssueDetailsBuilder<STATE>::TrackingSitesSet>&
BounceTrackingIssueDetails::BounceTrackingIssueDetailsBuilder<STATE>::setTrackingSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & TrackingSitesSet), "property trackingSites should not be set yet");
  m_result->setTrackingSites(std::move(value));
  return castState<TrackingSitesSet>();
}

inline BounceTrackingIssueDetails::BounceTrackingIssueDetails() {
}
inline CookieDeprecationMetadataIssueDetails::~CookieDeprecationMetadataIssueDetails() = default;
inline void CookieDeprecationMetadataIssueDetails::setAllowedSites(std::unique_ptr<protocol::Array<String>> value) { m_allowedSites = std::move(value); }
inline void CookieDeprecationMetadataIssueDetails::setOptOutPercentage(double value) { m_optOutPercentage = value; }
inline void CookieDeprecationMetadataIssueDetails::setIsOptOutTopLevel(bool value) { m_isOptOutTopLevel = value; }
inline void CookieDeprecationMetadataIssueDetails::setOperation(const String& value) { m_operation = value; }

template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::AllowedSitesSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::setAllowedSites(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & AllowedSitesSet), "property allowedSites should not be set yet");
  m_result->setAllowedSites(std::move(value));
  return castState<AllowedSitesSet>();
}
template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::OptOutPercentageSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::setOptOutPercentage(double value) {
  static_assert(!(STATE & OptOutPercentageSet), "property optOutPercentage should not be set yet");
  m_result->setOptOutPercentage(value);
  return castState<OptOutPercentageSet>();
}
template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::IsOptOutTopLevelSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::setIsOptOutTopLevel(bool value) {
  static_assert(!(STATE & IsOptOutTopLevelSet), "property isOptOutTopLevel should not be set yet");
  m_result->setIsOptOutTopLevel(value);
  return castState<IsOptOutTopLevelSet>();
}
template<int STATE>
inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE | CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::OperationSet>&
CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetailsBuilder<STATE>::setOperation(const String& value) {
  static_assert(!(STATE & OperationSet), "property operation should not be set yet");
  m_result->setOperation(value);
  return castState<OperationSet>();
}

inline CookieDeprecationMetadataIssueDetails::CookieDeprecationMetadataIssueDetails() {
  m_optOutPercentage = 0;
  m_isOptOutTopLevel = false;
}
inline FederatedAuthRequestIssueDetails::~FederatedAuthRequestIssueDetails() = default;
inline void FederatedAuthRequestIssueDetails::setFederatedAuthRequestIssueReason(const String& value) { m_federatedAuthRequestIssueReason = value; }

template<int STATE>
inline FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetailsBuilder<STATE | FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetailsBuilder<STATE>::FederatedAuthRequestIssueReasonSet>&
FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetailsBuilder<STATE>::setFederatedAuthRequestIssueReason(const String& value) {
  static_assert(!(STATE & FederatedAuthRequestIssueReasonSet), "property federatedAuthRequestIssueReason should not be set yet");
  m_result->setFederatedAuthRequestIssueReason(value);
  return castState<FederatedAuthRequestIssueReasonSet>();
}

inline FederatedAuthRequestIssueDetails::FederatedAuthRequestIssueDetails() {
}
inline FederatedAuthUserInfoRequestIssueDetails::~FederatedAuthUserInfoRequestIssueDetails() = default;
inline void FederatedAuthUserInfoRequestIssueDetails::setFederatedAuthUserInfoRequestIssueReason(const String& value) { m_federatedAuthUserInfoRequestIssueReason = value; }

template<int STATE>
inline FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE | FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE>::FederatedAuthUserInfoRequestIssueReasonSet>&
FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetailsBuilder<STATE>::setFederatedAuthUserInfoRequestIssueReason(const String& value) {
  static_assert(!(STATE & FederatedAuthUserInfoRequestIssueReasonSet), "property federatedAuthUserInfoRequestIssueReason should not be set yet");
  m_result->setFederatedAuthUserInfoRequestIssueReason(value);
  return castState<FederatedAuthUserInfoRequestIssueReasonSet>();
}

inline FederatedAuthUserInfoRequestIssueDetails::FederatedAuthUserInfoRequestIssueDetails() {
}
inline ClientHintIssueDetails::~ClientHintIssueDetails() = default;
inline void ClientHintIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void ClientHintIssueDetails::setClientHintIssueReason(const String& value) { m_clientHintIssueReason = value; }

template<int STATE>
inline ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE | ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->setSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE | ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::ClientHintIssueReasonSet>&
ClientHintIssueDetails::ClientHintIssueDetailsBuilder<STATE>::setClientHintIssueReason(const String& value) {
  static_assert(!(STATE & ClientHintIssueReasonSet), "property clientHintIssueReason should not be set yet");
  m_result->setClientHintIssueReason(value);
  return castState<ClientHintIssueReasonSet>();
}

inline ClientHintIssueDetails::ClientHintIssueDetails() {
}
inline FailedRequestInfo::~FailedRequestInfo() = default;
inline void FailedRequestInfo::setUrl(const String& value) { m_url = value; }
inline void FailedRequestInfo::setFailureMessage(const String& value) { m_failureMessage = value; }
inline void FailedRequestInfo::setRequestId(const String& value) { m_requestId = value; }

template<int STATE>
inline FailedRequestInfo::FailedRequestInfoBuilder<STATE | FailedRequestInfo::FailedRequestInfoBuilder<STATE>::UrlSet>&
FailedRequestInfo::FailedRequestInfoBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline FailedRequestInfo::FailedRequestInfoBuilder<STATE | FailedRequestInfo::FailedRequestInfoBuilder<STATE>::FailureMessageSet>&
FailedRequestInfo::FailedRequestInfoBuilder<STATE>::setFailureMessage(const String& value) {
  static_assert(!(STATE & FailureMessageSet), "property failureMessage should not be set yet");
  m_result->setFailureMessage(value);
  return castState<FailureMessageSet>();
}
template<int STATE>
inline FailedRequestInfo::FailedRequestInfoBuilder<STATE>& FailedRequestInfo::FailedRequestInfoBuilder<STATE>::setRequestId(const String& value) {
  m_result->setRequestId(value);
  return *this;
}

inline FailedRequestInfo::FailedRequestInfo() {
}
inline PartitioningBlobURLIssueDetails::~PartitioningBlobURLIssueDetails() = default;
inline void PartitioningBlobURLIssueDetails::setUrl(const String& value) { m_url = value; }
inline void PartitioningBlobURLIssueDetails::setPartitioningBlobURLInfo(const String& value) { m_partitioningBlobURLInfo = value; }

template<int STATE>
inline PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::UrlSet>&
PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::setUrl(const String& value) {
  static_assert(!(STATE & UrlSet), "property url should not be set yet");
  m_result->setUrl(value);
  return castState<UrlSet>();
}
template<int STATE>
inline PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE | PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::PartitioningBlobURLInfoSet>&
PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetailsBuilder<STATE>::setPartitioningBlobURLInfo(const String& value) {
  static_assert(!(STATE & PartitioningBlobURLInfoSet), "property partitioningBlobURLInfo should not be set yet");
  m_result->setPartitioningBlobURLInfo(value);
  return castState<PartitioningBlobURLInfoSet>();
}

inline PartitioningBlobURLIssueDetails::PartitioningBlobURLIssueDetails() {
}
inline ElementAccessibilityIssueDetails::~ElementAccessibilityIssueDetails() = default;
inline void ElementAccessibilityIssueDetails::setNodeId(int value) { m_nodeId = value; }
inline void ElementAccessibilityIssueDetails::setElementAccessibilityIssueReason(const String& value) { m_elementAccessibilityIssueReason = value; }
inline void ElementAccessibilityIssueDetails::setHasDisallowedAttributes(bool value) { m_hasDisallowedAttributes = value; }

template<int STATE>
inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::NodeIdSet>&
ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::setNodeId(int value) {
  static_assert(!(STATE & NodeIdSet), "property nodeId should not be set yet");
  m_result->setNodeId(value);
  return castState<NodeIdSet>();
}
template<int STATE>
inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::ElementAccessibilityIssueReasonSet>&
ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::setElementAccessibilityIssueReason(const String& value) {
  static_assert(!(STATE & ElementAccessibilityIssueReasonSet), "property elementAccessibilityIssueReason should not be set yet");
  m_result->setElementAccessibilityIssueReason(value);
  return castState<ElementAccessibilityIssueReasonSet>();
}
template<int STATE>
inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE | ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::HasDisallowedAttributesSet>&
ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetailsBuilder<STATE>::setHasDisallowedAttributes(bool value) {
  static_assert(!(STATE & HasDisallowedAttributesSet), "property hasDisallowedAttributes should not be set yet");
  m_result->setHasDisallowedAttributes(value);
  return castState<HasDisallowedAttributesSet>();
}

inline ElementAccessibilityIssueDetails::ElementAccessibilityIssueDetails() {
  m_nodeId = 0;
  m_hasDisallowedAttributes = false;
}
inline StylesheetLoadingIssueDetails::~StylesheetLoadingIssueDetails() = default;
inline void StylesheetLoadingIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void StylesheetLoadingIssueDetails::setStyleSheetLoadingIssueReason(const String& value) { m_styleSheetLoadingIssueReason = value; }
inline void StylesheetLoadingIssueDetails::setFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value) { m_failedRequestInfo = std::move(value); }

template<int STATE>
inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE | StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->setSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE | StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::StyleSheetLoadingIssueReasonSet>&
StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::setStyleSheetLoadingIssueReason(const String& value) {
  static_assert(!(STATE & StyleSheetLoadingIssueReasonSet), "property styleSheetLoadingIssueReason should not be set yet");
  m_result->setStyleSheetLoadingIssueReason(value);
  return castState<StyleSheetLoadingIssueReasonSet>();
}
template<int STATE>
inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>& StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetailsBuilder<STATE>::setFailedRequestInfo(std::unique_ptr<protocol::Audits::FailedRequestInfo> value) {
  m_result->setFailedRequestInfo(std::move(value));
  return *this;
}

inline StylesheetLoadingIssueDetails::StylesheetLoadingIssueDetails() {
}
inline PropertyRuleIssueDetails::~PropertyRuleIssueDetails() = default;
inline void PropertyRuleIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }
inline void PropertyRuleIssueDetails::setPropertyRuleIssueReason(const String& value) { m_propertyRuleIssueReason = value; }
inline void PropertyRuleIssueDetails::setPropertyValue(const String& value) { m_propertyValue = value; }

template<int STATE>
inline PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::SourceCodeLocationSet>&
PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  static_assert(!(STATE & SourceCodeLocationSet), "property sourceCodeLocation should not be set yet");
  m_result->setSourceCodeLocation(std::move(value));
  return castState<SourceCodeLocationSet>();
}
template<int STATE>
inline PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE | PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::PropertyRuleIssueReasonSet>&
PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::setPropertyRuleIssueReason(const String& value) {
  static_assert(!(STATE & PropertyRuleIssueReasonSet), "property propertyRuleIssueReason should not be set yet");
  m_result->setPropertyRuleIssueReason(value);
  return castState<PropertyRuleIssueReasonSet>();
}
template<int STATE>
inline PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>& PropertyRuleIssueDetails::PropertyRuleIssueDetailsBuilder<STATE>::setPropertyValue(const String& value) {
  m_result->setPropertyValue(value);
  return *this;
}

inline PropertyRuleIssueDetails::PropertyRuleIssueDetails() {
}
inline UserReidentificationIssueDetails::~UserReidentificationIssueDetails() = default;
inline void UserReidentificationIssueDetails::setType(const String& value) { m_type = value; }
inline void UserReidentificationIssueDetails::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) { m_request = std::move(value); }
inline void UserReidentificationIssueDetails::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) { m_sourceCodeLocation = std::move(value); }

template<int STATE>
inline UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE | UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::TypeSet>&
UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>& UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::setRequest(std::unique_ptr<protocol::Audits::AffectedRequest> value) {
  m_result->setRequest(std::move(value));
  return *this;
}
template<int STATE>
inline UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>& UserReidentificationIssueDetails::UserReidentificationIssueDetailsBuilder<STATE>::setSourceCodeLocation(std::unique_ptr<protocol::Audits::SourceCodeLocation> value) {
  m_result->setSourceCodeLocation(std::move(value));
  return *this;
}

inline UserReidentificationIssueDetails::UserReidentificationIssueDetails() {
}
inline InspectorIssueDetails::~InspectorIssueDetails() = default;
inline void InspectorIssueDetails::setCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value) { m_cookieIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) { m_mixedContentIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) { m_blockedByResponseIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) { m_heavyAdIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) { m_contentSecurityPolicyIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value) { m_sharedArrayBufferIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value) { m_lowTextContrastIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value) { m_corsIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value) { m_attributionReportingIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value) { m_quirksModeIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value) { m_partitioningBlobURLIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value) { m_navigatorUserAgentIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value) { m_genericIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value) { m_deprecationIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value) { m_clientHintIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value) { m_federatedAuthRequestIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value) { m_bounceTrackingIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value) { m_cookieDeprecationMetadataIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value) { m_stylesheetLoadingIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value) { m_propertyRuleIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value) { m_federatedAuthUserInfoRequestIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value) { m_sharedDictionaryIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value) { m_elementAccessibilityIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value) { m_sriMessageSignatureIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value) { m_unencodedDigestIssueDetails = std::move(value); }
inline void InspectorIssueDetails::setUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value) { m_userReidentificationIssueDetails = std::move(value); }

template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setCookieIssueDetails(std::unique_ptr<protocol::Audits::CookieIssueDetails> value) {
  m_result->setCookieIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setMixedContentIssueDetails(std::unique_ptr<protocol::Audits::MixedContentIssueDetails> value) {
  m_result->setMixedContentIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setBlockedByResponseIssueDetails(std::unique_ptr<protocol::Audits::BlockedByResponseIssueDetails> value) {
  m_result->setBlockedByResponseIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setHeavyAdIssueDetails(std::unique_ptr<protocol::Audits::HeavyAdIssueDetails> value) {
  m_result->setHeavyAdIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setContentSecurityPolicyIssueDetails(std::unique_ptr<protocol::Audits::ContentSecurityPolicyIssueDetails> value) {
  m_result->setContentSecurityPolicyIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setSharedArrayBufferIssueDetails(std::unique_ptr<protocol::Audits::SharedArrayBufferIssueDetails> value) {
  m_result->setSharedArrayBufferIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setLowTextContrastIssueDetails(std::unique_ptr<protocol::Audits::LowTextContrastIssueDetails> value) {
  m_result->setLowTextContrastIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setCorsIssueDetails(std::unique_ptr<protocol::Audits::CorsIssueDetails> value) {
  m_result->setCorsIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setAttributionReportingIssueDetails(std::unique_ptr<protocol::Audits::AttributionReportingIssueDetails> value) {
  m_result->setAttributionReportingIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setQuirksModeIssueDetails(std::unique_ptr<protocol::Audits::QuirksModeIssueDetails> value) {
  m_result->setQuirksModeIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setPartitioningBlobURLIssueDetails(std::unique_ptr<protocol::Audits::PartitioningBlobURLIssueDetails> value) {
  m_result->setPartitioningBlobURLIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setNavigatorUserAgentIssueDetails(std::unique_ptr<protocol::Audits::NavigatorUserAgentIssueDetails> value) {
  m_result->setNavigatorUserAgentIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setGenericIssueDetails(std::unique_ptr<protocol::Audits::GenericIssueDetails> value) {
  m_result->setGenericIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setDeprecationIssueDetails(std::unique_ptr<protocol::Audits::DeprecationIssueDetails> value) {
  m_result->setDeprecationIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setClientHintIssueDetails(std::unique_ptr<protocol::Audits::ClientHintIssueDetails> value) {
  m_result->setClientHintIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setFederatedAuthRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthRequestIssueDetails> value) {
  m_result->setFederatedAuthRequestIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setBounceTrackingIssueDetails(std::unique_ptr<protocol::Audits::BounceTrackingIssueDetails> value) {
  m_result->setBounceTrackingIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setCookieDeprecationMetadataIssueDetails(std::unique_ptr<protocol::Audits::CookieDeprecationMetadataIssueDetails> value) {
  m_result->setCookieDeprecationMetadataIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setStylesheetLoadingIssueDetails(std::unique_ptr<protocol::Audits::StylesheetLoadingIssueDetails> value) {
  m_result->setStylesheetLoadingIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setPropertyRuleIssueDetails(std::unique_ptr<protocol::Audits::PropertyRuleIssueDetails> value) {
  m_result->setPropertyRuleIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setFederatedAuthUserInfoRequestIssueDetails(std::unique_ptr<protocol::Audits::FederatedAuthUserInfoRequestIssueDetails> value) {
  m_result->setFederatedAuthUserInfoRequestIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setSharedDictionaryIssueDetails(std::unique_ptr<protocol::Audits::SharedDictionaryIssueDetails> value) {
  m_result->setSharedDictionaryIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setElementAccessibilityIssueDetails(std::unique_ptr<protocol::Audits::ElementAccessibilityIssueDetails> value) {
  m_result->setElementAccessibilityIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setSriMessageSignatureIssueDetails(std::unique_ptr<protocol::Audits::SRIMessageSignatureIssueDetails> value) {
  m_result->setSriMessageSignatureIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setUnencodedDigestIssueDetails(std::unique_ptr<protocol::Audits::UnencodedDigestIssueDetails> value) {
  m_result->setUnencodedDigestIssueDetails(std::move(value));
  return *this;
}
template<int STATE>
inline InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>& InspectorIssueDetails::InspectorIssueDetailsBuilder<STATE>::setUserReidentificationIssueDetails(std::unique_ptr<protocol::Audits::UserReidentificationIssueDetails> value) {
  m_result->setUserReidentificationIssueDetails(std::move(value));
  return *this;
}

inline InspectorIssueDetails::InspectorIssueDetails() {
}
inline InspectorIssue::~InspectorIssue() = default;
inline void InspectorIssue::setCode(const String& value) { m_code = value; }
inline void InspectorIssue::setDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) { m_details = std::move(value); }
inline void InspectorIssue::setIssueId(const String& value) { m_issueId = value; }

template<int STATE>
inline InspectorIssue::InspectorIssueBuilder<STATE | InspectorIssue::InspectorIssueBuilder<STATE>::CodeSet>&
InspectorIssue::InspectorIssueBuilder<STATE>::setCode(const String& value) {
  static_assert(!(STATE & CodeSet), "property code should not be set yet");
  m_result->setCode(value);
  return castState<CodeSet>();
}
template<int STATE>
inline InspectorIssue::InspectorIssueBuilder<STATE | InspectorIssue::InspectorIssueBuilder<STATE>::DetailsSet>&
InspectorIssue::InspectorIssueBuilder<STATE>::setDetails(std::unique_ptr<protocol::Audits::InspectorIssueDetails> value) {
  static_assert(!(STATE & DetailsSet), "property details should not be set yet");
  m_result->setDetails(std::move(value));
  return castState<DetailsSet>();
}
template<int STATE>
inline InspectorIssue::InspectorIssueBuilder<STATE>& InspectorIssue::InspectorIssueBuilder<STATE>::setIssueId(const String& value) {
  m_result->setIssueId(value);
  return *this;
}

inline InspectorIssue::InspectorIssue() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getEncodedResponse(const String& in_requestId, const String& in_encoding, std::optional<double> in_quality, std::optional<bool> in_sizeOnly, std::optional<Binary>* out_body, int* out_originalSize, int* out_encodedSize) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse checkContrast(std::optional<bool> in_reportAAA) = 0;
    virtual DispatchResponse checkFormsIssues(std::unique_ptr<protocol::Array<protocol::Audits::GenericIssueDetails>>* out_formIssues) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void issueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Audits
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_Audits_h)
