// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_VALUE_KEYWORDS_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_VALUE_KEYWORDS_H_

#include <string.h>
#include <stdint.h>

#include <string_view>

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/css/parser/css_parser_mode.h"

namespace blink {

enum class CSSValueID {
  kInvalid = 0,
  kInherit = 1,
  kInitial = 2,
  kNone = 3,
  kHidden = 4,
  kInset = 5,
  kGroove = 6,
  kOutset = 7,
  kRidge = 8,
  kDotted = 9,
  kDashed = 10,
  kSolid = 11,
  kDouble = 12,
  kCaption = 13,
  kIcon = 14,
  kMenu = 15,
  kMessageBox = 16,
  kSmallCaption = 17,
  kWebkitMiniControl = 18,
  kWebkitSmallControl = 19,
  kWebkitControl = 20,
  kStatusBar = 21,
  kItalic = 22,
  kOblique = 23,
  kAll = 24,
  kCommonLigatures = 25,
  kNoCommonLigatures = 26,
  kDiscretionaryLigatures = 27,
  kNoDiscretionaryLigatures = 28,
  kHistoricalLigatures = 29,
  kNoHistoricalLigatures = 30,
  kContextual = 31,
  kNoContextual = 32,
  kSmallCaps = 33,
  kAllSmallCaps = 34,
  kPetiteCaps = 35,
  kAllPetiteCaps = 36,
  kUnicase = 37,
  kTitlingCaps = 38,
  kJis78 = 39,
  kJis83 = 40,
  kJis90 = 41,
  kJis04 = 42,
  kSimplified = 43,
  kTraditional = 44,
  kFullWidth = 45,
  kProportionalWidth = 46,
  kRuby = 47,
  kLiningNums = 48,
  kOldstyleNums = 49,
  kProportionalNums = 50,
  kTabularNums = 51,
  kDiagonalFractions = 52,
  kStackedFractions = 53,
  kOrdinal = 54,
  kSlashedZero = 55,
  kStylistic = 56,
  kHistoricalForms = 57,
  kStyleset = 58,
  kCharacterVariant = 59,
  kSwash = 60,
  kOrnaments = 61,
  kAnnotation = 62,
  kNormal = 63,
  kBold = 64,
  kBolder = 65,
  kLighter = 66,
  kWeight = 67,
  kUltraCondensed = 68,
  kExtraCondensed = 69,
  kCondensed = 70,
  kSemiCondensed = 71,
  kSemiExpanded = 72,
  kExpanded = 73,
  kExtraExpanded = 74,
  kUltraExpanded = 75,
  kXxSmall = 76,
  kXSmall = 77,
  kSmall = 78,
  kMedium = 79,
  kLarge = 80,
  kXLarge = 81,
  kXxLarge = 82,
  kXxxLarge = 83,
  kSmaller = 84,
  kLarger = 85,
  kWebkitXxxLarge = 86,
  kExHeight = 87,
  kCapHeight = 88,
  kChWidth = 89,
  kIcWidth = 90,
  kIcHeight = 91,
  kSerif = 92,
  kSansSerif = 93,
  kCursive = 94,
  kFantasy = 95,
  kMonospace = 96,
  kSystemUi = 97,
  kWebkitBody = 98,
  kMath = 99,
  kSwap = 100,
  kFallback = 101,
  kOptional = 102,
  kFontTech = 103,
  kFontFormat = 104,
  kEmoji = 105,
  kUnicode = 106,
  kPaletteMix = 107,
  kAqua = 108,
  kBlack = 109,
  kBlue = 110,
  kFuchsia = 111,
  kGray = 112,
  kGreen = 113,
  kLime = 114,
  kMaroon = 115,
  kNavy = 116,
  kOlive = 117,
  kOrange = 118,
  kPurple = 119,
  kRed = 120,
  kSilver = 121,
  kTeal = 122,
  kWhite = 123,
  kYellow = 124,
  kTransparent = 125,
  kWebkitLink = 126,
  kWebkitActivelink = 127,
  kAccentcolor = 128,
  kAccentcolortext = 129,
  kActiveborder = 130,
  kActivecaption = 131,
  kActivetext = 132,
  kAppworkspace = 133,
  kBackground = 134,
  kButtonborder = 135,
  kButtonface = 136,
  kButtonhighlight = 137,
  kButtonshadow = 138,
  kButtontext = 139,
  kCanvas = 140,
  kCanvastext = 141,
  kCaptiontext = 142,
  kField = 143,
  kFieldtext = 144,
  kGraytext = 145,
  kHighlight = 146,
  kHighlighttext = 147,
  kInactiveborder = 148,
  kInactivecaption = 149,
  kInactivecaptiontext = 150,
  kInfobackground = 151,
  kInfotext = 152,
  kLinktext = 153,
  kMark = 154,
  kMarktext = 155,
  kMenutext = 156,
  kSelecteditem = 157,
  kSelecteditemtext = 158,
  kScrollbar = 159,
  kThreeddarkshadow = 160,
  kThreedface = 161,
  kThreedhighlight = 162,
  kThreedlightshadow = 163,
  kThreedshadow = 164,
  kVisitedtext = 165,
  kWindow = 166,
  kWindowframe = 167,
  kWindowtext = 168,
  kInternalActiveListBoxSelection = 169,
  kInternalActiveListBoxSelectionText = 170,
  kInternalInactiveListBoxSelection = 171,
  kInternalInactiveListBoxSelectionText = 172,
  kWebkitFocusRingColor = 173,
  kCurrentcolor = 174,
  kGrey = 175,
  kInternalQuirkInherit = 176,
  kInternalSpellingErrorColor = 177,
  kInternalGrammarErrorColor = 178,
  kInternalSearchColor = 179,
  kInternalSearchTextColor = 180,
  kInternalCurrentSearchColor = 181,
  kInternalCurrentSearchTextColor = 182,
  kAliceblue = 183,
  kAntiquewhite = 184,
  kAquamarine = 185,
  kAzure = 186,
  kBeige = 187,
  kBisque = 188,
  kBlanchedalmond = 189,
  kBlueviolet = 190,
  kBrown = 191,
  kBurlywood = 192,
  kCadetblue = 193,
  kChartreuse = 194,
  kChocolate = 195,
  kCoral = 196,
  kCornflowerblue = 197,
  kCornsilk = 198,
  kCrimson = 199,
  kCyan = 200,
  kDarkblue = 201,
  kDarkcyan = 202,
  kDarkgoldenrod = 203,
  kDarkgray = 204,
  kDarkgreen = 205,
  kDarkgrey = 206,
  kDarkkhaki = 207,
  kDarkmagenta = 208,
  kDarkolivegreen = 209,
  kDarkorange = 210,
  kDarkorchid = 211,
  kDarkred = 212,
  kDarksalmon = 213,
  kDarkseagreen = 214,
  kDarkslateblue = 215,
  kDarkslategray = 216,
  kDarkslategrey = 217,
  kDarkturquoise = 218,
  kDarkviolet = 219,
  kDeeppink = 220,
  kDeepskyblue = 221,
  kDimgray = 222,
  kDimgrey = 223,
  kDodgerblue = 224,
  kFirebrick = 225,
  kFloralwhite = 226,
  kForestgreen = 227,
  kGainsboro = 228,
  kGhostwhite = 229,
  kGold = 230,
  kGoldenrod = 231,
  kGreenyellow = 232,
  kHoneydew = 233,
  kHotpink = 234,
  kIndianred = 235,
  kIndigo = 236,
  kIvory = 237,
  kKhaki = 238,
  kLavender = 239,
  kLavenderblush = 240,
  kLawngreen = 241,
  kLemonchiffon = 242,
  kLightblue = 243,
  kLightcoral = 244,
  kLightcyan = 245,
  kLightgoldenrodyellow = 246,
  kLightgray = 247,
  kLightgreen = 248,
  kLightgrey = 249,
  kLightpink = 250,
  kLightsalmon = 251,
  kLightseagreen = 252,
  kLightskyblue = 253,
  kLightslategray = 254,
  kLightslategrey = 255,
  kLightsteelblue = 256,
  kLightyellow = 257,
  kLimegreen = 258,
  kLinen = 259,
  kMagenta = 260,
  kMediumaquamarine = 261,
  kMediumblue = 262,
  kMediumorchid = 263,
  kMediumpurple = 264,
  kMediumseagreen = 265,
  kMediumslateblue = 266,
  kMediumspringgreen = 267,
  kMediumturquoise = 268,
  kMediumvioletred = 269,
  kMidnightblue = 270,
  kMintcream = 271,
  kMistyrose = 272,
  kMoccasin = 273,
  kNavajowhite = 274,
  kOldlace = 275,
  kOlivedrab = 276,
  kOrangered = 277,
  kOrchid = 278,
  kPalegoldenrod = 279,
  kPalegreen = 280,
  kPaleturquoise = 281,
  kPalevioletred = 282,
  kPapayawhip = 283,
  kPeachpuff = 284,
  kPeru = 285,
  kPink = 286,
  kPlum = 287,
  kPowderblue = 288,
  kRebeccapurple = 289,
  kRosybrown = 290,
  kRoyalblue = 291,
  kSaddlebrown = 292,
  kSalmon = 293,
  kSandybrown = 294,
  kSeagreen = 295,
  kSeashell = 296,
  kSienna = 297,
  kSkyblue = 298,
  kSlateblue = 299,
  kSlategray = 300,
  kSlategrey = 301,
  kSnow = 302,
  kSpringgreen = 303,
  kSteelblue = 304,
  kTan = 305,
  kThistle = 306,
  kTomato = 307,
  kTurquoise = 308,
  kViolet = 309,
  kWheat = 310,
  kWhitesmoke = 311,
  kYellowgreen = 312,
  kRepeat = 313,
  kRepeatX = 314,
  kRepeatY = 315,
  kNoRepeat = 316,
  kClear = 317,
  kCopy = 318,
  kSourceOver = 319,
  kSourceIn = 320,
  kSourceOut = 321,
  kSourceAtop = 322,
  kDestinationOver = 323,
  kDestinationIn = 324,
  kDestinationOut = 325,
  kDestinationAtop = 326,
  kXor = 327,
  kPlusLighter = 328,
  kSubtract = 329,
  kIntersect = 330,
  kExclude = 331,
  kBaseline = 332,
  kMiddle = 333,
  kSub = 334,
  kSuper = 335,
  kTextTop = 336,
  kTextBottom = 337,
  kTop = 338,
  kBottom = 339,
  kWebkitBaselineMiddle = 340,
  kWebkitAuto = 341,
  kLeft = 342,
  kRight = 343,
  kCenter = 344,
  kJustify = 345,
  kMatchParent = 346,
  kWebkitLeft = 347,
  kWebkitRight = 348,
  kWebkitCenter = 349,
  kWebkitMatchParent = 350,
  kInternalCenter = 351,
  kInlineStart = 352,
  kInlineEnd = 353,
  kOutside = 354,
  kInside = 355,
  kDisc = 356,
  kCircle = 357,
  kSquare = 358,
  kDisclosureOpen = 359,
  kDisclosureClosed = 360,
  kDecimal = 361,
  kInline = 362,
  kBlock = 363,
  kFlowRoot = 364,
  kFlow = 365,
  kTable = 366,
  kFlex = 367,
  kGrid = 368,
  kMasonry = 369,
  kContents = 370,
  kTableRowGroup = 371,
  kTableHeaderGroup = 372,
  kTableFooterGroup = 373,
  kTableRow = 374,
  kTableColumnGroup = 375,
  kTableColumn = 376,
  kTableCell = 377,
  kTableCaption = 378,
  kRubyText = 379,
  kInlineBlock = 380,
  kInlineTable = 381,
  kInlineFlex = 382,
  kInlineGrid = 383,
  kInlineMasonry = 384,
  kWebkitBox = 385,
  kWebkitInlineBox = 386,
  kWebkitFlex = 387,
  kWebkitInlineFlex = 388,
  kLayout = 389,
  kInlineLayout = 390,
  kListItem = 391,
  kAuto = 392,
  kCrosshair = 393,
  kDefault = 394,
  kPointer = 395,
  kMove = 396,
  kVerticalText = 397,
  kCell = 398,
  kContextMenu = 399,
  kAlias = 400,
  kProgress = 401,
  kNoDrop = 402,
  kNotAllowed = 403,
  kZoomIn = 404,
  kZoomOut = 405,
  kEResize = 406,
  kNeResize = 407,
  kNwResize = 408,
  kNResize = 409,
  kSeResize = 410,
  kSwResize = 411,
  kSResize = 412,
  kWResize = 413,
  kEwResize = 414,
  kNsResize = 415,
  kNeswResize = 416,
  kNwseResize = 417,
  kColResize = 418,
  kRowResize = 419,
  kText = 420,
  kWait = 421,
  kHelp = 422,
  kAllScroll = 423,
  kGrab = 424,
  kGrabbing = 425,
  kWebkitGrab = 426,
  kWebkitGrabbing = 427,
  kWebkitZoomIn = 428,
  kWebkitZoomOut = 429,
  kLtr = 430,
  kRtl = 431,
  kCapitalize = 432,
  kUppercase = 433,
  kLowercase = 434,
  kMathAuto = 435,
  kVisible = 436,
  kCollapse = 437,
  kPreserve = 438,
  kPreserveBreaks = 439,
  kPretty = 440,
  kA3 = 441,
  kA4 = 442,
  kA5 = 443,
  kAbove = 444,
  kAbsolute = 445,
  kAlways = 446,
  kAvoid = 447,
  kB4 = 448,
  kB5 = 449,
  kBelow = 450,
  kBidiOverride = 451,
  kBlink = 452,
  kBoth = 453,
  kBreakSpaces = 454,
  kCloseQuote = 455,
  kEmbed = 456,
  kFixed = 457,
  kHand = 458,
  kHide = 459,
  kIsolate = 460,
  kIsolateOverride = 461,
  kPlaintext = 462,
  kWebkitIsolate = 463,
  kWebkitIsolateOverride = 464,
  kWebkitPlaintext = 465,
  kJisB5 = 466,
  kJisB4 = 467,
  kLandscape = 468,
  kLedger = 469,
  kLegal = 470,
  kLetter = 471,
  kLineThrough = 472,
  kLocal = 473,
  kNoCloseQuote = 474,
  kNoOpenQuote = 475,
  kNowrap = 476,
  kOpenQuote = 477,
  kOverlay = 478,
  kOverline = 479,
  kPortrait = 480,
  kPre = 481,
  kPreLine = 482,
  kPreWrap = 483,
  kRelative = 484,
  kScroll = 485,
  kSeparate = 486,
  kShow = 487,
  kStatic = 488,
  kThick = 489,
  kThin = 490,
  kUnderline = 491,
  kView = 492,
  kWavy = 493,
  kCompact = 494,
  kStretch = 495,
  kStart = 496,
  kEnd = 497,
  kClone = 498,
  kSlice = 499,
  kReverse = 500,
  kHorizontal = 501,
  kVertical = 502,
  kInlineAxis = 503,
  kBlockAxis = 504,
  kFlexStart = 505,
  kFlexEnd = 506,
  kSpaceBetween = 507,
  kSpaceAround = 508,
  kSpaceEvenly = 509,
  kUnsafe = 510,
  kSafe = 511,
  kAnchorCenter = 512,
  kRow = 513,
  kRowReverse = 514,
  kColumn = 515,
  kColumnReverse = 516,
  kWrap = 517,
  kWrapReverse = 518,
  kAutoFlow = 519,
  kDense = 520,
  kReadOnly = 521,
  kReadWrite = 522,
  kReadWritePlaintextOnly = 523,
  kElement = 524,
  kWebkitMinContent = 525,
  kWebkitMaxContent = 526,
  kWebkitFillAvailable = 527,
  kWebkitFitContent = 528,
  kMinContent = 529,
  kMaxContent = 530,
  kFitContent = 531,
  kFromElement = 532,
  kNoAutospace = 533,
  kCap = 534,
  kEx = 535,
  kTrimBoth = 536,
  kTrimEnd = 537,
  kTrimStart = 538,
  kClip = 539,
  kEllipsis = 540,
  kSpellingError = 541,
  kGrammarError = 542,
  kFromFont = 543,
  kSpaceAll = 544,
  kSpaceFirst = 545,
  kBreakAll = 546,
  kKeepAll = 547,
  kAutoPhrase = 548,
  kBreakWord = 549,
  kSpace = 550,
  kLoose = 551,
  kStrict = 552,
  kAfterWhiteSpace = 553,
  kAnywhere = 554,
  kManual = 555,
  kCheckbox = 556,
  kRadio = 557,
  kButton = 558,
  kListbox = 559,
  kInternalMediaControl = 560,
  kMenulist = 561,
  kMenulistButton = 562,
  kMeter = 563,
  kProgressBar = 564,
  kSearchfield = 565,
  kTextfield = 566,
  kTextarea = 567,
  kSliderVertical = 568,
  kRound = 569,
  kBase = 570,
  kBaseSelect = 571,
  kInternalAutoBase = 572,
  kInternalPartialInterestContent = 573,
  kBorder = 574,
  kBorderBox = 575,
  kContent = 576,
  kContentBox = 577,
  kPadding = 578,
  kPaddingBox = 579,
  kMarginBox = 580,
  kNoClip = 581,
  kContain = 582,
  kCover = 583,
  kLogical = 584,
  kVisual = 585,
  kReplace = 586,
  kAccumulate = 587,
  kAlternate = 588,
  kAlternateReverse = 589,
  kForwards = 590,
  kBackwards = 591,
  kInfinite = 592,
  kRunning = 593,
  kPaused = 594,
  kFlat = 595,
  kPreserve3d = 596,
  kFillBox = 597,
  kViewBox = 598,
  kEase = 599,
  kLinear = 600,
  kEaseIn = 601,
  kEaseOut = 602,
  kEaseInOut = 603,
  kJumpBoth = 604,
  kJumpEnd = 605,
  kJumpNone = 606,
  kJumpStart = 607,
  kStepStart = 608,
  kStepEnd = 609,
  kSteps = 610,
  kFrames = 611,
  kCubicBezier = 612,
  kDocument = 613,
  kReset = 614,
  kZoom = 615,
  kVisiblepainted = 616,
  kVisiblefill = 617,
  kVisiblestroke = 618,
  kPainted = 619,
  kFill = 620,
  kStroke = 621,
  kBoundingBox = 622,
  kSpellOut = 623,
  kDigits = 624,
  kLiteralPunctuation = 625,
  kNoPunctuation = 626,
  kAntialiased = 627,
  kSubpixelAntialiased = 628,
  kOptimizespeed = 629,
  kOptimizelegibility = 630,
  kGeometricprecision = 631,
  kCrispedges = 632,
  kEconomy = 633,
  kExact = 634,
  kLr = 635,
  kRl = 636,
  kTb = 637,
  kLrTb = 638,
  kRlTb = 639,
  kTbRl = 640,
  kHorizontalTb = 641,
  kVerticalRl = 642,
  kVerticalLr = 643,
  kSidewaysRl = 644,
  kSidewaysLr = 645,
  kAfter = 646,
  kBefore = 647,
  kInterCharacter = 648,
  kOver = 649,
  kUnder = 650,
  kFilled = 651,
  kOpen = 652,
  kDot = 653,
  kDoubleCircle = 654,
  kTriangle = 655,
  kSesame = 656,
  kEllipse = 657,
  kClosestSide = 658,
  kClosestCorner = 659,
  kFarthestSide = 660,
  kFarthestCorner = 661,
  kMixed = 662,
  kSideways = 663,
  kSidewaysRight = 664,
  kUpright = 665,
  kVerticalRight = 666,
  kOn = 667,
  kOff = 668,
  kOptimizequality = 669,
  kPixelated = 670,
  kWebkitOptimizeContrast = 671,
  kFromImage = 672,
  kRotateLeft = 673,
  kRotateRight = 674,
  kNonzero = 675,
  kEvenodd = 676,
  kAt = 677,
  kAlphabetic = 678,
  kBorderless = 679,
  kFullscreen = 680,
  kStandalone = 681,
  kMinimalUi = 682,
  kBrowser = 683,
  kWindowControlsOverlay = 684,
  kTabbed = 685,
  kPictureInPicture = 686,
  kMinimized = 687,
  kMaximized = 688,
  kPaged = 689,
  kSlow = 690,
  kFast = 691,
  kSticky = 692,
  kCoarse = 693,
  kFine = 694,
  kOnDemand = 695,
  kHover = 696,
  kMultiply = 697,
  kScreen = 698,
  kDarken = 699,
  kLighten = 700,
  kColorDodge = 701,
  kColorBurn = 702,
  kHardLight = 703,
  kSoftLight = 704,
  kDifference = 705,
  kExclusion = 706,
  kHue = 707,
  kSaturation = 708,
  kColor = 709,
  kLuminosity = 710,
  kScaleDown = 711,
  kBalance = 712,
  kNotch = 713,
  kScoop = 714,
  kSquircle = 715,
  kSuperellipse = 716,
  kDrag = 717,
  kNoDrag = 718,
  kSpan = 719,
  kMinmax = 720,
  kSubgrid = 721,
  kProgressive = 722,
  kInterlace = 723,
  kMarkers = 724,
  kAlpha = 725,
  kLuminance = 726,
  kMatchSource = 727,
  kSRGB = 728,
  kLinearrgb = 729,
  kButt = 730,
  kMiter = 731,
  kBevel = 732,
  kBeforeEdge = 733,
  kAfterEdge = 734,
  kCentral = 735,
  kTextBeforeEdge = 736,
  kTextAfterEdge = 737,
  kIdeographic = 738,
  kHanging = 739,
  kMathematical = 740,
  kRowOverColumn = 741,
  kColumnOverRow = 742,
  kIntersection = 743,
  kSpanningItem = 744,
  kAround = 745,
  kBetween = 746,
  kUseScript = 747,
  kNoChange = 748,
  kResetSize = 749,
  kDynamic = 750,
  kNonScalingStroke = 751,
  kInternalExtendToZoom = 752,
  kPanX = 753,
  kPanY = 754,
  kPanLeft = 755,
  kPanRight = 756,
  kPanUp = 757,
  kPanDown = 758,
  kManipulation = 759,
  kPinchZoom = 760,
  kLastBaseline = 761,
  kFirstBaseline = 762,
  kFirst = 763,
  kLast = 764,
  kSelfStart = 765,
  kSelfEnd = 766,
  kLegacy = 767,
  kSmooth = 768,
  kScrollPosition = 769,
  kRevert = 770,
  kRevertLayer = 771,
  kRevertRule = 772,
  kUnset = 773,
  kLinearGradient = 774,
  kRadialGradient = 775,
  kConicGradient = 776,
  kRepeatingLinearGradient = 777,
  kRepeatingRadialGradient = 778,
  kRepeatingConicGradient = 779,
  kPaint = 780,
  kCrossFade = 781,
  kWebkitCrossFade = 782,
  kWebkitGradient = 783,
  kWebkitLinearGradient = 784,
  kWebkitRadialGradient = 785,
  kWebkitRepeatingLinearGradient = 786,
  kWebkitRepeatingRadialGradient = 787,
  kWebkitImageSet = 788,
  kImageSet = 789,
  kType = 790,
  kTo = 791,
  kColorStop = 792,
  kRadial = 793,
  kAttr = 794,
  kCounter = 795,
  kCounters = 796,
  kRect = 797,
  kPolygon = 798,
  kShape = 799,
  kBy = 800,
  kLine = 801,
  kClose = 802,
  kHline = 803,
  kVline = 804,
  kArc = 805,
  kCw = 806,
  kCcw = 807,
  kCurve = 808,
  kOrigin = 809,
  kWith = 810,
  kFormat = 811,
  kCollection = 812,
  kEmbeddedOpentype = 813,
  kOpentype = 814,
  kSVG = 815,
  kTruetype = 816,
  kWoff = 817,
  kWoff2 = 818,
  kTech = 819,
  kFeaturesOpentype = 820,
  kFeaturesAat = 821,
  kFeaturesGraphite = 822,
  kColorCOLRv0 = 823,
  kColorCOLRv1 = 824,
  kColorSVG = 825,
  kColorSbix = 826,
  kColorCBDT = 827,
  kVariations = 828,
  kPalettes = 829,
  kIncremental = 830,
  kInvert = 831,
  kGrayscale = 832,
  kSepia = 833,
  kSaturate = 834,
  kHueRotate = 835,
  kOpacity = 836,
  kBrightness = 837,
  kContrast = 838,
  kBlur = 839,
  kDropShadow = 840,
  kUrl = 841,
  kRgb = 842,
  kRgba = 843,
  kHsl = 844,
  kHsla = 845,
  kHwb = 846,
  kLab = 847,
  kOklab = 848,
  kLch = 849,
  kOklch = 850,
  kLightDark = 851,
  kSRGBLinear = 852,
  kDisplayP3 = 853,
  kDisplayP3Linear = 854,
  kA98Rgb = 855,
  kProphotoRgb = 856,
  kRec2100Linear = 857,
  kXyz = 858,
  kXyzD50 = 859,
  kXyzD65 = 860,
  kShorter = 861,
  kLonger = 862,
  kDecreasing = 863,
  kIncreasing = 864,
  kIn = 865,
  kColorMix = 866,
  kFrom = 867,
  kR = 868,
  kG = 869,
  kB = 870,
  kH = 871,
  kS = 872,
  kL = 873,
  kW = 874,
  kA = 875,
  kC = 876,
  kMatrix = 877,
  kMatrix3d = 878,
  kPerspective = 879,
  kRotate = 880,
  kRotateX = 881,
  kRotateY = 882,
  kRotateZ = 883,
  kRotate3d = 884,
  kScale = 885,
  kScaleX = 886,
  kScaleY = 887,
  kScaleZ = 888,
  kScale3d = 889,
  kSkew = 890,
  kSkewX = 891,
  kSkewY = 892,
  kTranslate = 893,
  kTranslateX = 894,
  kTranslateY = 895,
  kTranslateZ = 896,
  kTranslate3d = 897,
  kX = 898,
  kY = 899,
  kZ = 900,
  kPath = 901,
  kRay = 902,
  kSides = 903,
  kStrokeBox = 904,
  kHalfBorderBox = 905,
  kCalc = 906,
  kWebkitCalc = 907,
  kMin = 908,
  kMax = 909,
  kClamp = 910,
  kCalcSize = 911,
  kAny = 912,
  kSin = 913,
  kCos = 914,
  kAsin = 915,
  kAtan = 916,
  kAtan2 = 917,
  kAcos = 918,
  kMod = 919,
  kRem = 920,
  kUp = 921,
  kDown = 922,
  kToZero = 923,
  kSign = 924,
  kAbs = 925,
  kPow = 926,
  kSqrt = 927,
  kHypot = 928,
  kLog = 929,
  kExp = 930,
  kInfinity = 931,
  kNegativeInfinity = 932,
  kNan = 933,
  kPi = 934,
  kE = 935,
  kMandatory = 936,
  kProximity = 937,
  kStyle = 938,
  kSize = 939,
  kBlockSize = 940,
  kInlineSize = 941,
  kViewTransition = 942,
  kScrollState = 943,
  kBlockStart = 944,
  kBlockEnd = 945,
  kAnchored = 946,
  kAutoFill = 947,
  kAutoFit = 948,
  kVar = 949,
  kInternalVariableValue = 950,
  kEnv = 951,
  kArg = 952,
  kAvoidPage = 953,
  kPage = 954,
  kRecto = 955,
  kVerso = 956,
  kAvoidColumn = 957,
  kP3 = 958,
  kRec2020 = 959,
  kAdd = 960,
  kAutoAdd = 961,
  kTrue = 962,
  kFalse = 963,
  kNoPreference = 964,
  kDark = 965,
  kLight = 966,
  kOnly = 967,
  kReduce = 968,
  kActive = 969,
  kPreserveParentColor = 970,
  kBackButton = 971,
  kFabricated = 972,
  kSelector = 973,
  kAtRule = 974,
  kContinuous = 975,
  kFolded = 976,
  kStable = 977,
  kBothEdges = 978,
  kMore = 979,
  kLess = 980,
  kCustom = 981,
  kCyclic = 982,
  kSymbolic = 983,
  kNumeric = 984,
  kAdditive = 985,
  kExtends = 986,
  kInternalSimpChineseInformal = 987,
  kInternalSimpChineseFormal = 988,
  kInternalTradChineseInformal = 989,
  kInternalTradChineseFormal = 990,
  kInternalKoreanHangulFormal = 991,
  kInternalKoreanHanjaInformal = 992,
  kInternalKoreanHanjaFormal = 993,
  kInternalHebrew = 994,
  kInternalLowerArmenian = 995,
  kInternalUpperArmenian = 996,
  kInternalEthiopicNumeric = 997,
  kBullets = 998,
  kNumbers = 999,
  kWords = 1000,
  kStandard = 1001,
  kHigh = 1002,
  kNoLimit = 1003,
  kConstrained = 1004,
  kDynamicRangeLimitMix = 1005,
  kLayer = 1006,
  kSupports = 1007,
  kScope = 1008,
  kColorContrast = 1009,
  kVs = 1010,
  kAA = 1011,
  kAALarge = 1012,
  kAAA = 1013,
  kAAALarge = 1014,
  kDrop = 1015,
  kRaise = 1016,
  kXywh = 1017,
  kAnchor = 1018,
  kAnchorSize = 1019,
  kWidth = 1020,
  kHeight = 1021,
  kSelfBlock = 1022,
  kSelfInline = 1023,
  kEntry = 1024,
  kExit = 1025,
  kEntryCrossing = 1026,
  kExitCrossing = 1027,
  kRoot = 1028,
  kNearest = 1029,
  kSelf = 1030,
  kAllowDiscrete = 1031,
  kInverted = 1032,
  kLayered = 1033,
  kMatchElement = 1034,
  kEnabled = 1035,
  kInitialOnly = 1036,
  kSpanLeft = 1037,
  kSpanRight = 1038,
  kXStart = 1039,
  kXEnd = 1040,
  kSpanXStart = 1041,
  kSpanXEnd = 1042,
  kXSelfStart = 1043,
  kXSelfEnd = 1044,
  kSpanXSelfStart = 1045,
  kSpanXSelfEnd = 1046,
  kSelfXStart = 1047,
  kSelfXEnd = 1048,
  kSpanSelfXStart = 1049,
  kSpanSelfXEnd = 1050,
  kSpanAll = 1051,
  kSpanTop = 1052,
  kSpanBottom = 1053,
  kYStart = 1054,
  kYEnd = 1055,
  kSpanYStart = 1056,
  kSpanYEnd = 1057,
  kYSelfStart = 1058,
  kYSelfEnd = 1059,
  kSpanYSelfStart = 1060,
  kSpanYSelfEnd = 1061,
  kSelfYStart = 1062,
  kSelfYEnd = 1063,
  kSpanSelfYStart = 1064,
  kSpanSelfYEnd = 1065,
  kSpanBlockStart = 1066,
  kSpanBlockEnd = 1067,
  kSelfBlockStart = 1068,
  kSelfBlockEnd = 1069,
  kSpanSelfBlockStart = 1070,
  kSpanSelfBlockEnd = 1071,
  kSpanInlineStart = 1072,
  kSpanInlineEnd = 1073,
  kSelfInlineStart = 1074,
  kSelfInlineEnd = 1075,
  kSpanSelfInlineStart = 1076,
  kSpanSelfInlineEnd = 1077,
  kSpanStart = 1078,
  kSpanEnd = 1079,
  kSpanSelfStart = 1080,
  kSpanSelfEnd = 1081,
  kPositionArea = 1082,
  kInternalTextareaAuto = 1083,
  kMostWidth = 1084,
  kMostHeight = 1085,
  kMostBlockSize = 1086,
  kMostInlineSize = 1087,
  kFlipBlock = 1088,
  kFlipInline = 1089,
  kFlipStart = 1090,
  kAnchorsVisible = 1091,
  kNoOverflow = 1092,
  kFlexVisual = 1093,
  kFlexFlow = 1094,
  kGridRows = 1095,
  kGridColumns = 1096,
  kGridOrder = 1097,
  kSourceOrder = 1098,
  kContextFill = 1099,
  kContextStroke = 1100,
  kPerLine = 1101,
  kConsistent = 1102,
  kFontSize = 1103,
  kScaleInline = 1104,
  kLetterSpacing = 1105,
  kMediaProgress = 1106,
  kContainerProgress = 1107,
  kOf = 1108,
  kBlinkFeature = 1109,
  kNumericOnly = 1110,
  kAllowKeywords = 1111,
  kInert = 1112,
  kSiblingCount = 1113,
  kSiblingIndex = 1114,
  kIdent = 1115,
  kReturns = 1116,
  kOnce = 1117,
  kState = 1118,
  kIf = 1119,
  kElse = 1120,
  kMedia = 1121,
  kTabs = 1122,
  kLinks = 1123,
  kBar = 1124,
  kUnderscore = 1125,
  kWebkitLegacy = 1126,
  kNoEllipsis = 1127,
  kInterWord = 1128,
  kPlay = 1129,
  kPause = 1130,
  kPlayOnce = 1131,
  kPlayAlternate = 1132,
  kPlayForwards = 1133,
  kPlayBackwards = 1134,
  kPlayPause = 1135,
  kReplay = 1136,
};

constexpr int kNumCSSValueKeywords = 1137;
constexpr size_t kMaxCSSValueKeywordLength = 42;

inline bool IsValidCSSValueID(CSSValueID id)
{
    return id != CSSValueID::kInvalid;
}

CORE_EXPORT std::string_view GetCSSValueName(CSSValueID);

template <typename StringType>
inline StringType GetCSSValueNameAs(CSSValueID value_id) {
  return StringType(base::as_byte_span(GetCSSValueName(value_id)));
}

bool IsValueAllowedInMode(CSSValueID id, CSSParserMode mode);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_VALUE_KEYWORDS_H_
