// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_SESSION_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_SESSION_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class XRDOMOverlayInit;
class XRDepthStateInit;
class XRTrackedImageInit;

class MODULES_EXPORT XRSessionInit : public bindings::InputDictionaryBase {
  
  public:
static XRSessionInit* Create() {
  return MakeGarbageCollected<XRSessionInit>();
}
static XRSessionInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRSessionInit>(isolate);
}
static XRSessionInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRSessionInit();
explicit  XRSessionInit(v8::Isolate* isolate);

bool hasDepthSensing() const {
  return has_depth_sensing_;
}
XRDepthStateInit* depthSensing() const {
  DCHECK(hasDepthSensing());
return member_depth_sensing_.Get();
}
XRDepthStateInit* getDepthSensingOr(XRDepthStateInit* fallback_value) const {
  if (!hasDepthSensing()) {
  return fallback_value;
}
return member_depth_sensing_.Get();
}
void setDepthSensing(XRDepthStateInit* value) {
  member_depth_sensing_ = value;
has_depth_sensing_ = true;
DCHECK(member_depth_sensing_);
}

bool hasDomOverlay() const {
  return has_dom_overlay_;
}
XRDOMOverlayInit* domOverlay() const {
  DCHECK(hasDomOverlay());
return member_dom_overlay_.Get();
}
XRDOMOverlayInit* getDomOverlayOr(XRDOMOverlayInit* fallback_value) const {
  if (!hasDomOverlay()) {
  return fallback_value;
}
return member_dom_overlay_.Get();
}
void setDomOverlay(XRDOMOverlayInit* value) {
  member_dom_overlay_ = value;
has_dom_overlay_ = true;
DCHECK(member_dom_overlay_);
}

bool hasOptionalFeatures() const {
  return has_optional_features_;
}
const Vector<String>& optionalFeatures() const {
  DCHECK(hasOptionalFeatures());
return member_optional_features_;
}
Vector<String> getOptionalFeaturesOr(const Vector<String>& fallback_value) const;
Vector<String> getOptionalFeaturesOr(Vector<String>&& fallback_value) const;
void setOptionalFeatures(const Vector<String>& value);
void setOptionalFeatures(Vector<String>&& value);

bool hasRequiredFeatures() const {
  return has_required_features_;
}
const Vector<String>& requiredFeatures() const {
  DCHECK(hasRequiredFeatures());
return member_required_features_;
}
Vector<String> getRequiredFeaturesOr(const Vector<String>& fallback_value) const;
Vector<String> getRequiredFeaturesOr(Vector<String>&& fallback_value) const;
void setRequiredFeatures(const Vector<String>& value);
void setRequiredFeatures(Vector<String>&& value);

bool hasTrackedImages() const {
  return has_tracked_images_;
}
const HeapVector<Member<XRTrackedImageInit>>& trackedImages() const {
  DCHECK(hasTrackedImages());
return member_tracked_images_;
}
HeapVector<Member<XRTrackedImageInit>> getTrackedImagesOr(const HeapVector<Member<XRTrackedImageInit>>& fallback_value) const;
HeapVector<Member<XRTrackedImageInit>> getTrackedImagesOr(HeapVector<Member<XRTrackedImageInit>>&& fallback_value) const;
void setTrackedImages(const HeapVector<Member<XRTrackedImageInit>>& value);
void setTrackedImages(HeapVector<Member<XRTrackedImageInit>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_depth_sensing_ = false;
bool has_dom_overlay_ = false;
bool has_optional_features_ = false;
bool has_required_features_ = false;
bool has_tracked_images_ = false;

Member<XRDepthStateInit> member_depth_sensing_;
Member<XRDOMOverlayInit> member_dom_overlay_;
Vector<String> member_optional_features_;
Vector<String> member_required_features_;
HeapVector<Member<XRTrackedImageInit>> member_tracked_images_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_SESSION_INIT_H_
