// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_RENDER_STATE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_RENDER_STATE_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRLayer;
class XRWebGLLayer;

class MODULES_EXPORT XRRenderStateInit : public bindings::InputDictionaryBase {
  
  public:
static XRRenderStateInit* Create() {
  return MakeGarbageCollected<XRRenderStateInit>();
}
static XRRenderStateInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRRenderStateInit>(isolate);
}
static XRRenderStateInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRRenderStateInit();
explicit  XRRenderStateInit(v8::Isolate* isolate);

bool hasBaseLayer() const {
  return has_base_layer_;
}
XRWebGLLayer* baseLayer() const {
  DCHECK(hasBaseLayer());
return member_base_layer_.Get();
}
XRWebGLLayer* getBaseLayerOr(XRWebGLLayer* fallback_value) const {
  if (!hasBaseLayer()) {
  return fallback_value;
}
return member_base_layer_.Get();
}
void setBaseLayer(XRWebGLLayer* value) {
  member_base_layer_ = value;
has_base_layer_ = true;
}

bool hasDepthFar() const {
  return has_depth_far_;
}
double depthFar() const {
  DCHECK(hasDepthFar());
return member_depth_far_;
}
double getDepthFarOr(double fallback_value) const {
  if (!hasDepthFar()) {
  return fallback_value;
}
return member_depth_far_;
}
void setDepthFar(double value) {
  member_depth_far_ = value;
has_depth_far_ = true;
}

bool hasDepthNear() const {
  return has_depth_near_;
}
double depthNear() const {
  DCHECK(hasDepthNear());
return member_depth_near_;
}
double getDepthNearOr(double fallback_value) const {
  if (!hasDepthNear()) {
  return fallback_value;
}
return member_depth_near_;
}
void setDepthNear(double value) {
  member_depth_near_ = value;
has_depth_near_ = true;
}

bool hasInlineVerticalFieldOfView() const {
  return has_inline_vertical_field_of_view_;
}
double inlineVerticalFieldOfView() const {
  DCHECK(hasInlineVerticalFieldOfView());
return member_inline_vertical_field_of_view_;
}
double getInlineVerticalFieldOfViewOr(double fallback_value) const {
  if (!hasInlineVerticalFieldOfView()) {
  return fallback_value;
}
return member_inline_vertical_field_of_view_;
}
void setInlineVerticalFieldOfView(double value) {
  member_inline_vertical_field_of_view_ = value;
has_inline_vertical_field_of_view_ = true;
}

bool hasLayers() const {
  return has_layers_;
}
GCedHeapVector<Member<XRLayer>>* layers() const {
  DCHECK(hasLayers());
return member_layers_.Get();
}
GCedHeapVector<Member<XRLayer>>* getLayersOr(GCedHeapVector<Member<XRLayer>>* fallback_value) const {
  if (!hasLayers()) {
  return fallback_value;
}
return member_layers_.Get();
}
void setLayers(GCedHeapVector<Member<XRLayer>>* value) {
  member_layers_ = value;
has_layers_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_base_layer_ = false;
bool has_depth_far_ = false;
bool has_depth_near_ = false;
bool has_inline_vertical_field_of_view_ = false;
bool has_layers_ = false;

Member<XRWebGLLayer> member_base_layer_;
double member_depth_far_;
double member_depth_near_;
double member_inline_vertical_field_of_view_;
Member<GCedHeapVector<Member<XRLayer>>> member_layers_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_RENDER_STATE_INIT_H_
