// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBGL_CONTEXT_ATTRIBUTES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBGL_CONTEXT_ATTRIBUTES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_power_preference.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebGLContextAttributes : public bindings::DictionaryBase {
  
  public:
static WebGLContextAttributes* Create() {
  return MakeGarbageCollected<WebGLContextAttributes>();
}
static WebGLContextAttributes* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebGLContextAttributes>(isolate);
}
static WebGLContextAttributes* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebGLContextAttributes();
explicit  WebGLContextAttributes(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
bool alpha() const {
  return member_alpha_;
}
void setAlpha(bool value) {
  member_alpha_ = value;
}

bool hasAntialias() const {
  return true;
}
bool antialias() const {
  return member_antialias_;
}
void setAntialias(bool value) {
  member_antialias_ = value;
}

bool hasDepth() const {
  return true;
}
bool depth() const {
  return member_depth_;
}
void setDepth(bool value) {
  member_depth_ = value;
}

bool hasDesynchronized() const {
  return true;
}
bool desynchronized() const {
  return member_desynchronized_;
}
void setDesynchronized(bool value) {
  member_desynchronized_ = value;
}

bool hasFailIfMajorPerformanceCaveat() const {
  return true;
}
bool failIfMajorPerformanceCaveat() const {
  return member_fail_if_major_performance_caveat_;
}
void setFailIfMajorPerformanceCaveat(bool value) {
  member_fail_if_major_performance_caveat_ = value;
}

bool hasPowerPreference() const {
  return true;
}
V8WebGLPowerPreference powerPreference() const {
  return member_power_preference_;
}
void setPowerPreference(V8WebGLPowerPreference value) {
  member_power_preference_ = value;
}
void setPowerPreference(V8WebGLPowerPreference::Enum value) {
  member_power_preference_ = V8WebGLPowerPreference(value);
}

bool hasPremultipliedAlpha() const {
  return true;
}
bool premultipliedAlpha() const {
  return member_premultiplied_alpha_;
}
void setPremultipliedAlpha(bool value) {
  member_premultiplied_alpha_ = value;
}

bool hasPreserveDrawingBuffer() const {
  return true;
}
bool preserveDrawingBuffer() const {
  return member_preserve_drawing_buffer_;
}
void setPreserveDrawingBuffer(bool value) {
  member_preserve_drawing_buffer_ = value;
}

bool hasStencil() const {
  return true;
}
bool stencil() const {
  return member_stencil_;
}
void setStencil(bool value) {
  member_stencil_ = value;
}

bool hasXrCompatible() const {
  return true;
}
bool xrCompatible() const {
  return member_xr_compatible_;
}
void setXrCompatible(bool value) {
  member_xr_compatible_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_alpha_{true};
bool member_antialias_{true};
bool member_depth_{true};
bool member_desynchronized_{false};
bool member_fail_if_major_performance_caveat_{false};
V8WebGLPowerPreference member_power_preference_{V8WebGLPowerPreference::Enum::kDefault};
bool member_premultiplied_alpha_{true};
bool member_preserve_drawing_buffer_{false};
bool member_stencil_{false};
bool member_xr_compatible_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEBGL_CONTEXT_ATTRIBUTES_H_
