// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class WebTransportHash;

class MODULES_EXPORT WebTransportOptions : public bindings::InputDictionaryBase {
  
  public:
static WebTransportOptions* Create() {
  return MakeGarbageCollected<WebTransportOptions>();
}
static WebTransportOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebTransportOptions>(isolate);
}
static WebTransportOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebTransportOptions();
explicit  WebTransportOptions(v8::Isolate* isolate);

bool hasProtocols() const {
  return has_protocols_;
}
const Vector<String>& protocols() const {
  DCHECK(hasProtocols());
return member_protocols_;
}
Vector<String> getProtocolsOr(const Vector<String>& fallback_value) const;
Vector<String> getProtocolsOr(Vector<String>&& fallback_value) const;
void setProtocols(const Vector<String>& value);
void setProtocols(Vector<String>&& value);

bool hasServerCertificateHashes() const {
  return has_server_certificate_hashes_;
}
const HeapVector<Member<WebTransportHash>>& serverCertificateHashes() const {
  DCHECK(hasServerCertificateHashes());
return member_server_certificate_hashes_;
}
HeapVector<Member<WebTransportHash>> getServerCertificateHashesOr(const HeapVector<Member<WebTransportHash>>& fallback_value) const;
HeapVector<Member<WebTransportHash>> getServerCertificateHashesOr(HeapVector<Member<WebTransportHash>>&& fallback_value) const;
void setServerCertificateHashes(const HeapVector<Member<WebTransportHash>>& value);
void setServerCertificateHashes(HeapVector<Member<WebTransportHash>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_protocols_ = false;
bool has_server_certificate_hashes_ = false;

Vector<String> member_protocols_;
HeapVector<Member<WebTransportHash>> member_server_certificate_hashes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_OPTIONS_H_
