// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_HASH_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_HASH_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT WebTransportHash : public bindings::InputDictionaryBase {
  
  public:
static WebTransportHash* Create() {
  return MakeGarbageCollected<WebTransportHash>();
}
static WebTransportHash* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebTransportHash>(isolate);
}
static WebTransportHash* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebTransportHash();
explicit  WebTransportHash(v8::Isolate* isolate);

bool hasAlgorithm() const {
  return has_algorithm_;
}
const String& algorithm() const {
  DCHECK(hasAlgorithm());
return member_algorithm_;
}
String getAlgorithmOr(const String& fallback_value) const;
String getAlgorithmOr(String&& fallback_value) const;
void setAlgorithm(const String& value);
void setAlgorithm(String&& value);

bool hasValue() const {
  return has_value_;
}
V8UnionArrayBufferOrArrayBufferView* value() const {
  DCHECK(hasValue());
return member_value_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getValueOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasValue()) {
  return fallback_value;
}
return member_value_.Get();
}
void setValue(V8UnionArrayBufferOrArrayBufferView* value) {
  member_value_ = value;
has_value_ = true;
DCHECK(member_value_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_algorithm_ = false;
bool has_value_ = false;

String member_algorithm_;
Member<V8UnionArrayBufferOrArrayBufferView> member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_HASH_H_
