// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_ERROR_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_ERROR_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebTransportErrorInit : public bindings::InputDictionaryBase {
  
  public:
static WebTransportErrorInit* Create() {
  return MakeGarbageCollected<WebTransportErrorInit>();
}
static WebTransportErrorInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebTransportErrorInit>(isolate);
}
static WebTransportErrorInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebTransportErrorInit();
explicit  WebTransportErrorInit(v8::Isolate* isolate);

bool hasMessage() const {
  return has_message_;
}
const String& message() const {
  DCHECK(hasMessage());
return member_message_;
}
String getMessageOr(const String& fallback_value) const;
String getMessageOr(String&& fallback_value) const;
void setMessage(const String& value);
void setMessage(String&& value);

bool hasStreamErrorCode() const {
  return has_stream_error_code_;
}
uint8_t streamErrorCode() const {
  DCHECK(hasStreamErrorCode());
return member_stream_error_code_;
}
uint8_t getStreamErrorCodeOr(uint8_t fallback_value) const {
  if (!hasStreamErrorCode()) {
  return fallback_value;
}
return member_stream_error_code_;
}
void setStreamErrorCode(uint8_t value) {
  member_stream_error_code_ = value;
has_stream_error_code_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_message_ = false;
bool has_stream_error_code_ = false;

String member_message_;
uint8_t member_stream_error_code_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_ERROR_INIT_H_
