// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_MEDIA_SIZE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_MEDIA_SIZE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8UnionUnsignedLongOrWebPrintingRange;
class WebPrintingRange;

class MODULES_EXPORT WebPrintingMediaSize : public bindings::DictionaryBase {
  
  public:
static WebPrintingMediaSize* Create() {
  return MakeGarbageCollected<WebPrintingMediaSize>();
}
static WebPrintingMediaSize* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrintingMediaSize>(isolate);
}
static WebPrintingMediaSize* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrintingMediaSize();
explicit  WebPrintingMediaSize(v8::Isolate* isolate);

bool hasXDimension() const {
  return has_x_dimension_;
}
V8UnionUnsignedLongOrWebPrintingRange* xDimension() const {
  DCHECK(hasXDimension());
return member_x_dimension_.Get();
}
V8UnionUnsignedLongOrWebPrintingRange* getXDimensionOr(V8UnionUnsignedLongOrWebPrintingRange* fallback_value) const {
  if (!hasXDimension()) {
  return fallback_value;
}
return member_x_dimension_.Get();
}
void setXDimension(V8UnionUnsignedLongOrWebPrintingRange* value) {
  member_x_dimension_ = value;
has_x_dimension_ = true;
DCHECK(member_x_dimension_);
}

bool hasYDimension() const {
  return has_y_dimension_;
}
V8UnionUnsignedLongOrWebPrintingRange* yDimension() const {
  DCHECK(hasYDimension());
return member_y_dimension_.Get();
}
V8UnionUnsignedLongOrWebPrintingRange* getYDimensionOr(V8UnionUnsignedLongOrWebPrintingRange* fallback_value) const {
  if (!hasYDimension()) {
  return fallback_value;
}
return member_y_dimension_.Get();
}
void setYDimension(V8UnionUnsignedLongOrWebPrintingRange* value) {
  member_y_dimension_ = value;
has_y_dimension_ = true;
DCHECK(member_y_dimension_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_x_dimension_ = false;
bool has_y_dimension_ = false;

Member<V8UnionUnsignedLongOrWebPrintingRange> member_x_dimension_;
Member<V8UnionUnsignedLongOrWebPrintingRange> member_y_dimension_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_MEDIA_SIZE_H_
