// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_MEDIA_COLLECTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_MEDIA_COLLECTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class WebPrintingMediaSize;

class MODULES_EXPORT WebPrintingMediaCollection : public bindings::DictionaryBase {
  
  public:
static WebPrintingMediaCollection* Create() {
  return MakeGarbageCollected<WebPrintingMediaCollection>();
}
static WebPrintingMediaCollection* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrintingMediaCollection>(isolate);
}
static WebPrintingMediaCollection* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrintingMediaCollection();
explicit  WebPrintingMediaCollection(v8::Isolate* isolate);

bool hasMediaSize() const {
  return has_media_size_;
}
WebPrintingMediaSize* mediaSize() const {
  DCHECK(hasMediaSize());
return member_media_size_.Get();
}
WebPrintingMediaSize* getMediaSizeOr(WebPrintingMediaSize* fallback_value) const {
  if (!hasMediaSize()) {
  return fallback_value;
}
return member_media_size_.Get();
}
void setMediaSize(WebPrintingMediaSize* value) {
  member_media_size_ = value;
has_media_size_ = true;
DCHECK(member_media_size_);
}

bool hasMediaSizeName() const {
  return has_media_size_name_;
}
const String& mediaSizeName() const {
  DCHECK(hasMediaSizeName());
return member_media_size_name_;
}
String getMediaSizeNameOr(const String& fallback_value) const;
String getMediaSizeNameOr(String&& fallback_value) const;
void setMediaSizeName(const String& value);
void setMediaSizeName(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_media_size_ = false;
bool has_media_size_name_ = false;

Member<WebPrintingMediaSize> member_media_size_;
String member_media_size_name_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINTING_MEDIA_COLLECTION_H_
