// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINT_JOB_ATTRIBUTES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINT_JOB_ATTRIBUTES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_job_state.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebPrintJobAttributes : public bindings::DictionaryBase {
  
  public:
static WebPrintJobAttributes* Create() {
  return MakeGarbageCollected<WebPrintJobAttributes>();
}
static WebPrintJobAttributes* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebPrintJobAttributes>(isolate);
}
static WebPrintJobAttributes* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebPrintJobAttributes();
explicit  WebPrintJobAttributes(v8::Isolate* isolate);

bool hasJobName() const {
  return has_job_name_;
}
const String& jobName() const {
  DCHECK(hasJobName());
return member_job_name_;
}
String getJobNameOr(const String& fallback_value) const;
String getJobNameOr(String&& fallback_value) const;
void setJobName(const String& value);
void setJobName(String&& value);

bool hasJobPages() const {
  return has_job_pages_;
}
uint32_t jobPages() const {
  DCHECK(hasJobPages());
return member_job_pages_;
}
uint32_t getJobPagesOr(uint32_t fallback_value) const {
  if (!hasJobPages()) {
  return fallback_value;
}
return member_job_pages_;
}
void setJobPages(uint32_t value) {
  member_job_pages_ = value;
has_job_pages_ = true;
}

bool hasJobPagesCompleted() const {
  return has_job_pages_completed_;
}
uint32_t jobPagesCompleted() const {
  DCHECK(hasJobPagesCompleted());
return member_job_pages_completed_;
}
uint32_t getJobPagesCompletedOr(uint32_t fallback_value) const {
  if (!hasJobPagesCompleted()) {
  return fallback_value;
}
return member_job_pages_completed_;
}
void setJobPagesCompleted(uint32_t value) {
  member_job_pages_completed_ = value;
has_job_pages_completed_ = true;
}

bool hasJobState() const {
  return has_job_state_;
}
V8WebPrintJobState jobState() const {
  DCHECK(hasJobState());
return member_job_state_;
}
V8WebPrintJobState getJobStateOr(V8WebPrintJobState fallback_value) const {
  if (!hasJobState()) {
  return fallback_value;
}
return member_job_state_;
}
void setJobState(V8WebPrintJobState value) {
  member_job_state_ = value;
has_job_state_ = true;
}
void setJobState(V8WebPrintJobState::Enum value) {
  member_job_state_ = V8WebPrintJobState(value);
has_job_state_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_job_name_ = false;
bool has_job_pages_ = false;
bool has_job_pages_completed_ = false;
bool has_job_state_ = false;

String member_job_name_;
uint32_t member_job_pages_;
uint32_t member_job_pages_completed_;
V8WebPrintJobState member_job_state_{static_cast<V8WebPrintJobState::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_PRINT_JOB_ATTRIBUTES_H_
