// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_METADATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_METADATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class BackgroundBlur;
class ExceptionState;

class MODULES_EXPORT VideoFrameMetadata : public bindings::DictionaryBase {
  
  public:
static VideoFrameMetadata* Create() {
  return MakeGarbageCollected<VideoFrameMetadata>();
}
static VideoFrameMetadata* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoFrameMetadata>(isolate);
}
static VideoFrameMetadata* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoFrameMetadata();
explicit  VideoFrameMetadata(v8::Isolate* isolate);

bool hasBackgroundBlur() const {
  return has_background_blur_;
}
BackgroundBlur* backgroundBlur() const {
  DCHECK(hasBackgroundBlur());
return member_background_blur_.Get();
}
BackgroundBlur* getBackgroundBlurOr(BackgroundBlur* fallback_value) const {
  if (!hasBackgroundBlur()) {
  return fallback_value;
}
return member_background_blur_.Get();
}
void setBackgroundBlur(BackgroundBlur* value) {
  member_background_blur_ = value;
has_background_blur_ = true;
DCHECK(member_background_blur_);
}

bool hasRtpTimestamp() const {
  return has_rtp_timestamp_;
}
uint32_t rtpTimestamp() const {
  DCHECK(hasRtpTimestamp());
return member_rtp_timestamp_;
}
uint32_t getRtpTimestampOr(uint32_t fallback_value) const {
  if (!hasRtpTimestamp()) {
  return fallback_value;
}
return member_rtp_timestamp_;
}
void setRtpTimestamp(uint32_t value) {
  member_rtp_timestamp_ = value;
has_rtp_timestamp_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_background_blur_ = false;
bool has_rtp_timestamp_ = false;

Member<BackgroundBlur> member_background_blur_;
uint32_t member_rtp_timestamp_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_FRAME_METADATA_H_
