// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame_callback_metadata.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"captureTime",
"expectedDisplayTime",
"height",
"mediaTime",
"presentationTime",
"presentedFrames",
"processingDuration",
"receiveTime",
"rtpTimestamp",
"width",
};


}  // namespace 

VideoFrameCallbackMetadata* VideoFrameCallbackMetadata::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoFrameCallbackMetadata* dictionary = MakeGarbageCollected<VideoFrameCallbackMetadata>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoFrameCallbackMetadata";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoFrameCallbackMetadata::VideoFrameCallbackMetadata() {
  
}

 VideoFrameCallbackMetadata::VideoFrameCallbackMetadata(v8::Isolate* isolate) {
  
}




























































void VideoFrameCallbackMetadata::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void VideoFrameCallbackMetadata::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void VideoFrameCallbackMetadata::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCaptureTime()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_capture_time_);
DCHECK(!values[0].IsEmpty());
}
if (hasExpectedDisplayTime()) {
  values[1] = ToV8Traits<IDLDouble>::ToV8(script_state, member_expected_display_time_);
DCHECK(!values[1].IsEmpty());
}
if (hasHeight()) {
  values[2] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_height_);
DCHECK(!values[2].IsEmpty());
}
if (hasMediaTime()) {
  values[3] = ToV8Traits<IDLDouble>::ToV8(script_state, member_media_time_);
DCHECK(!values[3].IsEmpty());
}
if (hasPresentationTime()) {
  values[4] = ToV8Traits<IDLDouble>::ToV8(script_state, member_presentation_time_);
DCHECK(!values[4].IsEmpty());
}
if (hasPresentedFrames()) {
  values[5] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_presented_frames_);
DCHECK(!values[5].IsEmpty());
}
if (hasProcessingDuration()) {
  values[6] = ToV8Traits<IDLDouble>::ToV8(script_state, member_processing_duration_);
DCHECK(!values[6].IsEmpty());
}
if (hasReceiveTime()) {
  values[7] = ToV8Traits<IDLDouble>::ToV8(script_state, member_receive_time_);
DCHECK(!values[7].IsEmpty());
}
if (hasRtpTimestamp()) {
  values[8] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_rtp_timestamp_);
DCHECK(!values[8].IsEmpty());
}
if (hasWidth()) {
  values[9] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_width_);
DCHECK(!values[9].IsEmpty());
}
}

const void* VideoFrameCallbackMetadata::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> VideoFrameCallbackMetadata::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void VideoFrameCallbackMetadata::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoFrameCallbackMetadata";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("captureTime");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_capture_time_, member_capture_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("expectedDisplayTime");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_expected_display_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_media_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("presentationTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_presentation_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("presentedFrames");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_presented_frames_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("processingDuration");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_processing_duration_, member_processing_duration_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("receiveTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_receive_time_, member_receive_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rtpTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_rtp_timestamp_, member_rtp_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> VideoFrameCallbackMetadata::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
