// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_ENCODE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_ENCODE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class VideoEncoderBuffer;
class VideoEncoderEncodeOptionsForAv1;
class VideoEncoderEncodeOptionsForAvc;
class VideoEncoderEncodeOptionsForHevc;
class VideoEncoderEncodeOptionsForVp9;

class MODULES_EXPORT VideoEncoderEncodeOptions : public bindings::InputDictionaryBase {
  
  public:
static VideoEncoderEncodeOptions* Create() {
  return MakeGarbageCollected<VideoEncoderEncodeOptions>();
}
static VideoEncoderEncodeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoEncoderEncodeOptions>(isolate);
}
static VideoEncoderEncodeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoEncoderEncodeOptions();
explicit  VideoEncoderEncodeOptions(v8::Isolate* isolate);

bool hasAv1() const {
  return has_av_1_;
}
VideoEncoderEncodeOptionsForAv1* av1() const {
  DCHECK(hasAv1());
return member_av_1_.Get();
}
VideoEncoderEncodeOptionsForAv1* getAv1Or(VideoEncoderEncodeOptionsForAv1* fallback_value) const {
  if (!hasAv1()) {
  return fallback_value;
}
return member_av_1_.Get();
}
void setAv1(VideoEncoderEncodeOptionsForAv1* value) {
  member_av_1_ = value;
has_av_1_ = true;
DCHECK(member_av_1_);
}

bool hasAvc() const {
  return has_avc_;
}
VideoEncoderEncodeOptionsForAvc* avc() const {
  DCHECK(hasAvc());
return member_avc_.Get();
}
VideoEncoderEncodeOptionsForAvc* getAvcOr(VideoEncoderEncodeOptionsForAvc* fallback_value) const {
  if (!hasAvc()) {
  return fallback_value;
}
return member_avc_.Get();
}
void setAvc(VideoEncoderEncodeOptionsForAvc* value) {
  member_avc_ = value;
has_avc_ = true;
DCHECK(member_avc_);
}

bool hasHevc() const {
  return has_hevc_;
}
VideoEncoderEncodeOptionsForHevc* hevc() const {
  DCHECK(hasHevc());
return member_hevc_.Get();
}
VideoEncoderEncodeOptionsForHevc* getHevcOr(VideoEncoderEncodeOptionsForHevc* fallback_value) const {
  if (!hasHevc()) {
  return fallback_value;
}
return member_hevc_.Get();
}
void setHevc(VideoEncoderEncodeOptionsForHevc* value) {
  member_hevc_ = value;
has_hevc_ = true;
DCHECK(member_hevc_);
}

bool hasKeyFrame() const {
  return true;
}
bool keyFrame() const {
  return member_key_frame_;
}
void setKeyFrame(bool value) {
  member_key_frame_ = value;
}

bool hasReferenceBuffers() const {
  return has_reference_buffers_;
}
const HeapVector<Member<VideoEncoderBuffer>>& referenceBuffers() const {
  DCHECK(hasReferenceBuffers());
return member_reference_buffers_;
}
HeapVector<Member<VideoEncoderBuffer>> getReferenceBuffersOr(const HeapVector<Member<VideoEncoderBuffer>>& fallback_value) const;
HeapVector<Member<VideoEncoderBuffer>> getReferenceBuffersOr(HeapVector<Member<VideoEncoderBuffer>>&& fallback_value) const;
void setReferenceBuffers(const HeapVector<Member<VideoEncoderBuffer>>& value);
void setReferenceBuffers(HeapVector<Member<VideoEncoderBuffer>>&& value);

bool hasUpdateBuffer() const {
  return has_update_buffer_;
}
VideoEncoderBuffer* updateBuffer() const {
  DCHECK(hasUpdateBuffer());
return member_update_buffer_.Get();
}
VideoEncoderBuffer* getUpdateBufferOr(VideoEncoderBuffer* fallback_value) const {
  if (!hasUpdateBuffer()) {
  return fallback_value;
}
return member_update_buffer_.Get();
}
void setUpdateBuffer(VideoEncoderBuffer* value) {
  member_update_buffer_ = value;
has_update_buffer_ = true;
DCHECK(member_update_buffer_);
}

bool hasVp9() const {
  return has_vp_9_;
}
VideoEncoderEncodeOptionsForVp9* vp9() const {
  DCHECK(hasVp9());
return member_vp_9_.Get();
}
VideoEncoderEncodeOptionsForVp9* getVp9Or(VideoEncoderEncodeOptionsForVp9* fallback_value) const {
  if (!hasVp9()) {
  return fallback_value;
}
return member_vp_9_.Get();
}
void setVp9(VideoEncoderEncodeOptionsForVp9* value) {
  member_vp_9_ = value;
has_vp_9_ = true;
DCHECK(member_vp_9_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_av_1_ = false;
bool has_avc_ = false;
bool has_hevc_ = false;
bool has_reference_buffers_ = false;
bool has_update_buffer_ = false;
bool has_vp_9_ = false;

Member<VideoEncoderEncodeOptionsForAv1> member_av_1_;
Member<VideoEncoderEncodeOptionsForAvc> member_avc_;
Member<VideoEncoderEncodeOptionsForHevc> member_hevc_;
bool member_key_frame_{false};
HeapVector<Member<VideoEncoderBuffer>> member_reference_buffers_;
Member<VideoEncoderBuffer> member_update_buffer_;
Member<VideoEncoderEncodeOptionsForVp9> member_vp_9_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_ENCODE_OPTIONS_H_
