// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_alpha_option.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hardware_preference.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_latency_mode.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_bitrate_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AvcEncoderConfig;
class ExceptionState;
class HevcEncoderConfig;

class MODULES_EXPORT VideoEncoderConfig : public bindings::DictionaryBase {
  
  public:
static VideoEncoderConfig* Create() {
  return MakeGarbageCollected<VideoEncoderConfig>();
}
static VideoEncoderConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoEncoderConfig>(isolate);
}
static VideoEncoderConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoEncoderConfig();
explicit  VideoEncoderConfig(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
V8AlphaOption alpha() const {
  return member_alpha_;
}
void setAlpha(V8AlphaOption value) {
  member_alpha_ = value;
}
void setAlpha(V8AlphaOption::Enum value) {
  member_alpha_ = V8AlphaOption(value);
}

bool hasAvc() const {
  return has_avc_;
}
AvcEncoderConfig* avc() const {
  DCHECK(hasAvc());
return member_avc_.Get();
}
AvcEncoderConfig* getAvcOr(AvcEncoderConfig* fallback_value) const {
  if (!hasAvc()) {
  return fallback_value;
}
return member_avc_.Get();
}
void setAvc(AvcEncoderConfig* value) {
  member_avc_ = value;
has_avc_ = true;
DCHECK(member_avc_);
}

bool hasBitrate() const {
  return has_bitrate_;
}
uint64_t bitrate() const {
  DCHECK(hasBitrate());
return member_bitrate_;
}
uint64_t getBitrateOr(uint64_t fallback_value) const {
  if (!hasBitrate()) {
  return fallback_value;
}
return member_bitrate_;
}
void setBitrate(uint64_t value) {
  member_bitrate_ = value;
has_bitrate_ = true;
}

bool hasBitrateMode() const {
  return true;
}
V8VideoEncoderBitrateMode bitrateMode() const {
  return member_bitrate_mode_;
}
void setBitrateMode(V8VideoEncoderBitrateMode value) {
  member_bitrate_mode_ = value;
}
void setBitrateMode(V8VideoEncoderBitrateMode::Enum value) {
  member_bitrate_mode_ = V8VideoEncoderBitrateMode(value);
}

bool hasCodec() const {
  return true;
}
const String& codec() const {
  return member_codec_;
}
void setCodec(const String& value);
void setCodec(String&& value);

bool hasContentHint() const {
  return true;
}
const String& contentHint() const {
  return member_content_hint_;
}
void setContentHint(const String& value);
void setContentHint(String&& value);

bool hasDisplayHeight() const {
  return has_display_height_;
}
uint32_t displayHeight() const {
  DCHECK(hasDisplayHeight());
return member_display_height_;
}
uint32_t getDisplayHeightOr(uint32_t fallback_value) const {
  if (!hasDisplayHeight()) {
  return fallback_value;
}
return member_display_height_;
}
void setDisplayHeight(uint32_t value) {
  member_display_height_ = value;
has_display_height_ = true;
}

bool hasDisplayWidth() const {
  return has_display_width_;
}
uint32_t displayWidth() const {
  DCHECK(hasDisplayWidth());
return member_display_width_;
}
uint32_t getDisplayWidthOr(uint32_t fallback_value) const {
  if (!hasDisplayWidth()) {
  return fallback_value;
}
return member_display_width_;
}
void setDisplayWidth(uint32_t value) {
  member_display_width_ = value;
has_display_width_ = true;
}

bool hasFramerate() const {
  return has_framerate_;
}
double framerate() const {
  DCHECK(hasFramerate());
return member_framerate_;
}
double getFramerateOr(double fallback_value) const {
  if (!hasFramerate()) {
  return fallback_value;
}
return member_framerate_;
}
void setFramerate(double value) {
  member_framerate_ = value;
has_framerate_ = true;
}

bool hasHardwareAcceleration() const {
  return true;
}
V8HardwarePreference hardwareAcceleration() const {
  return member_hardware_acceleration_;
}
void setHardwareAcceleration(V8HardwarePreference value) {
  member_hardware_acceleration_ = value;
}
void setHardwareAcceleration(V8HardwarePreference::Enum value) {
  member_hardware_acceleration_ = V8HardwarePreference(value);
}

bool hasHeight() const {
  return true;
}
uint32_t height() const {
  return member_height_;
}
void setHeight(uint32_t value) {
  member_height_ = value;
}

bool hasHevc() const {
  return has_hevc_;
}
HevcEncoderConfig* hevc() const {
  DCHECK(hasHevc());
return member_hevc_.Get();
}
HevcEncoderConfig* getHevcOr(HevcEncoderConfig* fallback_value) const {
  if (!hasHevc()) {
  return fallback_value;
}
return member_hevc_.Get();
}
void setHevc(HevcEncoderConfig* value) {
  member_hevc_ = value;
has_hevc_ = true;
DCHECK(member_hevc_);
}

bool hasLatencyMode() const {
  return true;
}
V8LatencyMode latencyMode() const {
  return member_latency_mode_;
}
void setLatencyMode(V8LatencyMode value) {
  member_latency_mode_ = value;
}
void setLatencyMode(V8LatencyMode::Enum value) {
  member_latency_mode_ = V8LatencyMode(value);
}

bool hasScalabilityMode() const {
  return has_scalability_mode_;
}
const String& scalabilityMode() const {
  DCHECK(hasScalabilityMode());
return member_scalability_mode_;
}
String getScalabilityModeOr(const String& fallback_value) const;
String getScalabilityModeOr(String&& fallback_value) const;
void setScalabilityMode(const String& value);
void setScalabilityMode(String&& value);

bool hasWidth() const {
  return true;
}
uint32_t width() const {
  return member_width_;
}
void setWidth(uint32_t value) {
  member_width_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 15;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_avc_ = false;
bool has_bitrate_ = false;
bool has_display_height_ = false;
bool has_display_width_ = false;
bool has_framerate_ = false;
bool has_hevc_ = false;
bool has_scalability_mode_ = false;

V8AlphaOption member_alpha_{V8AlphaOption::Enum::kDiscard};
Member<AvcEncoderConfig> member_avc_;
uint64_t member_bitrate_;
V8VideoEncoderBitrateMode member_bitrate_mode_{V8VideoEncoderBitrateMode::Enum::kVariable};
String member_codec_;
String member_content_hint_{""};
uint32_t member_display_height_;
uint32_t member_display_width_;
double member_framerate_;
V8HardwarePreference member_hardware_acceleration_{V8HardwarePreference::Enum::kNoPreference};
uint32_t member_height_;
Member<HevcEncoderConfig> member_hevc_;
V8LatencyMode member_latency_mode_{V8LatencyMode::Enum::kQuality};
String member_scalability_mode_;
uint32_t member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_ENCODER_CONFIG_H_
