// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_DECODER_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_DECODER_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hardware_preference.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared;
class VideoColorSpaceInit;

class MODULES_EXPORT VideoDecoderConfig : public bindings::DictionaryBase {
  
  public:
static VideoDecoderConfig* Create() {
  return MakeGarbageCollected<VideoDecoderConfig>();
}
static VideoDecoderConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoDecoderConfig>(isolate);
}
static VideoDecoderConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoDecoderConfig();
explicit  VideoDecoderConfig(v8::Isolate* isolate);

bool hasCodec() const {
  return true;
}
const String& codec() const {
  return member_codec_;
}
void setCodec(const String& value);
void setCodec(String&& value);

bool hasCodedHeight() const {
  return has_coded_height_;
}
uint32_t codedHeight() const {
  DCHECK(hasCodedHeight());
return member_coded_height_;
}
uint32_t getCodedHeightOr(uint32_t fallback_value) const {
  if (!hasCodedHeight()) {
  return fallback_value;
}
return member_coded_height_;
}
void setCodedHeight(uint32_t value) {
  member_coded_height_ = value;
has_coded_height_ = true;
}

bool hasCodedWidth() const {
  return has_coded_width_;
}
uint32_t codedWidth() const {
  DCHECK(hasCodedWidth());
return member_coded_width_;
}
uint32_t getCodedWidthOr(uint32_t fallback_value) const {
  if (!hasCodedWidth()) {
  return fallback_value;
}
return member_coded_width_;
}
void setCodedWidth(uint32_t value) {
  member_coded_width_ = value;
has_coded_width_ = true;
}

bool hasColorSpace() const {
  return has_color_space_;
}
VideoColorSpaceInit* colorSpace() const {
  DCHECK(hasColorSpace());
return member_color_space_.Get();
}
VideoColorSpaceInit* getColorSpaceOr(VideoColorSpaceInit* fallback_value) const {
  if (!hasColorSpace()) {
  return fallback_value;
}
return member_color_space_.Get();
}
void setColorSpace(VideoColorSpaceInit* value) {
  member_color_space_ = value;
has_color_space_ = true;
DCHECK(member_color_space_);
}

bool hasDescription() const {
  return has_description_;
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* description() const {
  DCHECK(hasDescription());
return member_description_.Get();
}
V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* getDescriptionOr(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* fallback_value) const {
  if (!hasDescription()) {
  return fallback_value;
}
return member_description_.Get();
}
void setDescription(V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared* value) {
  member_description_ = value;
has_description_ = true;
DCHECK(member_description_);
}

bool hasDisplayAspectHeight() const {
  return has_display_aspect_height_;
}
uint32_t displayAspectHeight() const {
  DCHECK(hasDisplayAspectHeight());
return member_display_aspect_height_;
}
uint32_t getDisplayAspectHeightOr(uint32_t fallback_value) const {
  if (!hasDisplayAspectHeight()) {
  return fallback_value;
}
return member_display_aspect_height_;
}
void setDisplayAspectHeight(uint32_t value) {
  member_display_aspect_height_ = value;
has_display_aspect_height_ = true;
}

bool hasDisplayAspectWidth() const {
  return has_display_aspect_width_;
}
uint32_t displayAspectWidth() const {
  DCHECK(hasDisplayAspectWidth());
return member_display_aspect_width_;
}
uint32_t getDisplayAspectWidthOr(uint32_t fallback_value) const {
  if (!hasDisplayAspectWidth()) {
  return fallback_value;
}
return member_display_aspect_width_;
}
void setDisplayAspectWidth(uint32_t value) {
  member_display_aspect_width_ = value;
has_display_aspect_width_ = true;
}

bool hasEncryptionScheme() const {
  return has_encryption_scheme_;
}
const String& encryptionScheme() const {
  DCHECK(hasEncryptionScheme());
return member_encryption_scheme_;
}
String getEncryptionSchemeOr(const String& fallback_value) const;
String getEncryptionSchemeOr(String&& fallback_value) const;
void setEncryptionScheme(const String& value);
void setEncryptionScheme(String&& value);

bool hasFlip() const {
  return true;
}
bool flip() const {
  return member_flip_;
}
void setFlip(bool value) {
  member_flip_ = value;
}

bool hasHardwareAcceleration() const {
  return true;
}
V8HardwarePreference hardwareAcceleration() const {
  return member_hardware_acceleration_;
}
void setHardwareAcceleration(V8HardwarePreference value) {
  member_hardware_acceleration_ = value;
}
void setHardwareAcceleration(V8HardwarePreference::Enum value) {
  member_hardware_acceleration_ = V8HardwarePreference(value);
}

bool hasOptimizeForLatency() const {
  return has_optimize_for_latency_;
}
bool optimizeForLatency() const {
  DCHECK(hasOptimizeForLatency());
return member_optimize_for_latency_;
}
bool getOptimizeForLatencyOr(bool fallback_value) const {
  if (!hasOptimizeForLatency()) {
  return fallback_value;
}
return member_optimize_for_latency_;
}
void setOptimizeForLatency(bool value) {
  member_optimize_for_latency_ = value;
has_optimize_for_latency_ = true;
}

bool hasRotation() const {
  return true;
}
uint32_t rotation() const {
  return member_rotation_;
}
void setRotation(uint32_t value) {
  member_rotation_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 12;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_coded_height_ = false;
bool has_coded_width_ = false;
bool has_color_space_ = false;
bool has_description_ = false;
bool has_display_aspect_height_ = false;
bool has_display_aspect_width_ = false;
bool has_encryption_scheme_ = false;
bool has_optimize_for_latency_ = false;

String member_codec_;
uint32_t member_coded_height_;
uint32_t member_coded_width_;
Member<VideoColorSpaceInit> member_color_space_;
Member<V8UnionArrayBufferAllowSharedOrArrayBufferViewAllowShared> member_description_;
uint32_t member_display_aspect_height_;
uint32_t member_display_aspect_width_;
String member_encryption_scheme_;
bool member_flip_{false};
V8HardwarePreference member_hardware_acceleration_{V8HardwarePreference::Enum::kNoPreference};
bool member_optimize_for_latency_;
uint32_t member_rotation_{0};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_DECODER_CONFIG_H_
