// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_configuration.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bitrate",
"colorGamut",
"contentType",
"framerate",
"hdrMetadataType",
"height",
"scalabilityMode",
"spatialScalability",
"transferFunction",
"width",
};


}  // namespace 

VideoConfiguration* VideoConfiguration::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoConfiguration* dictionary = MakeGarbageCollected<VideoConfiguration>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoConfiguration";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoConfiguration::VideoConfiguration() {
  
}

 VideoConfiguration::VideoConfiguration(v8::Isolate* isolate) {
  
}















void VideoConfiguration::setContentType(const String& value) {
  member_content_type_ = value;
}

void VideoConfiguration::setContentType(String&& value) {
  member_content_type_ = std::move(value);
}





















String VideoConfiguration::getScalabilityModeOr(const String& fallback_value) const {
  if (!hasScalabilityMode()) {
  return fallback_value;
}
return member_scalability_mode_;
}

String VideoConfiguration::getScalabilityModeOr(String&& fallback_value) const {
  if (!hasScalabilityMode()) {
  return std::move(fallback_value);
}
return member_scalability_mode_;
}

void VideoConfiguration::setScalabilityMode(const String& value) {
  member_scalability_mode_ = value;
has_scalability_mode_ = true;
}

void VideoConfiguration::setScalabilityMode(String&& value) {
  member_scalability_mode_ = std::move(value);
has_scalability_mode_ = true;
}






















void VideoConfiguration::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void VideoConfiguration::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoConfiguration";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bitrate");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("colorGamut");
constexpr bool is_optional = false;
if (!bindings::GetDictionaryMemberFromV8Object<V8ColorGamut, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_color_gamut_, member_color_gamut_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("contentType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_content_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("framerate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_framerate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hdrMetadataType");
if (!bindings::GetDictionaryMemberFromV8Object<V8HdrMetadataType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_hdr_metadata_type_, member_hdr_metadata_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("scalabilityMode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_scalability_mode_, member_scalability_mode_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("spatialScalability");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_spatial_scalability_, member_spatial_scalability_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transferFunction");
if (!bindings::GetDictionaryMemberFromV8Object<V8TransferFunction, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_transfer_function_, member_transfer_function_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> VideoConfiguration::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
