// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNKNOWN_CREDENTIAL_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNKNOWN_CREDENTIAL_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT UnknownCredentialOptions : public bindings::InputDictionaryBase {
  
  public:
static UnknownCredentialOptions* Create() {
  return MakeGarbageCollected<UnknownCredentialOptions>();
}
static UnknownCredentialOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UnknownCredentialOptions>(isolate);
}
static UnknownCredentialOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UnknownCredentialOptions();
explicit  UnknownCredentialOptions(v8::Isolate* isolate);

bool hasCredentialId() const {
  return true;
}
const String& credentialId() const {
  return member_credential_id_;
}
void setCredentialId(const String& value);
void setCredentialId(String&& value);

bool hasRpId() const {
  return true;
}
const String& rpId() const {
  return member_rp_id_;
}
void setRpId(const String& value);
void setRpId(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_credential_id_;
String member_rp_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNKNOWN_CREDENTIAL_OPTIONS_H_
