// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_gputexture_gputextureview.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture_view.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionGPUTextureOrGPUTextureView* V8UnionGPUTextureOrGPUTextureView::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8GPUTextureView::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUTextureView::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUTextureOrGPUTextureView>(blink_value);
}
if (V8GPUTexture::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUTexture::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUTextureOrGPUTextureView>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










void V8UnionGPUTextureOrGPUTextureView::Trace(Visitor* visitor) const {
  visitor->Trace(member_gpu_texture_);
visitor->Trace(member_gpu_texture_view_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionGPUTextureOrGPUTextureView::Clear() {
  member_gpu_texture_.Clear();
member_gpu_texture_view_.Clear();
}



}  // namespace blink
