// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ENCODEDAUDIOCHUNK_ENCODEDAUDIOCHUNKORENCODEDVIDEOCHUNKSEQUENCE_ENCODEDVIDEOCHUNK_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ENCODEDAUDIOCHUNK_ENCODEDAUDIOCHUNKORENCODEDVIDEOCHUNKSEQUENCE_ENCODEDVIDEOCHUNK_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class EncodedAudioChunk;
class EncodedVideoChunk;
class ExceptionState;
class ScriptState;
class V8UnionEncodedAudioChunkOrEncodedVideoChunk;

class MODULES_EXPORT V8UnionEncodedAudioChunkOrEncodedAudioChunkOrEncodedVideoChunkSequenceOrEncodedVideoChunk final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kEncodedAudioChunk, kEncodedAudioChunkOrEncodedVideoChunkSequence, kEncodedVideoChunk
};

static V8UnionEncodedAudioChunkOrEncodedAudioChunkOrEncodedVideoChunkSequenceOrEncodedVideoChunk* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionEncodedAudioChunkOrEncodedAudioChunkOrEncodedVideoChunkSequenceOrEncodedVideoChunk(EncodedAudioChunk* value) : content_type_(ContentType::kEncodedAudioChunk), member_encoded_audio_chunk_(value) {
  DCHECK(value);
}
explicit  V8UnionEncodedAudioChunkOrEncodedAudioChunkOrEncodedVideoChunkSequenceOrEncodedVideoChunk(const HeapVector<Member<V8UnionEncodedAudioChunkOrEncodedVideoChunk>>& value);
explicit  V8UnionEncodedAudioChunkOrEncodedAudioChunkOrEncodedVideoChunkSequenceOrEncodedVideoChunk(HeapVector<Member<V8UnionEncodedAudioChunkOrEncodedVideoChunk>>&& value);
explicit  V8UnionEncodedAudioChunkOrEncodedAudioChunkOrEncodedVideoChunkSequenceOrEncodedVideoChunk(EncodedVideoChunk* value) : content_type_(ContentType::kEncodedVideoChunk), member_encoded_video_chunk_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsEncodedAudioChunk() const {
  return content_type_ == ContentType::kEncodedAudioChunk;
}
EncodedAudioChunk* GetAsEncodedAudioChunk() const {
  DCHECK_EQ(content_type_, ContentType::kEncodedAudioChunk);
return member_encoded_audio_chunk_.Get();
}
void Set(EncodedAudioChunk* value) {
  DCHECK(value);
Clear();
member_encoded_audio_chunk_ = value;
content_type_ = ContentType::kEncodedAudioChunk;
}

bool IsEncodedAudioChunkOrEncodedVideoChunkSequence() const {
  return content_type_ == ContentType::kEncodedAudioChunkOrEncodedVideoChunkSequence;
}
const HeapVector<Member<V8UnionEncodedAudioChunkOrEncodedVideoChunk>>& GetAsEncodedAudioChunkOrEncodedVideoChunkSequence() const {
  DCHECK_EQ(content_type_, ContentType::kEncodedAudioChunkOrEncodedVideoChunkSequence);
return member_encoded_audio_chunk_or_encoded_video_chunk_sequence_;
}
void Set(const HeapVector<Member<V8UnionEncodedAudioChunkOrEncodedVideoChunk>>& value);
void Set(HeapVector<Member<V8UnionEncodedAudioChunkOrEncodedVideoChunk>>&& value);

bool IsEncodedVideoChunk() const {
  return content_type_ == ContentType::kEncodedVideoChunk;
}
EncodedVideoChunk* GetAsEncodedVideoChunk() const {
  DCHECK_EQ(content_type_, ContentType::kEncodedVideoChunk);
return member_encoded_video_chunk_.Get();
}
void Set(EncodedVideoChunk* value) {
  DCHECK(value);
Clear();
member_encoded_video_chunk_ = value;
content_type_ = ContentType::kEncodedVideoChunk;
}

bool IsV8UnionEncodedAudioChunkOrEncodedVideoChunk() const {
  return content_type_ == ContentType::kEncodedAudioChunk || content_type_ == ContentType::kEncodedVideoChunk;
}
V8UnionEncodedAudioChunkOrEncodedVideoChunk* GetAsV8UnionEncodedAudioChunkOrEncodedVideoChunk() const;
void Set(const V8UnionEncodedAudioChunkOrEncodedVideoChunk* value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(EncodedAudioChunk or EncodedVideoChunk or sequence<(EncodedAudioChunk or EncodedVideoChunk)>)";
}

ContentType content_type_;

Member<EncodedAudioChunk> member_encoded_audio_chunk_;
HeapVector<Member<V8UnionEncodedAudioChunkOrEncodedVideoChunk>> member_encoded_audio_chunk_or_encoded_video_chunk_sequence_;
Member<EncodedVideoChunk> member_encoded_video_chunk_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ENCODEDAUDIOCHUNK_ENCODEDAUDIOCHUNKORENCODEDVIDEOCHUNKSEQUENCE_ENCODEDVIDEOCHUNK_H_
