// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_DOUBLESEQUENCE_GPUCOLORDICT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_DOUBLESEQUENCE_GPUCOLORDICT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUColorDict;
class ScriptState;

class MODULES_EXPORT V8UnionDoubleSequenceOrGPUColorDict final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kDoubleSequence, kGPUColorDict
};

static V8UnionDoubleSequenceOrGPUColorDict* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionDoubleSequenceOrGPUColorDict(const Vector<double>& value);
explicit  V8UnionDoubleSequenceOrGPUColorDict(Vector<double>&& value);
explicit  V8UnionDoubleSequenceOrGPUColorDict(GPUColorDict* value) : content_type_(ContentType::kGPUColorDict), member_gpu_color_dict_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsDoubleSequence() const {
  return content_type_ == ContentType::kDoubleSequence;
}
const Vector<double>& GetAsDoubleSequence() const {
  DCHECK_EQ(content_type_, ContentType::kDoubleSequence);
return member_double_sequence_;
}
void Set(const Vector<double>& value);
void Set(Vector<double>&& value);

bool IsGPUColorDict() const {
  return content_type_ == ContentType::kGPUColorDict;
}
GPUColorDict* GetAsGPUColorDict() const {
  DCHECK_EQ(content_type_, ContentType::kGPUColorDict);
return member_gpu_color_dict_.Get();
}
void Set(GPUColorDict* value) {
  DCHECK(value);
Clear();
member_gpu_color_dict_ = value;
content_type_ = ContentType::kGPUColorDict;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(GPUColorDict or sequence<double>)";
}

ContentType content_type_;

Vector<double> member_double_sequence_;
Member<GPUColorDict> member_gpu_color_dict_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_DOUBLESEQUENCE_GPUCOLORDICT_H_
