// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_SOCKET_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_SOCKET_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_socket_dns_query_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_socket_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT UDPSocketOptions : public SocketOptions {
  
  public:
static UDPSocketOptions* Create() {
  return MakeGarbageCollected<UDPSocketOptions>();
}
static UDPSocketOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UDPSocketOptions>(isolate);
}
static UDPSocketOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UDPSocketOptions();
explicit  UDPSocketOptions(v8::Isolate* isolate);

bool hasDnsQueryType() const {
  return has_dns_query_type_;
}
V8SocketDnsQueryType dnsQueryType() const {
  DCHECK(hasDnsQueryType());
return member_dns_query_type_;
}
V8SocketDnsQueryType getDnsQueryTypeOr(V8SocketDnsQueryType fallback_value) const {
  if (!hasDnsQueryType()) {
  return fallback_value;
}
return member_dns_query_type_;
}
void setDnsQueryType(V8SocketDnsQueryType value) {
  member_dns_query_type_ = value;
has_dns_query_type_ = true;
}
void setDnsQueryType(V8SocketDnsQueryType::Enum value) {
  member_dns_query_type_ = V8SocketDnsQueryType(value);
has_dns_query_type_ = true;
}

bool hasIpv6Only() const {
  return has_ipv_6_only_;
}
bool ipv6Only() const {
  DCHECK(hasIpv6Only());
return member_ipv_6_only_;
}
bool getIpv6OnlyOr(bool fallback_value) const {
  if (!hasIpv6Only()) {
  return fallback_value;
}
return member_ipv_6_only_;
}
void setIpv6Only(bool value) {
  member_ipv_6_only_ = value;
has_ipv_6_only_ = true;
}

bool hasLocalAddress() const {
  return has_local_address_;
}
const String& localAddress() const {
  DCHECK(hasLocalAddress());
return member_local_address_;
}
String getLocalAddressOr(const String& fallback_value) const;
String getLocalAddressOr(String&& fallback_value) const;
void setLocalAddress(const String& value);
void setLocalAddress(String&& value);

bool hasLocalPort() const {
  return has_local_port_;
}
uint16_t localPort() const {
  DCHECK(hasLocalPort());
return member_local_port_;
}
uint16_t getLocalPortOr(uint16_t fallback_value) const {
  if (!hasLocalPort()) {
  return fallback_value;
}
return member_local_port_;
}
void setLocalPort(uint16_t value) {
  member_local_port_ = value;
has_local_port_ = true;
}

bool hasMulticastAllowAddressSharing() const {
  return has_multicast_allow_address_sharing_;
}
bool multicastAllowAddressSharing() const {
  DCHECK(hasMulticastAllowAddressSharing());
return member_multicast_allow_address_sharing_;
}
bool getMulticastAllowAddressSharingOr(bool fallback_value) const {
  if (!hasMulticastAllowAddressSharing()) {
  return fallback_value;
}
return member_multicast_allow_address_sharing_;
}
void setMulticastAllowAddressSharing(bool value) {
  member_multicast_allow_address_sharing_ = value;
has_multicast_allow_address_sharing_ = true;
}

bool hasMulticastLoopback() const {
  return has_multicast_loopback_;
}
bool multicastLoopback() const {
  DCHECK(hasMulticastLoopback());
return member_multicast_loopback_;
}
bool getMulticastLoopbackOr(bool fallback_value) const {
  if (!hasMulticastLoopback()) {
  return fallback_value;
}
return member_multicast_loopback_;
}
void setMulticastLoopback(bool value) {
  member_multicast_loopback_ = value;
has_multicast_loopback_ = true;
}

bool hasMulticastTimeToLive() const {
  return has_multicast_time_to_live_;
}
uint8_t multicastTimeToLive() const {
  DCHECK(hasMulticastTimeToLive());
return member_multicast_time_to_live_;
}
uint8_t getMulticastTimeToLiveOr(uint8_t fallback_value) const {
  if (!hasMulticastTimeToLive()) {
  return fallback_value;
}
return member_multicast_time_to_live_;
}
void setMulticastTimeToLive(uint8_t value) {
  member_multicast_time_to_live_ = value;
has_multicast_time_to_live_ = true;
}

bool hasRemoteAddress() const {
  return has_remote_address_;
}
const String& remoteAddress() const {
  DCHECK(hasRemoteAddress());
return member_remote_address_;
}
String getRemoteAddressOr(const String& fallback_value) const;
String getRemoteAddressOr(String&& fallback_value) const;
void setRemoteAddress(const String& value);
void setRemoteAddress(String&& value);

bool hasRemotePort() const {
  return has_remote_port_;
}
uint16_t remotePort() const {
  DCHECK(hasRemotePort());
return member_remote_port_;
}
uint16_t getRemotePortOr(uint16_t fallback_value) const {
  if (!hasRemotePort()) {
  return fallback_value;
}
return member_remote_port_;
}
void setRemotePort(uint16_t value) {
  member_remote_port_ = value;
has_remote_port_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = SocketOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 9;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dns_query_type_ = false;
bool has_ipv_6_only_ = false;
bool has_local_address_ = false;
bool has_local_port_ = false;
bool has_multicast_allow_address_sharing_ = false;
bool has_multicast_loopback_ = false;
bool has_multicast_time_to_live_ = false;
bool has_remote_address_ = false;
bool has_remote_port_ = false;

V8SocketDnsQueryType member_dns_query_type_{static_cast<V8SocketDnsQueryType::Enum>(0)};
bool member_ipv_6_only_;
String member_local_address_;
uint16_t member_local_port_;
bool member_multicast_allow_address_sharing_;
bool member_multicast_loopback_;
uint8_t member_multicast_time_to_live_;
String member_remote_address_;
uint16_t member_remote_port_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_SOCKET_OPTIONS_H_
