// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_SOCKET_OPEN_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_SOCKET_OPEN_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_socket_open_info.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MulticastController;

class MODULES_EXPORT UDPSocketOpenInfo : public SocketOpenInfo {
  
  public:
static UDPSocketOpenInfo* Create() {
  return MakeGarbageCollected<UDPSocketOpenInfo>();
}
static UDPSocketOpenInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UDPSocketOpenInfo>(isolate);
}
static UDPSocketOpenInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UDPSocketOpenInfo();
explicit  UDPSocketOpenInfo(v8::Isolate* isolate);

bool hasMulticastController() const {
  return has_multicast_controller_;
}
MulticastController* multicastController() const {
  DCHECK(hasMulticastController());
return member_multicast_controller_.Get();
}
MulticastController* getMulticastControllerOr(MulticastController* fallback_value) const {
  if (!hasMulticastController()) {
  return fallback_value;
}
return member_multicast_controller_.Get();
}
void setMulticastController(MulticastController* value) {
  member_multicast_controller_ = value;
has_multicast_controller_ = true;
DCHECK(member_multicast_controller_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = SocketOpenInfo::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_multicast_controller_ = false;

Member<MulticastController> member_multicast_controller_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_SOCKET_OPEN_INFO_H_
