// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_MESSAGE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_MESSAGE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_socket_dns_query_type.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT UDPMessage : public bindings::DictionaryBase {
  
  public:
static UDPMessage* Create() {
  return MakeGarbageCollected<UDPMessage>();
}
static UDPMessage* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UDPMessage>(isolate);
}
static UDPMessage* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UDPMessage();
explicit  UDPMessage(v8::Isolate* isolate);

bool hasData() const {
  return has_data_;
}
V8UnionArrayBufferOrArrayBufferView* data() const {
  DCHECK(hasData());
return member_data_.Get();
}
V8UnionArrayBufferOrArrayBufferView* getDataOr(V8UnionArrayBufferOrArrayBufferView* fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_.Get();
}
void setData(V8UnionArrayBufferOrArrayBufferView* value) {
  member_data_ = value;
has_data_ = true;
DCHECK(member_data_);
}

bool hasDnsQueryType() const {
  return has_dns_query_type_;
}
V8SocketDnsQueryType dnsQueryType() const {
  DCHECK(hasDnsQueryType());
return member_dns_query_type_;
}
V8SocketDnsQueryType getDnsQueryTypeOr(V8SocketDnsQueryType fallback_value) const {
  if (!hasDnsQueryType()) {
  return fallback_value;
}
return member_dns_query_type_;
}
void setDnsQueryType(V8SocketDnsQueryType value) {
  member_dns_query_type_ = value;
has_dns_query_type_ = true;
}
void setDnsQueryType(V8SocketDnsQueryType::Enum value) {
  member_dns_query_type_ = V8SocketDnsQueryType(value);
has_dns_query_type_ = true;
}

bool hasRemoteAddress() const {
  return has_remote_address_;
}
const String& remoteAddress() const {
  DCHECK(hasRemoteAddress());
return member_remote_address_;
}
String getRemoteAddressOr(const String& fallback_value) const;
String getRemoteAddressOr(String&& fallback_value) const;
void setRemoteAddress(const String& value);
void setRemoteAddress(String&& value);

bool hasRemotePort() const {
  return has_remote_port_;
}
uint16_t remotePort() const {
  DCHECK(hasRemotePort());
return member_remote_port_;
}
uint16_t getRemotePortOr(uint16_t fallback_value) const {
  if (!hasRemotePort()) {
  return fallback_value;
}
return member_remote_port_;
}
void setRemotePort(uint16_t value) {
  member_remote_port_ = value;
has_remote_port_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_ = false;
bool has_dns_query_type_ = false;
bool has_remote_address_ = false;
bool has_remote_port_ = false;

Member<V8UnionArrayBufferOrArrayBufferView> member_data_;
V8SocketDnsQueryType member_dns_query_type_{static_cast<V8SocketDnsQueryType::Enum>(0)};
String member_remote_address_;
uint16_t member_remote_port_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UDP_MESSAGE_H_
