// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SOCKET_OPEN_INFO_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SOCKET_OPEN_INFO_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class ReadableStream;
class WritableStream;

class MODULES_EXPORT SocketOpenInfo : public bindings::DictionaryBase {
  
  public:
static SocketOpenInfo* Create() {
  return MakeGarbageCollected<SocketOpenInfo>();
}
static SocketOpenInfo* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SocketOpenInfo>(isolate);
}
static SocketOpenInfo* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SocketOpenInfo();
explicit  SocketOpenInfo(v8::Isolate* isolate);

bool hasLocalAddress() const {
  return has_local_address_;
}
const String& localAddress() const {
  DCHECK(hasLocalAddress());
return member_local_address_;
}
String getLocalAddressOr(const String& fallback_value) const;
String getLocalAddressOr(String&& fallback_value) const;
void setLocalAddress(const String& value);
void setLocalAddress(String&& value);

bool hasLocalPort() const {
  return has_local_port_;
}
uint16_t localPort() const {
  DCHECK(hasLocalPort());
return member_local_port_;
}
uint16_t getLocalPortOr(uint16_t fallback_value) const {
  if (!hasLocalPort()) {
  return fallback_value;
}
return member_local_port_;
}
void setLocalPort(uint16_t value) {
  member_local_port_ = value;
has_local_port_ = true;
}

bool hasReadable() const {
  return has_readable_;
}
ReadableStream* readable() const {
  DCHECK(hasReadable());
return member_readable_.Get();
}
ReadableStream* getReadableOr(ReadableStream* fallback_value) const {
  if (!hasReadable()) {
  return fallback_value;
}
return member_readable_.Get();
}
void setReadable(ReadableStream* value) {
  member_readable_ = value;
has_readable_ = true;
DCHECK(member_readable_);
}

bool hasRemoteAddress() const {
  return has_remote_address_;
}
const String& remoteAddress() const {
  DCHECK(hasRemoteAddress());
return member_remote_address_;
}
String getRemoteAddressOr(const String& fallback_value) const;
String getRemoteAddressOr(String&& fallback_value) const;
void setRemoteAddress(const String& value);
void setRemoteAddress(String&& value);

bool hasRemotePort() const {
  return has_remote_port_;
}
uint16_t remotePort() const {
  DCHECK(hasRemotePort());
return member_remote_port_;
}
uint16_t getRemotePortOr(uint16_t fallback_value) const {
  if (!hasRemotePort()) {
  return fallback_value;
}
return member_remote_port_;
}
void setRemotePort(uint16_t value) {
  member_remote_port_ = value;
has_remote_port_ = true;
}

bool hasWritable() const {
  return has_writable_;
}
WritableStream* writable() const {
  DCHECK(hasWritable());
return member_writable_.Get();
}
WritableStream* getWritableOr(WritableStream* fallback_value) const {
  if (!hasWritable()) {
  return fallback_value;
}
return member_writable_.Get();
}
void setWritable(WritableStream* value) {
  member_writable_ = value;
has_writable_ = true;
DCHECK(member_writable_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_local_address_ = false;
bool has_local_port_ = false;
bool has_readable_ = false;
bool has_remote_address_ = false;
bool has_remote_port_ = false;
bool has_writable_ = false;

String member_local_address_;
uint16_t member_local_port_;
Member<ReadableStream> member_readable_;
String member_remote_address_;
uint16_t member_remote_port_;
Member<WritableStream> member_writable_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SOCKET_OPEN_INFO_H_
